// services/data_decoder/public/mojom/data_decoder_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_DATA_DECODER_SERVICE_MOJOM_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_DATA_DECODER_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/data_decoder/public/mojom/data_decoder_service.mojom-features.h"  // IWYU pragma: export
#include "services/data_decoder/public/mojom/data_decoder_service.mojom-shared.h"  // IWYU pragma: export
#include "services/data_decoder/public/mojom/data_decoder_service.mojom-forward.h"  // IWYU pragma: export
#include "components/facilitated_payments/core/mojom/pix_code_validator.mojom-forward.h"
#include "components/web_package/mojom/web_bundle_parser.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "services/data_decoder/public/mojom/cbor_parser.mojom-forward.h"
#include "services/data_decoder/public/mojom/gzipper.mojom-forward.h"
#include "services/data_decoder/public/mojom/image_decoder.mojom-forward.h"
#include "services/data_decoder/public/mojom/structured_headers_parser.mojom-forward.h"
#include "services/data_decoder/public/mojom/xml_parser.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace data_decoder::mojom {

class DataDecoderServiceProxy;

template <typename ImplRefTraits>
class DataDecoderServiceStub;

class DataDecoderServiceRequestValidator;


class DataDecoderService
    : public DataDecoderServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "data_decoder.mojom.DataDecoderService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kService;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DataDecoderServiceInterfaceBase;
  using Proxy_ = DataDecoderServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DataDecoderServiceStub<ImplRefTraits>;

  using RequestValidator_ = DataDecoderServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindImageDecoderMinVersion = 0,
    kBindXmlParserMinVersion = 0,
    kBindWebBundleParserFactoryMinVersion = 0,
    kBindGzipperMinVersion = 0,
    kBindStructuredHeadersParserMinVersion = 0,
    kBindCborParserMinVersion = 0,
    kBindPixCodeValidatorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindImageDecoder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindXmlParser_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindWebBundleParserFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindGzipper_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindStructuredHeadersParser_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindCborParser_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindPixCodeValidator_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DataDecoderService() = default;

  virtual void BindImageDecoder(::mojo::PendingReceiver<::data_decoder::mojom::ImageDecoder> receiver) = 0;

  virtual void BindXmlParser(::mojo::PendingReceiver<::data_decoder::mojom::XmlParser> reciever) = 0;

  virtual void BindWebBundleParserFactory(::mojo::PendingReceiver<::web_package::mojom::WebBundleParserFactory> receiver) = 0;

  virtual void BindGzipper(::mojo::PendingReceiver<::data_decoder::mojom::Gzipper> receiver) = 0;

  virtual void BindStructuredHeadersParser(::mojo::PendingReceiver<::data_decoder::mojom::StructuredHeadersParser> receiver) = 0;

  virtual void BindCborParser(::mojo::PendingReceiver<::data_decoder::mojom::CborParser> receiver) = 0;

  virtual void BindPixCodeValidator(::mojo::PendingReceiver<::payments::facilitated::mojom::PixCodeValidator> receiver) = 0;
};



class  DataDecoderServiceProxy
    : public DataDecoderService {
 public:
  using InterfaceType = DataDecoderService;

  explicit DataDecoderServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindImageDecoder(::mojo::PendingReceiver<::data_decoder::mojom::ImageDecoder> receiver) final;
  
  void BindXmlParser(::mojo::PendingReceiver<::data_decoder::mojom::XmlParser> reciever) final;
  
  void BindWebBundleParserFactory(::mojo::PendingReceiver<::web_package::mojom::WebBundleParserFactory> receiver) final;
  
  void BindGzipper(::mojo::PendingReceiver<::data_decoder::mojom::Gzipper> receiver) final;
  
  void BindStructuredHeadersParser(::mojo::PendingReceiver<::data_decoder::mojom::StructuredHeadersParser> receiver) final;
  
  void BindCborParser(::mojo::PendingReceiver<::data_decoder::mojom::CborParser> receiver) final;
  
  void BindPixCodeValidator(::mojo::PendingReceiver<::payments::facilitated::mojom::PixCodeValidator> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DataDecoderServiceStubDispatch {
 public:
  static bool Accept(DataDecoderService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DataDecoderService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DataDecoderService>>
class DataDecoderServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DataDecoderServiceStub() = default;
  ~DataDecoderServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DataDecoderServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DataDecoderServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DataDecoderServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // data_decoder::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_DATA_DECODER_SERVICE_MOJOM_H_