// printing/mojom/printing_context.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_MOJOM_PRINTING_CONTEXT_MOJOM_SHARED_H_
#define PRINTING_MOJOM_PRINTING_CONTEXT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "printing/mojom/printing_context.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "printing/mojom/print.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "printing/mojom/printing_context.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PageMarginsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PageMarginsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PageMargins_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->header = Traits::header(input);

    fragment->footer = Traits::footer(input);

    fragment->left = Traits::left(input);

    fragment->right = Traits::right(input);

    fragment->top = Traits::top(input);

    fragment->bottom = Traits::bottom(input);
  }

  static bool Deserialize(::printing::mojom::internal::PageMargins_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PageMarginsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PageSetupDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PageSetupDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PageSetup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::physical_size(input)) in_physical_size = Traits::physical_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->physical_size)::BaseType> physical_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_physical_size,
      physical_size_fragment);

    fragment->physical_size.Set(
        physical_size_fragment.is_null() ? nullptr : physical_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->physical_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null physical_size in PageSetup struct");

    decltype(Traits::printable_area(input)) in_printable_area = Traits::printable_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printable_area)::BaseType> printable_area_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_printable_area,
      printable_area_fragment);

    fragment->printable_area.Set(
        printable_area_fragment.is_null() ? nullptr : printable_area_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printable_area.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printable_area in PageSetup struct");

    decltype(Traits::overlay_area(input)) in_overlay_area = Traits::overlay_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->overlay_area)::BaseType> overlay_area_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_overlay_area,
      overlay_area_fragment);

    fragment->overlay_area.Set(
        overlay_area_fragment.is_null() ? nullptr : overlay_area_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->overlay_area.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null overlay_area in PageSetup struct");

    decltype(Traits::content_area(input)) in_content_area = Traits::content_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_area)::BaseType> content_area_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_content_area,
      content_area_fragment);

    fragment->content_area.Set(
        content_area_fragment.is_null() ? nullptr : content_area_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_area.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_area in PageSetup struct");

    decltype(Traits::effective_margins(input)) in_effective_margins = Traits::effective_margins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->effective_margins)::BaseType> effective_margins_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::PageMarginsDataView>(
      in_effective_margins,
      effective_margins_fragment);

    fragment->effective_margins.Set(
        effective_margins_fragment.is_null() ? nullptr : effective_margins_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->effective_margins.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null effective_margins in PageSetup struct");

    decltype(Traits::requested_margins(input)) in_requested_margins = Traits::requested_margins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requested_margins)::BaseType> requested_margins_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::PageMarginsDataView>(
      in_requested_margins,
      requested_margins_fragment);

    fragment->requested_margins.Set(
        requested_margins_fragment.is_null() ? nullptr : requested_margins_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->requested_margins.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested_margins in PageSetup struct");

    fragment->forced_margins = Traits::forced_margins(input);

    fragment->text_height = Traits::text_height(input);
  }

  static bool Deserialize(::printing::mojom::internal::PageSetup_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PageSetupDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::RequestedMediaDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::RequestedMediaDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::RequestedMedia_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::size_microns(input)) in_size_microns = Traits::size_microns(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size_microns)::BaseType> size_microns_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size_microns,
      size_microns_fragment);

    fragment->size_microns.Set(
        size_microns_fragment.is_null() ? nullptr : size_microns_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->size_microns.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size_microns in RequestedMedia struct");

    decltype(Traits::vendor_id(input)) in_vendor_id = Traits::vendor_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->vendor_id)::BaseType> vendor_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_vendor_id,
      vendor_id_fragment);

    fragment->vendor_id.Set(
        vendor_id_fragment.is_null() ? nullptr : vendor_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->vendor_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vendor_id in RequestedMedia struct");
  }

  static bool Deserialize(::printing::mojom::internal::RequestedMedia_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::RequestedMediaDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintSettingsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::ranges(input)) in_ranges = Traits::ranges(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ranges)::BaseType>
        ranges_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ranges_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::PageRangeDataView>>(
      in_ranges,
      ranges_fragment,
      &ranges_validate_params);

    fragment->ranges.Set(
        ranges_fragment.is_null() ? nullptr : ranges_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ranges.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ranges in PrintSettings struct");

    fragment->selection_only = Traits::selection_only(input);

    
    mojo::internal::Serialize<::printing::mojom::MarginType>(
      Traits::margin_type(input),
      &fragment->margin_type);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in PrintSettings struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PrintSettings struct");

    fragment->display_header_footer = Traits::display_header_footer(input);

    fragment->should_print_backgrounds = Traits::should_print_backgrounds(input);

    fragment->collate = Traits::collate(input);

    
    mojo::internal::Serialize<::printing::mojom::ColorModel>(
      Traits::color(input),
      &fragment->color);

    fragment->copies = Traits::copies(input);

    
    mojo::internal::Serialize<::printing::mojom::DuplexMode>(
      Traits::duplex_mode(input),
      &fragment->duplex_mode);

    decltype(Traits::device_name(input)) in_device_name = Traits::device_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_name)::BaseType> device_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_device_name,
      device_name_fragment);

    fragment->device_name.Set(
        device_name_fragment.is_null() ? nullptr : device_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_name in PrintSettings struct");

    decltype(Traits::requested_media(input)) in_requested_media = Traits::requested_media(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requested_media)::BaseType> requested_media_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::RequestedMediaDataView>(
      in_requested_media,
      requested_media_fragment);

    fragment->requested_media.Set(
        requested_media_fragment.is_null() ? nullptr : requested_media_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->requested_media.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested_media in PrintSettings struct");

    decltype(Traits::page_setup_device_units(input)) in_page_setup_device_units = Traits::page_setup_device_units(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_setup_device_units)::BaseType> page_setup_device_units_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::PageSetupDataView>(
      in_page_setup_device_units,
      page_setup_device_units_fragment);

    fragment->page_setup_device_units.Set(
        page_setup_device_units_fragment.is_null() ? nullptr : page_setup_device_units_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->page_setup_device_units.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_setup_device_units in PrintSettings struct");

    fragment->borderless = Traits::borderless(input);

    decltype(Traits::media_type(input)) in_media_type = Traits::media_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_type)::BaseType> media_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_media_type,
      media_type_fragment);

    fragment->media_type.Set(
        media_type_fragment.is_null() ? nullptr : media_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->media_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_type in PrintSettings struct");

    decltype(Traits::dpi(input)) in_dpi = Traits::dpi(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dpi)::BaseType> dpi_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_dpi,
      dpi_fragment);

    fragment->dpi.Set(
        dpi_fragment.is_null() ? nullptr : dpi_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dpi.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dpi in PrintSettings struct");

    fragment->scale_factor = Traits::scale_factor(input);

    fragment->rasterize_pdf = Traits::rasterize_pdf(input);

    fragment->landscape = Traits::landscape(input);

    fragment->is_modifiable = Traits::is_modifiable(input);

    decltype(Traits::requested_custom_margins_in_microns(input)) in_requested_custom_margins_in_microns = Traits::requested_custom_margins_in_microns(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requested_custom_margins_in_microns)::BaseType> requested_custom_margins_in_microns_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::PageMarginsDataView>(
      in_requested_custom_margins_in_microns,
      requested_custom_margins_in_microns_fragment);

    fragment->requested_custom_margins_in_microns.Set(
        requested_custom_margins_in_microns_fragment.is_null() ? nullptr : requested_custom_margins_in_microns_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->requested_custom_margins_in_microns.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested_custom_margins_in_microns in PrintSettings struct");

    fragment->pages_per_sheet = Traits::pages_per_sheet(input);

    decltype(Traits::system_print_dialog_data(input)) in_system_print_dialog_data = Traits::system_print_dialog_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->system_print_dialog_data)::BaseType> system_print_dialog_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_system_print_dialog_data,
      system_print_dialog_data_fragment);

    fragment->system_print_dialog_data.Set(
        system_print_dialog_data_fragment.is_null() ? nullptr : system_print_dialog_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->system_print_dialog_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null system_print_dialog_data in PrintSettings struct");
  }

  static bool Deserialize(::printing::mojom::internal::PrintSettings_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintSettingsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace printing::mojom {



inline void PageSetupDataView::GetPhysicalSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->physical_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void PageSetupDataView::GetPrintableAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->printable_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void PageSetupDataView::GetOverlayAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->overlay_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void PageSetupDataView::GetContentAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->content_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void PageSetupDataView::GetEffectiveMarginsDataView(
    PageMarginsDataView* output) {
  auto pointer = data_->effective_margins.Get();
  *output = PageMarginsDataView(pointer, message_);
}
inline void PageSetupDataView::GetRequestedMarginsDataView(
    PageMarginsDataView* output) {
  auto pointer = data_->requested_margins.Get();
  *output = PageMarginsDataView(pointer, message_);
}


inline void RequestedMediaDataView::GetSizeMicronsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size_microns.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void RequestedMediaDataView::GetVendorIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->vendor_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PrintSettingsDataView::GetRangesDataView(
    mojo::ArrayDataView<::printing::mojom::PageRangeDataView>* output) {
  auto pointer = data_->ranges.Get();
  *output = mojo::ArrayDataView<::printing::mojom::PageRangeDataView>(pointer, message_);
}
inline void PrintSettingsDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PrintSettingsDataView::GetUrlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->url.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PrintSettingsDataView::GetDeviceNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->device_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PrintSettingsDataView::GetRequestedMediaDataView(
    RequestedMediaDataView* output) {
  auto pointer = data_->requested_media.Get();
  *output = RequestedMediaDataView(pointer, message_);
}
inline void PrintSettingsDataView::GetPageSetupDeviceUnitsDataView(
    PageSetupDataView* output) {
  auto pointer = data_->page_setup_device_units.Get();
  *output = PageSetupDataView(pointer, message_);
}
inline void PrintSettingsDataView::GetMediaTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PrintSettingsDataView::GetDpiDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->dpi.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void PrintSettingsDataView::GetRequestedCustomMarginsInMicronsDataView(
    PageMarginsDataView* output) {
  auto pointer = data_->requested_custom_margins_in_microns.Get();
  *output = PageMarginsDataView(pointer, message_);
}
inline void PrintSettingsDataView::GetSystemPrintDialogDataDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->system_print_dialog_data.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}



}  // printing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // PRINTING_MOJOM_PRINTING_CONTEXT_MOJOM_SHARED_H_