// owl/mojom/web_view_container_view.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/web_view_container_view.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/web_view_container_view.mojom-params-data.h"
#include "owl/mojom/web_view_container_view.mojom-shared-message-ids.h"

#include "owl/mojom/web_view_container_view.mojom-import-headers.h"
#include "owl/mojom/web_view_container_view.mojom-test-utils.h"


namespace owl::mojom {
// The declaration includes the definition on other builds.

LayerHost::IPCStableHashFunction LayerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LayerHost>(message.name())) {
    case messages::LayerHost::kSetGeometry: {
      return &LayerHost::SetGeometry_Sym::IPCStableHash;
    }
    case messages::LayerHost::kSetDisplayId: {
      return &LayerHost::SetDisplayId_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LayerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LayerHost>(message.name())) {
      case messages::LayerHost::kSetGeometry:
            return "Receive owl::mojom::LayerHost::SetGeometry";
      case messages::LayerHost::kSetDisplayId:
            return "Receive owl::mojom::LayerHost::SetDisplayId";
    }
  } else {
    switch (static_cast<messages::LayerHost>(message.name())) {
      case messages::LayerHost::kSetGeometry:
            return "Receive reply owl::mojom::LayerHost::SetGeometry";
      case messages::LayerHost::kSetDisplayId:
            return "Receive reply owl::mojom::LayerHost::SetDisplayId";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LayerHost::SetGeometry_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67ca0776;  // IPCStableHash for owl::mojom::LayerHost::SetGeometry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LayerHost::SetDisplayId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92a3a92a;  // IPCStableHash for owl::mojom::LayerHost::SetDisplayId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LayerHostProxy::LayerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LayerHostProxy::SetGeometry(
    const std::optional<::gfx::Rect>& in_window_frame_in_screen_dip, const ::gfx::Rect& in_view_bounds_in_window_dip) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::LayerHost::SetGeometry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_frame_in_screen_dip"), in_window_frame_in_screen_dip,
                        "<value of type const std::optional<::gfx::Rect>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_bounds_in_window_dip"), in_view_bounds_in_window_dip,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LayerHost::kSetGeometry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::LayerHost_SetGeometry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_frame_in_screen_dip)::BaseType> window_frame_in_screen_dip_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_window_frame_in_screen_dip,
    window_frame_in_screen_dip_fragment);

  params->window_frame_in_screen_dip.Set(
      window_frame_in_screen_dip_fragment.is_null() ? nullptr : window_frame_in_screen_dip_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->view_bounds_in_window_dip)::BaseType> view_bounds_in_window_dip_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_view_bounds_in_window_dip,
    view_bounds_in_window_dip_fragment);

  params->view_bounds_in_window_dip.Set(
      view_bounds_in_window_dip_fragment.is_null() ? nullptr : view_bounds_in_window_dip_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->view_bounds_in_window_dip.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null view_bounds_in_window_dip in LayerHost.SetGeometry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayerHost::Name_);
  message.set_method_name("SetGeometry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LayerHostProxy::SetDisplayId(
    int64_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::LayerHost::SetDisplayId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LayerHost::kSetDisplayId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::LayerHost_SetDisplayId_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayerHost::Name_);
  message.set_method_name("SetDisplayId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LayerHostStubDispatch::Accept(
    LayerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LayerHost>(message->header()->name)) {
    case messages::LayerHost::kSetGeometry: {
      DCHECK(message->is_serialized());
      internal::LayerHost_SetGeometry_Params_Data* params =
          reinterpret_cast<internal::LayerHost_SetGeometry_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LayerHost.0
      bool success = true;
      std::optional<::gfx::Rect> p_window_frame_in_screen_dip{};
      ::gfx::Rect p_view_bounds_in_window_dip{};
      LayerHost_SetGeometry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowFrameInScreenDip(&p_window_frame_in_screen_dip))
        success = false;
      if (success && !input_data_view.ReadViewBoundsInWindowDip(&p_view_bounds_in_window_dip))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetGeometry(        
        std::move(p_window_frame_in_screen_dip), 
        std::move(p_view_bounds_in_window_dip));
      return true;
    }
    case messages::LayerHost::kSetDisplayId: {
      DCHECK(message->is_serialized());
      internal::LayerHost_SetDisplayId_Params_Data* params =
          reinterpret_cast<internal::LayerHost_SetDisplayId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LayerHost.1
      bool success = true;
      int64_t p_id{};
      LayerHost_SetDisplayId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDisplayId(        
        std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool LayerHostStubDispatch::AcceptWithResponder(
    LayerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LayerHost>(message->header()->name)) {
    case messages::LayerHost::kSetGeometry: {
      break;
    }
    case messages::LayerHost::kSetDisplayId: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLayerHostValidationInfo[] = {
    { &internal::LayerHost_SetGeometry_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LayerHost_SetDisplayId_Params_Data::Validate,
     nullptr /* no response */},
};

bool LayerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::LayerHost::Name_,
    kLayerHostValidationInfo);
}

// The declaration includes the definition on other builds.

WebViewContainerView::IPCStableHashFunction WebViewContainerView::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebViewContainerView>(message.name())) {
    case messages::WebViewContainerView::kSetWebView: {
      return &WebViewContainerView::SetWebView_Sym::IPCStableHash;
    }
    case messages::WebViewContainerView::kSetVisible: {
      return &WebViewContainerView::SetVisible_Sym::IPCStableHash;
    }
    case messages::WebViewContainerView::kDestroy: {
      return &WebViewContainerView::Destroy_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebViewContainerView::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebViewContainerView>(message.name())) {
      case messages::WebViewContainerView::kSetWebView:
            return "Receive owl::mojom::WebViewContainerView::SetWebView";
      case messages::WebViewContainerView::kSetVisible:
            return "Receive owl::mojom::WebViewContainerView::SetVisible";
      case messages::WebViewContainerView::kDestroy:
            return "Receive owl::mojom::WebViewContainerView::Destroy";
    }
  } else {
    switch (static_cast<messages::WebViewContainerView>(message.name())) {
      case messages::WebViewContainerView::kSetWebView:
            return "Receive reply owl::mojom::WebViewContainerView::SetWebView";
      case messages::WebViewContainerView::kSetVisible:
            return "Receive reply owl::mojom::WebViewContainerView::SetVisible";
      case messages::WebViewContainerView::kDestroy:
            return "Receive reply owl::mojom::WebViewContainerView::Destroy";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebViewContainerView::SetWebView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44bcc77f;  // IPCStableHash for owl::mojom::WebViewContainerView::SetWebView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewContainerView::SetVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x57e6dfd4;  // IPCStableHash for owl::mojom::WebViewContainerView::SetVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewContainerView::Destroy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x201ed432;  // IPCStableHash for owl::mojom::WebViewContainerView::Destroy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebViewContainerViewProxy::WebViewContainerViewProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebViewContainerViewProxy::SetWebView(
    std::optional<uint64_t> in_web_content_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewContainerView::SetWebView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_content_id"), in_web_content_id,
                        "<value of type std::optional<uint64_t>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewContainerView::kSetWebView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewContainerView_SetWebView_Params_Data> params(
          message);
  params.Allocate();
  params->web_content_id_$flag = in_web_content_id.has_value();
  if (in_web_content_id.has_value()) {
    params->web_content_id_$value = in_web_content_id.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewContainerView::Name_);
  message.set_method_name("SetWebView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewContainerViewProxy::SetVisible(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewContainerView::SetVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewContainerView::kSetVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewContainerView_SetVisible_Params_Data> params(
          message);
  params.Allocate();

  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewContainerView::Name_);
  message.set_method_name("SetVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewContainerViewProxy::Destroy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewContainerView::Destroy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewContainerView::kDestroy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewContainerView_Destroy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewContainerView::Name_);
  message.set_method_name("Destroy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebViewContainerViewStubDispatch::Accept(
    WebViewContainerView* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebViewContainerView>(message->header()->name)) {
    case messages::WebViewContainerView::kSetWebView: {
      DCHECK(message->is_serialized());
      internal::WebViewContainerView_SetWebView_Params_Data* params =
          reinterpret_cast<internal::WebViewContainerView_SetWebView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewContainerView.0
      bool success = true;
      std::optional<uint64_t> p_web_content_id{};
      WebViewContainerView_SetWebView_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_web_content_id = input_data_view.web_content_id();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewContainerView::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWebView(        
        std::move(p_web_content_id));
      return true;
    }
    case messages::WebViewContainerView::kSetVisible: {
      DCHECK(message->is_serialized());
      internal::WebViewContainerView_SetVisible_Params_Data* params =
          reinterpret_cast<internal::WebViewContainerView_SetVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewContainerView.1
      bool success = true;
      bool p_value{};
      WebViewContainerView_SetVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewContainerView::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVisible(        
        std::move(p_value));
      return true;
    }
    case messages::WebViewContainerView::kDestroy: {
      DCHECK(message->is_serialized());
      internal::WebViewContainerView_Destroy_Params_Data* params =
          reinterpret_cast<internal::WebViewContainerView_Destroy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewContainerView.2
      bool success = true;
      WebViewContainerView_Destroy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewContainerView::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Destroy(        );
      return true;
    }
  }
  return false;
}

// static
bool WebViewContainerViewStubDispatch::AcceptWithResponder(
    WebViewContainerView* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebViewContainerView>(message->header()->name)) {
    case messages::WebViewContainerView::kSetWebView: {
      break;
    }
    case messages::WebViewContainerView::kSetVisible: {
      break;
    }
    case messages::WebViewContainerView::kDestroy: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebViewContainerViewValidationInfo[] = {
    { &internal::WebViewContainerView_SetWebView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewContainerView_SetVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewContainerView_Destroy_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebViewContainerViewRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WebViewContainerView::Name_,
    kWebViewContainerViewValidationInfo);
}

// The declaration includes the definition on other builds.

LayerHostClient::IPCStableHashFunction LayerHostClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LayerHostClient>(message.name())) {
    case messages::LayerHostClient::kSetCALayerParams: {
      return &LayerHostClient::SetCALayerParams_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LayerHostClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LayerHostClient>(message.name())) {
      case messages::LayerHostClient::kSetCALayerParams:
            return "Receive owl::mojom::LayerHostClient::SetCALayerParams";
    }
  } else {
    switch (static_cast<messages::LayerHostClient>(message.name())) {
      case messages::LayerHostClient::kSetCALayerParams:
            return "Receive reply owl::mojom::LayerHostClient::SetCALayerParams";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LayerHostClient::SetCALayerParams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x98d1ef42;  // IPCStableHash for owl::mojom::LayerHostClient::SetCALayerParams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LayerHostClientProxy::LayerHostClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LayerHostClientProxy::SetCALayerParams(
    const ::gfx::CALayerParams& in_ca_layer_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::LayerHostClient::SetCALayerParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ca_layer_params"), in_ca_layer_params,
                        "<value of type const ::gfx::CALayerParams&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LayerHostClient::kSetCALayerParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::LayerHostClient_SetCALayerParams_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ca_layer_params)::BaseType> ca_layer_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::CALayerParamsDataView>(
    in_ca_layer_params,
    ca_layer_params_fragment);

  params->ca_layer_params.Set(
      ca_layer_params_fragment.is_null() ? nullptr : ca_layer_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ca_layer_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ca_layer_params in LayerHostClient.SetCALayerParams request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayerHostClient::Name_);
  message.set_method_name("SetCALayerParams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LayerHostClientStubDispatch::Accept(
    LayerHostClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LayerHostClient>(message->header()->name)) {
    case messages::LayerHostClient::kSetCALayerParams: {
      DCHECK(message->is_serialized());
      internal::LayerHostClient_SetCALayerParams_Params_Data* params =
          reinterpret_cast<internal::LayerHostClient_SetCALayerParams_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LayerHostClient.0
      bool success = true;
      ::gfx::CALayerParams p_ca_layer_params{};
      LayerHostClient_SetCALayerParams_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCaLayerParams(&p_ca_layer_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayerHostClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCALayerParams(        
        std::move(p_ca_layer_params));
      return true;
    }
  }
  return false;
}

// static
bool LayerHostClientStubDispatch::AcceptWithResponder(
    LayerHostClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LayerHostClient>(message->header()->name)) {
    case messages::LayerHostClient::kSetCALayerParams: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLayerHostClientValidationInfo[] = {
    { &internal::LayerHostClient_SetCALayerParams_Params_Data::Validate,
     nullptr /* no response */},
};

bool LayerHostClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::LayerHostClient::Name_,
    kLayerHostClientValidationInfo);
}



}  // owl::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void LayerHostInterceptorForTesting::SetGeometry(const std::optional<::gfx::Rect>& window_frame_in_screen_dip, const ::gfx::Rect& view_bounds_in_window_dip) {
  GetForwardingInterface()->SetGeometry(
    std::move(window_frame_in_screen_dip)
    , 
    std::move(view_bounds_in_window_dip)
    );
}
void LayerHostInterceptorForTesting::SetDisplayId(int64_t id) {
  GetForwardingInterface()->SetDisplayId(
    std::move(id)
    );
}
LayerHostAsyncWaiter::LayerHostAsyncWaiter(
    LayerHost* proxy) : proxy_(proxy) {}

LayerHostAsyncWaiter::~LayerHostAsyncWaiter() = default;





void WebViewContainerViewInterceptorForTesting::SetWebView(std::optional<uint64_t> web_content_id) {
  GetForwardingInterface()->SetWebView(
    std::move(web_content_id)
    );
}
void WebViewContainerViewInterceptorForTesting::SetVisible(bool value) {
  GetForwardingInterface()->SetVisible(
    std::move(value)
    );
}
void WebViewContainerViewInterceptorForTesting::Destroy() {
  GetForwardingInterface()->Destroy();
}
WebViewContainerViewAsyncWaiter::WebViewContainerViewAsyncWaiter(
    WebViewContainerView* proxy) : proxy_(proxy) {}

WebViewContainerViewAsyncWaiter::~WebViewContainerViewAsyncWaiter() = default;





void LayerHostClientInterceptorForTesting::SetCALayerParams(const ::gfx::CALayerParams& ca_layer_params) {
  GetForwardingInterface()->SetCALayerParams(
    std::move(ca_layer_params)
    );
}
LayerHostClientAsyncWaiter::LayerHostClientAsyncWaiter(
    LayerHostClient* proxy) : proxy_(proxy) {}

LayerHostClientAsyncWaiter::~LayerHostClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif