// owl/mojom/web_content_renderer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/web_content_renderer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/process_id.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "owl/mojom/web_view_container_view.mojom-shared.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared.h"
#include "third_party/blink/public/mojom/webshare/share_error.mojom-shared.h"
#include "ui/base/cursor/mojom/cursor.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"
#include "ui/display/mojom/screen_infos.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/ca_layer_params.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"
#include "ui/base/mojom/attributed_string.mojom-shared.h"


namespace owl::mojom {
class RectWithRangeDataView;

class PopupMenuDataView;



}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::RectWithRangeDataView> {
  using Data = ::owl::mojom::internal::RectWithRange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::PopupMenuDataView> {
  using Data = ::owl::mojom::internal::PopupMenu_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class OverscrollType : int32_t {
  
  kNone = 0,
  
  kAuto = 1,
  
  kContain = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, OverscrollType value);
inline bool IsKnownEnumValue(OverscrollType value) {
  return internal::OverscrollType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebContentRendererInterfaceBase {};

using WebContentRendererPtrDataView =
    mojo::InterfacePtrDataView<WebContentRendererInterfaceBase>;
using WebContentRendererRequestDataView =
    mojo::InterfaceRequestDataView<WebContentRendererInterfaceBase>;
using WebContentRendererAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebContentRendererInterfaceBase>;
using WebContentRendererAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebContentRendererInterfaceBase>;
class PopupMenuRunnerInterfaceBase {};

using PopupMenuRunnerPtrDataView =
    mojo::InterfacePtrDataView<PopupMenuRunnerInterfaceBase>;
using PopupMenuRunnerRequestDataView =
    mojo::InterfaceRequestDataView<PopupMenuRunnerInterfaceBase>;
using PopupMenuRunnerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PopupMenuRunnerInterfaceBase>;
using PopupMenuRunnerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PopupMenuRunnerInterfaceBase>;
class WebContentRendererClientInterfaceBase {};

using WebContentRendererClientPtrDataView =
    mojo::InterfacePtrDataView<WebContentRendererClientInterfaceBase>;
using WebContentRendererClientRequestDataView =
    mojo::InterfaceRequestDataView<WebContentRendererClientInterfaceBase>;
using WebContentRendererClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebContentRendererClientInterfaceBase>;
using WebContentRendererClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebContentRendererClientInterfaceBase>;


class RectWithRangeDataView {
 public:
  RectWithRangeDataView() = default;

  RectWithRangeDataView(
      internal::RectWithRange_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetRangeDataView(
      ::gfx::mojom::RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRange(UserType* output) {
    
    auto* pointer = data_->range.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RangeDataView>(
        pointer, output, message_);
  }
 private:
  internal::RectWithRange_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PopupMenuDataView {
 public:
  PopupMenuDataView() = default;

  PopupMenuDataView(
      internal::PopupMenu_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemsDataView(
      mojo::ArrayDataView<::blink::mojom::MenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::MenuItemDataView>>(
        pointer, output, message_);
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  double item_font_size() const {
    return data_->item_font_size;
  }
  bool right_aligned() const {
    return data_->right_aligned;
  }
  uint32_t selected_item() const {
    return data_->selected_item;
  }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::owl::mojom::PopupMenuRunnerInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PopupMenu_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // owl::mojom

#endif  // OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_DATA_VIEW_H_