// owl/mojom/web_content.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_CONTENT_MOJOM_TEST_UTILS_H_
#define OWL_MOJOM_WEB_CONTENT_MOJOM_TEST_UTILS_H_

#include "owl/mojom/web_content.mojom.h"


namespace owl::mojom {


class  WebContentInterceptorForTesting : public WebContent {
  virtual WebContent* GetForwardingInterface() = 0;
  void SetInputMode(InputMode mode) override;
  void OnMouseEvent(::std::unique_ptr<::ui::Event> event) override;
  void OnBecameFirstResponder(WindowSelectionMethod method) override;
  void DraggingEntered(DropDataPtr drop_data, DraggingInfoPtr dragging_info) override;
  void DraggingExited() override;
  void DraggingUpdated(DraggingInfoPtr dragging_info) override;
  void PerformDragOperation(DraggingInfoPtr dragging_info) override;
  void EndDrag(uint64_t drag_operation, const ::gfx::PointF& local_point, const ::gfx::PointF& screen_point) override;
};
class  WebContentAsyncWaiter {
 public:
  explicit WebContentAsyncWaiter(WebContent* proxy);

  WebContentAsyncWaiter(const WebContentAsyncWaiter&) = delete;
  WebContentAsyncWaiter& operator=(const WebContentAsyncWaiter&) = delete;

  ~WebContentAsyncWaiter();

 private:
  WebContent* const proxy_;
};


class  WebContentClientInterceptorForTesting : public WebContentClient {
  virtual WebContentClient* GetForwardingInterface() = 0;
  void CreateRendererClient(uint64_t id, WebContentRendererType type, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentRendererClient> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebContentRenderer> renderer) override;
  void TakeFocus(bool reverse) override;
  void Destroy() override;
  void ShowContextMenu(::owl::mojom::ContextMenuParamsPtr params) override;
  void StartDrag(DropDataPtr drop_data, const ::url::Origin& source_origin, uint32_t operation_mask, const ::gfx::ImageSkia& image, const ::gfx::Vector2d& image_offset, bool is_privileged) override;
  void StartNativeDrag(const std::string& pasteboard_name, const ::gfx::ImageSkia& image, uint32_t operation, StartNativeDragCallback callback) override;
  void UpdateDragOperation(::ui::mojom::DragOperation operation) override;
};
class  WebContentClientAsyncWaiter {
 public:
  explicit WebContentClientAsyncWaiter(WebContentClient* proxy);

  WebContentClientAsyncWaiter(const WebContentClientAsyncWaiter&) = delete;
  WebContentClientAsyncWaiter& operator=(const WebContentClientAsyncWaiter&) = delete;

  ~WebContentClientAsyncWaiter();
  void StartNativeDrag(
      const std::string& pasteboard_name, const ::gfx::ImageSkia& image, uint32_t operation);
  

 private:
  WebContentClient* const proxy_;
};




}  // owl::mojom

#endif  // OWL_MOJOM_WEB_CONTENT_MOJOM_TEST_UTILS_H_