// owl/mojom/search_keyword.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/search_keyword.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/search_keyword.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* SearchKeywordTypeToStringHelper(SearchKeywordType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SearchKeywordType::kBuiltIn:
      return "kBuiltIn";
    case SearchKeywordType::kOther:
      return "kOther";
    default:
      return nullptr;
  }
}

std::string SearchKeywordTypeToString(SearchKeywordType value) {
  const char *str = SearchKeywordTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SearchKeywordType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SearchKeywordType value) {
  return os << SearchKeywordTypeToString(value);
}

namespace internal {


// static
bool SearchKeyword_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SearchKeyword_Data* object =
      static_cast<const SearchKeyword_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyword, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->keyword, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->favicon_url, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->favicon_url, validation_context))
    return false;


  if (!::owl::mojom::internal::SearchKeywordType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestions_url, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->suggestions_url, validation_context))
    return false;

  return true;
}

SearchKeyword_Data::SearchKeyword_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SearchKeywordsClient_OnSearchKeywordsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SearchKeywordsClient_OnSearchKeywordsChanged_Params_Data* object =
      static_cast<const SearchKeywordsClient_OnSearchKeywordsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->search_keywords, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& search_keywords_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->search_keywords, validation_context,
                                         &search_keywords_validate_params)) {
    return false;
  }

  return true;
}

SearchKeywordsClient_OnSearchKeywordsChanged_Params_Data::SearchKeywordsClient_OnSearchKeywordsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::SearchKeywordType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::SearchKeywordType value) {
  return std::move(context).WriteString(::owl::mojom::SearchKeywordTypeToString(value));
}

} // namespace perfetto