// owl/mojom/profile.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PROFILE_MOJOM_H_
#define OWL_MOJOM_PROFILE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/profile.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/profile.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/profile.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "owl/mojom/autocomplete.mojom-forward.h"
#include "owl/mojom/autofill.mojom-forward.h"
#include "owl/mojom/autofill_deprecated.mojom-forward.h"
#include "owl/mojom/bookmark_model.mojom-forward.h"
#include "owl/mojom/download_manager.mojom-forward.h"
#include "owl/mojom/extension_service.mojom-forward.h"
#include "owl/mojom/metrics.mojom-forward.h"
#include "owl/mojom/notification_service.mojom-forward.h"
#include "owl/mojom/search_keyword.mojom-forward.h"
#include "owl/mojom/web_content.mojom-forward.h"
#include "owl/mojom/web_prefs.mojom-forward.h"
#include "owl/mojom/web_view.mojom-forward.h"
#include "owl/mojom/web_view_container_view.mojom-forward.h"
#include "owl/mojom/web_view_group.mojom-forward.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "ui/display/mojom/display.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include "url/mojom/url.mojom.h"
#include "components/remote_cocoa/common/application.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class DownloadURLToFileClientProxy;

template <typename ImplRefTraits>
class DownloadURLToFileClientStub;

class DownloadURLToFileClientRequestValidator;


class DownloadURLToFileClient
    : public DownloadURLToFileClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.DownloadURLToFileClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DownloadURLToFileClientInterfaceBase;
  using Proxy_ = DownloadURLToFileClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DownloadURLToFileClientStub<ImplRefTraits>;

  using RequestValidator_ = DownloadURLToFileClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDoneOrErroredMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDoneOrErrored_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DownloadURLToFileClient() = default;

  virtual void OnDoneOrErrored(const ::base::FilePath& path, const std::optional<std::string>& mime_type) = 0;
};

class DeferredLoadBlockerProxy;

template <typename ImplRefTraits>
class DeferredLoadBlockerStub;

class DeferredLoadBlockerRequestValidator;


class DeferredLoadBlocker
    : public DeferredLoadBlockerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.DeferredLoadBlocker";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeferredLoadBlockerInterfaceBase;
  using Proxy_ = DeferredLoadBlockerProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeferredLoadBlockerStub<ImplRefTraits>;

  using RequestValidator_ = DeferredLoadBlockerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DeferredLoadBlocker() = default;
};

class ProfileCloseListenerProxy;

template <typename ImplRefTraits>
class ProfileCloseListenerStub;

class ProfileCloseListenerRequestValidator;


class ProfileCloseListener
    : public ProfileCloseListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.ProfileCloseListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProfileCloseListenerInterfaceBase;
  using Proxy_ = ProfileCloseListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProfileCloseListenerStub<ImplRefTraits>;

  using RequestValidator_ = ProfileCloseListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnClosedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProfileCloseListener() = default;

  virtual void OnClosed(bool success) = 0;
};

class ProfileProxy;

template <typename ImplRefTraits>
class ProfileStub;

class ProfileRequestValidator;
class ProfileResponseValidator;


class Profile
    : public ProfileInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.Profile";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProfileInterfaceBase;
  using Proxy_ = ProfileProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProfileStub<ImplRefTraits>;

  using RequestValidator_ = ProfileRequestValidator;
  using ResponseValidator_ = ProfileResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kGetIncognitoVariantMinVersion = 0,
    kUpdateAppearanceNameMinVersion = 0,
    kSetOverrideColorsMinVersion = 0,
    kCreateWebViewGroupMinVersion = 0,
    kRemoveWebViewGroupMinVersion = 0,
    kCreateDownloadManagerMinVersion = 0,
    kCreateBookmarkModelMinVersion = 0,
    kCreateExtensionServiceMinVersion = 0,
    kCreateAutofillControllerMinVersion = 0,
    kCreateMetricsServiceMinVersion = 0,
    kCreateNotificationServiceMinVersion = 0,
    kCreateWebViewContainerViewMinVersion = 0,
    kGetTypedUrlsMinVersion = 0,
    kGetAddressListMinVersion = 0,
    kGetCreditCardListMinVersion = 0,
    kSetCookieMinVersion = 0,
    kDeleteCookieMinVersion = 0,
    kMergeCookiesMinVersion = 0,
    kGetAllCookiesMinVersion = 0,
    kGetCookiesMinVersion = 0,
    kGetFaviconFromFaviconUrlMinVersion = 0,
    kGetFaviconForPageUrlMinVersion = 0,
    kCreateAutocompleteControllerMinVersion = 0,
    kGetDefaultDownloadsLocationMinVersion = 0,
    kSetDefaultDownloadsLocationMinVersion = 0,
    kRegisterSearchKeywordsClientMinVersion = 0,
    kAddSearchKeywordMinVersion = 0,
    kRemoveSearchKeywordMinVersion = 0,
    kUpdateSearchKeywordMinVersion = 0,
    kDownloadURLToFileMinVersion = 0,
    kFlushCookiesMinVersion = 0,
    kCloseProfileMinVersion = 0,
    kImportHistoryMinVersion = 0,
    kImportChromePasswordsMinVersion = 0,
    kClearBrowsingDataMinVersion = 0,
    kDeferLoadsForOriginMinVersion = 0,
    kSetCustomHeaderForHostsMinVersion = 0,
    kResetProfileSettingsMinVersion = 0,
    kSetWebPreferencesMinVersion = 0,
    kGetWebPreferencesMinVersion = 0,
    kQueryHistoryMinVersion = 0,
    kPingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetIncognitoVariant_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateAppearanceName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetOverrideColors_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateWebViewGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveWebViewGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateDownloadManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateBookmarkModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateExtensionService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateAutofillController_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateMetricsService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateNotificationService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateWebViewContainerView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTypedUrls_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAddressList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCreditCardList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCookie_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteCookie_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MergeCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFaviconFromFaviconUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFaviconForPageUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateAutocompleteController_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDefaultDownloadsLocation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDefaultDownloadsLocation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterSearchKeywordsClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddSearchKeyword_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveSearchKeyword_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateSearchKeyword_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DownloadURLToFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FlushCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseProfile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImportHistory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImportChromePasswords_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearBrowsingData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeferLoadsForOrigin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCustomHeaderForHosts_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetProfileSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWebPreferences_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWebPreferences_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueryHistory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Ping_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Profile() = default;

  virtual void SetClient(::mojo::PendingAssociatedRemote<ProfileClient> client) = 0;

  virtual void GetIncognitoVariant(::mojo::PendingReceiver<Profile> receiver) = 0;

  virtual void UpdateAppearanceName(const std::optional<std::string>& appearance_name) = 0;

  virtual void SetOverrideColors(bool is_custom_theme, std::optional<::SkColor> control_accent_color, std::optional<::SkColor> selected_text_background_color, std::optional<::SkColor> insertion_point_color, std::optional<::SkColor> control_accent_background_color, std::optional<::SkColor> control_accent_background_hover_color) = 0;

  virtual void CreateWebViewGroup(const std::string& id, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroup> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroupClient> client) = 0;

  virtual void RemoveWebViewGroup(const std::string& id) = 0;

  virtual void CreateDownloadManager(::mojo::PendingAssociatedReceiver<::owl::mojom::DownloadManager> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::DownloadManagerClient> client) = 0;

  using CreateBookmarkModelCallback = base::OnceCallback<void(CreateBookmarkModelResultPtr)>;
  using CreateBookmarkModelMojoCallback = base::OnceCallback<void(CreateBookmarkModelResultPtr)>;

  virtual void CreateBookmarkModel(CreateBookmarkModelCallback callback) = 0;

  virtual void CreateExtensionService(::mojo::PendingAssociatedReceiver<::owl::mojom::ExtensionService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::ExtensionServiceClient> client) = 0;

  virtual void CreateAutofillController(::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillControllerHost> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillControllerClient> client) = 0;

  virtual void CreateMetricsService(::mojo::PendingAssociatedReceiver<::owl::mojom::MetricsService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::MetricsServiceClient> client) = 0;

  virtual void CreateNotificationService(::mojo::PendingAssociatedReceiver<::owl::mojom::NotificationService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::NotificationServiceClient> client) = 0;

  virtual void CreateWebViewContainerView(::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewContainerView> receiver, ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHost> layer_host_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHostClient> layer_host_client) = 0;

  using GetTypedUrlsCallback = base::OnceCallback<void(std::vector<TypedUrlPtr>)>;
  using GetTypedUrlsMojoCallback = base::OnceCallback<void(std::vector<TypedUrlPtr>)>;

  virtual void GetTypedUrls(GetTypedUrlsCallback callback) = 0;

  using GetAddressListCallback = base::OnceCallback<void(std::vector<::owl::mojom::AutofillAddressEntryPtr>)>;
  using GetAddressListMojoCallback = base::OnceCallback<void(std::vector<::owl::mojom::AutofillAddressEntryPtr>)>;

  virtual void GetAddressList(GetAddressListCallback callback) = 0;

  using GetCreditCardListCallback = base::OnceCallback<void(std::vector<::owl::mojom::AutofillCreditCardEntryPtr>)>;
  using GetCreditCardListMojoCallback = base::OnceCallback<void(std::vector<::owl::mojom::AutofillCreditCardEntryPtr>)>;

  virtual void GetCreditCardList(GetCreditCardListCallback callback) = 0;

  using SetCookieCallback = base::OnceCallback<void(SetCookieResult)>;
  using SetCookieMojoCallback = base::OnceCallback<void(SetCookieResult)>;

  virtual void SetCookie(const ::GURL& url, CookieDataPtr cookie, SetCookieCallback callback) = 0;

  using DeleteCookieCallback = base::OnceCallback<void(DeleteCookieResult)>;
  using DeleteCookieMojoCallback = base::OnceCallback<void(DeleteCookieResult)>;

  virtual void DeleteCookie(const ::GURL& url, CookieDataPtr cookie, DeleteCookieCallback callback) = 0;

  using MergeCookiesCallback = base::OnceCallback<void(uint32_t)>;
  using MergeCookiesMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void MergeCookies(std::vector<CookieDataPtr> cookies, const std::optional<std::vector<uint8_t>>& decryption_key, MergeCookiesCallback callback) = 0;

  using GetAllCookiesCallback = base::OnceCallback<void(std::vector<CookieDataPtr>)>;
  using GetAllCookiesMojoCallback = base::OnceCallback<void(std::vector<CookieDataPtr>)>;

  virtual void GetAllCookies(const ::GURL& url, GetAllCookiesCallback callback) = 0;

  using GetCookiesCallback = base::OnceCallback<void(std::vector<CookieDataPtr>)>;
  using GetCookiesMojoCallback = base::OnceCallback<void(std::vector<CookieDataPtr>)>;

  virtual void GetCookies(const ::GURL& url, const std::string& name, GetCookiesCallback callback) = 0;

  using GetFaviconFromFaviconUrlCallback = base::OnceCallback<void(const ::gfx::ImageSkia&)>;
  using GetFaviconFromFaviconUrlMojoCallback = base::OnceCallback<void(const ::gfx::ImageSkia&)>;

  virtual void GetFaviconFromFaviconUrl(const ::GURL& url, GetFaviconFromFaviconUrlCallback callback) = 0;

  using GetFaviconForPageUrlCallback = base::OnceCallback<void(const ::gfx::ImageSkia&)>;
  using GetFaviconForPageUrlMojoCallback = base::OnceCallback<void(const ::gfx::ImageSkia&)>;

  virtual void GetFaviconForPageUrl(const ::GURL& url, GetFaviconForPageUrlCallback callback) = 0;

  virtual void CreateAutocompleteController(::owl::mojom::AutocompleteConfiguration configuration, ::mojo::PendingAssociatedReceiver<::owl::mojom::AutocompleteController> receiver) = 0;

  using GetDefaultDownloadsLocationCallback = base::OnceCallback<void(const ::base::FilePath&)>;
  using GetDefaultDownloadsLocationMojoCallback = base::OnceCallback<void(const ::base::FilePath&)>;

  virtual void GetDefaultDownloadsLocation(GetDefaultDownloadsLocationCallback callback) = 0;

  virtual void SetDefaultDownloadsLocation(const ::base::FilePath& path) = 0;

  virtual void RegisterSearchKeywordsClient(::mojo::PendingAssociatedRemote<::owl::mojom::SearchKeywordsClient> client) = 0;

  using AddSearchKeywordCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using AddSearchKeywordMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void AddSearchKeyword(const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url, AddSearchKeywordCallback callback) = 0;

  virtual void RemoveSearchKeyword(const std::string& id) = 0;

  virtual void UpdateSearchKeyword(const std::string& id, const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url) = 0;

  virtual void DownloadURLToFile(const ::GURL& url, ::mojo::PendingAssociatedRemote<DownloadURLToFileClient> client) = 0;

  using FlushCookiesCallback = base::OnceCallback<void()>;
  using FlushCookiesMojoCallback = base::OnceCallback<void()>;

  virtual void FlushCookies(FlushCookiesCallback callback) = 0;

  virtual void CloseProfile(::mojo::PendingRemote<ProfileCloseListener> listener) = 0;

  using ImportHistoryCallback = base::OnceCallback<void(int64_t)>;
  using ImportHistoryMojoCallback = base::OnceCallback<void(int64_t)>;

  virtual void ImportHistory(std::vector<HistoryVisitPtr> visits, ImportHistoryCallback callback) = 0;

  using ImportChromePasswordsCallback = base::OnceCallback<void(bool)>;
  using ImportChromePasswordsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ImportChromePasswords(const ::base::FilePath& profile_path, const std::vector<uint8_t>& decryption_key, ImportChromePasswordsCallback callback) = 0;

  using ClearBrowsingDataCallback = base::OnceCallback<void(bool)>;
  using ClearBrowsingDataMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ClearBrowsingData(const std::vector<ClearBrowsingDataType>& types, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end, ClearBrowsingDataCallback callback) = 0;

  virtual void DeferLoadsForOrigin(const ::GURL& origin, ::mojo::PendingReceiver<DeferredLoadBlocker> blocker_receiver) = 0;

  virtual void SetCustomHeaderForHosts(const std::string& header_name, const std::string& header_value, const std::vector<std::string>& hosts) = 0;

  using ResetProfileSettingsCallback = base::OnceCallback<void()>;
  using ResetProfileSettingsMojoCallback = base::OnceCallback<void()>;

  virtual void ResetProfileSettings(ResetProfileSettingsCallback callback) = 0;

  virtual void SetWebPreferences(::owl::mojom::WebPreferencesPtr prefs) = 0;

  using GetWebPreferencesCallback = base::OnceCallback<void(::owl::mojom::WebPreferencesPtr)>;
  using GetWebPreferencesMojoCallback = base::OnceCallback<void(::owl::mojom::WebPreferencesPtr)>;

  virtual void GetWebPreferences(GetWebPreferencesCallback callback) = 0;

  using QueryHistoryCallback = base::OnceCallback<void(QueryHistoryResponsePtr)>;
  using QueryHistoryMojoCallback = base::OnceCallback<void(QueryHistoryResponsePtr)>;

  virtual void QueryHistory(const ::std::u16string& query, QueryHistoryOptionsPtr options, QueryHistoryCallback callback) = 0;

  using PingCallback = base::OnceCallback<void()>;
  using PingMojoCallback = base::OnceCallback<void()>;

  virtual void Ping(PingCallback callback) = 0;
};

class ProfileClientProxy;

template <typename ImplRefTraits>
class ProfileClientStub;

class ProfileClientRequestValidator;


class ProfileClient
    : public ProfileClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.ProfileClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProfileClientInterfaceBase;
  using Proxy_ = ProfileClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProfileClientStub<ImplRefTraits>;

  using RequestValidator_ = ProfileClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateDisplaysMinVersion = 0,
    kCreateWebContentClientMinVersion = 0,
    kCreatedWebViewGroupMinVersion = 0,
    kCreatedIsolatedWebViewMinVersion = 0,
    kCreateWindowBridgeMinVersion = 0,
    kOnMainFrameTypedNavigationMinVersion = 0,
    kOnHistoryDeletionsMinVersion = 0,
    kOnFaviconsChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateDisplays_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateWebContentClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreatedWebViewGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreatedIsolatedWebView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateWindowBridge_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMainFrameTypedNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHistoryDeletions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFaviconsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProfileClient() = default;

  virtual void UpdateDisplays(const std::vector<::display::Display>& displays) = 0;

  virtual void CreateWebContentClient(uint64_t web_content_id, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentClient> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebContent> content) = 0;

  virtual void CreatedWebViewGroup(const std::string& id, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> group, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> client_receiver) = 0;

  virtual void CreatedIsolatedWebView(uint64_t web_content_id, const std::string& group_id, IsolatedWebViewSource source, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> group, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> group_client_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> view, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> view_client_receiver) = 0;

  virtual void CreateWindowBridge(::owl::mojom::WindowBridgeSource source, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> receiver) = 0;

  virtual void OnMainFrameTypedNavigation(const std::string& url_as_string, const ::std::u16string& title) = 0;

  virtual void OnHistoryDeletions(bool is_all_history, bool is_from_expiration, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end, const std::optional<std::vector<::GURL>>& restrict_urls, const std::vector<::GURL>& deleted_urls) = 0;

  virtual void OnFaviconsChanged(const std::vector<::GURL>& page_urls, const std::optional<::GURL>& icon_url) = 0;
};



class  DownloadURLToFileClientProxy
    : public DownloadURLToFileClient {
 public:
  using InterfaceType = DownloadURLToFileClient;

  explicit DownloadURLToFileClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDoneOrErrored(const ::base::FilePath& path, const std::optional<std::string>& mime_type) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DeferredLoadBlockerProxy
    : public DeferredLoadBlocker {
 public:
  using InterfaceType = DeferredLoadBlocker;

  explicit DeferredLoadBlockerProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ProfileCloseListenerProxy
    : public ProfileCloseListener {
 public:
  using InterfaceType = ProfileCloseListener;

  explicit ProfileCloseListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnClosed(bool success) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ProfileProxy
    : public Profile {
 public:
  using InterfaceType = Profile;

  explicit ProfileProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingAssociatedRemote<ProfileClient> client) final;
  
  void GetIncognitoVariant(::mojo::PendingReceiver<Profile> receiver) final;
  
  void UpdateAppearanceName(const std::optional<std::string>& appearance_name) final;
  
  void SetOverrideColors(bool is_custom_theme, std::optional<::SkColor> control_accent_color, std::optional<::SkColor> selected_text_background_color, std::optional<::SkColor> insertion_point_color, std::optional<::SkColor> control_accent_background_color, std::optional<::SkColor> control_accent_background_hover_color) final;
  
  void CreateWebViewGroup(const std::string& id, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroup> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroupClient> client) final;
  
  void RemoveWebViewGroup(const std::string& id) final;
  
  void CreateDownloadManager(::mojo::PendingAssociatedReceiver<::owl::mojom::DownloadManager> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::DownloadManagerClient> client) final;
  
  void CreateBookmarkModel(CreateBookmarkModelCallback callback) final;
  
  void CreateExtensionService(::mojo::PendingAssociatedReceiver<::owl::mojom::ExtensionService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::ExtensionServiceClient> client) final;
  
  void CreateAutofillController(::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillControllerHost> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillControllerClient> client) final;
  
  void CreateMetricsService(::mojo::PendingAssociatedReceiver<::owl::mojom::MetricsService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::MetricsServiceClient> client) final;
  
  void CreateNotificationService(::mojo::PendingAssociatedReceiver<::owl::mojom::NotificationService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::NotificationServiceClient> client) final;
  
  void CreateWebViewContainerView(::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewContainerView> receiver, ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHost> layer_host_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHostClient> layer_host_client) final;
  
  void GetTypedUrls(GetTypedUrlsCallback callback) final;
  
  void GetAddressList(GetAddressListCallback callback) final;
  
  void GetCreditCardList(GetCreditCardListCallback callback) final;
  
  void SetCookie(const ::GURL& url, CookieDataPtr cookie, SetCookieCallback callback) final;
  
  void DeleteCookie(const ::GURL& url, CookieDataPtr cookie, DeleteCookieCallback callback) final;
  
  void MergeCookies(std::vector<CookieDataPtr> cookies, const std::optional<std::vector<uint8_t>>& decryption_key, MergeCookiesCallback callback) final;
  
  void GetAllCookies(const ::GURL& url, GetAllCookiesCallback callback) final;
  
  void GetCookies(const ::GURL& url, const std::string& name, GetCookiesCallback callback) final;
  
  void GetFaviconFromFaviconUrl(const ::GURL& url, GetFaviconFromFaviconUrlCallback callback) final;
  
  void GetFaviconForPageUrl(const ::GURL& url, GetFaviconForPageUrlCallback callback) final;
  
  void CreateAutocompleteController(::owl::mojom::AutocompleteConfiguration configuration, ::mojo::PendingAssociatedReceiver<::owl::mojom::AutocompleteController> receiver) final;
  
  void GetDefaultDownloadsLocation(GetDefaultDownloadsLocationCallback callback) final;
  
  void SetDefaultDownloadsLocation(const ::base::FilePath& path) final;
  
  void RegisterSearchKeywordsClient(::mojo::PendingAssociatedRemote<::owl::mojom::SearchKeywordsClient> client) final;
  
  void AddSearchKeyword(const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url, AddSearchKeywordCallback callback) final;
  
  void RemoveSearchKeyword(const std::string& id) final;
  
  void UpdateSearchKeyword(const std::string& id, const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url) final;
  
  void DownloadURLToFile(const ::GURL& url, ::mojo::PendingAssociatedRemote<DownloadURLToFileClient> client) final;
  
  void FlushCookies(FlushCookiesCallback callback) final;
  
  void CloseProfile(::mojo::PendingRemote<ProfileCloseListener> listener) final;
  
  void ImportHistory(std::vector<HistoryVisitPtr> visits, ImportHistoryCallback callback) final;
  
  void ImportChromePasswords(const ::base::FilePath& profile_path, const std::vector<uint8_t>& decryption_key, ImportChromePasswordsCallback callback) final;
  
  void ClearBrowsingData(const std::vector<ClearBrowsingDataType>& types, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end, ClearBrowsingDataCallback callback) final;
  
  void DeferLoadsForOrigin(const ::GURL& origin, ::mojo::PendingReceiver<DeferredLoadBlocker> blocker_receiver) final;
  
  void SetCustomHeaderForHosts(const std::string& header_name, const std::string& header_value, const std::vector<std::string>& hosts) final;
  
  void ResetProfileSettings(ResetProfileSettingsCallback callback) final;
  
  void SetWebPreferences(::owl::mojom::WebPreferencesPtr prefs) final;
  
  void GetWebPreferences(GetWebPreferencesCallback callback) final;
  
  void QueryHistory(const ::std::u16string& query, QueryHistoryOptionsPtr options, QueryHistoryCallback callback) final;
  
  void Ping(PingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ProfileClientProxy
    : public ProfileClient {
 public:
  using InterfaceType = ProfileClient;

  explicit ProfileClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateDisplays(const std::vector<::display::Display>& displays) final;
  
  void CreateWebContentClient(uint64_t web_content_id, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentClient> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebContent> content) final;
  
  void CreatedWebViewGroup(const std::string& id, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> group, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> client_receiver) final;
  
  void CreatedIsolatedWebView(uint64_t web_content_id, const std::string& group_id, IsolatedWebViewSource source, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> group, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> group_client_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> view, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> view_client_receiver) final;
  
  void CreateWindowBridge(::owl::mojom::WindowBridgeSource source, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> receiver) final;
  
  void OnMainFrameTypedNavigation(const std::string& url_as_string, const ::std::u16string& title) final;
  
  void OnHistoryDeletions(bool is_all_history, bool is_from_expiration, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end, const std::optional<std::vector<::GURL>>& restrict_urls, const std::vector<::GURL>& deleted_urls) final;
  
  void OnFaviconsChanged(const std::vector<::GURL>& page_urls, const std::optional<::GURL>& icon_url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DownloadURLToFileClientStubDispatch {
 public:
  static bool Accept(DownloadURLToFileClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DownloadURLToFileClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DownloadURLToFileClient>>
class DownloadURLToFileClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DownloadURLToFileClientStub() = default;
  ~DownloadURLToFileClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DownloadURLToFileClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DownloadURLToFileClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DeferredLoadBlockerStubDispatch {
 public:
  static bool Accept(DeferredLoadBlocker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeferredLoadBlocker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeferredLoadBlocker>>
class DeferredLoadBlockerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeferredLoadBlockerStub() = default;
  ~DeferredLoadBlockerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeferredLoadBlockerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeferredLoadBlockerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProfileCloseListenerStubDispatch {
 public:
  static bool Accept(ProfileCloseListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProfileCloseListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProfileCloseListener>>
class ProfileCloseListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProfileCloseListenerStub() = default;
  ~ProfileCloseListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfileCloseListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfileCloseListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProfileStubDispatch {
 public:
  static bool Accept(Profile* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Profile* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Profile>>
class ProfileStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProfileStub() = default;
  ~ProfileStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfileStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfileStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProfileClientStubDispatch {
 public:
  static bool Accept(ProfileClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProfileClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProfileClient>>
class ProfileClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProfileClientStub() = default;
  ~ProfileClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfileClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfileClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DownloadURLToFileClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DeferredLoadBlockerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProfileCloseListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProfileRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProfileClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProfileResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};














class  TypedUrl {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TypedUrl, T>::value>;
  using DataView = TypedUrlDataView;
  using Data_ = internal::TypedUrl_Data;

  template <typename... Args>
  static TypedUrlPtr New(Args&&... args) {
    return TypedUrlPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TypedUrlPtr From(const U& u) {
    return mojo::TypeConverter<TypedUrlPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TypedUrl>::Convert(*this);
  }


  TypedUrl();

  TypedUrl(
      int64_t unique_id,
      const std::string& url_as_string,
      const ::std::u16string& title,
      int32_t visit_count,
      int32_t typed_count,
      ::base::Time last_visit_time);


  ~TypedUrl();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TypedUrlPtr>
  TypedUrlPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TypedUrl::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TypedUrl::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TypedUrl::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TypedUrl::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TypedUrl::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TypedUrl::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TypedUrl_UnserializedMessageContext<
            UserType, TypedUrl::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TypedUrl::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TypedUrl::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TypedUrl_UnserializedMessageContext<
            UserType, TypedUrl::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TypedUrl::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t unique_id;
  
  std::string url_as_string;
  
  ::std::u16string title;
  
  int32_t visit_count;
  
  int32_t typed_count;
  
  ::base::Time last_visit_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TypedUrl::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TypedUrl::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TypedUrl::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TypedUrl::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  QueryHistoryItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryHistoryItem, T>::value>;
  using DataView = QueryHistoryItemDataView;
  using Data_ = internal::QueryHistoryItem_Data;

  template <typename... Args>
  static QueryHistoryItemPtr New(Args&&... args) {
    return QueryHistoryItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryHistoryItemPtr From(const U& u) {
    return mojo::TypeConverter<QueryHistoryItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryHistoryItem>::Convert(*this);
  }


  QueryHistoryItem();

  QueryHistoryItem(
      const ::GURL& url,
      const ::std::u16string& title,
      ::base::Time visit_time);


  ~QueryHistoryItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryHistoryItemPtr>
  QueryHistoryItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryHistoryItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QueryHistoryItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QueryHistoryItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryHistoryItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryHistoryItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryHistoryItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryHistoryItem_UnserializedMessageContext<
            UserType, QueryHistoryItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QueryHistoryItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QueryHistoryItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryHistoryItem_UnserializedMessageContext<
            UserType, QueryHistoryItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryHistoryItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::std::u16string title;
  
  ::base::Time visit_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryHistoryItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryHistoryItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryHistoryItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryHistoryItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  QueryHistoryResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryHistoryResponse, T>::value>;
  using DataView = QueryHistoryResponseDataView;
  using Data_ = internal::QueryHistoryResponse_Data;

  template <typename... Args>
  static QueryHistoryResponsePtr New(Args&&... args) {
    return QueryHistoryResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryHistoryResponsePtr From(const U& u) {
    return mojo::TypeConverter<QueryHistoryResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryHistoryResponse>::Convert(*this);
  }


  QueryHistoryResponse();

  explicit QueryHistoryResponse(
      std::vector<QueryHistoryItemPtr> items);

QueryHistoryResponse(const QueryHistoryResponse&) = delete;
QueryHistoryResponse& operator=(const QueryHistoryResponse&) = delete;

  ~QueryHistoryResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryHistoryResponsePtr>
  QueryHistoryResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryHistoryResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QueryHistoryResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QueryHistoryResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryHistoryResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryHistoryResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryHistoryResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryHistoryResponse_UnserializedMessageContext<
            UserType, QueryHistoryResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QueryHistoryResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QueryHistoryResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryHistoryResponse_UnserializedMessageContext<
            UserType, QueryHistoryResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryHistoryResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<QueryHistoryItemPtr> items;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryHistoryResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryHistoryResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryHistoryResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryHistoryResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  QueryHistoryOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryHistoryOptions, T>::value>;
  using DataView = QueryHistoryOptionsDataView;
  using Data_ = internal::QueryHistoryOptions_Data;

  template <typename... Args>
  static QueryHistoryOptionsPtr New(Args&&... args) {
    return QueryHistoryOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryHistoryOptionsPtr From(const U& u) {
    return mojo::TypeConverter<QueryHistoryOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryHistoryOptions>::Convert(*this);
  }


  QueryHistoryOptions();

  QueryHistoryOptions(
      uint32_t limit,
      std::optional<::base::Time> start,
      std::optional<::base::Time> end);


  ~QueryHistoryOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryHistoryOptionsPtr>
  QueryHistoryOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryHistoryOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QueryHistoryOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QueryHistoryOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryHistoryOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryHistoryOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryHistoryOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryHistoryOptions_UnserializedMessageContext<
            UserType, QueryHistoryOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QueryHistoryOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QueryHistoryOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryHistoryOptions_UnserializedMessageContext<
            UserType, QueryHistoryOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryHistoryOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t limit;
  
  std::optional<::base::Time> start;
  
  std::optional<::base::Time> end;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryHistoryOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryHistoryOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryHistoryOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryHistoryOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CookieData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieData, T>::value>;
  using DataView = CookieDataDataView;
  using Data_ = internal::CookieData_Data;

  template <typename... Args>
  static CookieDataPtr New(Args&&... args) {
    return CookieDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieDataPtr From(const U& u) {
    return mojo::TypeConverter<CookieDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieData>::Convert(*this);
  }


  CookieData();

  CookieData(
      const std::string& name,
      const std::string& value,
      std::optional<std::vector<uint8_t>> encrypted_value,
      const std::string& domain,
      const std::string& path,
      bool http_only,
      bool secure,
      CookieSameSite same_site,
      ::base::Time expiration_time,
      std::optional<::base::Time> creation_time,
      std::optional<::base::Time> last_access_time,
      std::optional<::base::Time> last_update_time,
      std::optional<CookiePriority> priority,
      std::optional<CookieSourceScheme> source_scheme,
      std::optional<int32_t> source_port,
      std::optional<CookieSourceType> source_type);


  ~CookieData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieDataPtr>
  CookieDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieData_UnserializedMessageContext<
            UserType, CookieData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieData_UnserializedMessageContext<
            UserType, CookieData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string value;
  
  std::optional<std::vector<uint8_t>> encrypted_value;
  
  std::string domain;
  
  std::string path;
  
  bool http_only;
  
  bool secure;
  
  CookieSameSite same_site;
  
  ::base::Time expiration_time;
  
  std::optional<::base::Time> creation_time;
  
  std::optional<::base::Time> last_access_time;
  
  std::optional<::base::Time> last_update_time;
  
  std::optional<CookiePriority> priority;
  
  std::optional<CookieSourceScheme> source_scheme;
  
  std::optional<int32_t> source_port;
  
  std::optional<CookieSourceType> source_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HistoryVisit {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HistoryVisit, T>::value>;
  using DataView = HistoryVisitDataView;
  using Data_ = internal::HistoryVisit_Data;

  template <typename... Args>
  static HistoryVisitPtr New(Args&&... args) {
    return HistoryVisitPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HistoryVisitPtr From(const U& u) {
    return mojo::TypeConverter<HistoryVisitPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HistoryVisit>::Convert(*this);
  }


  HistoryVisit();

  HistoryVisit(
      int64_t id,
      const std::string& url,
      const std::string& title,
      ::base::Time time,
      std::optional<int64_t> referring_visit_id,
      const std::optional<std::string>& external_referrer_url,
      std::optional<bool> hidden,
      std::optional<int32_t> transition,
      std::optional<bool> should_increment_typed_count,
      std::optional<int64_t> opener_visit_id,
      std::optional<bool> consider_for_ntp_most_visited,
      std::optional<int64_t> visit_duration,
      std::optional<int64_t> redirect_source_visit_id,
      std::optional<int64_t> redirect_destination_visit_id);


  ~HistoryVisit();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HistoryVisitPtr>
  HistoryVisitPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HistoryVisit::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HistoryVisit::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HistoryVisit::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HistoryVisit::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HistoryVisit::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HistoryVisit::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HistoryVisit_UnserializedMessageContext<
            UserType, HistoryVisit::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HistoryVisit::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HistoryVisit::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HistoryVisit_UnserializedMessageContext<
            UserType, HistoryVisit::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HistoryVisit::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  std::string url;
  
  std::string title;
  
  ::base::Time time;
  
  std::optional<int64_t> referring_visit_id;
  
  std::optional<std::string> external_referrer_url;
  
  std::optional<bool> hidden;
  
  std::optional<int32_t> transition;
  
  std::optional<bool> should_increment_typed_count;
  
  std::optional<int64_t> opener_visit_id;
  
  std::optional<bool> consider_for_ntp_most_visited;
  
  std::optional<int64_t> visit_duration;
  
  std::optional<int64_t> redirect_source_visit_id;
  
  std::optional<int64_t> redirect_destination_visit_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HistoryVisit::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HistoryVisit::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HistoryVisit::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HistoryVisit::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CreateBookmarkModelResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateBookmarkModelResult, T>::value>;
  using DataView = CreateBookmarkModelResultDataView;
  using Data_ = internal::CreateBookmarkModelResult_Data;

  template <typename... Args>
  static CreateBookmarkModelResultPtr New(Args&&... args) {
    return CreateBookmarkModelResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateBookmarkModelResultPtr From(const U& u) {
    return mojo::TypeConverter<CreateBookmarkModelResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateBookmarkModelResult>::Convert(*this);
  }


  CreateBookmarkModelResult();

  CreateBookmarkModelResult(
      ::mojo::PendingAssociatedRemote<::owl::mojom::BookmarkModel> model,
      ::mojo::PendingAssociatedReceiver<::owl::mojom::BookmarkModelClient> client);

CreateBookmarkModelResult(const CreateBookmarkModelResult&) = delete;
CreateBookmarkModelResult& operator=(const CreateBookmarkModelResult&) = delete;

  ~CreateBookmarkModelResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateBookmarkModelResultPtr>
  CreateBookmarkModelResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateBookmarkModelResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateBookmarkModelResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateBookmarkModelResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateBookmarkModelResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateBookmarkModelResult_UnserializedMessageContext<
            UserType, CreateBookmarkModelResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateBookmarkModelResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateBookmarkModelResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateBookmarkModelResult_UnserializedMessageContext<
            UserType, CreateBookmarkModelResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateBookmarkModelResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedRemote<::owl::mojom::BookmarkModel> model;
  
  ::mojo::PendingAssociatedReceiver<::owl::mojom::BookmarkModelClient> client;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateBookmarkModelResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateBookmarkModelResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateBookmarkModelResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateBookmarkModelResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TypedUrlPtr TypedUrl::Clone() const {
  return New(
      mojo::Clone(unique_id),
      mojo::Clone(url_as_string),
      mojo::Clone(title),
      mojo::Clone(visit_count),
      mojo::Clone(typed_count),
      mojo::Clone(last_visit_time)
  );
}

template <typename T, TypedUrl::EnableIfSame<T>*>
bool TypedUrl::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->unique_id, other_struct.unique_id))
    return false;
  if (!mojo::Equals(this->url_as_string, other_struct.url_as_string))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->visit_count, other_struct.visit_count))
    return false;
  if (!mojo::Equals(this->typed_count, other_struct.typed_count))
    return false;
  if (!mojo::Equals(this->last_visit_time, other_struct.last_visit_time))
    return false;
  return true;
}

template <typename T, TypedUrl::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.unique_id < rhs.unique_id)
    return true;
  if (rhs.unique_id < lhs.unique_id)
    return false;
  if (lhs.url_as_string < rhs.url_as_string)
    return true;
  if (rhs.url_as_string < lhs.url_as_string)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.visit_count < rhs.visit_count)
    return true;
  if (rhs.visit_count < lhs.visit_count)
    return false;
  if (lhs.typed_count < rhs.typed_count)
    return true;
  if (rhs.typed_count < lhs.typed_count)
    return false;
  if (lhs.last_visit_time < rhs.last_visit_time)
    return true;
  if (rhs.last_visit_time < lhs.last_visit_time)
    return false;
  return false;
}
template <typename StructPtrType>
QueryHistoryItemPtr QueryHistoryItem::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(title),
      mojo::Clone(visit_time)
  );
}

template <typename T, QueryHistoryItem::EnableIfSame<T>*>
bool QueryHistoryItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->visit_time, other_struct.visit_time))
    return false;
  return true;
}

template <typename T, QueryHistoryItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.visit_time < rhs.visit_time)
    return true;
  if (rhs.visit_time < lhs.visit_time)
    return false;
  return false;
}
template <typename StructPtrType>
QueryHistoryResponsePtr QueryHistoryResponse::Clone() const {
  return New(
      mojo::Clone(items)
  );
}

template <typename T, QueryHistoryResponse::EnableIfSame<T>*>
bool QueryHistoryResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->items, other_struct.items))
    return false;
  return true;
}

template <typename T, QueryHistoryResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.items < rhs.items)
    return true;
  if (rhs.items < lhs.items)
    return false;
  return false;
}
template <typename StructPtrType>
QueryHistoryOptionsPtr QueryHistoryOptions::Clone() const {
  return New(
      mojo::Clone(limit),
      mojo::Clone(start),
      mojo::Clone(end)
  );
}

template <typename T, QueryHistoryOptions::EnableIfSame<T>*>
bool QueryHistoryOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->limit, other_struct.limit))
    return false;
  if (!mojo::Equals(this->start, other_struct.start))
    return false;
  if (!mojo::Equals(this->end, other_struct.end))
    return false;
  return true;
}

template <typename T, QueryHistoryOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.limit < rhs.limit)
    return true;
  if (rhs.limit < lhs.limit)
    return false;
  if (lhs.start < rhs.start)
    return true;
  if (rhs.start < lhs.start)
    return false;
  if (lhs.end < rhs.end)
    return true;
  if (rhs.end < lhs.end)
    return false;
  return false;
}
template <typename StructPtrType>
CookieDataPtr CookieData::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value),
      mojo::Clone(encrypted_value),
      mojo::Clone(domain),
      mojo::Clone(path),
      mojo::Clone(http_only),
      mojo::Clone(secure),
      mojo::Clone(same_site),
      mojo::Clone(expiration_time),
      mojo::Clone(creation_time),
      mojo::Clone(last_access_time),
      mojo::Clone(last_update_time),
      mojo::Clone(priority),
      mojo::Clone(source_scheme),
      mojo::Clone(source_port),
      mojo::Clone(source_type)
  );
}

template <typename T, CookieData::EnableIfSame<T>*>
bool CookieData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->encrypted_value, other_struct.encrypted_value))
    return false;
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->http_only, other_struct.http_only))
    return false;
  if (!mojo::Equals(this->secure, other_struct.secure))
    return false;
  if (!mojo::Equals(this->same_site, other_struct.same_site))
    return false;
  if (!mojo::Equals(this->expiration_time, other_struct.expiration_time))
    return false;
  if (!mojo::Equals(this->creation_time, other_struct.creation_time))
    return false;
  if (!mojo::Equals(this->last_access_time, other_struct.last_access_time))
    return false;
  if (!mojo::Equals(this->last_update_time, other_struct.last_update_time))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->source_scheme, other_struct.source_scheme))
    return false;
  if (!mojo::Equals(this->source_port, other_struct.source_port))
    return false;
  if (!mojo::Equals(this->source_type, other_struct.source_type))
    return false;
  return true;
}

template <typename T, CookieData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.encrypted_value < rhs.encrypted_value)
    return true;
  if (rhs.encrypted_value < lhs.encrypted_value)
    return false;
  if (lhs.domain < rhs.domain)
    return true;
  if (rhs.domain < lhs.domain)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.http_only < rhs.http_only)
    return true;
  if (rhs.http_only < lhs.http_only)
    return false;
  if (lhs.secure < rhs.secure)
    return true;
  if (rhs.secure < lhs.secure)
    return false;
  if (lhs.same_site < rhs.same_site)
    return true;
  if (rhs.same_site < lhs.same_site)
    return false;
  if (lhs.expiration_time < rhs.expiration_time)
    return true;
  if (rhs.expiration_time < lhs.expiration_time)
    return false;
  if (lhs.creation_time < rhs.creation_time)
    return true;
  if (rhs.creation_time < lhs.creation_time)
    return false;
  if (lhs.last_access_time < rhs.last_access_time)
    return true;
  if (rhs.last_access_time < lhs.last_access_time)
    return false;
  if (lhs.last_update_time < rhs.last_update_time)
    return true;
  if (rhs.last_update_time < lhs.last_update_time)
    return false;
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  if (lhs.source_scheme < rhs.source_scheme)
    return true;
  if (rhs.source_scheme < lhs.source_scheme)
    return false;
  if (lhs.source_port < rhs.source_port)
    return true;
  if (rhs.source_port < lhs.source_port)
    return false;
  if (lhs.source_type < rhs.source_type)
    return true;
  if (rhs.source_type < lhs.source_type)
    return false;
  return false;
}
template <typename StructPtrType>
HistoryVisitPtr HistoryVisit::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(url),
      mojo::Clone(title),
      mojo::Clone(time),
      mojo::Clone(referring_visit_id),
      mojo::Clone(external_referrer_url),
      mojo::Clone(hidden),
      mojo::Clone(transition),
      mojo::Clone(should_increment_typed_count),
      mojo::Clone(opener_visit_id),
      mojo::Clone(consider_for_ntp_most_visited),
      mojo::Clone(visit_duration),
      mojo::Clone(redirect_source_visit_id),
      mojo::Clone(redirect_destination_visit_id)
  );
}

template <typename T, HistoryVisit::EnableIfSame<T>*>
bool HistoryVisit::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->time, other_struct.time))
    return false;
  if (!mojo::Equals(this->referring_visit_id, other_struct.referring_visit_id))
    return false;
  if (!mojo::Equals(this->external_referrer_url, other_struct.external_referrer_url))
    return false;
  if (!mojo::Equals(this->hidden, other_struct.hidden))
    return false;
  if (!mojo::Equals(this->transition, other_struct.transition))
    return false;
  if (!mojo::Equals(this->should_increment_typed_count, other_struct.should_increment_typed_count))
    return false;
  if (!mojo::Equals(this->opener_visit_id, other_struct.opener_visit_id))
    return false;
  if (!mojo::Equals(this->consider_for_ntp_most_visited, other_struct.consider_for_ntp_most_visited))
    return false;
  if (!mojo::Equals(this->visit_duration, other_struct.visit_duration))
    return false;
  if (!mojo::Equals(this->redirect_source_visit_id, other_struct.redirect_source_visit_id))
    return false;
  if (!mojo::Equals(this->redirect_destination_visit_id, other_struct.redirect_destination_visit_id))
    return false;
  return true;
}

template <typename T, HistoryVisit::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.time < rhs.time)
    return true;
  if (rhs.time < lhs.time)
    return false;
  if (lhs.referring_visit_id < rhs.referring_visit_id)
    return true;
  if (rhs.referring_visit_id < lhs.referring_visit_id)
    return false;
  if (lhs.external_referrer_url < rhs.external_referrer_url)
    return true;
  if (rhs.external_referrer_url < lhs.external_referrer_url)
    return false;
  if (lhs.hidden < rhs.hidden)
    return true;
  if (rhs.hidden < lhs.hidden)
    return false;
  if (lhs.transition < rhs.transition)
    return true;
  if (rhs.transition < lhs.transition)
    return false;
  if (lhs.should_increment_typed_count < rhs.should_increment_typed_count)
    return true;
  if (rhs.should_increment_typed_count < lhs.should_increment_typed_count)
    return false;
  if (lhs.opener_visit_id < rhs.opener_visit_id)
    return true;
  if (rhs.opener_visit_id < lhs.opener_visit_id)
    return false;
  if (lhs.consider_for_ntp_most_visited < rhs.consider_for_ntp_most_visited)
    return true;
  if (rhs.consider_for_ntp_most_visited < lhs.consider_for_ntp_most_visited)
    return false;
  if (lhs.visit_duration < rhs.visit_duration)
    return true;
  if (rhs.visit_duration < lhs.visit_duration)
    return false;
  if (lhs.redirect_source_visit_id < rhs.redirect_source_visit_id)
    return true;
  if (rhs.redirect_source_visit_id < lhs.redirect_source_visit_id)
    return false;
  if (lhs.redirect_destination_visit_id < rhs.redirect_destination_visit_id)
    return true;
  if (rhs.redirect_destination_visit_id < lhs.redirect_destination_visit_id)
    return false;
  return false;
}
template <typename StructPtrType>
CreateBookmarkModelResultPtr CreateBookmarkModelResult::Clone() const {
  return New(
      mojo::Clone(model),
      mojo::Clone(client)
  );
}

template <typename T, CreateBookmarkModelResult::EnableIfSame<T>*>
bool CreateBookmarkModelResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->model, other_struct.model))
    return false;
  if (!mojo::Equals(this->client, other_struct.client))
    return false;
  return true;
}

template <typename T, CreateBookmarkModelResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.model < rhs.model)
    return true;
  if (rhs.model < lhs.model)
    return false;
  if (lhs.client < rhs.client)
    return true;
  if (rhs.client < lhs.client)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::TypedUrl::DataView,
                                         ::owl::mojom::TypedUrlPtr> {
  static bool IsNull(const ::owl::mojom::TypedUrlPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::TypedUrlPtr* output) { output->reset(); }

  static decltype(::owl::mojom::TypedUrl::unique_id) unique_id(
      const ::owl::mojom::TypedUrlPtr& input) {
    return input->unique_id;
  }

  static const decltype(::owl::mojom::TypedUrl::url_as_string)& url_as_string(
      const ::owl::mojom::TypedUrlPtr& input) {
    return input->url_as_string;
  }

  static const decltype(::owl::mojom::TypedUrl::title)& title(
      const ::owl::mojom::TypedUrlPtr& input) {
    return input->title;
  }

  static decltype(::owl::mojom::TypedUrl::visit_count) visit_count(
      const ::owl::mojom::TypedUrlPtr& input) {
    return input->visit_count;
  }

  static decltype(::owl::mojom::TypedUrl::typed_count) typed_count(
      const ::owl::mojom::TypedUrlPtr& input) {
    return input->typed_count;
  }

  static const decltype(::owl::mojom::TypedUrl::last_visit_time)& last_visit_time(
      const ::owl::mojom::TypedUrlPtr& input) {
    return input->last_visit_time;
  }

  static bool Read(::owl::mojom::TypedUrl::DataView input, ::owl::mojom::TypedUrlPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::QueryHistoryItem::DataView,
                                         ::owl::mojom::QueryHistoryItemPtr> {
  static bool IsNull(const ::owl::mojom::QueryHistoryItemPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::QueryHistoryItemPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::QueryHistoryItem::url)& url(
      const ::owl::mojom::QueryHistoryItemPtr& input) {
    return input->url;
  }

  static const decltype(::owl::mojom::QueryHistoryItem::title)& title(
      const ::owl::mojom::QueryHistoryItemPtr& input) {
    return input->title;
  }

  static const decltype(::owl::mojom::QueryHistoryItem::visit_time)& visit_time(
      const ::owl::mojom::QueryHistoryItemPtr& input) {
    return input->visit_time;
  }

  static bool Read(::owl::mojom::QueryHistoryItem::DataView input, ::owl::mojom::QueryHistoryItemPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::QueryHistoryResponse::DataView,
                                         ::owl::mojom::QueryHistoryResponsePtr> {
  static bool IsNull(const ::owl::mojom::QueryHistoryResponsePtr& input) { return !input; }
  static void SetToNull(::owl::mojom::QueryHistoryResponsePtr* output) { output->reset(); }

  static const decltype(::owl::mojom::QueryHistoryResponse::items)& items(
      const ::owl::mojom::QueryHistoryResponsePtr& input) {
    return input->items;
  }

  static bool Read(::owl::mojom::QueryHistoryResponse::DataView input, ::owl::mojom::QueryHistoryResponsePtr* output);
};


template <>
struct  StructTraits<::owl::mojom::QueryHistoryOptions::DataView,
                                         ::owl::mojom::QueryHistoryOptionsPtr> {
  static bool IsNull(const ::owl::mojom::QueryHistoryOptionsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::QueryHistoryOptionsPtr* output) { output->reset(); }

  static decltype(::owl::mojom::QueryHistoryOptions::limit) limit(
      const ::owl::mojom::QueryHistoryOptionsPtr& input) {
    return input->limit;
  }

  static const decltype(::owl::mojom::QueryHistoryOptions::start)& start(
      const ::owl::mojom::QueryHistoryOptionsPtr& input) {
    return input->start;
  }

  static const decltype(::owl::mojom::QueryHistoryOptions::end)& end(
      const ::owl::mojom::QueryHistoryOptionsPtr& input) {
    return input->end;
  }

  static bool Read(::owl::mojom::QueryHistoryOptions::DataView input, ::owl::mojom::QueryHistoryOptionsPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::CookieData::DataView,
                                         ::owl::mojom::CookieDataPtr> {
  static bool IsNull(const ::owl::mojom::CookieDataPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CookieDataPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::CookieData::name)& name(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->name;
  }

  static const decltype(::owl::mojom::CookieData::value)& value(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->value;
  }

  static const decltype(::owl::mojom::CookieData::encrypted_value)& encrypted_value(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->encrypted_value;
  }

  static const decltype(::owl::mojom::CookieData::domain)& domain(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->domain;
  }

  static const decltype(::owl::mojom::CookieData::path)& path(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->path;
  }

  static decltype(::owl::mojom::CookieData::http_only) http_only(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->http_only;
  }

  static decltype(::owl::mojom::CookieData::secure) secure(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->secure;
  }

  static decltype(::owl::mojom::CookieData::same_site) same_site(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->same_site;
  }

  static const decltype(::owl::mojom::CookieData::expiration_time)& expiration_time(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->expiration_time;
  }

  static const decltype(::owl::mojom::CookieData::creation_time)& creation_time(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->creation_time;
  }

  static const decltype(::owl::mojom::CookieData::last_access_time)& last_access_time(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->last_access_time;
  }

  static const decltype(::owl::mojom::CookieData::last_update_time)& last_update_time(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->last_update_time;
  }

  static decltype(::owl::mojom::CookieData::priority) priority(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->priority;
  }

  static decltype(::owl::mojom::CookieData::source_scheme) source_scheme(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->source_scheme;
  }

  static decltype(::owl::mojom::CookieData::source_port) source_port(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->source_port;
  }

  static decltype(::owl::mojom::CookieData::source_type) source_type(
      const ::owl::mojom::CookieDataPtr& input) {
    return input->source_type;
  }

  static bool Read(::owl::mojom::CookieData::DataView input, ::owl::mojom::CookieDataPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::HistoryVisit::DataView,
                                         ::owl::mojom::HistoryVisitPtr> {
  static bool IsNull(const ::owl::mojom::HistoryVisitPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::HistoryVisitPtr* output) { output->reset(); }

  static decltype(::owl::mojom::HistoryVisit::id) id(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->id;
  }

  static const decltype(::owl::mojom::HistoryVisit::url)& url(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->url;
  }

  static const decltype(::owl::mojom::HistoryVisit::title)& title(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->title;
  }

  static const decltype(::owl::mojom::HistoryVisit::time)& time(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->time;
  }

  static decltype(::owl::mojom::HistoryVisit::referring_visit_id) referring_visit_id(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->referring_visit_id;
  }

  static const decltype(::owl::mojom::HistoryVisit::external_referrer_url)& external_referrer_url(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->external_referrer_url;
  }

  static decltype(::owl::mojom::HistoryVisit::hidden) hidden(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->hidden;
  }

  static decltype(::owl::mojom::HistoryVisit::transition) transition(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->transition;
  }

  static decltype(::owl::mojom::HistoryVisit::should_increment_typed_count) should_increment_typed_count(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->should_increment_typed_count;
  }

  static decltype(::owl::mojom::HistoryVisit::opener_visit_id) opener_visit_id(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->opener_visit_id;
  }

  static decltype(::owl::mojom::HistoryVisit::consider_for_ntp_most_visited) consider_for_ntp_most_visited(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->consider_for_ntp_most_visited;
  }

  static decltype(::owl::mojom::HistoryVisit::visit_duration) visit_duration(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->visit_duration;
  }

  static decltype(::owl::mojom::HistoryVisit::redirect_source_visit_id) redirect_source_visit_id(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->redirect_source_visit_id;
  }

  static decltype(::owl::mojom::HistoryVisit::redirect_destination_visit_id) redirect_destination_visit_id(
      const ::owl::mojom::HistoryVisitPtr& input) {
    return input->redirect_destination_visit_id;
  }

  static bool Read(::owl::mojom::HistoryVisit::DataView input, ::owl::mojom::HistoryVisitPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::CreateBookmarkModelResult::DataView,
                                         ::owl::mojom::CreateBookmarkModelResultPtr> {
  static bool IsNull(const ::owl::mojom::CreateBookmarkModelResultPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CreateBookmarkModelResultPtr* output) { output->reset(); }

  static  decltype(::owl::mojom::CreateBookmarkModelResult::model)& model(
       ::owl::mojom::CreateBookmarkModelResultPtr& input) {
    return input->model;
  }

  static  decltype(::owl::mojom::CreateBookmarkModelResult::client)& client(
       ::owl::mojom::CreateBookmarkModelResultPtr& input) {
    return input->client;
  }

  static bool Read(::owl::mojom::CreateBookmarkModelResult::DataView input, ::owl::mojom::CreateBookmarkModelResultPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_PROFILE_MOJOM_H_