// owl/mojom/profile.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PROFILE_MOJOM_SEND_VALIDATION_H_
#define OWL_MOJOM_PROFILE_MOJOM_SEND_VALIDATION_H_

#include "owl/mojom/profile.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "owl/mojom/autocomplete.mojom-shared.h"
#include "owl/mojom/autofill.mojom-shared.h"
#include "owl/mojom/autofill_deprecated.mojom-shared.h"
#include "owl/mojom/bookmark_model.mojom-shared.h"
#include "owl/mojom/download_manager.mojom-shared.h"
#include "owl/mojom/extension_service.mojom-shared.h"
#include "owl/mojom/metrics.mojom-shared.h"
#include "owl/mojom/notification_service.mojom-shared.h"
#include "owl/mojom/search_keyword.mojom-shared.h"
#include "owl/mojom/web_content.mojom-shared.h"
#include "owl/mojom/web_prefs.mojom-shared.h"
#include "owl/mojom/web_view.mojom-shared.h"
#include "owl/mojom/web_view_container_view.mojom-shared.h"
#include "owl/mojom/web_view_group.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/display/mojom/display.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/remote_cocoa/common/application.mojom-shared.h"

#include "owl/mojom/profile.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::ClearBrowsingDataType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::SetCookieResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::DeleteCookieResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::CookieSameSite, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::CookiePriority, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::CookieSourceScheme, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::CookieSourceType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::IsolatedWebViewSource, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::TypedUrlDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::TypedUrlDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::TypedUrl_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->unique_id = Traits::unique_id(input);

      decltype(Traits::url_as_string(input)) in_url_as_string = Traits::url_as_string(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url_as_string)::BaseType> url_as_string_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_url_as_string,
        url_as_string_fragment);

      fragment->url_as_string.Set(
          url_as_string_fragment.is_null() ? nullptr : url_as_string_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url_as_string.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url_as_string in TypedUrl struct");

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in TypedUrl struct");

      fragment->visit_count = Traits::visit_count(input);

      fragment->typed_count = Traits::typed_count(input);

      decltype(Traits::last_visit_time(input)) in_last_visit_time = Traits::last_visit_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_visit_time)::BaseType> last_visit_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_visit_time,
        last_visit_time_fragment);

      fragment->last_visit_time.Set(
          last_visit_time_fragment.is_null() ? nullptr : last_visit_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_visit_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_visit_time in TypedUrl struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::QueryHistoryItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::QueryHistoryItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::QueryHistoryItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in QueryHistoryItem struct");

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in QueryHistoryItem struct");

      decltype(Traits::visit_time(input)) in_visit_time = Traits::visit_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->visit_time)::BaseType> visit_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_visit_time,
        visit_time_fragment);

      fragment->visit_time.Set(
          visit_time_fragment.is_null() ? nullptr : visit_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->visit_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visit_time in QueryHistoryItem struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::QueryHistoryResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::QueryHistoryResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::QueryHistoryResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::items(input)) in_items = Traits::items(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->items)::BaseType>
          items_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::QueryHistoryItemDataView>, send_validation>(
        in_items,
        items_fragment,
        &items_validate_params);

      fragment->items.Set(
          items_fragment.is_null() ? nullptr : items_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->items.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null items in QueryHistoryResponse struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::QueryHistoryOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::QueryHistoryOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::QueryHistoryOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->limit = Traits::limit(input);

      decltype(Traits::start(input)) in_start = Traits::start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->start)::BaseType> start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_start,
        start_fragment);

      fragment->start.Set(
          start_fragment.is_null() ? nullptr : start_fragment.data());

      decltype(Traits::end(input)) in_end = Traits::end(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->end)::BaseType> end_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_end,
        end_fragment);

      fragment->end.Set(
          end_fragment.is_null() ? nullptr : end_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::CookieDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CookieDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CookieData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in CookieData struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in CookieData struct");

      decltype(Traits::encrypted_value(input)) in_encrypted_value = Traits::encrypted_value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->encrypted_value)::BaseType>
          encrypted_value_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& encrypted_value_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_encrypted_value,
        encrypted_value_fragment,
        &encrypted_value_validate_params);

      fragment->encrypted_value.Set(
          encrypted_value_fragment.is_null() ? nullptr : encrypted_value_fragment.data());

      decltype(Traits::domain(input)) in_domain = Traits::domain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->domain)::BaseType> domain_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_domain,
        domain_fragment);

      fragment->domain.Set(
          domain_fragment.is_null() ? nullptr : domain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->domain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain in CookieData struct");

      decltype(Traits::path(input)) in_path = Traits::path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->path)::BaseType> path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_path,
        path_fragment);

      fragment->path.Set(
          path_fragment.is_null() ? nullptr : path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in CookieData struct");

      fragment->http_only = Traits::http_only(input);

      fragment->secure = Traits::secure(input);

      
      mojo::internal::Serialize<::owl::mojom::CookieSameSite>(
        Traits::same_site(input),
        &fragment->same_site);

      decltype(Traits::expiration_time(input)) in_expiration_time = Traits::expiration_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->expiration_time)::BaseType> expiration_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_expiration_time,
        expiration_time_fragment);

      fragment->expiration_time.Set(
          expiration_time_fragment.is_null() ? nullptr : expiration_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->expiration_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiration_time in CookieData struct");

      decltype(Traits::creation_time(input)) in_creation_time = Traits::creation_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->creation_time)::BaseType> creation_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_creation_time,
        creation_time_fragment);

      fragment->creation_time.Set(
          creation_time_fragment.is_null() ? nullptr : creation_time_fragment.data());

      decltype(Traits::last_access_time(input)) in_last_access_time = Traits::last_access_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_access_time)::BaseType> last_access_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_access_time,
        last_access_time_fragment);

      fragment->last_access_time.Set(
          last_access_time_fragment.is_null() ? nullptr : last_access_time_fragment.data());

      decltype(Traits::last_update_time(input)) in_last_update_time = Traits::last_update_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_update_time)::BaseType> last_update_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_update_time,
        last_update_time_fragment);

      fragment->last_update_time.Set(
          last_update_time_fragment.is_null() ? nullptr : last_update_time_fragment.data());
      fragment->priority_$flag = Traits::priority(input).has_value();
      if (Traits::priority(input).has_value()) {
        
        mojo::internal::Serialize<::owl::mojom::CookiePriority>(
          Traits::priority(input).value(),
          &fragment->priority_$value);
      } else {
        fragment->priority_$value =
            static_cast<int32_t>(::owl::mojom::CookiePriority::kMinValue);
      }
      fragment->source_scheme_$flag = Traits::source_scheme(input).has_value();
      if (Traits::source_scheme(input).has_value()) {
        
        mojo::internal::Serialize<::owl::mojom::CookieSourceScheme>(
          Traits::source_scheme(input).value(),
          &fragment->source_scheme_$value);
      } else {
        fragment->source_scheme_$value =
            static_cast<int32_t>(::owl::mojom::CookieSourceScheme::kMinValue);
      }
      fragment->source_port_$flag = Traits::source_port(input).has_value();
      if (Traits::source_port(input).has_value()) {
        fragment->source_port_$value = Traits::source_port(input).value();
      }
      fragment->source_type_$flag = Traits::source_type(input).has_value();
      if (Traits::source_type(input).has_value()) {
        
        mojo::internal::Serialize<::owl::mojom::CookieSourceType>(
          Traits::source_type(input).value(),
          &fragment->source_type_$value);
      } else {
        fragment->source_type_$value =
            static_cast<int32_t>(::owl::mojom::CookieSourceType::kMinValue);
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::HistoryVisitDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::HistoryVisitDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::HistoryVisit_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in HistoryVisit struct");

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in HistoryVisit struct");

      decltype(Traits::time(input)) in_time = Traits::time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->time)::BaseType> time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_time,
        time_fragment);

      fragment->time.Set(
          time_fragment.is_null() ? nullptr : time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time in HistoryVisit struct");
      fragment->referring_visit_id_$flag = Traits::referring_visit_id(input).has_value();
      if (Traits::referring_visit_id(input).has_value()) {
        fragment->referring_visit_id_$value = Traits::referring_visit_id(input).value();
      }

      decltype(Traits::external_referrer_url(input)) in_external_referrer_url = Traits::external_referrer_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->external_referrer_url)::BaseType> external_referrer_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_external_referrer_url,
        external_referrer_url_fragment);

      fragment->external_referrer_url.Set(
          external_referrer_url_fragment.is_null() ? nullptr : external_referrer_url_fragment.data());
      fragment->hidden_$flag = Traits::hidden(input).has_value();
      if (Traits::hidden(input).has_value()) {
        fragment->hidden_$value = Traits::hidden(input).value();
      }
      fragment->transition_$flag = Traits::transition(input).has_value();
      if (Traits::transition(input).has_value()) {
        fragment->transition_$value = Traits::transition(input).value();
      }
      fragment->should_increment_typed_count_$flag = Traits::should_increment_typed_count(input).has_value();
      if (Traits::should_increment_typed_count(input).has_value()) {
        fragment->should_increment_typed_count_$value = Traits::should_increment_typed_count(input).value();
      }
      fragment->opener_visit_id_$flag = Traits::opener_visit_id(input).has_value();
      if (Traits::opener_visit_id(input).has_value()) {
        fragment->opener_visit_id_$value = Traits::opener_visit_id(input).value();
      }
      fragment->consider_for_ntp_most_visited_$flag = Traits::consider_for_ntp_most_visited(input).has_value();
      if (Traits::consider_for_ntp_most_visited(input).has_value()) {
        fragment->consider_for_ntp_most_visited_$value = Traits::consider_for_ntp_most_visited(input).value();
      }
      fragment->visit_duration_$flag = Traits::visit_duration(input).has_value();
      if (Traits::visit_duration(input).has_value()) {
        fragment->visit_duration_$value = Traits::visit_duration(input).value();
      }
      fragment->redirect_source_visit_id_$flag = Traits::redirect_source_visit_id(input).has_value();
      if (Traits::redirect_source_visit_id(input).has_value()) {
        fragment->redirect_source_visit_id_$value = Traits::redirect_source_visit_id(input).value();
      }
      fragment->redirect_destination_visit_id_$flag = Traits::redirect_destination_visit_id(input).has_value();
      if (Traits::redirect_destination_visit_id(input).has_value()) {
        fragment->redirect_destination_visit_id_$value = Traits::redirect_destination_visit_id(input).value();
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::CreateBookmarkModelResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CreateBookmarkModelResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CreateBookmarkModelResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::model(input)) in_model = Traits::model(input);

      
      mojo::internal::Serialize<::owl::mojom::BookmarkModelAssociatedPtrInfoDataView>(
        in_model,
        &fragment->model,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->model)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid model in CreateBookmarkModelResult struct");

      decltype(Traits::client(input)) in_client = Traits::client(input);

      
      mojo::internal::Serialize<::owl::mojom::BookmarkModelClientAssociatedRequestDataView>(
        in_client,
        &fragment->client,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->client)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid client in CreateBookmarkModelResult struct");
  }
};

}  // namespace mojo::internal

#endif  // OWL_MOJOM_PROFILE_MOJOM_SEND_VALIDATION_H_