// owl/mojom/permission_prompt.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/permission_prompt.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/permission_prompt.mojom-params-data.h"
#include "owl/mojom/permission_prompt.mojom-shared-message-ids.h"

#include "owl/mojom/permission_prompt.mojom-import-headers.h"
#include "owl/mojom/permission_prompt.mojom-test-utils.h"


namespace owl::mojom {
PermissionPromptViewButton::PermissionPromptViewButton()
    : text(),
      id() {}

PermissionPromptViewButton::PermissionPromptViewButton(
    const ::std::u16string& text_in,
    int32_t id_in)
    : text(std::move(text_in)),
      id(std::move(id_in)) {}

PermissionPromptViewButton::~PermissionPromptViewButton() = default;

void PermissionPromptViewButton::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PermissionPromptViewButton::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PermissionPromptRequestItem::PermissionPromptRequestItem()
    : request_type(),
      text() {}

PermissionPromptRequestItem::PermissionPromptRequestItem(
    PermissionPromptRequestType request_type_in,
    const ::std::u16string& text_in)
    : request_type(std::move(request_type_in)),
      text(std::move(text_in)) {}

PermissionPromptRequestItem::~PermissionPromptRequestItem() = default;

void PermissionPromptRequestItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_type"), this->request_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PermissionPromptRequestType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PermissionPromptRequestItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PermissionPromptDetails::PermissionPromptDetails()
    : requesting_origin(),
      title(),
      extra_text(),
      is_embedded(),
      requests(),
      allow_text(),
      allow_once_text(),
      block_text(),
      view_buttons() {}

PermissionPromptDetails::PermissionPromptDetails(
    const ::GURL& requesting_origin_in,
    const ::std::u16string& title_in,
    const std::optional<::std::u16string>& extra_text_in,
    bool is_embedded_in,
    std::vector<PermissionPromptRequestItemPtr> requests_in,
    const ::std::u16string& allow_text_in,
    const std::optional<::std::u16string>& allow_once_text_in,
    const ::std::u16string& block_text_in,
    std::vector<PermissionPromptViewButtonPtr> view_buttons_in)
    : requesting_origin(std::move(requesting_origin_in)),
      title(std::move(title_in)),
      extra_text(std::move(extra_text_in)),
      is_embedded(std::move(is_embedded_in)),
      requests(std::move(requests_in)),
      allow_text(std::move(allow_text_in)),
      allow_once_text(std::move(allow_once_text_in)),
      block_text(std::move(block_text_in)),
      view_buttons(std::move(view_buttons_in)) {}

PermissionPromptDetails::~PermissionPromptDetails() = default;

void PermissionPromptDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requesting_origin"), this->requesting_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_text"), this->extra_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_embedded"), this->is_embedded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requests"), this->requests,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PermissionPromptRequestItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_text"), this->allow_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_once_text"), this->allow_once_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "block_text"), this->block_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_buttons"), this->view_buttons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PermissionPromptViewButtonPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PermissionPromptDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PermissionPrompt::IPCStableHashFunction PermissionPrompt::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PermissionPrompt>(message.name())) {
    case messages::PermissionPrompt::kClose: {
      return &PermissionPrompt::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PermissionPrompt::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PermissionPrompt>(message.name())) {
      case messages::PermissionPrompt::kClose:
            return "Receive owl::mojom::PermissionPrompt::Close";
    }
  } else {
    switch (static_cast<messages::PermissionPrompt>(message.name())) {
      case messages::PermissionPrompt::kClose:
            return "Receive reply owl::mojom::PermissionPrompt::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PermissionPrompt::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x247ab6d4;  // IPCStableHash for owl::mojom::PermissionPrompt::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PermissionPromptProxy::PermissionPromptProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PermissionPromptProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::PermissionPrompt::Close");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionPrompt::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::PermissionPrompt_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionPrompt::Name_);
  message.set_method_name("Close");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PermissionPromptStubDispatch::Accept(
    PermissionPrompt* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PermissionPrompt>(message->header()->name)) {
    case messages::PermissionPrompt::kClose: {
      DCHECK(message->is_serialized());
      internal::PermissionPrompt_Close_Params_Data* params =
          reinterpret_cast<internal::PermissionPrompt_Close_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionPrompt.0
      bool success = true;
      PermissionPrompt_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionPrompt::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(        );
      return true;
    }
  }
  return false;
}

// static
bool PermissionPromptStubDispatch::AcceptWithResponder(
    PermissionPrompt* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PermissionPrompt>(message->header()->name)) {
    case messages::PermissionPrompt::kClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPermissionPromptValidationInfo[] = {
    { &internal::PermissionPrompt_Close_Params_Data::Validate,
     nullptr /* no response */},
};

bool PermissionPromptRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::PermissionPrompt::Name_,
    kPermissionPromptValidationInfo);
}

// The declaration includes the definition on other builds.

PermissionPromptClient::IPCStableHashFunction PermissionPromptClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PermissionPromptClient>(message.name())) {
    case messages::PermissionPromptClient::kAccept: {
      return &PermissionPromptClient::Accept_Sym::IPCStableHash;
    }
    case messages::PermissionPromptClient::kAcceptOnce: {
      return &PermissionPromptClient::AcceptOnce_Sym::IPCStableHash;
    }
    case messages::PermissionPromptClient::kDeny: {
      return &PermissionPromptClient::Deny_Sym::IPCStableHash;
    }
    case messages::PermissionPromptClient::kDismiss: {
      return &PermissionPromptClient::Dismiss_Sym::IPCStableHash;
    }
    case messages::PermissionPromptClient::kRunViewButton: {
      return &PermissionPromptClient::RunViewButton_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PermissionPromptClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PermissionPromptClient>(message.name())) {
      case messages::PermissionPromptClient::kAccept:
            return "Receive owl::mojom::PermissionPromptClient::Accept";
      case messages::PermissionPromptClient::kAcceptOnce:
            return "Receive owl::mojom::PermissionPromptClient::AcceptOnce";
      case messages::PermissionPromptClient::kDeny:
            return "Receive owl::mojom::PermissionPromptClient::Deny";
      case messages::PermissionPromptClient::kDismiss:
            return "Receive owl::mojom::PermissionPromptClient::Dismiss";
      case messages::PermissionPromptClient::kRunViewButton:
            return "Receive owl::mojom::PermissionPromptClient::RunViewButton";
    }
  } else {
    switch (static_cast<messages::PermissionPromptClient>(message.name())) {
      case messages::PermissionPromptClient::kAccept:
            return "Receive reply owl::mojom::PermissionPromptClient::Accept";
      case messages::PermissionPromptClient::kAcceptOnce:
            return "Receive reply owl::mojom::PermissionPromptClient::AcceptOnce";
      case messages::PermissionPromptClient::kDeny:
            return "Receive reply owl::mojom::PermissionPromptClient::Deny";
      case messages::PermissionPromptClient::kDismiss:
            return "Receive reply owl::mojom::PermissionPromptClient::Dismiss";
      case messages::PermissionPromptClient::kRunViewButton:
            return "Receive reply owl::mojom::PermissionPromptClient::RunViewButton";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PermissionPromptClient::Accept_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x824422fe;  // IPCStableHash for owl::mojom::PermissionPromptClient::Accept
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionPromptClient::AcceptOnce_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7fa02b18;  // IPCStableHash for owl::mojom::PermissionPromptClient::AcceptOnce
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionPromptClient::Deny_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42ae51ed;  // IPCStableHash for owl::mojom::PermissionPromptClient::Deny
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionPromptClient::Dismiss_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6115f5d4;  // IPCStableHash for owl::mojom::PermissionPromptClient::Dismiss
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionPromptClient::RunViewButton_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd070ea66;  // IPCStableHash for owl::mojom::PermissionPromptClient::RunViewButton
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PermissionPromptClientProxy::PermissionPromptClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PermissionPromptClientProxy::Accept(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::PermissionPromptClient::Accept");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionPromptClient::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::PermissionPromptClient_Accept_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionPromptClient::Name_);
  message.set_method_name("Accept");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PermissionPromptClientProxy::AcceptOnce(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::PermissionPromptClient::AcceptOnce");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionPromptClient::kAcceptOnce), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::PermissionPromptClient_AcceptOnce_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionPromptClient::Name_);
  message.set_method_name("AcceptOnce");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PermissionPromptClientProxy::Deny(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::PermissionPromptClient::Deny");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionPromptClient::kDeny), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::PermissionPromptClient_Deny_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionPromptClient::Name_);
  message.set_method_name("Deny");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PermissionPromptClientProxy::Dismiss(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::PermissionPromptClient::Dismiss");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionPromptClient::kDismiss), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::PermissionPromptClient_Dismiss_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionPromptClient::Name_);
  message.set_method_name("Dismiss");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PermissionPromptClientProxy::RunViewButton(
    int32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::PermissionPromptClient::RunViewButton", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionPromptClient::kRunViewButton), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::PermissionPromptClient_RunViewButton_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionPromptClient::Name_);
  message.set_method_name("RunViewButton");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PermissionPromptClientStubDispatch::Accept(
    PermissionPromptClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PermissionPromptClient>(message->header()->name)) {
    case messages::PermissionPromptClient::kAccept: {
      DCHECK(message->is_serialized());
      internal::PermissionPromptClient_Accept_Params_Data* params =
          reinterpret_cast<internal::PermissionPromptClient_Accept_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionPromptClient.0
      bool success = true;
      PermissionPromptClient_Accept_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionPromptClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Accept(        );
      return true;
    }
    case messages::PermissionPromptClient::kAcceptOnce: {
      DCHECK(message->is_serialized());
      internal::PermissionPromptClient_AcceptOnce_Params_Data* params =
          reinterpret_cast<internal::PermissionPromptClient_AcceptOnce_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionPromptClient.1
      bool success = true;
      PermissionPromptClient_AcceptOnce_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionPromptClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptOnce(        );
      return true;
    }
    case messages::PermissionPromptClient::kDeny: {
      DCHECK(message->is_serialized());
      internal::PermissionPromptClient_Deny_Params_Data* params =
          reinterpret_cast<internal::PermissionPromptClient_Deny_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionPromptClient.2
      bool success = true;
      PermissionPromptClient_Deny_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionPromptClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Deny(        );
      return true;
    }
    case messages::PermissionPromptClient::kDismiss: {
      DCHECK(message->is_serialized());
      internal::PermissionPromptClient_Dismiss_Params_Data* params =
          reinterpret_cast<internal::PermissionPromptClient_Dismiss_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionPromptClient.3
      bool success = true;
      PermissionPromptClient_Dismiss_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionPromptClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Dismiss(        );
      return true;
    }
    case messages::PermissionPromptClient::kRunViewButton: {
      DCHECK(message->is_serialized());
      internal::PermissionPromptClient_RunViewButton_Params_Data* params =
          reinterpret_cast<internal::PermissionPromptClient_RunViewButton_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionPromptClient.4
      bool success = true;
      int32_t p_id{};
      PermissionPromptClient_RunViewButton_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionPromptClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunViewButton(        
        std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool PermissionPromptClientStubDispatch::AcceptWithResponder(
    PermissionPromptClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PermissionPromptClient>(message->header()->name)) {
    case messages::PermissionPromptClient::kAccept: {
      break;
    }
    case messages::PermissionPromptClient::kAcceptOnce: {
      break;
    }
    case messages::PermissionPromptClient::kDeny: {
      break;
    }
    case messages::PermissionPromptClient::kDismiss: {
      break;
    }
    case messages::PermissionPromptClient::kRunViewButton: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPermissionPromptClientValidationInfo[] = {
    { &internal::PermissionPromptClient_Accept_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PermissionPromptClient_AcceptOnce_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PermissionPromptClient_Deny_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PermissionPromptClient_Dismiss_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PermissionPromptClient_RunViewButton_Params_Data::Validate,
     nullptr /* no response */},
};

bool PermissionPromptClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::PermissionPromptClient::Name_,
    kPermissionPromptClientValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::PermissionPromptViewButton::DataView, ::owl::mojom::PermissionPromptViewButtonPtr>::Read(
    ::owl::mojom::PermissionPromptViewButton::DataView input,
    ::owl::mojom::PermissionPromptViewButtonPtr* output) {
  bool success = true;
  ::owl::mojom::PermissionPromptViewButtonPtr result(::owl::mojom::PermissionPromptViewButton::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::PermissionPromptRequestItem::DataView, ::owl::mojom::PermissionPromptRequestItemPtr>::Read(
    ::owl::mojom::PermissionPromptRequestItem::DataView input,
    ::owl::mojom::PermissionPromptRequestItemPtr* output) {
  bool success = true;
  ::owl::mojom::PermissionPromptRequestItemPtr result(::owl::mojom::PermissionPromptRequestItem::New());
  
      if (success && !input.ReadRequestType(&result->request_type))
        success = false;
      if (success && !input.ReadText(&result->text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::PermissionPromptDetails::DataView, ::owl::mojom::PermissionPromptDetailsPtr>::Read(
    ::owl::mojom::PermissionPromptDetails::DataView input,
    ::owl::mojom::PermissionPromptDetailsPtr* output) {
  bool success = true;
  ::owl::mojom::PermissionPromptDetailsPtr result(::owl::mojom::PermissionPromptDetails::New());
  
      if (success && !input.ReadRequestingOrigin(&result->requesting_origin))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadExtraText(&result->extra_text))
        success = false;
      if (success)
        result->is_embedded = input.is_embedded();
      if (success && !input.ReadRequests(&result->requests))
        success = false;
      if (success && !input.ReadAllowText(&result->allow_text))
        success = false;
      if (success && !input.ReadAllowOnceText(&result->allow_once_text))
        success = false;
      if (success && !input.ReadBlockText(&result->block_text))
        success = false;
      if (success && !input.ReadViewButtons(&result->view_buttons))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void PermissionPromptInterceptorForTesting::Close() {
  GetForwardingInterface()->Close();
}
PermissionPromptAsyncWaiter::PermissionPromptAsyncWaiter(
    PermissionPrompt* proxy) : proxy_(proxy) {}

PermissionPromptAsyncWaiter::~PermissionPromptAsyncWaiter() = default;





void PermissionPromptClientInterceptorForTesting::Accept() {
  GetForwardingInterface()->Accept();
}
void PermissionPromptClientInterceptorForTesting::AcceptOnce() {
  GetForwardingInterface()->AcceptOnce();
}
void PermissionPromptClientInterceptorForTesting::Deny() {
  GetForwardingInterface()->Deny();
}
void PermissionPromptClientInterceptorForTesting::Dismiss() {
  GetForwardingInterface()->Dismiss();
}
void PermissionPromptClientInterceptorForTesting::RunViewButton(int32_t id) {
  GetForwardingInterface()->RunViewButton(
    std::move(id)
    );
}
PermissionPromptClientAsyncWaiter::PermissionPromptClientAsyncWaiter(
    PermissionPromptClient* proxy) : proxy_(proxy) {}

PermissionPromptClientAsyncWaiter::~PermissionPromptClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif