// owl/mojom/permission_prompt.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PERMISSION_PROMPT_MOJOM_SHARED_H_
#define OWL_MOJOM_PERMISSION_PROMPT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/permission_prompt.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/permission_prompt.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::PermissionPromptRequestType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::PermissionPromptRequestType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::PermissionPromptRequestType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::PermissionPromptRequestType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::PermissionPromptRequestType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::PermissionPromptViewButtonDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::PermissionPromptViewButtonDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::PermissionPromptViewButton_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in PermissionPromptViewButton struct");

    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::owl::mojom::internal::PermissionPromptViewButton_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::PermissionPromptViewButtonDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::PermissionPromptRequestItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::PermissionPromptRequestItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::PermissionPromptRequestItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::owl::mojom::PermissionPromptRequestType>(
      Traits::request_type(input),
      &fragment->request_type);

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in PermissionPromptRequestItem struct");
  }

  static bool Deserialize(::owl::mojom::internal::PermissionPromptRequestItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::PermissionPromptRequestItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::PermissionPromptDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::PermissionPromptDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::PermissionPromptDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::requesting_origin(input)) in_requesting_origin = Traits::requesting_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requesting_origin)::BaseType> requesting_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_requesting_origin,
      requesting_origin_fragment);

    fragment->requesting_origin.Set(
        requesting_origin_fragment.is_null() ? nullptr : requesting_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->requesting_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requesting_origin in PermissionPromptDetails struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in PermissionPromptDetails struct");

    decltype(Traits::extra_text(input)) in_extra_text = Traits::extra_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extra_text)::BaseType> extra_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_extra_text,
      extra_text_fragment);

    fragment->extra_text.Set(
        extra_text_fragment.is_null() ? nullptr : extra_text_fragment.data());

    fragment->is_embedded = Traits::is_embedded(input);

    decltype(Traits::requests(input)) in_requests = Traits::requests(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requests)::BaseType>
        requests_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::PermissionPromptRequestItemDataView>>(
      in_requests,
      requests_fragment,
      &requests_validate_params);

    fragment->requests.Set(
        requests_fragment.is_null() ? nullptr : requests_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->requests.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requests in PermissionPromptDetails struct");

    decltype(Traits::allow_text(input)) in_allow_text = Traits::allow_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allow_text)::BaseType> allow_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_allow_text,
      allow_text_fragment);

    fragment->allow_text.Set(
        allow_text_fragment.is_null() ? nullptr : allow_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allow_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allow_text in PermissionPromptDetails struct");

    decltype(Traits::allow_once_text(input)) in_allow_once_text = Traits::allow_once_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allow_once_text)::BaseType> allow_once_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_allow_once_text,
      allow_once_text_fragment);

    fragment->allow_once_text.Set(
        allow_once_text_fragment.is_null() ? nullptr : allow_once_text_fragment.data());

    decltype(Traits::block_text(input)) in_block_text = Traits::block_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->block_text)::BaseType> block_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_block_text,
      block_text_fragment);

    fragment->block_text.Set(
        block_text_fragment.is_null() ? nullptr : block_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->block_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null block_text in PermissionPromptDetails struct");

    decltype(Traits::view_buttons(input)) in_view_buttons = Traits::view_buttons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->view_buttons)::BaseType>
        view_buttons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& view_buttons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::PermissionPromptViewButtonDataView>>(
      in_view_buttons,
      view_buttons_fragment,
      &view_buttons_validate_params);

    fragment->view_buttons.Set(
        view_buttons_fragment.is_null() ? nullptr : view_buttons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->view_buttons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null view_buttons in PermissionPromptDetails struct");
  }

  static bool Deserialize(::owl::mojom::internal::PermissionPromptDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::PermissionPromptDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void PermissionPromptViewButtonDataView::GetTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void PermissionPromptRequestItemDataView::GetTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void PermissionPromptDetailsDataView::GetRequestingOriginDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->requesting_origin.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PermissionPromptDetailsDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PermissionPromptDetailsDataView::GetExtraTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->extra_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PermissionPromptDetailsDataView::GetRequestsDataView(
    mojo::ArrayDataView<PermissionPromptRequestItemDataView>* output) {
  auto pointer = data_->requests.Get();
  *output = mojo::ArrayDataView<PermissionPromptRequestItemDataView>(pointer, message_);
}
inline void PermissionPromptDetailsDataView::GetAllowTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->allow_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PermissionPromptDetailsDataView::GetAllowOnceTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->allow_once_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PermissionPromptDetailsDataView::GetBlockTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->block_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PermissionPromptDetailsDataView::GetViewButtonsDataView(
    mojo::ArrayDataView<PermissionPromptViewButtonDataView>* output) {
  auto pointer = data_->view_buttons.Get();
  *output = mojo::ArrayDataView<PermissionPromptViewButtonDataView>(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::PermissionPromptRequestType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::PermissionPromptRequestType value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_PERMISSION_PROMPT_MOJOM_SHARED_H_