// owl/mojom/password_prompt.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PASSWORD_PROMPT_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_PASSWORD_PROMPT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/password_prompt.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace owl::mojom {
class FederatedCredentialsDataView;

class UsernamePasswordCredentialsDataView;

class SavePasswordPromptDetailsDataView;

class PasswordPromptCredentialsDataView;


}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::FederatedCredentialsDataView> {
  using Data = ::owl::mojom::internal::FederatedCredentials_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::UsernamePasswordCredentialsDataView> {
  using Data = ::owl::mojom::internal::UsernamePasswordCredentials_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::SavePasswordPromptDetailsDataView> {
  using Data = ::owl::mojom::internal::SavePasswordPromptDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::PasswordPromptCredentialsDataView> {
  using Data = ::owl::mojom::internal::PasswordPromptCredentials_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class SavePasswordPromptType : int32_t {
  
  kCreateNewEntry = 0,
  
  kUpdateExitingEntry = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SavePasswordPromptType value);
inline bool IsKnownEnumValue(SavePasswordPromptType value) {
  return internal::SavePasswordPromptType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SavePasswordPromptInterfaceBase {};

using SavePasswordPromptPtrDataView =
    mojo::InterfacePtrDataView<SavePasswordPromptInterfaceBase>;
using SavePasswordPromptRequestDataView =
    mojo::InterfaceRequestDataView<SavePasswordPromptInterfaceBase>;
using SavePasswordPromptAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SavePasswordPromptInterfaceBase>;
using SavePasswordPromptAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SavePasswordPromptInterfaceBase>;
class SavePasswordPromptClientInterfaceBase {};

using SavePasswordPromptClientPtrDataView =
    mojo::InterfacePtrDataView<SavePasswordPromptClientInterfaceBase>;
using SavePasswordPromptClientRequestDataView =
    mojo::InterfaceRequestDataView<SavePasswordPromptClientInterfaceBase>;
using SavePasswordPromptClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SavePasswordPromptClientInterfaceBase>;
using SavePasswordPromptClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SavePasswordPromptClientInterfaceBase>;


class FederatedCredentialsDataView {
 public:
  FederatedCredentialsDataView() = default;

  FederatedCredentialsDataView(
      internal::FederatedCredentials_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUpperTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpperText(UserType* output) {
    
    auto* pointer = data_->upper_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetLowerTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLowerText(UserType* output) {
    
    auto* pointer = data_->lower_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::FederatedCredentials_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsernamePasswordCredentialsDataView {
 public:
  UsernamePasswordCredentialsDataView() = default;

  UsernamePasswordCredentialsDataView(
      internal::UsernamePasswordCredentials_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUsernameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsername(UserType* output) {
    
    auto* pointer = data_->username.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetPasswordDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPassword(UserType* output) {
    
    auto* pointer = data_->password.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAllUsernamesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllUsernames(UserType* output) {
    
    auto* pointer = data_->all_usernames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetAllPasswordsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllPasswords(UserType* output) {
    
    auto* pointer = data_->all_passwords.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
 private:
  internal::UsernamePasswordCredentials_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SavePasswordPromptDetailsDataView {
 public:
  SavePasswordPromptDetailsDataView() = default;

  SavePasswordPromptDetailsDataView(
      internal::SavePasswordPromptDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::owl::mojom::SavePasswordPromptType>(
        data_value, output);
  }
  SavePasswordPromptType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::SavePasswordPromptType>(data_->type));
  }
  inline void GetCredentialsDataView(
      PasswordPromptCredentialsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentials(UserType* output) {
    
    auto* pointer = !data_->credentials.is_null() ? &data_->credentials : nullptr;
    return mojo::internal::Deserialize<::owl::mojom::PasswordPromptCredentialsDataView>(
        pointer, output, message_);
  }
 private:
  internal::SavePasswordPromptDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordPromptCredentialsDataView {
 public:
  using Tag = internal::PasswordPromptCredentials_Data::PasswordPromptCredentials_Tag;

  PasswordPromptCredentialsDataView() = default;

  PasswordPromptCredentialsDataView(
      internal::PasswordPromptCredentials_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_username_password_credentials() const { return data_->tag == Tag::kUsernamePasswordCredentials; }
  inline void GetUsernamePasswordCredentialsDataView(
      UsernamePasswordCredentialsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUsernamePasswordCredentials(UserType* output) const {
    
    CHECK(is_username_password_credentials());
    return mojo::internal::Deserialize<::owl::mojom::UsernamePasswordCredentialsDataView>(
        data_->data.f_username_password_credentials.Get(), output, message_);
  }
  bool is_federated_credentials() const { return data_->tag == Tag::kFederatedCredentials; }
  inline void GetFederatedCredentialsDataView(
      FederatedCredentialsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFederatedCredentials(UserType* output) const {
    
    CHECK(is_federated_credentials());
    return mojo::internal::Deserialize<::owl::mojom::FederatedCredentialsDataView>(
        data_->data.f_federated_credentials.Get(), output, message_);
  }

 private:
  internal::PasswordPromptCredentials_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // owl::mojom

#endif  // OWL_MOJOM_PASSWORD_PROMPT_MOJOM_DATA_VIEW_H_