// owl/mojom/icloud_passkeys.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/icloud_passkeys.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/icloud_passkeys.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* UserVerificationRequirementToStringHelper(UserVerificationRequirement value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserVerificationRequirement::kDiscouraged:
      return "kDiscouraged";
    case UserVerificationRequirement::kPreferred:
      return "kPreferred";
    case UserVerificationRequirement::kRequired:
      return "kRequired";
    default:
      return nullptr;
  }
}

std::string UserVerificationRequirementToString(UserVerificationRequirement value) {
  const char *str = UserVerificationRequirementToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserVerificationRequirement value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserVerificationRequirement value) {
  return os << UserVerificationRequirementToString(value);
}

NOINLINE static const char* LargeBlobSupportToStringHelper(LargeBlobSupport value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LargeBlobSupport::kRequired:
      return "kRequired";
    case LargeBlobSupport::kPreferred:
      return "kPreferred";
    case LargeBlobSupport::kNotRequested:
      return "kNotRequested";
    default:
      return nullptr;
  }
}

std::string LargeBlobSupportToString(LargeBlobSupport value) {
  const char *str = LargeBlobSupportToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LargeBlobSupport value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LargeBlobSupport value) {
  return os << LargeBlobSupportToString(value);
}

NOINLINE static const char* MakeCredentialFailureReasonToStringHelper(MakeCredentialFailureReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MakeCredentialFailureReason::kUserConsentButCredentialExcluded:
      return "kUserConsentButCredentialExcluded";
    case MakeCredentialFailureReason::kUserConsentDenied:
      return "kUserConsentDenied";
    case MakeCredentialFailureReason::kUnavailable:
      return "kUnavailable";
    case MakeCredentialFailureReason::kUnknown:
      return "kUnknown";
    default:
      return nullptr;
  }
}

std::string MakeCredentialFailureReasonToString(MakeCredentialFailureReason value) {
  const char *str = MakeCredentialFailureReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MakeCredentialFailureReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MakeCredentialFailureReason value) {
  return os << MakeCredentialFailureReasonToString(value);
}

NOINLINE static const char* GetAssertionFailureReasonToStringHelper(GetAssertionFailureReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GetAssertionFailureReason::kICloudKeychainNoCredentials:
      return "kICloudKeychainNoCredentials";
    case GetAssertionFailureReason::kUserConsentDenied:
      return "kUserConsentDenied";
    case GetAssertionFailureReason::kUnavailable:
      return "kUnavailable";
    default:
      return nullptr;
  }
}

std::string GetAssertionFailureReasonToString(GetAssertionFailureReason value) {
  const char *str = GetAssertionFailureReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GetAssertionFailureReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GetAssertionFailureReason value) {
  return os << GetAssertionFailureReasonToString(value);
}

NOINLINE static const char* GetCredentialsFailureReasonToStringHelper(GetCredentialsFailureReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GetCredentialsFailureReason::kNotAuthorizedOrDenied:
      return "kNotAuthorizedOrDenied";
    case GetCredentialsFailureReason::kUnavailable:
      return "kUnavailable";
    default:
      return nullptr;
  }
}

std::string GetCredentialsFailureReasonToString(GetCredentialsFailureReason value) {
  const char *str = GetCredentialsFailureReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GetCredentialsFailureReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GetCredentialsFailureReason value) {
  return os << GetCredentialsFailureReasonToString(value);
}

namespace internal {


// static
bool ICloudKeychainPasskeyResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ICloudKeychainPasskeyResult_Data* object =
      static_cast<const ICloudKeychainPasskeyResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_attestation_object, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& raw_attestation_object_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_attestation_object, validation_context,
                                         &raw_attestation_object_validate_params)) {
    return false;
  }

  return true;
}

ICloudKeychainPasskeyResult_Data::ICloudKeychainPasskeyResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PRFInput_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PRFInput_Data* object =
      static_cast<const PRFInput_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input1, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input1_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input1, validation_context,
                                         &input1_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& input2_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input2, validation_context,
                                         &input2_validate_params)) {
    return false;
  }

  return true;
}

PRFInput_Data::PRFInput_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PublicKeyCredentialDescriptor_Data* object =
      static_cast<const PublicKeyCredentialDescriptor_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transports, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transports_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->transports, validation_context,
                                         &transports_validate_params)) {
    return false;
  }

  return true;
}

PublicKeyCredentialDescriptor_Data::PublicKeyCredentialDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RequestID_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RequestID_Data* object =
      static_cast<const RequestID_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

RequestID_Data::RequestID_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CtapMakeCredentialRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 96, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CtapMakeCredentialRequest_Data* object =
      static_cast<const CtapMakeCredentialRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rp_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rp_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->rp_id, validation_context,
                                         &rp_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_data_hash, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_data_hash_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_data_hash, validation_context,
                                         &client_data_hash_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_id, validation_context,
                                         &user_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_name, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_name, validation_context,
                                         &user_name_validate_params)) {
    return false;
  }


  if (!::owl::mojom::internal::UserVerificationRequirement_Data
        ::Validate(object->user_verification, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& user_display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_display_name, validation_context,
                                         &user_display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->prf_input, validation_context))
    return false;


  if (!::owl::mojom::internal::LargeBlobSupport_Data
        ::Validate(object->large_blob_support, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->public_key_algorithms, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& public_key_algorithms_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->public_key_algorithms, validation_context,
                                         &public_key_algorithms_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->exclude_list, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& exclude_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->exclude_list, validation_context,
                                         &exclude_list_validate_params)) {
    return false;
  }

  return true;
}

CtapMakeCredentialRequest_Data::CtapMakeCredentialRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CtapGetAssertionRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CtapGetAssertionRequest_Data* object =
      static_cast<const CtapGetAssertionRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rp_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rp_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->rp_id, validation_context,
                                         &rp_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_data_hash, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_data_hash_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_data_hash, validation_context,
                                         &client_data_hash_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allowed_ids, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& allowed_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->allowed_ids, validation_context,
                                         &allowed_ids_validate_params)) {
    return false;
  }


  if (!::owl::mojom::internal::UserVerificationRequirement_Data
        ::Validate(object->user_verification, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prf_inputs, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prf_inputs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prf_inputs, validation_context,
                                         &prf_inputs_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& large_blob_write_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->large_blob_write, validation_context,
                                         &large_blob_write_validate_params)) {
    return false;
  }

  return true;
}

CtapGetAssertionRequest_Data::CtapGetAssertionRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ICloudCredentialPrfData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ICloudCredentialPrfData_Data* object =
      static_cast<const ICloudCredentialPrfData_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& prf_results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prf_results, validation_context,
                                         &prf_results_validate_params)) {
    return false;
  }

  return true;
}

ICloudCredentialPrfData_Data::ICloudCredentialPrfData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ICloudCredential_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ICloudCredential_Data* object =
      static_cast<const ICloudCredential_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_attestation_object, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& raw_attestation_object_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_attestation_object, validation_context,
                                         &raw_attestation_object_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credential_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& credential_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->credential_id, validation_context,
                                         &credential_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->prf_data, validation_context))
    return false;

  return true;
}

ICloudCredential_Data::ICloudCredential_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MakeCredentialResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MakeCredentialResult_Data* object =
      static_cast<const MakeCredentialResult_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;


  if (!::owl::mojom::internal::MakeCredentialFailureReason_Data
        ::Validate(object->failure_reason_$value, validation_context))
    return false;

  return true;
}

MakeCredentialResult_Data::MakeCredentialResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticatorData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuthenticatorData_Data* object =
      static_cast<const AuthenticatorData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_authenticator_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& raw_authenticator_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_authenticator_data, validation_context,
                                         &raw_authenticator_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_id, validation_context,
                                         &user_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credential_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& credential_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->credential_id, validation_context,
                                         &credential_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& hmac_secret_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hmac_secret, validation_context,
                                         &hmac_secret_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& large_blob_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->large_blob, validation_context,
                                         &large_blob_validate_params)) {
    return false;
  }

  return true;
}

AuthenticatorData_Data::AuthenticatorData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetAssertionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetAssertionResult_Data* object =
      static_cast<const GetAssertionResult_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;


  if (!::owl::mojom::internal::GetAssertionFailureReason_Data
        ::Validate(object->failure_reason_$value, validation_context))
    return false;

  return true;
}

GetAssertionResult_Data::GetAssertionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExistingCredential_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExistingCredential_Data* object =
      static_cast<const ExistingCredential_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credential_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& credential_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->credential_id, validation_context,
                                         &credential_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& provider_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->provider_name, validation_context,
                                         &provider_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_handle, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_handle_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_handle, validation_context,
                                         &user_handle_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

ExistingCredential_Data::ExistingCredential_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetCredentialsResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetCredentialsResult_Data* object =
      static_cast<const GetCredentialsResult_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& credentials_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->credentials, validation_context,
                                         &credentials_validate_params)) {
    return false;
  }


  if (!::owl::mojom::internal::GetCredentialsFailureReason_Data
        ::Validate(object->failure_reason_$value, validation_context))
    return false;

  return true;
}

GetCredentialsResult_Data::GetCredentialsResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_Params_Data* object =
      static_cast<const ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_Params_Data::ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ResponseParams_Data* object =
      static_cast<const ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ResponseParams_Data::ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_Params_Data* object =
      static_cast<const ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_Params_Data::ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ResponseParams_Data* object =
      static_cast<const ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ResponseParams_Data::ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ICloudKeychainPasskeyBridge_GetCredentials_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ICloudKeychainPasskeyBridge_GetCredentials_Params_Data* object =
      static_cast<const ICloudKeychainPasskeyBridge_GetCredentials_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rp_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rp_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->rp_id, validation_context,
                                         &rp_id_validate_params)) {
    return false;
  }

  return true;
}

ICloudKeychainPasskeyBridge_GetCredentials_Params_Data::ICloudKeychainPasskeyBridge_GetCredentials_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ICloudKeychainPasskeyBridge_GetCredentials_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ICloudKeychainPasskeyBridge_GetCredentials_ResponseParams_Data* object =
      static_cast<const ICloudKeychainPasskeyBridge_GetCredentials_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ICloudKeychainPasskeyBridge_GetCredentials_ResponseParams_Data::ICloudKeychainPasskeyBridge_GetCredentials_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ICloudKeychainPasskeyBridge_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ICloudKeychainPasskeyBridge_Cancel_Params_Data* object =
      static_cast<const ICloudKeychainPasskeyBridge_Cancel_Params_Data*>(data);

  return true;
}

ICloudKeychainPasskeyBridge_Cancel_Params_Data::ICloudKeychainPasskeyBridge_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::UserVerificationRequirement>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::UserVerificationRequirement value) {
  return std::move(context).WriteString(::owl::mojom::UserVerificationRequirementToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::LargeBlobSupport>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::LargeBlobSupport value) {
  return std::move(context).WriteString(::owl::mojom::LargeBlobSupportToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::MakeCredentialFailureReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::MakeCredentialFailureReason value) {
  return std::move(context).WriteString(::owl::mojom::MakeCredentialFailureReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::GetAssertionFailureReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::GetAssertionFailureReason value) {
  return std::move(context).WriteString(::owl::mojom::GetAssertionFailureReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::GetCredentialsFailureReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::GetCredentialsFailureReason value) {
  return std::move(context).WriteString(::owl::mojom::GetCredentialsFailureReasonToString(value));
}

} // namespace perfetto