// owl/mojom/card_prompt.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_CARD_PROMPT_MOJOM_H_
#define OWL_MOJOM_CARD_PROMPT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/card_prompt.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/card_prompt.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/card_prompt.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class SaveCardPromptProxy;

template <typename ImplRefTraits>
class SaveCardPromptStub;

class SaveCardPromptRequestValidator;


class SaveCardPrompt
    : public SaveCardPromptInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.SaveCardPrompt";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SaveCardPromptInterfaceBase;
  using Proxy_ = SaveCardPromptProxy;

  template <typename ImplRefTraits>
  using Stub_ = SaveCardPromptStub<ImplRefTraits>;

  using RequestValidator_ = SaveCardPromptRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SaveCardPrompt() = default;

  virtual void Close() = 0;
};

class SaveCardPromptClientProxy;

template <typename ImplRefTraits>
class SaveCardPromptClientStub;

class SaveCardPromptClientRequestValidator;


class SaveCardPromptClient
    : public SaveCardPromptClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.SaveCardPromptClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SaveCardPromptClientInterfaceBase;
  using Proxy_ = SaveCardPromptClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SaveCardPromptClientStub<ImplRefTraits>;

  using RequestValidator_ = SaveCardPromptClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAcceptMinVersion = 0,
    kDeclineMinVersion = 0,
    kDismissMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Accept_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Decline_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Dismiss_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SaveCardPromptClient() = default;

  virtual void Accept() = 0;

  virtual void Decline() = 0;

  virtual void Dismiss() = 0;
};



class  SaveCardPromptProxy
    : public SaveCardPrompt {
 public:
  using InterfaceType = SaveCardPrompt;

  explicit SaveCardPromptProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Close() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SaveCardPromptClientProxy
    : public SaveCardPromptClient {
 public:
  using InterfaceType = SaveCardPromptClient;

  explicit SaveCardPromptClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Accept() final;
  
  void Decline() final;
  
  void Dismiss() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SaveCardPromptStubDispatch {
 public:
  static bool Accept(SaveCardPrompt* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SaveCardPrompt* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SaveCardPrompt>>
class SaveCardPromptStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SaveCardPromptStub() = default;
  ~SaveCardPromptStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SaveCardPromptStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SaveCardPromptStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SaveCardPromptClientStubDispatch {
 public:
  static bool Accept(SaveCardPromptClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SaveCardPromptClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SaveCardPromptClient>>
class SaveCardPromptClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SaveCardPromptClientStub() = default;
  ~SaveCardPromptClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SaveCardPromptClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SaveCardPromptClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SaveCardPromptRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SaveCardPromptClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  SaveCardPromptDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SaveCardPromptDetails, T>::value>;
  using DataView = SaveCardPromptDetailsDataView;
  using Data_ = internal::SaveCardPromptDetails_Data;

  template <typename... Args>
  static SaveCardPromptDetailsPtr New(Args&&... args) {
    return SaveCardPromptDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SaveCardPromptDetailsPtr From(const U& u) {
    return mojo::TypeConverter<SaveCardPromptDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SaveCardPromptDetails>::Convert(*this);
  }


  SaveCardPromptDetails();

  SaveCardPromptDetails(
      const ::std::u16string& card_label,
      const ::std::u16string& expiration_date);


  ~SaveCardPromptDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SaveCardPromptDetailsPtr>
  SaveCardPromptDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SaveCardPromptDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SaveCardPromptDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SaveCardPromptDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SaveCardPromptDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SaveCardPromptDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SaveCardPromptDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SaveCardPromptDetails_UnserializedMessageContext<
            UserType, SaveCardPromptDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SaveCardPromptDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SaveCardPromptDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SaveCardPromptDetails_UnserializedMessageContext<
            UserType, SaveCardPromptDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SaveCardPromptDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string card_label;
  
  ::std::u16string expiration_date;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SaveCardPromptDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SaveCardPromptDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SaveCardPromptDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SaveCardPromptDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SaveCardPromptDetailsPtr SaveCardPromptDetails::Clone() const {
  return New(
      mojo::Clone(card_label),
      mojo::Clone(expiration_date)
  );
}

template <typename T, SaveCardPromptDetails::EnableIfSame<T>*>
bool SaveCardPromptDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->card_label, other_struct.card_label))
    return false;
  if (!mojo::Equals(this->expiration_date, other_struct.expiration_date))
    return false;
  return true;
}

template <typename T, SaveCardPromptDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.card_label < rhs.card_label)
    return true;
  if (rhs.card_label < lhs.card_label)
    return false;
  if (lhs.expiration_date < rhs.expiration_date)
    return true;
  if (rhs.expiration_date < lhs.expiration_date)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::SaveCardPromptDetails::DataView,
                                         ::owl::mojom::SaveCardPromptDetailsPtr> {
  static bool IsNull(const ::owl::mojom::SaveCardPromptDetailsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::SaveCardPromptDetailsPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::SaveCardPromptDetails::card_label)& card_label(
      const ::owl::mojom::SaveCardPromptDetailsPtr& input) {
    return input->card_label;
  }

  static const decltype(::owl::mojom::SaveCardPromptDetails::expiration_date)& expiration_date(
      const ::owl::mojom::SaveCardPromptDetailsPtr& input) {
    return input->expiration_date;
  }

  static bool Read(::owl::mojom::SaveCardPromptDetails::DataView input, ::owl::mojom::SaveCardPromptDetailsPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_CARD_PROMPT_MOJOM_H_