// owl/mojom/bookmark_model.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_BOOKMARK_MODEL_MOJOM_SEND_VALIDATION_H_
#define OWL_MOJOM_BOOKMARK_MODEL_MOJOM_SEND_VALIDATION_H_

#include "owl/mojom/bookmark_model.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "owl/mojom/bookmark_model.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::BookmarkType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::BookmarkNodeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::BookmarkNodeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::BookmarkNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uuid)::BaseType> uuid_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UuidDataView, send_validation>(
        in_uuid,
        uuid_fragment);

      fragment->uuid.Set(
          uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uuid.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuid in BookmarkNode struct");

      
      mojo::internal::Serialize<::owl::mojom::BookmarkType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in BookmarkNode struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      decltype(Traits::children(input)) in_children = Traits::children(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->children)::BaseType>
          children_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::BookmarkNodeDataView>, send_validation>(
        in_children,
        children_fragment,
        &children_validate_params);

      fragment->children.Set(
          children_fragment.is_null() ? nullptr : children_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->children.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null children in BookmarkNode struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::BookmarksDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::BookmarksDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::Bookmarks_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bookmark_bar_node(input)) in_bookmark_bar_node = Traits::bookmark_bar_node(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bookmark_bar_node)::BaseType> bookmark_bar_node_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::owl::mojom::BookmarkNodeDataView, send_validation>(
        in_bookmark_bar_node,
        bookmark_bar_node_fragment);

      fragment->bookmark_bar_node.Set(
          bookmark_bar_node_fragment.is_null() ? nullptr : bookmark_bar_node_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bookmark_bar_node.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bookmark_bar_node in Bookmarks struct");

      decltype(Traits::other_node(input)) in_other_node = Traits::other_node(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->other_node)::BaseType> other_node_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::owl::mojom::BookmarkNodeDataView, send_validation>(
        in_other_node,
        other_node_fragment);

      fragment->other_node.Set(
          other_node_fragment.is_null() ? nullptr : other_node_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->other_node.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null other_node in Bookmarks struct");

      decltype(Traits::mobile_node(input)) in_mobile_node = Traits::mobile_node(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mobile_node)::BaseType> mobile_node_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::owl::mojom::BookmarkNodeDataView, send_validation>(
        in_mobile_node,
        mobile_node_fragment);

      fragment->mobile_node.Set(
          mobile_node_fragment.is_null() ? nullptr : mobile_node_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mobile_node.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mobile_node in Bookmarks struct");
  }
};

}  // namespace mojo::internal

#endif  // OWL_MOJOM_BOOKMARK_MODEL_MOJOM_SEND_VALIDATION_H_