// owl/mojom/autocomplete.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/autocomplete.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/autocomplete.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* AutocompleteConfigurationToStringHelper(AutocompleteConfiguration value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutocompleteConfiguration::kMinimal:
      return "kMinimal";
    default:
      return nullptr;
  }
}

std::string AutocompleteConfigurationToString(AutocompleteConfiguration value) {
  const char *str = AutocompleteConfigurationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutocompleteConfiguration value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutocompleteConfiguration value) {
  return os << AutocompleteConfigurationToString(value);
}

NOINLINE static const char* AutocompleteMatchTypeToStringHelper(AutocompleteMatchType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutocompleteMatchType::kUrlThatYouTyped:
      return "kUrlThatYouTyped";
    case AutocompleteMatchType::kHistory:
      return "kHistory";
    case AutocompleteMatchType::kBookmarkTitle:
      return "kBookmarkTitle";
    case AutocompleteMatchType::kOpenTab:
      return "kOpenTab";
    default:
      return nullptr;
  }
}

std::string AutocompleteMatchTypeToString(AutocompleteMatchType value) {
  const char *str = AutocompleteMatchTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutocompleteMatchType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutocompleteMatchType value) {
  return os << AutocompleteMatchTypeToString(value);
}

namespace internal {


// static
bool AutocompleteMatch_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteMatch_Data* object =
      static_cast<const AutocompleteMatch_Data*>(data);


  if (!::owl::mojom::internal::AutocompleteMatchType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fill_into_edit, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fill_into_edit, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->inline_autocompletion, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->inline_autocompletion, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  return true;
}

AutocompleteMatch_Data::AutocompleteMatch_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutocompleteResults_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteResults_Data* object =
      static_cast<const AutocompleteResults_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->matches, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& matches_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->matches, validation_context,
                                         &matches_validate_params)) {
    return false;
  }

  return true;
}

AutocompleteResults_Data::AutocompleteResults_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutocompleteController_Destroy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteController_Destroy_Params_Data* object =
      static_cast<const AutocompleteController_Destroy_Params_Data*>(data);

  return true;
}

AutocompleteController_Destroy_Params_Data::AutocompleteController_Destroy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutocompleteController_Start_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteController_Start_Params_Data* object =
      static_cast<const AutocompleteController_Start_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AutocompleteController_Start_Params_Data::AutocompleteController_Start_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutocompleteController_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteController_Stop_Params_Data* object =
      static_cast<const AutocompleteController_Stop_Params_Data*>(data);

  return true;
}

AutocompleteController_Stop_Params_Data::AutocompleteController_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutocompleteClient_OnResults_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteClient_OnResults_Params_Data* object =
      static_cast<const AutocompleteClient_OnResults_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->results, validation_context))
    return false;

  return true;
}

AutocompleteClient_OnResults_Params_Data::AutocompleteClient_OnResults_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::AutocompleteConfiguration>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::AutocompleteConfiguration value) {
  return std::move(context).WriteString(::owl::mojom::AutocompleteConfigurationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::AutocompleteMatchType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::AutocompleteMatchType value) {
  return std::move(context).WriteString(::owl::mojom::AutocompleteMatchTypeToString(value));
}

} // namespace perfetto