// mojo/public/mojom/base/time.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_TIME_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_TIME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/time.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "mojo/public/cpp/base/time_mojom_traits.h"
#include "base/component_export.h"




namespace mojo_base::mojom {





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) Time {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Time, T>::value>;
  using DataView = TimeDataView;
  using Data_ = internal::Time_Data;

  template <typename... Args>
  static TimePtr New(Args&&... args) {
    return TimePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TimePtr From(const U& u) {
    return mojo::TypeConverter<TimePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Time>::Convert(*this);
  }


  Time();

  explicit Time(
      int64_t internal_value);


  ~Time();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TimePtr>
  TimePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Time::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Time::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Time::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Time::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Time::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Time::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Time_UnserializedMessageContext<
            UserType, Time::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Time::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Time::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Time_UnserializedMessageContext<
            UserType, Time::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Time::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t internal_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Time::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Time::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Time::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Time::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) JSTime {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<JSTime, T>::value>;
  using DataView = JSTimeDataView;
  using Data_ = internal::JSTime_Data;

  template <typename... Args>
  static JSTimePtr New(Args&&... args) {
    return JSTimePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static JSTimePtr From(const U& u) {
    return mojo::TypeConverter<JSTimePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, JSTime>::Convert(*this);
  }


  JSTime();

  explicit JSTime(
      double msec);


  ~JSTime();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = JSTimePtr>
  JSTimePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, JSTime::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, JSTime::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, JSTime::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JSTime::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JSTime::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        JSTime::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::JSTime_UnserializedMessageContext<
            UserType, JSTime::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<JSTime::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return JSTime::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::JSTime_UnserializedMessageContext<
            UserType, JSTime::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<JSTime::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double msec;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, JSTime::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, JSTime::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, JSTime::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, JSTime::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) TimeDelta {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TimeDelta, T>::value>;
  using DataView = TimeDeltaDataView;
  using Data_ = internal::TimeDelta_Data;

  template <typename... Args>
  static TimeDeltaPtr New(Args&&... args) {
    return TimeDeltaPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TimeDeltaPtr From(const U& u) {
    return mojo::TypeConverter<TimeDeltaPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TimeDelta>::Convert(*this);
  }


  TimeDelta();

  explicit TimeDelta(
      int64_t microseconds);


  ~TimeDelta();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TimeDeltaPtr>
  TimeDeltaPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TimeDelta::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TimeDelta::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TimeDelta::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TimeDelta::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TimeDelta::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TimeDelta::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TimeDelta_UnserializedMessageContext<
            UserType, TimeDelta::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TimeDelta::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TimeDelta::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TimeDelta_UnserializedMessageContext<
            UserType, TimeDelta::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TimeDelta::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t microseconds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TimeDelta::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TimeDelta::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TimeDelta::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TimeDelta::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) TimeTicks {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TimeTicks, T>::value>;
  using DataView = TimeTicksDataView;
  using Data_ = internal::TimeTicks_Data;

  template <typename... Args>
  static TimeTicksPtr New(Args&&... args) {
    return TimeTicksPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TimeTicksPtr From(const U& u) {
    return mojo::TypeConverter<TimeTicksPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TimeTicks>::Convert(*this);
  }


  TimeTicks();

  explicit TimeTicks(
      int64_t internal_value);


  ~TimeTicks();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TimeTicksPtr>
  TimeTicksPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TimeTicks::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TimeTicks::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TimeTicks::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TimeTicks::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TimeTicks::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TimeTicks::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TimeTicks_UnserializedMessageContext<
            UserType, TimeTicks::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TimeTicks::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TimeTicks::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TimeTicks_UnserializedMessageContext<
            UserType, TimeTicks::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TimeTicks::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t internal_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TimeTicks::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TimeTicks::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TimeTicks::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TimeTicks::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







template <typename StructPtrType>
TimePtr Time::Clone() const {
  return New(
      mojo::Clone(internal_value)
  );
}

template <typename T, Time::EnableIfSame<T>*>
bool Time::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->internal_value, other_struct.internal_value))
    return false;
  return true;
}

template <typename T, Time::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.internal_value < rhs.internal_value)
    return true;
  if (rhs.internal_value < lhs.internal_value)
    return false;
  return false;
}
template <typename StructPtrType>
JSTimePtr JSTime::Clone() const {
  return New(
      mojo::Clone(msec)
  );
}

template <typename T, JSTime::EnableIfSame<T>*>
bool JSTime::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->msec, other_struct.msec))
    return false;
  return true;
}

template <typename T, JSTime::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.msec < rhs.msec)
    return true;
  if (rhs.msec < lhs.msec)
    return false;
  return false;
}
template <typename StructPtrType>
TimeDeltaPtr TimeDelta::Clone() const {
  return New(
      mojo::Clone(microseconds)
  );
}

template <typename T, TimeDelta::EnableIfSame<T>*>
bool TimeDelta::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->microseconds, other_struct.microseconds))
    return false;
  return true;
}

template <typename T, TimeDelta::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.microseconds < rhs.microseconds)
    return true;
  if (rhs.microseconds < lhs.microseconds)
    return false;
  return false;
}
template <typename StructPtrType>
TimeTicksPtr TimeTicks::Clone() const {
  return New(
      mojo::Clone(internal_value)
  );
}

template <typename T, TimeTicks::EnableIfSame<T>*>
bool TimeTicks::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->internal_value, other_struct.internal_value))
    return false;
  return true;
}

template <typename T, TimeTicks::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.internal_value < rhs.internal_value)
    return true;
  if (rhs.internal_value < lhs.internal_value)
    return false;
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::Time::DataView,
                                         ::mojo_base::mojom::TimePtr> {
  static bool IsNull(const ::mojo_base::mojom::TimePtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::TimePtr* output) { output->reset(); }

  static decltype(::mojo_base::mojom::Time::internal_value) internal_value(
      const ::mojo_base::mojom::TimePtr& input) {
    return input->internal_value;
  }

  static bool Read(::mojo_base::mojom::Time::DataView input, ::mojo_base::mojom::TimePtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::JSTime::DataView,
                                         ::mojo_base::mojom::JSTimePtr> {
  static bool IsNull(const ::mojo_base::mojom::JSTimePtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::JSTimePtr* output) { output->reset(); }

  static decltype(::mojo_base::mojom::JSTime::msec) msec(
      const ::mojo_base::mojom::JSTimePtr& input) {
    return input->msec;
  }

  static bool Read(::mojo_base::mojom::JSTime::DataView input, ::mojo_base::mojom::JSTimePtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::TimeDelta::DataView,
                                         ::mojo_base::mojom::TimeDeltaPtr> {
  static bool IsNull(const ::mojo_base::mojom::TimeDeltaPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::TimeDeltaPtr* output) { output->reset(); }

  static decltype(::mojo_base::mojom::TimeDelta::microseconds) microseconds(
      const ::mojo_base::mojom::TimeDeltaPtr& input) {
    return input->microseconds;
  }

  static bool Read(::mojo_base::mojom::TimeDelta::DataView input, ::mojo_base::mojom::TimeDeltaPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::TimeTicks::DataView,
                                         ::mojo_base::mojom::TimeTicksPtr> {
  static bool IsNull(const ::mojo_base::mojom::TimeTicksPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::TimeTicksPtr* output) { output->reset(); }

  static decltype(::mojo_base::mojom::TimeTicks::internal_value) internal_value(
      const ::mojo_base::mojom::TimeTicksPtr& input) {
    return input->internal_value;
  }

  static bool Read(::mojo_base::mojom::TimeTicks::DataView input, ::mojo_base::mojom::TimeTicksPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_TIME_MOJOM_H_