// mojo/public/mojom/base/proto_wrapper.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_PROTO_WRAPPER_MOJOM_BLINK_H_
#define MOJO_PUBLIC_MOJOM_BASE_PROTO_WRAPPER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/proto_wrapper.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/proto_wrapper.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/base/proto_wrapper_mojom_traits.h"
#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace mojo_base::mojom::blink {








class COMPONENT_EXPORT(MOJO_BASE_MOJOM_PROTOBUF_SUPPORT_BLINK) ProtoWrapper {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProtoWrapper, T>::value>;
  using DataView = ProtoWrapperDataView;
  using Data_ = internal::ProtoWrapper_Data;

  template <typename... Args>
  static ProtoWrapperPtr New(Args&&... args) {
    return ProtoWrapperPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProtoWrapperPtr From(const U& u) {
    return mojo::TypeConverter<ProtoWrapperPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProtoWrapper>::Convert(*this);
  }


  ProtoWrapper();

  ProtoWrapper(
      const ::blink::String& proto_name,
      ::mojo_base::BigBuffer smuggled);

ProtoWrapper(const ProtoWrapper&) = delete;
ProtoWrapper& operator=(const ProtoWrapper&) = delete;

  ~ProtoWrapper();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProtoWrapperPtr>
  ProtoWrapperPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProtoWrapper::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProtoWrapper::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProtoWrapper::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProtoWrapper::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProtoWrapper_UnserializedMessageContext<
            UserType, ProtoWrapper::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProtoWrapper::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProtoWrapper::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProtoWrapper_UnserializedMessageContext<
            UserType, ProtoWrapper::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProtoWrapper::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String proto_name;
  
  ::mojo_base::BigBuffer smuggled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProtoWrapper::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProtoWrapper::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProtoWrapper::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProtoWrapper::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ProtoWrapperPtr ProtoWrapper::Clone() const {
  return New(
      mojo::Clone(proto_name),
      mojo::Clone(smuggled)
  );
}

template <typename T, ProtoWrapper::EnableIfSame<T>*>
bool ProtoWrapper::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->proto_name, other_struct.proto_name))
    return false;
  if (!mojo::Equals(this->smuggled, other_struct.smuggled))
    return false;
  return true;
}

template <typename T, ProtoWrapper::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.proto_name < rhs.proto_name)
    return true;
  if (rhs.proto_name < lhs.proto_name)
    return false;
  if (lhs.smuggled < rhs.smuggled)
    return true;
  if (rhs.smuggled < lhs.smuggled)
    return false;
  return false;
}


}  // mojo_base::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM_PROTOBUF_SUPPORT_BLINK) StructTraits<::mojo_base::mojom::blink::ProtoWrapper::DataView,
                                         ::mojo_base::mojom::blink::ProtoWrapperPtr> {
  static bool IsNull(const ::mojo_base::mojom::blink::ProtoWrapperPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::blink::ProtoWrapperPtr* output) { output->reset(); }

  static const decltype(::mojo_base::mojom::blink::ProtoWrapper::proto_name)& proto_name(
      const ::mojo_base::mojom::blink::ProtoWrapperPtr& input) {
    return input->proto_name;
  }

  static  decltype(::mojo_base::mojom::blink::ProtoWrapper::smuggled)& smuggled(
       ::mojo_base::mojom::blink::ProtoWrapperPtr& input) {
    return input->smuggled;
  }

  static bool Read(::mojo_base::mojom::blink::ProtoWrapper::DataView input, ::mojo_base::mojom::blink::ProtoWrapperPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_PROTO_WRAPPER_MOJOM_BLINK_H_