// mojo/public/mojom/base/int128.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_INT128_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_INT128_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/int128.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/int128.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/int128.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "mojo/public/cpp/base/int128_mojom_traits.h"
#include "base/component_export.h"




namespace mojo_base::mojom {





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) Int128 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Int128, T>::value>;
  using DataView = Int128DataView;
  using Data_ = internal::Int128_Data;

  template <typename... Args>
  static Int128Ptr New(Args&&... args) {
    return Int128Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Int128Ptr From(const U& u) {
    return mojo::TypeConverter<Int128Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Int128>::Convert(*this);
  }


  Int128();

  Int128(
      int64_t high,
      uint64_t low);


  ~Int128();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Int128Ptr>
  Int128Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Int128::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Int128::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Int128::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Int128::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Int128::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Int128::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Int128_UnserializedMessageContext<
            UserType, Int128::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Int128::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Int128::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Int128_UnserializedMessageContext<
            UserType, Int128::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Int128::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t high;
  
  uint64_t low;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Int128::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Int128::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Int128::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Int128::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) Uint128 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Uint128, T>::value>;
  using DataView = Uint128DataView;
  using Data_ = internal::Uint128_Data;

  template <typename... Args>
  static Uint128Ptr New(Args&&... args) {
    return Uint128Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Uint128Ptr From(const U& u) {
    return mojo::TypeConverter<Uint128Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Uint128>::Convert(*this);
  }


  Uint128();

  Uint128(
      uint64_t high,
      uint64_t low);


  ~Uint128();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Uint128Ptr>
  Uint128Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Uint128::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Uint128::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Uint128::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Uint128::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Uint128::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Uint128::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Uint128_UnserializedMessageContext<
            UserType, Uint128::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Uint128::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Uint128::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Uint128_UnserializedMessageContext<
            UserType, Uint128::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Uint128::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t high;
  
  uint64_t low;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Uint128::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Uint128::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Uint128::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Uint128::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename StructPtrType>
Int128Ptr Int128::Clone() const {
  return New(
      mojo::Clone(high),
      mojo::Clone(low)
  );
}

template <typename T, Int128::EnableIfSame<T>*>
bool Int128::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->high, other_struct.high))
    return false;
  if (!mojo::Equals(this->low, other_struct.low))
    return false;
  return true;
}

template <typename T, Int128::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.high < rhs.high)
    return true;
  if (rhs.high < lhs.high)
    return false;
  if (lhs.low < rhs.low)
    return true;
  if (rhs.low < lhs.low)
    return false;
  return false;
}
template <typename StructPtrType>
Uint128Ptr Uint128::Clone() const {
  return New(
      mojo::Clone(high),
      mojo::Clone(low)
  );
}

template <typename T, Uint128::EnableIfSame<T>*>
bool Uint128::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->high, other_struct.high))
    return false;
  if (!mojo::Equals(this->low, other_struct.low))
    return false;
  return true;
}

template <typename T, Uint128::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.high < rhs.high)
    return true;
  if (rhs.high < lhs.high)
    return false;
  if (lhs.low < rhs.low)
    return true;
  if (rhs.low < lhs.low)
    return false;
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::Int128::DataView,
                                         ::mojo_base::mojom::Int128Ptr> {
  static bool IsNull(const ::mojo_base::mojom::Int128Ptr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::Int128Ptr* output) { output->reset(); }

  static decltype(::mojo_base::mojom::Int128::high) high(
      const ::mojo_base::mojom::Int128Ptr& input) {
    return input->high;
  }

  static decltype(::mojo_base::mojom::Int128::low) low(
      const ::mojo_base::mojom::Int128Ptr& input) {
    return input->low;
  }

  static bool Read(::mojo_base::mojom::Int128::DataView input, ::mojo_base::mojom::Int128Ptr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::Uint128::DataView,
                                         ::mojo_base::mojom::Uint128Ptr> {
  static bool IsNull(const ::mojo_base::mojom::Uint128Ptr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::Uint128Ptr* output) { output->reset(); }

  static decltype(::mojo_base::mojom::Uint128::high) high(
      const ::mojo_base::mojom::Uint128Ptr& input) {
    return input->high;
  }

  static decltype(::mojo_base::mojom::Uint128::low) low(
      const ::mojo_base::mojom::Uint128Ptr& input) {
    return input->low;
  }

  static bool Read(::mojo_base::mojom::Uint128::DataView input, ::mojo_base::mojom::Uint128Ptr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_INT128_MOJOM_H_