// mojo/public/mojom/base/byte_count.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_BYTE_COUNT_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_BYTE_COUNT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/byte_count.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_count.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_count.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "mojo/public/cpp/base/byte_count_mojom_traits.h"
#include "base/component_export.h"




namespace mojo_base::mojom {





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) ByteCount {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ByteCount, T>::value>;
  using DataView = ByteCountDataView;
  using Data_ = internal::ByteCount_Data;

  template <typename... Args>
  static ByteCountPtr New(Args&&... args) {
    return ByteCountPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ByteCountPtr From(const U& u) {
    return mojo::TypeConverter<ByteCountPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ByteCount>::Convert(*this);
  }


  ByteCount();

  explicit ByteCount(
      int64_t count);


  ~ByteCount();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ByteCountPtr>
  ByteCountPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ByteCount::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ByteCount::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ByteCount::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ByteCount::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ByteCount::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ByteCount::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ByteCount_UnserializedMessageContext<
            UserType, ByteCount::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ByteCount::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ByteCount::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ByteCount_UnserializedMessageContext<
            UserType, ByteCount::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ByteCount::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ByteCount::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ByteCount::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ByteCount::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ByteCount::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
ByteCountPtr ByteCount::Clone() const {
  return New(
      mojo::Clone(count)
  );
}

template <typename T, ByteCount::EnableIfSame<T>*>
bool ByteCount::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->count, other_struct.count))
    return false;
  return true;
}

template <typename T, ByteCount::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.count < rhs.count)
    return true;
  if (rhs.count < lhs.count)
    return false;
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::ByteCount::DataView,
                                         ::mojo_base::mojom::ByteCountPtr> {
  static bool IsNull(const ::mojo_base::mojom::ByteCountPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::ByteCountPtr* output) { output->reset(); }

  static decltype(::mojo_base::mojom::ByteCount::count) count(
      const ::mojo_base::mojom::ByteCountPtr& input) {
    return input->count;
  }

  static bool Read(::mojo_base::mojom::ByteCount::DataView input, ::mojo_base::mojom::ByteCountPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_BYTE_COUNT_MOJOM_H_