// mojo/public/interfaces/bindings/pipe_control_messages.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_SEND_VALIDATION_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_SEND_VALIDATION_H_

#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-shared-internal.h"

#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojo::pipe_control::RunOrClosePipeMessageParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::pipe_control::RunOrClosePipeMessageParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::pipe_control::internal::RunOrClosePipeMessageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::input(input)) in_input = Traits::input(input);
      mojo::internal::MessageFragment<decltype(fragment->input)>
          input_fragment(fragment.message());
      input_fragment.Claim(&fragment->input);
      
      mojo::internal::Serialize<::mojo::pipe_control::RunOrClosePipeInputDataView, send_validation>(
        in_input,
        input_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input in RunOrClosePipeMessageParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojo::pipe_control::DisconnectReasonDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::pipe_control::DisconnectReasonDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::pipe_control::internal::DisconnectReason_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->custom_reason = Traits::custom_reason(input);

      decltype(Traits::description(input)) in_description = Traits::description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description)::BaseType> description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_description,
        description_fragment);

      fragment->description.Set(
          description_fragment.is_null() ? nullptr : description_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->description.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in DisconnectReason struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::pipe_control::internal::PeerAssociatedEndpointClosedEvent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::disconnect_reason(input)) in_disconnect_reason = Traits::disconnect_reason(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->disconnect_reason)::BaseType> disconnect_reason_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo::pipe_control::DisconnectReasonDataView, send_validation>(
        in_disconnect_reason,
        disconnect_reason_fragment);

      fragment->disconnect_reason.Set(
          disconnect_reason_fragment.is_null() ? nullptr : disconnect_reason_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojo::pipe_control::PauseUntilFlushCompletesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::pipe_control::PauseUntilFlushCompletesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::pipe_control::internal::PauseUntilFlushCompletes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::flush_pipe(input)) in_flush_pipe = Traits::flush_pipe(input);

      
      mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
        in_flush_pipe,
        &fragment->flush_pipe,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->flush_pipe)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid flush_pipe in PauseUntilFlushCompletes struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojo::pipe_control::FlushAsyncDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::pipe_control::FlushAsyncDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::pipe_control::internal::FlushAsync_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::flusher_pipe(input)) in_flusher_pipe = Traits::flusher_pipe(input);

      
      mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
        in_flusher_pipe,
        &fragment->flusher_pipe,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->flusher_pipe)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid flusher_pipe in FlushAsync struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::mojo::pipe_control::RunOrClosePipeInputDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojo::pipe_control::RunOrClosePipeInputDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojo::pipe_control::internal::RunOrClosePipeInput_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojo::pipe_control::RunOrClosePipeInputDataView::Tag::kPeerAssociatedEndpointClosedEvent: {
    decltype(Traits::peer_associated_endpoint_closed_event(input))
    in_peer_associated_endpoint_closed_event = Traits::peer_associated_endpoint_closed_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_peer_associated_endpoint_closed_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView, send_validation>(
  in_peer_associated_endpoint_closed_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null peer_associated_endpoint_closed_event in RunOrClosePipeInput union");
    fragment->data.f_peer_associated_endpoint_closed_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo::pipe_control::RunOrClosePipeInputDataView::Tag::kPauseUntilFlushCompletes: {
    decltype(Traits::pause_until_flush_completes(input))
    in_pause_until_flush_completes = Traits::pause_until_flush_completes(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pause_until_flush_completes)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo::pipe_control::PauseUntilFlushCompletesDataView, send_validation>(
  in_pause_until_flush_completes,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pause_until_flush_completes in RunOrClosePipeInput union");
    fragment->data.f_pause_until_flush_completes.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo::pipe_control::RunOrClosePipeInputDataView::Tag::kFlushAsync: {
    decltype(Traits::flush_async(input))
    in_flush_async = Traits::flush_async(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_flush_async)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo::pipe_control::FlushAsyncDataView, send_validation>(
  in_flush_async,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null flush_async in RunOrClosePipeInput union");
    fragment->data.f_flush_async.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_SEND_VALIDATION_H_