// media/mojo/mojom/watch_time_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/watch_time_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/watch_time_recorder.mojom-params-data.h"
#include "media/mojo/mojom/watch_time_recorder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/watch_time_recorder.mojom-import-headers.h"
#include "media/mojo/mojom/watch_time_recorder.mojom-test-utils.h"


namespace media::mojom {
PlaybackProperties::PlaybackProperties()
    : has_audio(),
      has_video(),
      is_background(),
      is_muted(),
      is_eme(),
      is_embedded_media_experience(),
      media_stream_type(),
      renderer_type(),
      demuxer_type() {}

PlaybackProperties::PlaybackProperties(
    bool has_audio_in,
    bool has_video_in,
    bool is_background_in,
    bool is_muted_in,
    bool is_eme_in,
    bool is_embedded_media_experience_in,
    ::media::mojom::MediaStreamType media_stream_type_in,
    ::media::RendererType renderer_type_in,
    ::media::DemuxerType demuxer_type_in)
    : has_audio(std::move(has_audio_in)),
      has_video(std::move(has_video_in)),
      is_background(std::move(is_background_in)),
      is_muted(std::move(is_muted_in)),
      is_eme(std::move(is_eme_in)),
      is_embedded_media_experience(std::move(is_embedded_media_experience_in)),
      media_stream_type(std::move(media_stream_type_in)),
      renderer_type(std::move(renderer_type_in)),
      demuxer_type(std::move(demuxer_type_in)) {}

PlaybackProperties::~PlaybackProperties() = default;

void PlaybackProperties::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_audio"), this->has_audio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_video"), this->has_video,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_background"), this->is_background,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_muted"), this->is_muted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_eme"), this->is_eme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_embedded_media_experience"), this->is_embedded_media_experience,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_stream_type"), this->media_stream_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::MediaStreamType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_type"), this->renderer_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::RendererType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "demuxer_type"), this->demuxer_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::DemuxerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PlaybackProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SecondaryPlaybackProperties::SecondaryPlaybackProperties()
    : audio_codec(),
      video_codec(),
      audio_codec_profile(),
      video_codec_profile(),
      audio_decoder(),
      video_decoder(),
      audio_encryption_scheme(),
      video_encryption_scheme(),
      natural_size() {}

SecondaryPlaybackProperties::SecondaryPlaybackProperties(
    ::media::AudioCodec audio_codec_in,
    ::media::VideoCodec video_codec_in,
    ::media::AudioCodecProfile audio_codec_profile_in,
    ::media::VideoCodecProfile video_codec_profile_in,
    ::media::AudioDecoderType audio_decoder_in,
    ::media::VideoDecoderType video_decoder_in,
    ::media::EncryptionScheme audio_encryption_scheme_in,
    ::media::EncryptionScheme video_encryption_scheme_in,
    const ::gfx::Size& natural_size_in)
    : audio_codec(std::move(audio_codec_in)),
      video_codec(std::move(video_codec_in)),
      audio_codec_profile(std::move(audio_codec_profile_in)),
      video_codec_profile(std::move(video_codec_profile_in)),
      audio_decoder(std::move(audio_decoder_in)),
      video_decoder(std::move(video_decoder_in)),
      audio_encryption_scheme(std::move(audio_encryption_scheme_in)),
      video_encryption_scheme(std::move(video_encryption_scheme_in)),
      natural_size(std::move(natural_size_in)) {}

SecondaryPlaybackProperties::~SecondaryPlaybackProperties() = default;

void SecondaryPlaybackProperties::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_codec"), this->audio_codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_codec"), this->video_codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_codec_profile"), this->audio_codec_profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_codec_profile"), this->video_codec_profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_decoder"), this->audio_decoder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioDecoderType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_decoder"), this->video_decoder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoDecoderType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_encryption_scheme"), this->audio_encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_encryption_scheme"), this->video_encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "natural_size"), this->natural_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SecondaryPlaybackProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WatchTimeRecorder::IPCStableHashFunction WatchTimeRecorder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WatchTimeRecorder>(message.name())) {
    case messages::WatchTimeRecorder::kRecordWatchTime: {
      return &WatchTimeRecorder::RecordWatchTime_Sym::IPCStableHash;
    }
    case messages::WatchTimeRecorder::kFinalizeWatchTime: {
      return &WatchTimeRecorder::FinalizeWatchTime_Sym::IPCStableHash;
    }
    case messages::WatchTimeRecorder::kOnError: {
      return &WatchTimeRecorder::OnError_Sym::IPCStableHash;
    }
    case messages::WatchTimeRecorder::kUpdateSecondaryProperties: {
      return &WatchTimeRecorder::UpdateSecondaryProperties_Sym::IPCStableHash;
    }
    case messages::WatchTimeRecorder::kSetAutoplayInitiated: {
      return &WatchTimeRecorder::SetAutoplayInitiated_Sym::IPCStableHash;
    }
    case messages::WatchTimeRecorder::kOnDurationChanged: {
      return &WatchTimeRecorder::OnDurationChanged_Sym::IPCStableHash;
    }
    case messages::WatchTimeRecorder::kUpdateVideoDecodeStats: {
      return &WatchTimeRecorder::UpdateVideoDecodeStats_Sym::IPCStableHash;
    }
    case messages::WatchTimeRecorder::kUpdateUnderflowCount: {
      return &WatchTimeRecorder::UpdateUnderflowCount_Sym::IPCStableHash;
    }
    case messages::WatchTimeRecorder::kUpdateUnderflowDuration: {
      return &WatchTimeRecorder::UpdateUnderflowDuration_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WatchTimeRecorder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WatchTimeRecorder>(message.name())) {
      case messages::WatchTimeRecorder::kRecordWatchTime:
            return "Receive media::mojom::WatchTimeRecorder::RecordWatchTime";
      case messages::WatchTimeRecorder::kFinalizeWatchTime:
            return "Receive media::mojom::WatchTimeRecorder::FinalizeWatchTime";
      case messages::WatchTimeRecorder::kOnError:
            return "Receive media::mojom::WatchTimeRecorder::OnError";
      case messages::WatchTimeRecorder::kUpdateSecondaryProperties:
            return "Receive media::mojom::WatchTimeRecorder::UpdateSecondaryProperties";
      case messages::WatchTimeRecorder::kSetAutoplayInitiated:
            return "Receive media::mojom::WatchTimeRecorder::SetAutoplayInitiated";
      case messages::WatchTimeRecorder::kOnDurationChanged:
            return "Receive media::mojom::WatchTimeRecorder::OnDurationChanged";
      case messages::WatchTimeRecorder::kUpdateVideoDecodeStats:
            return "Receive media::mojom::WatchTimeRecorder::UpdateVideoDecodeStats";
      case messages::WatchTimeRecorder::kUpdateUnderflowCount:
            return "Receive media::mojom::WatchTimeRecorder::UpdateUnderflowCount";
      case messages::WatchTimeRecorder::kUpdateUnderflowDuration:
            return "Receive media::mojom::WatchTimeRecorder::UpdateUnderflowDuration";
    }
  } else {
    switch (static_cast<messages::WatchTimeRecorder>(message.name())) {
      case messages::WatchTimeRecorder::kRecordWatchTime:
            return "Receive reply media::mojom::WatchTimeRecorder::RecordWatchTime";
      case messages::WatchTimeRecorder::kFinalizeWatchTime:
            return "Receive reply media::mojom::WatchTimeRecorder::FinalizeWatchTime";
      case messages::WatchTimeRecorder::kOnError:
            return "Receive reply media::mojom::WatchTimeRecorder::OnError";
      case messages::WatchTimeRecorder::kUpdateSecondaryProperties:
            return "Receive reply media::mojom::WatchTimeRecorder::UpdateSecondaryProperties";
      case messages::WatchTimeRecorder::kSetAutoplayInitiated:
            return "Receive reply media::mojom::WatchTimeRecorder::SetAutoplayInitiated";
      case messages::WatchTimeRecorder::kOnDurationChanged:
            return "Receive reply media::mojom::WatchTimeRecorder::OnDurationChanged";
      case messages::WatchTimeRecorder::kUpdateVideoDecodeStats:
            return "Receive reply media::mojom::WatchTimeRecorder::UpdateVideoDecodeStats";
      case messages::WatchTimeRecorder::kUpdateUnderflowCount:
            return "Receive reply media::mojom::WatchTimeRecorder::UpdateUnderflowCount";
      case messages::WatchTimeRecorder::kUpdateUnderflowDuration:
            return "Receive reply media::mojom::WatchTimeRecorder::UpdateUnderflowDuration";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WatchTimeRecorder::RecordWatchTime_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00a0f68f;  // IPCStableHash for media::mojom::WatchTimeRecorder::RecordWatchTime
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WatchTimeRecorder::FinalizeWatchTime_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfa1fdc14;  // IPCStableHash for media::mojom::WatchTimeRecorder::FinalizeWatchTime
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WatchTimeRecorder::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca562813;  // IPCStableHash for media::mojom::WatchTimeRecorder::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WatchTimeRecorder::UpdateSecondaryProperties_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf3546da;  // IPCStableHash for media::mojom::WatchTimeRecorder::UpdateSecondaryProperties
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WatchTimeRecorder::SetAutoplayInitiated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2efed165;  // IPCStableHash for media::mojom::WatchTimeRecorder::SetAutoplayInitiated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WatchTimeRecorder::OnDurationChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6cf4a1fa;  // IPCStableHash for media::mojom::WatchTimeRecorder::OnDurationChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WatchTimeRecorder::UpdateVideoDecodeStats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8f3c81d9;  // IPCStableHash for media::mojom::WatchTimeRecorder::UpdateVideoDecodeStats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WatchTimeRecorder::UpdateUnderflowCount_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a7d9798;  // IPCStableHash for media::mojom::WatchTimeRecorder::UpdateUnderflowCount
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WatchTimeRecorder::UpdateUnderflowDuration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf10b62ef;  // IPCStableHash for media::mojom::WatchTimeRecorder::UpdateUnderflowDuration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WatchTimeRecorderProxy::WatchTimeRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WatchTimeRecorderProxy::RecordWatchTime(
    ::media::WatchTimeKey in_key, ::base::TimeDelta in_watch_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WatchTimeRecorder::RecordWatchTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type ::media::WatchTimeKey>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("watch_time"), in_watch_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchTimeRecorder::kRecordWatchTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_RecordWatchTime_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::WatchTimeKey>(
    in_key,
    &params->key);
  mojo::internal::MessageFragment<
      typename decltype(params->watch_time)::BaseType> watch_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_watch_time,
    watch_time_fragment);

  params->watch_time.Set(
      watch_time_fragment.is_null() ? nullptr : watch_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->watch_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null watch_time in WatchTimeRecorder.RecordWatchTime request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("RecordWatchTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WatchTimeRecorderProxy::FinalizeWatchTime(
    const std::vector<::media::WatchTimeKey>& in_watch_time_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WatchTimeRecorder::FinalizeWatchTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("watch_time_keys"), in_watch_time_keys,
                        "<value of type const std::vector<::media::WatchTimeKey>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchTimeRecorder::kFinalizeWatchTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->watch_time_keys)::BaseType>
      watch_time_keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& watch_time_keys_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::WatchTimeKey_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::WatchTimeKey>>(
    in_watch_time_keys,
    watch_time_keys_fragment,
    &watch_time_keys_validate_params);

  params->watch_time_keys.Set(
      watch_time_keys_fragment.is_null() ? nullptr : watch_time_keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->watch_time_keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null watch_time_keys in WatchTimeRecorder.FinalizeWatchTime request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("FinalizeWatchTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WatchTimeRecorderProxy::OnError(
    const ::media::PipelineStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WatchTimeRecorder::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::PipelineStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchTimeRecorder::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PipelineStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in WatchTimeRecorder.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WatchTimeRecorderProxy::UpdateSecondaryProperties(
    SecondaryPlaybackPropertiesPtr in_secondary_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WatchTimeRecorder::UpdateSecondaryProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secondary_properties"), in_secondary_properties,
                        "<value of type SecondaryPlaybackPropertiesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchTimeRecorder::kUpdateSecondaryProperties), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->secondary_properties)::BaseType> secondary_properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::SecondaryPlaybackPropertiesDataView>(
    in_secondary_properties,
    secondary_properties_fragment);

  params->secondary_properties.Set(
      secondary_properties_fragment.is_null() ? nullptr : secondary_properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->secondary_properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null secondary_properties in WatchTimeRecorder.UpdateSecondaryProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateSecondaryProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WatchTimeRecorderProxy::SetAutoplayInitiated(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WatchTimeRecorder::SetAutoplayInitiated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchTimeRecorder::kSetAutoplayInitiated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data> params(
          message);
  params.Allocate();

  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("SetAutoplayInitiated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WatchTimeRecorderProxy::OnDurationChanged(
    ::base::TimeDelta in_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WatchTimeRecorder::OnDurationChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration"), in_duration,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchTimeRecorder::kOnDurationChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_OnDurationChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->duration)::BaseType> duration_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_duration,
    duration_fragment);

  params->duration.Set(
      duration_fragment.is_null() ? nullptr : duration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->duration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null duration in WatchTimeRecorder.OnDurationChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("OnDurationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WatchTimeRecorderProxy::UpdateVideoDecodeStats(
    uint32_t in_frames_decoded, uint32_t in_frames_dropped) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WatchTimeRecorder::UpdateVideoDecodeStats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frames_decoded"), in_frames_decoded,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frames_dropped"), in_frames_dropped,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchTimeRecorder::kUpdateVideoDecodeStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data> params(
          message);
  params.Allocate();

  params->frames_decoded = in_frames_decoded;

  params->frames_dropped = in_frames_dropped;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateVideoDecodeStats");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WatchTimeRecorderProxy::UpdateUnderflowCount(
    int32_t in_total_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WatchTimeRecorder::UpdateUnderflowCount", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_count"), in_total_count,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchTimeRecorder::kUpdateUnderflowCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data> params(
          message);
  params.Allocate();

  params->total_count = in_total_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateUnderflowCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WatchTimeRecorderProxy::UpdateUnderflowDuration(
    int32_t in_total_completed_count, ::base::TimeDelta in_total_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WatchTimeRecorder::UpdateUnderflowDuration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_completed_count"), in_total_completed_count,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_duration"), in_total_duration,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchTimeRecorder::kUpdateUnderflowDuration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data> params(
          message);
  params.Allocate();

  params->total_completed_count = in_total_completed_count;
  mojo::internal::MessageFragment<
      typename decltype(params->total_duration)::BaseType> total_duration_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_total_duration,
    total_duration_fragment);

  params->total_duration.Set(
      total_duration_fragment.is_null() ? nullptr : total_duration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->total_duration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null total_duration in WatchTimeRecorder.UpdateUnderflowDuration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateUnderflowDuration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WatchTimeRecorderStubDispatch::Accept(
    WatchTimeRecorder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WatchTimeRecorder>(message->header()->name)) {
    case messages::WatchTimeRecorder::kRecordWatchTime: {
      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_RecordWatchTime_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_RecordWatchTime_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WatchTimeRecorder.0
      bool success = true;
      ::media::WatchTimeKey p_key{};
      ::base::TimeDelta p_watch_time{};
      WatchTimeRecorder_RecordWatchTime_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadWatchTime(&p_watch_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordWatchTime(        
        std::move(p_key), 
        std::move(p_watch_time));
      return true;
    }
    case messages::WatchTimeRecorder::kFinalizeWatchTime: {
      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WatchTimeRecorder.1
      bool success = true;
      std::vector<::media::WatchTimeKey> p_watch_time_keys{};
      WatchTimeRecorder_FinalizeWatchTime_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWatchTimeKeys(&p_watch_time_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FinalizeWatchTime(        
        std::move(p_watch_time_keys));
      return true;
    }
    case messages::WatchTimeRecorder::kOnError: {
      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_OnError_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WatchTimeRecorder.2
      bool success = true;
      ::media::PipelineStatus p_status{};
      WatchTimeRecorder_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_status));
      return true;
    }
    case messages::WatchTimeRecorder::kUpdateSecondaryProperties: {
      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WatchTimeRecorder.3
      bool success = true;
      SecondaryPlaybackPropertiesPtr p_secondary_properties{};
      WatchTimeRecorder_UpdateSecondaryProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSecondaryProperties(&p_secondary_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSecondaryProperties(        
        std::move(p_secondary_properties));
      return true;
    }
    case messages::WatchTimeRecorder::kSetAutoplayInitiated: {
      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WatchTimeRecorder.4
      bool success = true;
      bool p_value{};
      WatchTimeRecorder_SetAutoplayInitiated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAutoplayInitiated(        
        std::move(p_value));
      return true;
    }
    case messages::WatchTimeRecorder::kOnDurationChanged: {
      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_OnDurationChanged_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_OnDurationChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WatchTimeRecorder.5
      bool success = true;
      ::base::TimeDelta p_duration{};
      WatchTimeRecorder_OnDurationChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDuration(&p_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDurationChanged(        
        std::move(p_duration));
      return true;
    }
    case messages::WatchTimeRecorder::kUpdateVideoDecodeStats: {
      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WatchTimeRecorder.6
      bool success = true;
      uint32_t p_frames_decoded{};
      uint32_t p_frames_dropped{};
      WatchTimeRecorder_UpdateVideoDecodeStats_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frames_decoded = input_data_view.frames_decoded();
      if (success)
        p_frames_dropped = input_data_view.frames_dropped();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateVideoDecodeStats(        
        std::move(p_frames_decoded), 
        std::move(p_frames_dropped));
      return true;
    }
    case messages::WatchTimeRecorder::kUpdateUnderflowCount: {
      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WatchTimeRecorder.7
      bool success = true;
      int32_t p_total_count{};
      WatchTimeRecorder_UpdateUnderflowCount_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_total_count = input_data_view.total_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUnderflowCount(        
        std::move(p_total_count));
      return true;
    }
    case messages::WatchTimeRecorder::kUpdateUnderflowDuration: {
      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WatchTimeRecorder.8
      bool success = true;
      int32_t p_total_completed_count{};
      ::base::TimeDelta p_total_duration{};
      WatchTimeRecorder_UpdateUnderflowDuration_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_total_completed_count = input_data_view.total_completed_count();
      if (success && !input_data_view.ReadTotalDuration(&p_total_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUnderflowDuration(        
        std::move(p_total_completed_count), 
        std::move(p_total_duration));
      return true;
    }
  }
  return false;
}

// static
bool WatchTimeRecorderStubDispatch::AcceptWithResponder(
    WatchTimeRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WatchTimeRecorder>(message->header()->name)) {
    case messages::WatchTimeRecorder::kRecordWatchTime: {
      break;
    }
    case messages::WatchTimeRecorder::kFinalizeWatchTime: {
      break;
    }
    case messages::WatchTimeRecorder::kOnError: {
      break;
    }
    case messages::WatchTimeRecorder::kUpdateSecondaryProperties: {
      break;
    }
    case messages::WatchTimeRecorder::kSetAutoplayInitiated: {
      break;
    }
    case messages::WatchTimeRecorder::kOnDurationChanged: {
      break;
    }
    case messages::WatchTimeRecorder::kUpdateVideoDecodeStats: {
      break;
    }
    case messages::WatchTimeRecorder::kUpdateUnderflowCount: {
      break;
    }
    case messages::WatchTimeRecorder::kUpdateUnderflowDuration: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWatchTimeRecorderValidationInfo[] = {
    { &internal::WatchTimeRecorder_RecordWatchTime_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WatchTimeRecorder_OnError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WatchTimeRecorder_OnDurationChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data::Validate,
     nullptr /* no response */},
};

bool WatchTimeRecorderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::WatchTimeRecorder::Name_,
    kWatchTimeRecorderValidationInfo);
}



}  // media::mojom


namespace mojo {


// static
bool StructTraits<::media::mojom::PlaybackProperties::DataView, ::media::mojom::PlaybackPropertiesPtr>::Read(
    ::media::mojom::PlaybackProperties::DataView input,
    ::media::mojom::PlaybackPropertiesPtr* output) {
  bool success = true;
  ::media::mojom::PlaybackPropertiesPtr result(::media::mojom::PlaybackProperties::New());
  
      if (success)
        result->has_audio = input.has_audio();
      if (success)
        result->has_video = input.has_video();
      if (success)
        result->is_background = input.is_background();
      if (success)
        result->is_muted = input.is_muted();
      if (success)
        result->is_eme = input.is_eme();
      if (success)
        result->is_embedded_media_experience = input.is_embedded_media_experience();
      if (success && !input.ReadMediaStreamType(&result->media_stream_type))
        success = false;
      if (success && !input.ReadRendererType(&result->renderer_type))
        success = false;
      if (success && !input.ReadDemuxerType(&result->demuxer_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SecondaryPlaybackProperties::DataView, ::media::mojom::SecondaryPlaybackPropertiesPtr>::Read(
    ::media::mojom::SecondaryPlaybackProperties::DataView input,
    ::media::mojom::SecondaryPlaybackPropertiesPtr* output) {
  bool success = true;
  ::media::mojom::SecondaryPlaybackPropertiesPtr result(::media::mojom::SecondaryPlaybackProperties::New());
  
      if (success && !input.ReadAudioCodec(&result->audio_codec))
        success = false;
      if (success && !input.ReadVideoCodec(&result->video_codec))
        success = false;
      if (success && !input.ReadAudioCodecProfile(&result->audio_codec_profile))
        success = false;
      if (success && !input.ReadVideoCodecProfile(&result->video_codec_profile))
        success = false;
      if (success && !input.ReadAudioDecoder(&result->audio_decoder))
        success = false;
      if (success && !input.ReadVideoDecoder(&result->video_decoder))
        success = false;
      if (success && !input.ReadAudioEncryptionScheme(&result->audio_encryption_scheme))
        success = false;
      if (success && !input.ReadVideoEncryptionScheme(&result->video_encryption_scheme))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void WatchTimeRecorderInterceptorForTesting::RecordWatchTime(::media::WatchTimeKey key, ::base::TimeDelta watch_time) {
  GetForwardingInterface()->RecordWatchTime(
    std::move(key)
    , 
    std::move(watch_time)
    );
}
void WatchTimeRecorderInterceptorForTesting::FinalizeWatchTime(const std::vector<::media::WatchTimeKey>& watch_time_keys) {
  GetForwardingInterface()->FinalizeWatchTime(
    std::move(watch_time_keys)
    );
}
void WatchTimeRecorderInterceptorForTesting::OnError(const ::media::PipelineStatus& status) {
  GetForwardingInterface()->OnError(
    std::move(status)
    );
}
void WatchTimeRecorderInterceptorForTesting::UpdateSecondaryProperties(SecondaryPlaybackPropertiesPtr secondary_properties) {
  GetForwardingInterface()->UpdateSecondaryProperties(
    std::move(secondary_properties)
    );
}
void WatchTimeRecorderInterceptorForTesting::SetAutoplayInitiated(bool value) {
  GetForwardingInterface()->SetAutoplayInitiated(
    std::move(value)
    );
}
void WatchTimeRecorderInterceptorForTesting::OnDurationChanged(::base::TimeDelta duration) {
  GetForwardingInterface()->OnDurationChanged(
    std::move(duration)
    );
}
void WatchTimeRecorderInterceptorForTesting::UpdateVideoDecodeStats(uint32_t frames_decoded, uint32_t frames_dropped) {
  GetForwardingInterface()->UpdateVideoDecodeStats(
    std::move(frames_decoded)
    , 
    std::move(frames_dropped)
    );
}
void WatchTimeRecorderInterceptorForTesting::UpdateUnderflowCount(int32_t total_count) {
  GetForwardingInterface()->UpdateUnderflowCount(
    std::move(total_count)
    );
}
void WatchTimeRecorderInterceptorForTesting::UpdateUnderflowDuration(int32_t total_completed_count, ::base::TimeDelta total_duration) {
  GetForwardingInterface()->UpdateUnderflowDuration(
    std::move(total_completed_count)
    , 
    std::move(total_duration)
    );
}
WatchTimeRecorderAsyncWaiter::WatchTimeRecorderAsyncWaiter(
    WatchTimeRecorder* proxy) : proxy_(proxy) {}

WatchTimeRecorderAsyncWaiter::~WatchTimeRecorderAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif