// media/mojo/mojom/video_decode_stats_recorder.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('media.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoDecodeStatsRecorderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoDecodeStatsRecorder.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.VideoDecodeStatsRecorderInterface }
 */
media.mojom.VideoDecodeStatsRecorderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoDecodeStatsRecorderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoDecodeStatsRecorderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoDecodeStatsRecorderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.PredictionFeatures } features
   */

  startNewRecord(
      features) {
    this.proxy.sendMessage(
        0,
        media.mojom.VideoDecodeStatsRecorder_StartNewRecord_ParamsSpec.$,
        null,
        [
          features
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PredictionTargets } targets
   */

  updateRecord(
      targets) {
    this.proxy.sendMessage(
        1,
        media.mojom.VideoDecodeStatsRecorder_UpdateRecord_ParamsSpec.$,
        null,
        [
          targets
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoDecodeStatsRecorder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoDecodeStatsRecorderReceiver = class {
  /**
   * @param {!media.mojom.VideoDecodeStatsRecorderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoDecodeStatsRecorderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoDecodeStatsRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoDecodeStatsRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoDecodeStatsRecorder_StartNewRecord_ParamsSpec.$,
        null,
        impl.startNewRecord.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoDecodeStatsRecorder_UpdateRecord_ParamsSpec.$,
        null,
        impl.updateRecord.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoDecodeStatsRecorder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoDecodeStatsRecorder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoDecodeStatsRecorderRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoDecodeStatsRecorderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoDecodeStatsRecorder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoDecodeStatsRecorderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoDecodeStatsRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoDecodeStatsRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startNewRecord =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoDecodeStatsRecorder_StartNewRecord_ParamsSpec.$,
        null,
        this.startNewRecord.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRecord =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoDecodeStatsRecorder_UpdateRecord_ParamsSpec.$,
        null,
        this.updateRecord.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecodeStatsRecorder_StartNewRecord_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecodeStatsRecorder_UpdateRecord_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.VideoDecodeStatsRecorder_StartNewRecord_ParamsSpec.$,
    'VideoDecodeStatsRecorder_StartNewRecord_Params',
    [
      mojo.internal.StructField(
        'features', 0,
        0,
        media.mojom.PredictionFeaturesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.VideoDecodeStatsRecorder_StartNewRecord_Params = class {
  constructor() {
    /** @export { !media.mojom.PredictionFeatures } */
    this.features;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecodeStatsRecorder_UpdateRecord_ParamsSpec.$,
    'VideoDecodeStatsRecorder_UpdateRecord_Params',
    [
      mojo.internal.StructField(
        'targets', 0,
        0,
        media.mojom.PredictionTargetsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.VideoDecodeStatsRecorder_UpdateRecord_Params = class {
  constructor() {
    /** @export { !media.mojom.PredictionTargets } */
    this.targets;
  }
};

