// media/mojo/mojom/speech_recognition_result.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/speech_recognition_result.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"

#include "media/mojo/mojom/speech_recognition_result.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::SpeechRecognitionHypothesisDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SpeechRecognitionHypothesisDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SpeechRecognitionHypothesis_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::utterance(input)) in_utterance = Traits::utterance(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->utterance)::BaseType> utterance_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_utterance,
        utterance_fragment);

      fragment->utterance.Set(
          utterance_fragment.is_null() ? nullptr : utterance_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->utterance.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null utterance in SpeechRecognitionHypothesis struct");

      fragment->confidence = Traits::confidence(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::WebSpeechRecognitionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::WebSpeechRecognitionResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::WebSpeechRecognitionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::hypotheses(input)) in_hypotheses = Traits::hypotheses(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hypotheses)::BaseType>
          hypotheses_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& hypotheses_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SpeechRecognitionHypothesisDataView>, send_validation>(
        in_hypotheses,
        hypotheses_fragment,
        &hypotheses_validate_params);

      fragment->hypotheses.Set(
          hypotheses_fragment.is_null() ? nullptr : hypotheses_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hypotheses.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hypotheses in WebSpeechRecognitionResult struct");

      fragment->is_provisional = Traits::is_provisional(input);
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_SEND_VALIDATION_H_