// media/mojo/mojom/speech_recognition.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/speech_recognition.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/speech_recognition.mojom-params-data.h"
#include "media/mojo/mojom/speech_recognition.mojom-shared-message-ids.h"

#include "media/mojo/mojom/speech_recognition.mojom-import-headers.h"
#include "media/mojo/mojom/speech_recognition.mojom-test-utils.h"


namespace media::mojom {
HypothesisParts::HypothesisParts()
    : text(),
      hypothesis_part_offset() {}

HypothesisParts::HypothesisParts(
    std::vector<std::string> text_in,
    ::base::TimeDelta hypothesis_part_offset_in)
    : text(std::move(text_in)),
      hypothesis_part_offset(std::move(hypothesis_part_offset_in)) {}

HypothesisParts::~HypothesisParts() = default;

void HypothesisParts::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hypothesis_part_offset"), this->hypothesis_part_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HypothesisParts::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaTimestampRange::MediaTimestampRange()
    : start(),
      end() {}

MediaTimestampRange::MediaTimestampRange(
    ::base::TimeDelta start_in,
    ::base::TimeDelta end_in)
    : start(std::move(start_in)),
      end(std::move(end_in)) {}

MediaTimestampRange::~MediaTimestampRange() = default;

void MediaTimestampRange::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start"), this->start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end"), this->end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaTimestampRange::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TimingInformation::TimingInformation()
    : audio_start_time(),
      audio_end_time(),
      hypothesis_parts(),
      originating_media_timestamps() {}

TimingInformation::TimingInformation(
    ::base::TimeDelta audio_start_time_in,
    ::base::TimeDelta audio_end_time_in,
    std::optional<std::vector<::media::HypothesisParts>> hypothesis_parts_in)
    : audio_start_time(std::move(audio_start_time_in)),
      audio_end_time(std::move(audio_end_time_in)),
      hypothesis_parts(std::move(hypothesis_parts_in)),
      originating_media_timestamps() {}

TimingInformation::TimingInformation(
    ::base::TimeDelta audio_start_time_in,
    ::base::TimeDelta audio_end_time_in,
    std::optional<std::vector<::media::HypothesisParts>> hypothesis_parts_in,
    std::optional<std::vector<::media::MediaTimestampRange>> originating_media_timestamps_in)
    : audio_start_time(std::move(audio_start_time_in)),
      audio_end_time(std::move(audio_end_time_in)),
      hypothesis_parts(std::move(hypothesis_parts_in)),
      originating_media_timestamps(std::move(originating_media_timestamps_in)) {}

TimingInformation::~TimingInformation() = default;

void TimingInformation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_start_time"), this->audio_start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_end_time"), this->audio_end_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hypothesis_parts"), this->hypothesis_parts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::media::HypothesisParts>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "originating_media_timestamps"), this->originating_media_timestamps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::media::MediaTimestampRange>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TimingInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpeechRecognitionResult::SpeechRecognitionResult()
    : transcription(),
      is_final(),
      timing_information() {}

SpeechRecognitionResult::SpeechRecognitionResult(
    const std::string& transcription_in,
    bool is_final_in,
    const std::optional<::media::TimingInformation>& timing_information_in)
    : transcription(std::move(transcription_in)),
      is_final(std::move(is_final_in)),
      timing_information(std::move(timing_information_in)) {}

SpeechRecognitionResult::~SpeechRecognitionResult() = default;

void SpeechRecognitionResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transcription"), this->transcription,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_final"), this->is_final,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timing_information"), this->timing_information,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::TimingInformation>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpeechRecognitionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LanguageIdentificationEvent::LanguageIdentificationEvent()
    : language(),
      confidence_level(),
      asr_switch_result() {}

LanguageIdentificationEvent::LanguageIdentificationEvent(
    const std::string& language_in,
    ConfidenceLevel confidence_level_in)
    : language(std::move(language_in)),
      confidence_level(std::move(confidence_level_in)),
      asr_switch_result() {}

LanguageIdentificationEvent::LanguageIdentificationEvent(
    const std::string& language_in,
    ConfidenceLevel confidence_level_in,
    std::optional<AsrSwitchResult> asr_switch_result_in)
    : language(std::move(language_in)),
      confidence_level(std::move(confidence_level_in)),
      asr_switch_result(std::move(asr_switch_result_in)) {}

LanguageIdentificationEvent::~LanguageIdentificationEvent() = default;

void LanguageIdentificationEvent::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "confidence_level"), this->confidence_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ConfidenceLevel>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "asr_switch_result"), this->asr_switch_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<AsrSwitchResult>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LanguageIdentificationEvent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpeechRecognitionOptions::SpeechRecognitionOptions()
    : recognition_mode(),
      enable_formatting(),
      language(),
      is_server_based(),
      recognizer_client_type(),
      skip_continuously_empty_audio(false),
      experiment_recognizer_routing_key(),
      channel_count(),
      sample_rate(),
      recognition_context() {}

SpeechRecognitionOptions::SpeechRecognitionOptions(
    SpeechRecognitionMode recognition_mode_in,
    bool enable_formatting_in,
    const std::optional<std::string>& language_in)
    : recognition_mode(std::move(recognition_mode_in)),
      enable_formatting(std::move(enable_formatting_in)),
      language(std::move(language_in)),
      is_server_based(),
      recognizer_client_type(),
      skip_continuously_empty_audio(false),
      experiment_recognizer_routing_key(),
      channel_count(),
      sample_rate(),
      recognition_context() {}

SpeechRecognitionOptions::SpeechRecognitionOptions(
    SpeechRecognitionMode recognition_mode_in,
    bool enable_formatting_in,
    const std::optional<std::string>& language_in,
    bool is_server_based_in,
    RecognizerClientType recognizer_client_type_in)
    : recognition_mode(std::move(recognition_mode_in)),
      enable_formatting(std::move(enable_formatting_in)),
      language(std::move(language_in)),
      is_server_based(std::move(is_server_based_in)),
      recognizer_client_type(std::move(recognizer_client_type_in)),
      skip_continuously_empty_audio(false),
      experiment_recognizer_routing_key(),
      channel_count(),
      sample_rate(),
      recognition_context() {}

SpeechRecognitionOptions::SpeechRecognitionOptions(
    SpeechRecognitionMode recognition_mode_in,
    bool enable_formatting_in,
    const std::optional<std::string>& language_in,
    bool is_server_based_in,
    RecognizerClientType recognizer_client_type_in,
    bool skip_continuously_empty_audio_in)
    : recognition_mode(std::move(recognition_mode_in)),
      enable_formatting(std::move(enable_formatting_in)),
      language(std::move(language_in)),
      is_server_based(std::move(is_server_based_in)),
      recognizer_client_type(std::move(recognizer_client_type_in)),
      skip_continuously_empty_audio(std::move(skip_continuously_empty_audio_in)),
      experiment_recognizer_routing_key(),
      channel_count(),
      sample_rate(),
      recognition_context() {}

SpeechRecognitionOptions::SpeechRecognitionOptions(
    SpeechRecognitionMode recognition_mode_in,
    bool enable_formatting_in,
    const std::optional<std::string>& language_in,
    bool is_server_based_in,
    RecognizerClientType recognizer_client_type_in,
    bool skip_continuously_empty_audio_in,
    const std::optional<std::string>& experiment_recognizer_routing_key_in)
    : recognition_mode(std::move(recognition_mode_in)),
      enable_formatting(std::move(enable_formatting_in)),
      language(std::move(language_in)),
      is_server_based(std::move(is_server_based_in)),
      recognizer_client_type(std::move(recognizer_client_type_in)),
      skip_continuously_empty_audio(std::move(skip_continuously_empty_audio_in)),
      experiment_recognizer_routing_key(std::move(experiment_recognizer_routing_key_in)),
      channel_count(),
      sample_rate(),
      recognition_context() {}

SpeechRecognitionOptions::SpeechRecognitionOptions(
    SpeechRecognitionMode recognition_mode_in,
    bool enable_formatting_in,
    const std::optional<std::string>& language_in,
    bool is_server_based_in,
    RecognizerClientType recognizer_client_type_in,
    bool skip_continuously_empty_audio_in,
    const std::optional<std::string>& experiment_recognizer_routing_key_in,
    int32_t channel_count_in,
    int32_t sample_rate_in)
    : recognition_mode(std::move(recognition_mode_in)),
      enable_formatting(std::move(enable_formatting_in)),
      language(std::move(language_in)),
      is_server_based(std::move(is_server_based_in)),
      recognizer_client_type(std::move(recognizer_client_type_in)),
      skip_continuously_empty_audio(std::move(skip_continuously_empty_audio_in)),
      experiment_recognizer_routing_key(std::move(experiment_recognizer_routing_key_in)),
      channel_count(std::move(channel_count_in)),
      sample_rate(std::move(sample_rate_in)),
      recognition_context() {}

SpeechRecognitionOptions::SpeechRecognitionOptions(
    SpeechRecognitionMode recognition_mode_in,
    bool enable_formatting_in,
    const std::optional<std::string>& language_in,
    bool is_server_based_in,
    RecognizerClientType recognizer_client_type_in,
    bool skip_continuously_empty_audio_in,
    const std::optional<std::string>& experiment_recognizer_routing_key_in,
    int32_t channel_count_in,
    int32_t sample_rate_in,
    const std::optional<::media::SpeechRecognitionRecognitionContext>& recognition_context_in)
    : recognition_mode(std::move(recognition_mode_in)),
      enable_formatting(std::move(enable_formatting_in)),
      language(std::move(language_in)),
      is_server_based(std::move(is_server_based_in)),
      recognizer_client_type(std::move(recognizer_client_type_in)),
      skip_continuously_empty_audio(std::move(skip_continuously_empty_audio_in)),
      experiment_recognizer_routing_key(std::move(experiment_recognizer_routing_key_in)),
      channel_count(std::move(channel_count_in)),
      sample_rate(std::move(sample_rate_in)),
      recognition_context(std::move(recognition_context_in)) {}

SpeechRecognitionOptions::~SpeechRecognitionOptions() = default;

void SpeechRecognitionOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recognition_mode"), this->recognition_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SpeechRecognitionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_formatting"), this->enable_formatting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_server_based"), this->is_server_based,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recognizer_client_type"), this->recognizer_client_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RecognizerClientType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_continuously_empty_audio"), this->skip_continuously_empty_audio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "experiment_recognizer_routing_key"), this->experiment_recognizer_routing_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_count"), this->channel_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recognition_context"), this->recognition_context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::SpeechRecognitionRecognitionContext>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpeechRecognitionOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SpeechRecognitionContext::IPCStableHashFunction SpeechRecognitionContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionContext>(message.name())) {
    case messages::SpeechRecognitionContext::kBindRecognizer: {
      return &SpeechRecognitionContext::BindRecognizer_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionContext::kBindWebSpeechRecognizer: {
      return &SpeechRecognitionContext::BindWebSpeechRecognizer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionContext>(message.name())) {
      case messages::SpeechRecognitionContext::kBindRecognizer:
            return "Receive media::mojom::SpeechRecognitionContext::BindRecognizer";
      case messages::SpeechRecognitionContext::kBindWebSpeechRecognizer:
            return "Receive media::mojom::SpeechRecognitionContext::BindWebSpeechRecognizer";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionContext>(message.name())) {
      case messages::SpeechRecognitionContext::kBindRecognizer:
            return "Receive reply media::mojom::SpeechRecognitionContext::BindRecognizer";
      case messages::SpeechRecognitionContext::kBindWebSpeechRecognizer:
            return "Receive reply media::mojom::SpeechRecognitionContext::BindWebSpeechRecognizer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionContext::BindRecognizer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xccc14190;  // IPCStableHash for media::mojom::SpeechRecognitionContext::BindRecognizer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionContext::BindWebSpeechRecognizer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe2702524;  // IPCStableHash for media::mojom::SpeechRecognitionContext::BindWebSpeechRecognizer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SpeechRecognitionContext_BindRecognizer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SpeechRecognitionContext_BindRecognizer_ForwardToCallback(
      SpeechRecognitionContext::BindRecognizerCallback callback
      ) : callback_(std::move(callback)) {
  }

  SpeechRecognitionContext_BindRecognizer_ForwardToCallback(const SpeechRecognitionContext_BindRecognizer_ForwardToCallback&) = delete;
  SpeechRecognitionContext_BindRecognizer_ForwardToCallback& operator=(const SpeechRecognitionContext_BindRecognizer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SpeechRecognitionContext::BindRecognizerCallback callback_;
};

SpeechRecognitionContextProxy::SpeechRecognitionContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionContextProxy::BindRecognizer(
    ::mojo::PendingReceiver<SpeechRecognitionRecognizer> in_receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> in_client, SpeechRecognitionOptionsPtr in_options, BindRecognizerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionContext::BindRecognizer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<SpeechRecognitionRecognizer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<SpeechRecognitionRecognizerClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type SpeechRecognitionOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionContext::kBindRecognizer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionContext_BindRecognizer_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionRecognizerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in SpeechRecognitionContext.BindRecognizer request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionRecognizerClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in SpeechRecognitionContext.BindRecognizer request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in SpeechRecognitionContext.BindRecognizer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionContext::Name_);
  message.set_method_name("BindRecognizer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SpeechRecognitionContext_BindRecognizer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SpeechRecognitionContextProxy::BindWebSpeechRecognizer(
    ::mojo::PendingReceiver<::media::mojom::SpeechRecognitionSession> in_session_receiver, ::mojo::PendingRemote<::media::mojom::SpeechRecognitionSessionClient> in_session_client, ::mojo::PendingReceiver<::media::mojom::SpeechRecognitionAudioForwarder> in_audio_forwarder, int32_t in_channel_count, int32_t in_sample_rate, SpeechRecognitionOptionsPtr in_options, bool in_continuous) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionContext::BindWebSpeechRecognizer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_receiver"), in_session_receiver,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::SpeechRecognitionSession>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_client"), in_session_client,
                        "<value of type ::mojo::PendingRemote<::media::mojom::SpeechRecognitionSessionClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_forwarder"), in_audio_forwarder,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::SpeechRecognitionAudioForwarder>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_count"), in_channel_count,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sample_rate"), in_sample_rate,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type SpeechRecognitionOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("continuous"), in_continuous,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionContext::kBindWebSpeechRecognizer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionContext_BindWebSpeechRecognizer_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionSessionInterfaceBase>>(
    in_session_receiver,
    &params->session_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session_receiver in SpeechRecognitionContext.BindWebSpeechRecognizer request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionSessionClientInterfaceBase>>(
    in_session_client,
    &params->session_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session_client in SpeechRecognitionContext.BindWebSpeechRecognizer request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionAudioForwarderInterfaceBase>>(
    in_audio_forwarder,
    &params->audio_forwarder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->audio_forwarder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid audio_forwarder in SpeechRecognitionContext.BindWebSpeechRecognizer request");

  params->channel_count = in_channel_count;

  params->sample_rate = in_sample_rate;
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in SpeechRecognitionContext.BindWebSpeechRecognizer request");

  params->continuous = in_continuous;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionContext::Name_);
  message.set_method_name("BindWebSpeechRecognizer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class SpeechRecognitionContext_BindRecognizer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SpeechRecognitionContext::BindRecognizerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SpeechRecognitionContext_BindRecognizer_ProxyToResponder> proxy(
        new SpeechRecognitionContext_BindRecognizer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SpeechRecognitionContext_BindRecognizer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SpeechRecognitionContext_BindRecognizer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SpeechRecognitionContext_BindRecognizer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SpeechRecognitionContext::BindRecognizerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_multichannel_supported);
};

bool SpeechRecognitionContext_BindRecognizer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SpeechRecognitionContext.0
  bool success = true;
  bool p_is_multichannel_supported{};
  SpeechRecognitionContext_BindRecognizer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_multichannel_supported = input_data_view.is_multichannel_supported();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SpeechRecognitionContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_multichannel_supported));
  }
  return true;
}

void SpeechRecognitionContext_BindRecognizer_ProxyToResponder::Run(
    bool in_is_multichannel_supported) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::SpeechRecognitionContext::BindRecognizer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_multichannel_supported"), in_is_multichannel_supported,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionContext::kBindRecognizer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_multichannel_supported = in_is_multichannel_supported;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionContext::Name_);
  message.set_method_name("BindRecognizer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SpeechRecognitionContextStubDispatch::Accept(
    SpeechRecognitionContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionContext>(message->header()->name)) {
    case messages::SpeechRecognitionContext::kBindRecognizer: {
      break;
    }
    case messages::SpeechRecognitionContext::kBindWebSpeechRecognizer: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionContext_BindWebSpeechRecognizer_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionContext_BindWebSpeechRecognizer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionContext.1
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::SpeechRecognitionSession> p_session_receiver{};
      ::mojo::PendingRemote<::media::mojom::SpeechRecognitionSessionClient> p_session_client{};
      ::mojo::PendingReceiver<::media::mojom::SpeechRecognitionAudioForwarder> p_audio_forwarder{};
      int32_t p_channel_count{};
      int32_t p_sample_rate{};
      SpeechRecognitionOptionsPtr p_options{};
      bool p_continuous{};
      SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_session_receiver =
            input_data_view.TakeSessionReceiver<decltype(p_session_receiver)>();
      }
      if (success) {
        p_session_client =
            input_data_view.TakeSessionClient<decltype(p_session_client)>();
      }
      if (success) {
        p_audio_forwarder =
            input_data_view.TakeAudioForwarder<decltype(p_audio_forwarder)>();
      }
      if (success)
        p_channel_count = input_data_view.channel_count();
      if (success)
        p_sample_rate = input_data_view.sample_rate();
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success)
        p_continuous = input_data_view.continuous();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWebSpeechRecognizer(        
        std::move(p_session_receiver), 
        std::move(p_session_client), 
        std::move(p_audio_forwarder), 
        std::move(p_channel_count), 
        std::move(p_sample_rate), 
        std::move(p_options), 
        std::move(p_continuous));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionContextStubDispatch::AcceptWithResponder(
    SpeechRecognitionContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionContext>(message->header()->name)) {
    case messages::SpeechRecognitionContext::kBindRecognizer: {
      internal::SpeechRecognitionContext_BindRecognizer_Params_Data* params =
          reinterpret_cast<
              internal::SpeechRecognitionContext_BindRecognizer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SpeechRecognitionContext.0
      bool success = true;
      ::mojo::PendingReceiver<SpeechRecognitionRecognizer> p_receiver{};
      ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> p_client{};
      SpeechRecognitionOptionsPtr p_options{};
      SpeechRecognitionContext_BindRecognizer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionContext::Name_, 0, false);
        return false;
      }
      auto callback =
          SpeechRecognitionContext_BindRecognizer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindRecognizer(        
        std::move(p_receiver), 
        std::move(p_client), 
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::SpeechRecognitionContext::kBindWebSpeechRecognizer: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionContextValidationInfo[] = {
    { &internal::SpeechRecognitionContext_BindRecognizer_Params_Data::Validate,
     &internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data::Validate},
    { &internal::SpeechRecognitionContext_BindWebSpeechRecognizer_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionContextRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionContext::Name_,
    kSpeechRecognitionContextValidationInfo);
}

bool SpeechRecognitionContextResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionContext::Name_,
    kSpeechRecognitionContextValidationInfo);
}
// The declaration includes the definition on other builds.

SpeechRecognitionRecognizer::IPCStableHashFunction SpeechRecognitionRecognizer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionRecognizer>(message.name())) {
    case messages::SpeechRecognitionRecognizer::kSendAudioToSpeechRecognitionService: {
      return &SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionRecognizer::kMarkDone: {
      return &SpeechRecognitionRecognizer::MarkDone_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionRecognizer::kOnLanguageChanged: {
      return &SpeechRecognitionRecognizer::OnLanguageChanged_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionRecognizer::kOnMaskOffensiveWordsChanged: {
      return &SpeechRecognitionRecognizer::OnMaskOffensiveWordsChanged_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionRecognizer::kUpdateRecognitionContext: {
      return &SpeechRecognitionRecognizer::UpdateRecognitionContext_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionRecognizer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionRecognizer>(message.name())) {
      case messages::SpeechRecognitionRecognizer::kSendAudioToSpeechRecognitionService:
            return "Receive media::mojom::SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService";
      case messages::SpeechRecognitionRecognizer::kMarkDone:
            return "Receive media::mojom::SpeechRecognitionRecognizer::MarkDone";
      case messages::SpeechRecognitionRecognizer::kOnLanguageChanged:
            return "Receive media::mojom::SpeechRecognitionRecognizer::OnLanguageChanged";
      case messages::SpeechRecognitionRecognizer::kOnMaskOffensiveWordsChanged:
            return "Receive media::mojom::SpeechRecognitionRecognizer::OnMaskOffensiveWordsChanged";
      case messages::SpeechRecognitionRecognizer::kUpdateRecognitionContext:
            return "Receive media::mojom::SpeechRecognitionRecognizer::UpdateRecognitionContext";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionRecognizer>(message.name())) {
      case messages::SpeechRecognitionRecognizer::kSendAudioToSpeechRecognitionService:
            return "Receive reply media::mojom::SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService";
      case messages::SpeechRecognitionRecognizer::kMarkDone:
            return "Receive reply media::mojom::SpeechRecognitionRecognizer::MarkDone";
      case messages::SpeechRecognitionRecognizer::kOnLanguageChanged:
            return "Receive reply media::mojom::SpeechRecognitionRecognizer::OnLanguageChanged";
      case messages::SpeechRecognitionRecognizer::kOnMaskOffensiveWordsChanged:
            return "Receive reply media::mojom::SpeechRecognitionRecognizer::OnMaskOffensiveWordsChanged";
      case messages::SpeechRecognitionRecognizer::kUpdateRecognitionContext:
            return "Receive reply media::mojom::SpeechRecognitionRecognizer::UpdateRecognitionContext";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f2a7771;  // IPCStableHash for media::mojom::SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionRecognizer::MarkDone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd9128db3;  // IPCStableHash for media::mojom::SpeechRecognitionRecognizer::MarkDone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionRecognizer::OnLanguageChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5063ac4e;  // IPCStableHash for media::mojom::SpeechRecognitionRecognizer::OnLanguageChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionRecognizer::OnMaskOffensiveWordsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29ccb53b;  // IPCStableHash for media::mojom::SpeechRecognitionRecognizer::OnMaskOffensiveWordsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionRecognizer::UpdateRecognitionContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7b027c58;  // IPCStableHash for media::mojom::SpeechRecognitionRecognizer::UpdateRecognitionContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechRecognitionRecognizerProxy::SpeechRecognitionRecognizerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionRecognizerProxy::SendAudioToSpeechRecognitionService(
    ::media::mojom::AudioDataS16Ptr in_buffer, std::optional<::base::TimeDelta> in_media_start_pts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::AudioDataS16Ptr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_start_pts"), in_media_start_pts,
                        "<value of type std::optional<::base::TimeDelta>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionRecognizer::kSendAudioToSpeechRecognitionService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioDataS16DataView>(
    in_buffer,
    buffer_fragment);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in SpeechRecognitionRecognizer.SendAudioToSpeechRecognitionService request");
  mojo::internal::MessageFragment<
      typename decltype(params->media_start_pts)::BaseType> media_start_pts_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_media_start_pts,
    media_start_pts_fragment);

  params->media_start_pts.Set(
      media_start_pts_fragment.is_null() ? nullptr : media_start_pts_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizer::Name_);
  message.set_method_name("SendAudioToSpeechRecognitionService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionRecognizerProxy::MarkDone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionRecognizer::MarkDone");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionRecognizer::kMarkDone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizer_MarkDone_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizer::Name_);
  message.set_method_name("MarkDone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionRecognizerProxy::OnLanguageChanged(
    const std::string& in_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionRecognizer::OnLanguageChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionRecognizer::kOnLanguageChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_language,
    language_fragment);

  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null language in SpeechRecognitionRecognizer.OnLanguageChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizer::Name_);
  message.set_method_name("OnLanguageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionRecognizerProxy::OnMaskOffensiveWordsChanged(
    bool in_mask_offensive_words) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionRecognizer::OnMaskOffensiveWordsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mask_offensive_words"), in_mask_offensive_words,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionRecognizer::kOnMaskOffensiveWordsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params_Data> params(
          message);
  params.Allocate();

  params->mask_offensive_words = in_mask_offensive_words;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizer::Name_);
  message.set_method_name("OnMaskOffensiveWordsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionRecognizerProxy::UpdateRecognitionContext(
    const ::media::SpeechRecognitionRecognitionContext& in_recognition_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionRecognizer::UpdateRecognitionContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recognition_context"), in_recognition_context,
                        "<value of type const ::media::SpeechRecognitionRecognitionContext&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionRecognizer::kUpdateRecognitionContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizer_UpdateRecognitionContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->recognition_context)::BaseType> recognition_context_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionRecognitionContextDataView>(
    in_recognition_context,
    recognition_context_fragment);

  params->recognition_context.Set(
      recognition_context_fragment.is_null() ? nullptr : recognition_context_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->recognition_context.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null recognition_context in SpeechRecognitionRecognizer.UpdateRecognitionContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizer::Name_);
  message.set_method_name("UpdateRecognitionContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechRecognitionRecognizerStubDispatch::Accept(
    SpeechRecognitionRecognizer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionRecognizer>(message->header()->name)) {
    case messages::SpeechRecognitionRecognizer::kSendAudioToSpeechRecognitionService: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionRecognizer.0
      bool success = true;
      ::media::mojom::AudioDataS16Ptr p_buffer{};
      std::optional<::base::TimeDelta> p_media_start_pts{};
      SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (success && !input_data_view.ReadMediaStartPts(&p_media_start_pts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendAudioToSpeechRecognitionService(        
        std::move(p_buffer), 
        std::move(p_media_start_pts));
      return true;
    }
    case messages::SpeechRecognitionRecognizer::kMarkDone: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizer_MarkDone_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizer_MarkDone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionRecognizer.1
      bool success = true;
      SpeechRecognitionRecognizer_MarkDone_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MarkDone(        );
      return true;
    }
    case messages::SpeechRecognitionRecognizer::kOnLanguageChanged: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionRecognizer.2
      bool success = true;
      std::string p_language{};
      SpeechRecognitionRecognizer_OnLanguageChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLanguageChanged(        
        std::move(p_language));
      return true;
    }
    case messages::SpeechRecognitionRecognizer::kOnMaskOffensiveWordsChanged: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionRecognizer.3
      bool success = true;
      bool p_mask_offensive_words{};
      SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_mask_offensive_words = input_data_view.mask_offensive_words();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMaskOffensiveWordsChanged(        
        std::move(p_mask_offensive_words));
      return true;
    }
    case messages::SpeechRecognitionRecognizer::kUpdateRecognitionContext: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizer_UpdateRecognitionContext_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizer_UpdateRecognitionContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionRecognizer.4
      bool success = true;
      ::media::SpeechRecognitionRecognitionContext p_recognition_context{};
      SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRecognitionContext(&p_recognition_context))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRecognitionContext(        
        std::move(p_recognition_context));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionRecognizerStubDispatch::AcceptWithResponder(
    SpeechRecognitionRecognizer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionRecognizer>(message->header()->name)) {
    case messages::SpeechRecognitionRecognizer::kSendAudioToSpeechRecognitionService: {
      break;
    }
    case messages::SpeechRecognitionRecognizer::kMarkDone: {
      break;
    }
    case messages::SpeechRecognitionRecognizer::kOnLanguageChanged: {
      break;
    }
    case messages::SpeechRecognitionRecognizer::kOnMaskOffensiveWordsChanged: {
      break;
    }
    case messages::SpeechRecognitionRecognizer::kUpdateRecognitionContext: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionRecognizerValidationInfo[] = {
    { &internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionRecognizer_MarkDone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionRecognizer_UpdateRecognitionContext_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionRecognizerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionRecognizer::Name_,
    kSpeechRecognitionRecognizerValidationInfo);
}

// The declaration includes the definition on other builds.

SpeechRecognitionRecognizerClient::IPCStableHashFunction SpeechRecognitionRecognizerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionRecognizerClient>(message.name())) {
    case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionRecognitionEvent: {
      return &SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionStopped: {
      return &SpeechRecognitionRecognizerClient::OnSpeechRecognitionStopped_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionError: {
      return &SpeechRecognitionRecognizerClient::OnSpeechRecognitionError_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionRecognizerClient::kOnLanguageIdentificationEvent: {
      return &SpeechRecognitionRecognizerClient::OnLanguageIdentificationEvent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionRecognizerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionRecognizerClient>(message.name())) {
      case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionRecognitionEvent:
            return "Receive media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent";
      case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionStopped:
            return "Receive media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionStopped";
      case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionError:
            return "Receive media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionError";
      case messages::SpeechRecognitionRecognizerClient::kOnLanguageIdentificationEvent:
            return "Receive media::mojom::SpeechRecognitionRecognizerClient::OnLanguageIdentificationEvent";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionRecognizerClient>(message.name())) {
      case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionRecognitionEvent:
            return "Receive reply media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent";
      case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionStopped:
            return "Receive reply media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionStopped";
      case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionError:
            return "Receive reply media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionError";
      case messages::SpeechRecognitionRecognizerClient::kOnLanguageIdentificationEvent:
            return "Receive reply media::mojom::SpeechRecognitionRecognizerClient::OnLanguageIdentificationEvent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3203e815;  // IPCStableHash for media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionRecognizerClient::OnSpeechRecognitionStopped_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x75063a99;  // IPCStableHash for media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionStopped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionRecognizerClient::OnSpeechRecognitionError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x06f946b8;  // IPCStableHash for media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionRecognizerClient::OnLanguageIdentificationEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x677134ac;  // IPCStableHash for media::mojom::SpeechRecognitionRecognizerClient::OnLanguageIdentificationEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback(
      SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback(const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback&) = delete;
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback& operator=(const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback callback_;
};

SpeechRecognitionRecognizerClientProxy::SpeechRecognitionRecognizerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionRecognizerClientProxy::OnSpeechRecognitionRecognitionEvent(
    const ::media::SpeechRecognitionResult& in_result, OnSpeechRecognitionRecognitionEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const ::media::SpeechRecognitionResult&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionRecognitionEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in SpeechRecognitionRecognizerClient.OnSpeechRecognitionRecognitionEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizerClient::Name_);
  message.set_method_name("OnSpeechRecognitionRecognitionEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SpeechRecognitionRecognizerClientProxy::OnSpeechRecognitionStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionStopped");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizerClient::Name_);
  message.set_method_name("OnSpeechRecognitionStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionRecognizerClientProxy::OnSpeechRecognitionError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionError");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizerClient::Name_);
  message.set_method_name("OnSpeechRecognitionError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionRecognizerClientProxy::OnLanguageIdentificationEvent(
    LanguageIdentificationEventPtr in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionRecognizerClient::OnLanguageIdentificationEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type LanguageIdentificationEventPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionRecognizerClient::kOnLanguageIdentificationEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::LanguageIdentificationEventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in SpeechRecognitionRecognizerClient.OnLanguageIdentificationEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizerClient::Name_);
  message.set_method_name("OnLanguageIdentificationEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder> proxy(
        new SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_continue_recognition);
};

bool SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SpeechRecognitionRecognizerClient.0
  bool success = true;
  bool p_continue_recognition{};
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_continue_recognition = input_data_view.continue_recognition();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SpeechRecognitionRecognizerClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_continue_recognition));
  }
  return true;
}

void SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder::Run(
    bool in_continue_recognition) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("continue_recognition"), in_continue_recognition,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionRecognitionEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->continue_recognition = in_continue_recognition;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizerClient::Name_);
  message.set_method_name("OnSpeechRecognitionRecognitionEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SpeechRecognitionRecognizerClientStubDispatch::Accept(
    SpeechRecognitionRecognizerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionRecognizerClient>(message->header()->name)) {
    case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionRecognitionEvent: {
      break;
    }
    case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionStopped: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionRecognizerClient.1
      bool success = true;
      SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSpeechRecognitionStopped(        );
      return true;
    }
    case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionError: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionRecognizerClient.2
      bool success = true;
      SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizerClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSpeechRecognitionError(        );
      return true;
    }
    case messages::SpeechRecognitionRecognizerClient::kOnLanguageIdentificationEvent: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionRecognizerClient.3
      bool success = true;
      LanguageIdentificationEventPtr p_event{};
      SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizerClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLanguageIdentificationEvent(        
        std::move(p_event));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionRecognizerClientStubDispatch::AcceptWithResponder(
    SpeechRecognitionRecognizerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionRecognizerClient>(message->header()->name)) {
    case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionRecognitionEvent: {
      internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data* params =
          reinterpret_cast<
              internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SpeechRecognitionRecognizerClient.0
      bool success = true;
      ::media::SpeechRecognitionResult p_result{};
      SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizerClient::Name_, 0, false);
        return false;
      }
      auto callback =
          SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSpeechRecognitionRecognitionEvent(        
        std::move(p_result), std::move(callback));
      return true;
    }
    case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionStopped: {
      break;
    }
    case messages::SpeechRecognitionRecognizerClient::kOnSpeechRecognitionError: {
      break;
    }
    case messages::SpeechRecognitionRecognizerClient::kOnLanguageIdentificationEvent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionRecognizerClientValidationInfo[] = {
    { &internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data::Validate,
     &internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data::Validate},
    { &internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionRecognizerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionRecognizerClient::Name_,
    kSpeechRecognitionRecognizerClientValidationInfo);
}

bool SpeechRecognitionRecognizerClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionRecognizerClient::Name_,
    kSpeechRecognitionRecognizerClientValidationInfo);
}
// The declaration includes the definition on other builds.

SpeechRecognitionBrowserObserver::IPCStableHashFunction SpeechRecognitionBrowserObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionBrowserObserver>(message.name())) {
    case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionAvailabilityChanged: {
      return &SpeechRecognitionBrowserObserver::SpeechRecognitionAvailabilityChanged_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionLanguageChanged: {
      return &SpeechRecognitionBrowserObserver::SpeechRecognitionLanguageChanged_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionMaskOffensiveWordsChanged: {
      return &SpeechRecognitionBrowserObserver::SpeechRecognitionMaskOffensiveWordsChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionBrowserObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionBrowserObserver>(message.name())) {
      case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionAvailabilityChanged:
            return "Receive media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionAvailabilityChanged";
      case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionLanguageChanged:
            return "Receive media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionLanguageChanged";
      case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionMaskOffensiveWordsChanged:
            return "Receive media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionMaskOffensiveWordsChanged";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionBrowserObserver>(message.name())) {
      case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionAvailabilityChanged:
            return "Receive reply media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionAvailabilityChanged";
      case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionLanguageChanged:
            return "Receive reply media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionLanguageChanged";
      case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionMaskOffensiveWordsChanged:
            return "Receive reply media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionMaskOffensiveWordsChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionBrowserObserver::SpeechRecognitionAvailabilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c1f6fa6;  // IPCStableHash for media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionAvailabilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionBrowserObserver::SpeechRecognitionLanguageChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5106afac;  // IPCStableHash for media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionLanguageChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionBrowserObserver::SpeechRecognitionMaskOffensiveWordsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e6b18f8;  // IPCStableHash for media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionMaskOffensiveWordsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechRecognitionBrowserObserverProxy::SpeechRecognitionBrowserObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionBrowserObserverProxy::SpeechRecognitionAvailabilityChanged(
    bool in_is_speech_recognition_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionAvailabilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_speech_recognition_available"), in_is_speech_recognition_available,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionAvailabilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_speech_recognition_available = in_is_speech_recognition_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionBrowserObserver::Name_);
  message.set_method_name("SpeechRecognitionAvailabilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionBrowserObserverProxy::SpeechRecognitionLanguageChanged(
    const std::string& in_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionLanguageChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionLanguageChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_language,
    language_fragment);

  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null language in SpeechRecognitionBrowserObserver.SpeechRecognitionLanguageChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionBrowserObserver::Name_);
  message.set_method_name("SpeechRecognitionLanguageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionBrowserObserverProxy::SpeechRecognitionMaskOffensiveWordsChanged(
    bool in_mask_offensive_words) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionMaskOffensiveWordsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mask_offensive_words"), in_mask_offensive_words,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionMaskOffensiveWordsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params_Data> params(
          message);
  params.Allocate();

  params->mask_offensive_words = in_mask_offensive_words;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionBrowserObserver::Name_);
  message.set_method_name("SpeechRecognitionMaskOffensiveWordsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechRecognitionBrowserObserverStubDispatch::Accept(
    SpeechRecognitionBrowserObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionBrowserObserver>(message->header()->name)) {
    case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionAvailabilityChanged: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionBrowserObserver.0
      bool success = true;
      bool p_is_speech_recognition_available{};
      SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_speech_recognition_available = input_data_view.is_speech_recognition_available();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionBrowserObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SpeechRecognitionAvailabilityChanged(        
        std::move(p_is_speech_recognition_available));
      return true;
    }
    case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionLanguageChanged: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionBrowserObserver.1
      bool success = true;
      std::string p_language{};
      SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionBrowserObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SpeechRecognitionLanguageChanged(        
        std::move(p_language));
      return true;
    }
    case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionMaskOffensiveWordsChanged: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionBrowserObserver.2
      bool success = true;
      bool p_mask_offensive_words{};
      SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_mask_offensive_words = input_data_view.mask_offensive_words();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionBrowserObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SpeechRecognitionMaskOffensiveWordsChanged(        
        std::move(p_mask_offensive_words));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionBrowserObserverStubDispatch::AcceptWithResponder(
    SpeechRecognitionBrowserObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionBrowserObserver>(message->header()->name)) {
    case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionAvailabilityChanged: {
      break;
    }
    case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionLanguageChanged: {
      break;
    }
    case messages::SpeechRecognitionBrowserObserver::kSpeechRecognitionMaskOffensiveWordsChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionBrowserObserverValidationInfo[] = {
    { &internal::SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionBrowserObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionBrowserObserver::Name_,
    kSpeechRecognitionBrowserObserverValidationInfo);
}

// The declaration includes the definition on other builds.

SpeechRecognitionSurface::IPCStableHashFunction SpeechRecognitionSurface::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionSurface>(message.name())) {
    case messages::SpeechRecognitionSurface::kActivate: {
      return &SpeechRecognitionSurface::Activate_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSurface::kGetBounds: {
      return &SpeechRecognitionSurface::GetBounds_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionSurface::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionSurface>(message.name())) {
      case messages::SpeechRecognitionSurface::kActivate:
            return "Receive media::mojom::SpeechRecognitionSurface::Activate";
      case messages::SpeechRecognitionSurface::kGetBounds:
            return "Receive media::mojom::SpeechRecognitionSurface::GetBounds";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionSurface>(message.name())) {
      case messages::SpeechRecognitionSurface::kActivate:
            return "Receive reply media::mojom::SpeechRecognitionSurface::Activate";
      case messages::SpeechRecognitionSurface::kGetBounds:
            return "Receive reply media::mojom::SpeechRecognitionSurface::GetBounds";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionSurface::Activate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe6b189d3;  // IPCStableHash for media::mojom::SpeechRecognitionSurface::Activate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSurface::GetBounds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3edba81;  // IPCStableHash for media::mojom::SpeechRecognitionSurface::GetBounds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SpeechRecognitionSurface_GetBounds_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SpeechRecognitionSurface_GetBounds_ForwardToCallback(
      SpeechRecognitionSurface::GetBoundsCallback callback
      ) : callback_(std::move(callback)) {
  }

  SpeechRecognitionSurface_GetBounds_ForwardToCallback(const SpeechRecognitionSurface_GetBounds_ForwardToCallback&) = delete;
  SpeechRecognitionSurface_GetBounds_ForwardToCallback& operator=(const SpeechRecognitionSurface_GetBounds_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SpeechRecognitionSurface::GetBoundsCallback callback_;
};

SpeechRecognitionSurfaceProxy::SpeechRecognitionSurfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionSurfaceProxy::Activate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSurface::Activate");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSurface::kActivate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSurface_Activate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSurface::Name_);
  message.set_method_name("Activate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSurfaceProxy::GetBounds(
    GetBoundsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSurface::GetBounds");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSurface::kGetBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSurface_GetBounds_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSurface::Name_);
  message.set_method_name("GetBounds");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SpeechRecognitionSurface_GetBounds_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SpeechRecognitionSurface_GetBounds_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SpeechRecognitionSurface::GetBoundsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SpeechRecognitionSurface_GetBounds_ProxyToResponder> proxy(
        new SpeechRecognitionSurface_GetBounds_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SpeechRecognitionSurface_GetBounds_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SpeechRecognitionSurface_GetBounds_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SpeechRecognitionSurface_GetBounds_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SpeechRecognitionSurface::GetBoundsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::gfx::Rect>& in_bounds);
};

bool SpeechRecognitionSurface_GetBounds_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SpeechRecognitionSurface_GetBounds_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SpeechRecognitionSurface_GetBounds_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SpeechRecognitionSurface.1
  bool success = true;
  std::optional<::gfx::Rect> p_bounds{};
  SpeechRecognitionSurface_GetBounds_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBounds(&p_bounds))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SpeechRecognitionSurface::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bounds));
  }
  return true;
}

void SpeechRecognitionSurface_GetBounds_ProxyToResponder::Run(
    const std::optional<::gfx::Rect>& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::SpeechRecognitionSurface::GetBounds", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const std::optional<::gfx::Rect>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSurface::kGetBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSurface_GetBounds_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSurface::Name_);
  message.set_method_name("GetBounds");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SpeechRecognitionSurfaceStubDispatch::Accept(
    SpeechRecognitionSurface* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionSurface>(message->header()->name)) {
    case messages::SpeechRecognitionSurface::kActivate: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSurface_Activate_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSurface_Activate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionSurface.0
      bool success = true;
      SpeechRecognitionSurface_Activate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSurface::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Activate(        );
      return true;
    }
    case messages::SpeechRecognitionSurface::kGetBounds: {
      break;
    }
  }
  return false;
}

// static
bool SpeechRecognitionSurfaceStubDispatch::AcceptWithResponder(
    SpeechRecognitionSurface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionSurface>(message->header()->name)) {
    case messages::SpeechRecognitionSurface::kActivate: {
      break;
    }
    case messages::SpeechRecognitionSurface::kGetBounds: {
      internal::SpeechRecognitionSurface_GetBounds_Params_Data* params =
          reinterpret_cast<
              internal::SpeechRecognitionSurface_GetBounds_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SpeechRecognitionSurface.1
      bool success = true;
      SpeechRecognitionSurface_GetBounds_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSurface::Name_, 1, false);
        return false;
      }
      auto callback =
          SpeechRecognitionSurface_GetBounds_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBounds(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionSurfaceValidationInfo[] = {
    { &internal::SpeechRecognitionSurface_Activate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSurface_GetBounds_Params_Data::Validate,
     &internal::SpeechRecognitionSurface_GetBounds_ResponseParams_Data::Validate},
};

bool SpeechRecognitionSurfaceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionSurface::Name_,
    kSpeechRecognitionSurfaceValidationInfo);
}

bool SpeechRecognitionSurfaceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionSurface::Name_,
    kSpeechRecognitionSurfaceValidationInfo);
}
// The declaration includes the definition on other builds.

SpeechRecognitionSurfaceClient::IPCStableHashFunction SpeechRecognitionSurfaceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionSurfaceClient>(message.name())) {
    case messages::SpeechRecognitionSurfaceClient::kOnSessionEnded: {
      return &SpeechRecognitionSurfaceClient::OnSessionEnded_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSurfaceClient::kOnFullscreenToggled: {
      return &SpeechRecognitionSurfaceClient::OnFullscreenToggled_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionSurfaceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionSurfaceClient>(message.name())) {
      case messages::SpeechRecognitionSurfaceClient::kOnSessionEnded:
            return "Receive media::mojom::SpeechRecognitionSurfaceClient::OnSessionEnded";
      case messages::SpeechRecognitionSurfaceClient::kOnFullscreenToggled:
            return "Receive media::mojom::SpeechRecognitionSurfaceClient::OnFullscreenToggled";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionSurfaceClient>(message.name())) {
      case messages::SpeechRecognitionSurfaceClient::kOnSessionEnded:
            return "Receive reply media::mojom::SpeechRecognitionSurfaceClient::OnSessionEnded";
      case messages::SpeechRecognitionSurfaceClient::kOnFullscreenToggled:
            return "Receive reply media::mojom::SpeechRecognitionSurfaceClient::OnFullscreenToggled";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionSurfaceClient::OnSessionEnded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1dd0a1f1;  // IPCStableHash for media::mojom::SpeechRecognitionSurfaceClient::OnSessionEnded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSurfaceClient::OnFullscreenToggled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb21f0f43;  // IPCStableHash for media::mojom::SpeechRecognitionSurfaceClient::OnFullscreenToggled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechRecognitionSurfaceClientProxy::SpeechRecognitionSurfaceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionSurfaceClientProxy::OnSessionEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSurfaceClient::OnSessionEnded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSurfaceClient::kOnSessionEnded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSurfaceClient_OnSessionEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSurfaceClient::Name_);
  message.set_method_name("OnSessionEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSurfaceClientProxy::OnFullscreenToggled(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSurfaceClient::OnFullscreenToggled");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSurfaceClient::kOnFullscreenToggled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSurfaceClient::Name_);
  message.set_method_name("OnFullscreenToggled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechRecognitionSurfaceClientStubDispatch::Accept(
    SpeechRecognitionSurfaceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionSurfaceClient>(message->header()->name)) {
    case messages::SpeechRecognitionSurfaceClient::kOnSessionEnded: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSurfaceClient_OnSessionEnded_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSurfaceClient_OnSessionEnded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionSurfaceClient.0
      bool success = true;
      SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSurfaceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionEnded(        );
      return true;
    }
    case messages::SpeechRecognitionSurfaceClient::kOnFullscreenToggled: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionSurfaceClient.1
      bool success = true;
      SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSurfaceClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFullscreenToggled(        );
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionSurfaceClientStubDispatch::AcceptWithResponder(
    SpeechRecognitionSurfaceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionSurfaceClient>(message->header()->name)) {
    case messages::SpeechRecognitionSurfaceClient::kOnSessionEnded: {
      break;
    }
    case messages::SpeechRecognitionSurfaceClient::kOnFullscreenToggled: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionSurfaceClientValidationInfo[] = {
    { &internal::SpeechRecognitionSurfaceClient_OnSessionEnded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionSurfaceClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionSurfaceClient::Name_,
    kSpeechRecognitionSurfaceClientValidationInfo);
}

// The declaration includes the definition on other builds.

SpeechRecognitionClientBrowserInterface::IPCStableHashFunction SpeechRecognitionClientBrowserInterface::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionClientBrowserInterface>(message.name())) {
    case messages::SpeechRecognitionClientBrowserInterface::kBindSpeechRecognitionBrowserObserver: {
      return &SpeechRecognitionClientBrowserInterface::BindSpeechRecognitionBrowserObserver_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionClientBrowserInterface::kREMOVED_1: {
      return &SpeechRecognitionClientBrowserInterface::REMOVED_1_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionClientBrowserInterface::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionClientBrowserInterface>(message.name())) {
      case messages::SpeechRecognitionClientBrowserInterface::kBindSpeechRecognitionBrowserObserver:
            return "Receive media::mojom::SpeechRecognitionClientBrowserInterface::BindSpeechRecognitionBrowserObserver";
      case messages::SpeechRecognitionClientBrowserInterface::kREMOVED_1:
            return "Receive media::mojom::SpeechRecognitionClientBrowserInterface::REMOVED_1";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionClientBrowserInterface>(message.name())) {
      case messages::SpeechRecognitionClientBrowserInterface::kBindSpeechRecognitionBrowserObserver:
            return "Receive reply media::mojom::SpeechRecognitionClientBrowserInterface::BindSpeechRecognitionBrowserObserver";
      case messages::SpeechRecognitionClientBrowserInterface::kREMOVED_1:
            return "Receive reply media::mojom::SpeechRecognitionClientBrowserInterface::REMOVED_1";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionClientBrowserInterface::BindSpeechRecognitionBrowserObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73976d70;  // IPCStableHash for media::mojom::SpeechRecognitionClientBrowserInterface::BindSpeechRecognitionBrowserObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionClientBrowserInterface::REMOVED_1_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8eb1921;  // IPCStableHash for media::mojom::SpeechRecognitionClientBrowserInterface::REMOVED_1
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechRecognitionClientBrowserInterfaceProxy::SpeechRecognitionClientBrowserInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionClientBrowserInterfaceProxy::BindSpeechRecognitionBrowserObserver(
    ::mojo::PendingRemote<SpeechRecognitionBrowserObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionClientBrowserInterface::BindSpeechRecognitionBrowserObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<SpeechRecognitionBrowserObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionClientBrowserInterface::kBindSpeechRecognitionBrowserObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionBrowserObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in SpeechRecognitionClientBrowserInterface.BindSpeechRecognitionBrowserObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionClientBrowserInterface::Name_);
  message.set_method_name("BindSpeechRecognitionBrowserObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionClientBrowserInterfaceProxy::REMOVED_1(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionClientBrowserInterface::REMOVED_1");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionClientBrowserInterface::kREMOVED_1), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionClientBrowserInterface_REMOVED_1_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionClientBrowserInterface::Name_);
  message.set_method_name("REMOVED_1");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechRecognitionClientBrowserInterfaceStubDispatch::Accept(
    SpeechRecognitionClientBrowserInterface* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionClientBrowserInterface>(message->header()->name)) {
    case messages::SpeechRecognitionClientBrowserInterface::kBindSpeechRecognitionBrowserObserver: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionClientBrowserInterface.0
      bool success = true;
      ::mojo::PendingRemote<SpeechRecognitionBrowserObserver> p_observer{};
      SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionClientBrowserInterface::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSpeechRecognitionBrowserObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::SpeechRecognitionClientBrowserInterface::kREMOVED_1: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionClientBrowserInterface_REMOVED_1_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionClientBrowserInterface_REMOVED_1_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionClientBrowserInterface.1
      bool success = true;
      SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionClientBrowserInterface::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->REMOVED_1(        );
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionClientBrowserInterfaceStubDispatch::AcceptWithResponder(
    SpeechRecognitionClientBrowserInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionClientBrowserInterface>(message->header()->name)) {
    case messages::SpeechRecognitionClientBrowserInterface::kBindSpeechRecognitionBrowserObserver: {
      break;
    }
    case messages::SpeechRecognitionClientBrowserInterface::kREMOVED_1: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionClientBrowserInterfaceValidationInfo[] = {
    { &internal::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionClientBrowserInterface_REMOVED_1_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionClientBrowserInterfaceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionClientBrowserInterface::Name_,
    kSpeechRecognitionClientBrowserInterfaceValidationInfo);
}



}  // media::mojom


namespace mojo {


// static
bool StructTraits<::media::mojom::HypothesisParts::DataView, ::media::mojom::HypothesisPartsPtr>::Read(
    ::media::mojom::HypothesisParts::DataView input,
    ::media::mojom::HypothesisPartsPtr* output) {
  bool success = true;
  ::media::mojom::HypothesisPartsPtr result(::media::mojom::HypothesisParts::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadHypothesisPartOffset(&result->hypothesis_part_offset))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::MediaTimestampRange::DataView, ::media::mojom::MediaTimestampRangePtr>::Read(
    ::media::mojom::MediaTimestampRange::DataView input,
    ::media::mojom::MediaTimestampRangePtr* output) {
  bool success = true;
  ::media::mojom::MediaTimestampRangePtr result(::media::mojom::MediaTimestampRange::New());
  
      if (success && !input.ReadStart(&result->start))
        success = false;
      if (success && !input.ReadEnd(&result->end))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::TimingInformation::DataView, ::media::mojom::TimingInformationPtr>::Read(
    ::media::mojom::TimingInformation::DataView input,
    ::media::mojom::TimingInformationPtr* output) {
  bool success = true;
  ::media::mojom::TimingInformationPtr result(::media::mojom::TimingInformation::New());
  
      if (success && !input.ReadAudioStartTime(&result->audio_start_time))
        success = false;
      if (success && !input.ReadAudioEndTime(&result->audio_end_time))
        success = false;
      if (success && !input.ReadHypothesisParts(&result->hypothesis_parts))
        success = false;
      if (success && !input.ReadOriginatingMediaTimestamps(&result->originating_media_timestamps))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SpeechRecognitionResult::DataView, ::media::mojom::SpeechRecognitionResultPtr>::Read(
    ::media::mojom::SpeechRecognitionResult::DataView input,
    ::media::mojom::SpeechRecognitionResultPtr* output) {
  bool success = true;
  ::media::mojom::SpeechRecognitionResultPtr result(::media::mojom::SpeechRecognitionResult::New());
  
      if (success && !input.ReadTranscription(&result->transcription))
        success = false;
      if (success)
        result->is_final = input.is_final();
      if (success && !input.ReadTimingInformation(&result->timing_information))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::LanguageIdentificationEvent::DataView, ::media::mojom::LanguageIdentificationEventPtr>::Read(
    ::media::mojom::LanguageIdentificationEvent::DataView input,
    ::media::mojom::LanguageIdentificationEventPtr* output) {
  bool success = true;
  ::media::mojom::LanguageIdentificationEventPtr result(::media::mojom::LanguageIdentificationEvent::New());
  
      if (success && !input.ReadLanguage(&result->language))
        success = false;
      if (success && !input.ReadConfidenceLevel(&result->confidence_level))
        success = false;
      if (success && !input.ReadAsrSwitchResult(&result->asr_switch_result)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SpeechRecognitionOptions::DataView, ::media::mojom::SpeechRecognitionOptionsPtr>::Read(
    ::media::mojom::SpeechRecognitionOptions::DataView input,
    ::media::mojom::SpeechRecognitionOptionsPtr* output) {
  bool success = true;
  ::media::mojom::SpeechRecognitionOptionsPtr result(::media::mojom::SpeechRecognitionOptions::New());
  
      if (success && !input.ReadRecognitionMode(&result->recognition_mode))
        success = false;
      if (success)
        result->enable_formatting = input.enable_formatting();
      if (success && !input.ReadLanguage(&result->language))
        success = false;
      if (success)
        result->is_server_based = input.is_server_based();
      if (success && !input.ReadRecognizerClientType(&result->recognizer_client_type))
        success = false;
      if (success)
        result->skip_continuously_empty_audio = input.skip_continuously_empty_audio();
      if (success && !input.ReadExperimentRecognizerRoutingKey(&result->experiment_recognizer_routing_key))
        success = false;
      if (success)
        result->channel_count = input.channel_count();
      if (success)
        result->sample_rate = input.sample_rate();
      if (success && !input.ReadRecognitionContext(&result->recognition_context))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void SpeechRecognitionContextInterceptorForTesting::BindRecognizer(::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options, BindRecognizerCallback callback) {
  GetForwardingInterface()->BindRecognizer(
    std::move(receiver)
    , 
    std::move(client)
    , 
    std::move(options)
    , std::move(callback));
}
void SpeechRecognitionContextInterceptorForTesting::BindWebSpeechRecognizer(::mojo::PendingReceiver<::media::mojom::SpeechRecognitionSession> session_receiver, ::mojo::PendingRemote<::media::mojom::SpeechRecognitionSessionClient> session_client, ::mojo::PendingReceiver<::media::mojom::SpeechRecognitionAudioForwarder> audio_forwarder, int32_t channel_count, int32_t sample_rate, SpeechRecognitionOptionsPtr options, bool continuous) {
  GetForwardingInterface()->BindWebSpeechRecognizer(
    std::move(session_receiver)
    , 
    std::move(session_client)
    , 
    std::move(audio_forwarder)
    , 
    std::move(channel_count)
    , 
    std::move(sample_rate)
    , 
    std::move(options)
    , 
    std::move(continuous)
    );
}
SpeechRecognitionContextAsyncWaiter::SpeechRecognitionContextAsyncWaiter(
    SpeechRecognitionContext* proxy) : proxy_(proxy) {}

SpeechRecognitionContextAsyncWaiter::~SpeechRecognitionContextAsyncWaiter() = default;


void SpeechRecognitionContextAsyncWaiter::BindRecognizer(
    ::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options, bool* out_is_multichannel_supported) {
  base::RunLoop loop;
  proxy_->BindRecognizer(
      std::move(receiver),
      std::move(client),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_multichannel_supported
,
             bool is_multichannel_supported) {*out_is_multichannel_supported = std::move(is_multichannel_supported);
            loop->Quit();
          },
          &loop,
          out_is_multichannel_supported));
  loop.Run();
}

bool SpeechRecognitionContextAsyncWaiter::BindRecognizer(
    ::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options) {
  bool async_wait_result;
  BindRecognizer(std::move(receiver),std::move(client),std::move(options),&async_wait_result);
  return async_wait_result;
}




void SpeechRecognitionRecognizerInterceptorForTesting::SendAudioToSpeechRecognitionService(::media::mojom::AudioDataS16Ptr buffer, std::optional<::base::TimeDelta> media_start_pts) {
  GetForwardingInterface()->SendAudioToSpeechRecognitionService(
    std::move(buffer)
    , 
    std::move(media_start_pts)
    );
}
void SpeechRecognitionRecognizerInterceptorForTesting::MarkDone() {
  GetForwardingInterface()->MarkDone();
}
void SpeechRecognitionRecognizerInterceptorForTesting::OnLanguageChanged(const std::string& language) {
  GetForwardingInterface()->OnLanguageChanged(
    std::move(language)
    );
}
void SpeechRecognitionRecognizerInterceptorForTesting::OnMaskOffensiveWordsChanged(bool mask_offensive_words) {
  GetForwardingInterface()->OnMaskOffensiveWordsChanged(
    std::move(mask_offensive_words)
    );
}
void SpeechRecognitionRecognizerInterceptorForTesting::UpdateRecognitionContext(const ::media::SpeechRecognitionRecognitionContext& recognition_context) {
  GetForwardingInterface()->UpdateRecognitionContext(
    std::move(recognition_context)
    );
}
SpeechRecognitionRecognizerAsyncWaiter::SpeechRecognitionRecognizerAsyncWaiter(
    SpeechRecognitionRecognizer* proxy) : proxy_(proxy) {}

SpeechRecognitionRecognizerAsyncWaiter::~SpeechRecognitionRecognizerAsyncWaiter() = default;





void SpeechRecognitionRecognizerClientInterceptorForTesting::OnSpeechRecognitionRecognitionEvent(const ::media::SpeechRecognitionResult& result, OnSpeechRecognitionRecognitionEventCallback callback) {
  GetForwardingInterface()->OnSpeechRecognitionRecognitionEvent(
    std::move(result)
    , std::move(callback));
}
void SpeechRecognitionRecognizerClientInterceptorForTesting::OnSpeechRecognitionStopped() {
  GetForwardingInterface()->OnSpeechRecognitionStopped();
}
void SpeechRecognitionRecognizerClientInterceptorForTesting::OnSpeechRecognitionError() {
  GetForwardingInterface()->OnSpeechRecognitionError();
}
void SpeechRecognitionRecognizerClientInterceptorForTesting::OnLanguageIdentificationEvent(LanguageIdentificationEventPtr event) {
  GetForwardingInterface()->OnLanguageIdentificationEvent(
    std::move(event)
    );
}
SpeechRecognitionRecognizerClientAsyncWaiter::SpeechRecognitionRecognizerClientAsyncWaiter(
    SpeechRecognitionRecognizerClient* proxy) : proxy_(proxy) {}

SpeechRecognitionRecognizerClientAsyncWaiter::~SpeechRecognitionRecognizerClientAsyncWaiter() = default;


void SpeechRecognitionRecognizerClientAsyncWaiter::OnSpeechRecognitionRecognitionEvent(
    const ::media::SpeechRecognitionResult& result, bool* out_continue_recognition) {
  base::RunLoop loop;
  proxy_->OnSpeechRecognitionRecognitionEvent(
      std::move(result),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_continue_recognition
,
             bool continue_recognition) {*out_continue_recognition = std::move(continue_recognition);
            loop->Quit();
          },
          &loop,
          out_continue_recognition));
  loop.Run();
}

bool SpeechRecognitionRecognizerClientAsyncWaiter::OnSpeechRecognitionRecognitionEvent(
    const ::media::SpeechRecognitionResult& result) {
  bool async_wait_result;
  OnSpeechRecognitionRecognitionEvent(std::move(result),&async_wait_result);
  return async_wait_result;
}




void SpeechRecognitionBrowserObserverInterceptorForTesting::SpeechRecognitionAvailabilityChanged(bool is_speech_recognition_available) {
  GetForwardingInterface()->SpeechRecognitionAvailabilityChanged(
    std::move(is_speech_recognition_available)
    );
}
void SpeechRecognitionBrowserObserverInterceptorForTesting::SpeechRecognitionLanguageChanged(const std::string& language) {
  GetForwardingInterface()->SpeechRecognitionLanguageChanged(
    std::move(language)
    );
}
void SpeechRecognitionBrowserObserverInterceptorForTesting::SpeechRecognitionMaskOffensiveWordsChanged(bool mask_offensive_words) {
  GetForwardingInterface()->SpeechRecognitionMaskOffensiveWordsChanged(
    std::move(mask_offensive_words)
    );
}
SpeechRecognitionBrowserObserverAsyncWaiter::SpeechRecognitionBrowserObserverAsyncWaiter(
    SpeechRecognitionBrowserObserver* proxy) : proxy_(proxy) {}

SpeechRecognitionBrowserObserverAsyncWaiter::~SpeechRecognitionBrowserObserverAsyncWaiter() = default;





void SpeechRecognitionSurfaceInterceptorForTesting::Activate() {
  GetForwardingInterface()->Activate();
}
void SpeechRecognitionSurfaceInterceptorForTesting::GetBounds(GetBoundsCallback callback) {
  GetForwardingInterface()->GetBounds(std::move(callback));
}
SpeechRecognitionSurfaceAsyncWaiter::SpeechRecognitionSurfaceAsyncWaiter(
    SpeechRecognitionSurface* proxy) : proxy_(proxy) {}

SpeechRecognitionSurfaceAsyncWaiter::~SpeechRecognitionSurfaceAsyncWaiter() = default;


void SpeechRecognitionSurfaceAsyncWaiter::GetBounds(
    std::optional<::gfx::Rect>* out_bounds) {
  base::RunLoop loop;
  proxy_->GetBounds(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::gfx::Rect>* out_bounds
,
             const std::optional<::gfx::Rect>& bounds) {*out_bounds = std::move(bounds);
            loop->Quit();
          },
          &loop,
          out_bounds));
  loop.Run();
}

std::optional<::gfx::Rect> SpeechRecognitionSurfaceAsyncWaiter::GetBounds(
    ) {
  std::optional<::gfx::Rect> async_wait_result;
  GetBounds(&async_wait_result);
  return async_wait_result;
}




void SpeechRecognitionSurfaceClientInterceptorForTesting::OnSessionEnded() {
  GetForwardingInterface()->OnSessionEnded();
}
void SpeechRecognitionSurfaceClientInterceptorForTesting::OnFullscreenToggled() {
  GetForwardingInterface()->OnFullscreenToggled();
}
SpeechRecognitionSurfaceClientAsyncWaiter::SpeechRecognitionSurfaceClientAsyncWaiter(
    SpeechRecognitionSurfaceClient* proxy) : proxy_(proxy) {}

SpeechRecognitionSurfaceClientAsyncWaiter::~SpeechRecognitionSurfaceClientAsyncWaiter() = default;





void SpeechRecognitionClientBrowserInterfaceInterceptorForTesting::BindSpeechRecognitionBrowserObserver(::mojo::PendingRemote<SpeechRecognitionBrowserObserver> observer) {
  GetForwardingInterface()->BindSpeechRecognitionBrowserObserver(
    std::move(observer)
    );
}
void SpeechRecognitionClientBrowserInterfaceInterceptorForTesting::REMOVED_1() {
  GetForwardingInterface()->REMOVED_1();
}
SpeechRecognitionClientBrowserInterfaceAsyncWaiter::SpeechRecognitionClientBrowserInterfaceAsyncWaiter(
    SpeechRecognitionClientBrowserInterface* proxy) : proxy_(proxy) {}

SpeechRecognitionClientBrowserInterfaceAsyncWaiter::~SpeechRecognitionClientBrowserInterfaceAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif