// media/mojo/mojom/speech_recognition.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/speech_recognition.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/speech_recognition.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* ConfidenceLevelToStringHelper(ConfidenceLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ConfidenceLevel::kUnknown:
      return "kUnknown";
    case ConfidenceLevel::kNotConfident:
      return "kNotConfident";
    case ConfidenceLevel::kConfident:
      return "kConfident";
    case ConfidenceLevel::kHighlyConfident:
      return "kHighlyConfident";
    default:
      return nullptr;
  }
}

std::string ConfidenceLevelToString(ConfidenceLevel value) {
  const char *str = ConfidenceLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ConfidenceLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ConfidenceLevel value) {
  return os << ConfidenceLevelToString(value);
}

NOINLINE static const char* AsrSwitchResultToStringHelper(AsrSwitchResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AsrSwitchResult::kDefaultNoSwitch:
      return "kDefaultNoSwitch";
    case AsrSwitchResult::kSwitchSucceeded:
      return "kSwitchSucceeded";
    case AsrSwitchResult::kSwitchFailed:
      return "kSwitchFailed";
    case AsrSwitchResult::kSwitchSkipedNoLp:
      return "kSwitchSkipedNoLp";
    default:
      return nullptr;
  }
}

std::string AsrSwitchResultToString(AsrSwitchResult value) {
  const char *str = AsrSwitchResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AsrSwitchResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AsrSwitchResult value) {
  return os << AsrSwitchResultToString(value);
}

NOINLINE static const char* SpeechRecognitionModeToStringHelper(SpeechRecognitionMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SpeechRecognitionMode::kUnknown:
      return "kUnknown";
    case SpeechRecognitionMode::kIme:
      return "kIme";
    case SpeechRecognitionMode::kCaption:
      return "kCaption";
    default:
      return nullptr;
  }
}

std::string SpeechRecognitionModeToString(SpeechRecognitionMode value) {
  const char *str = SpeechRecognitionModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SpeechRecognitionMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SpeechRecognitionMode value) {
  return os << SpeechRecognitionModeToString(value);
}

NOINLINE static const char* RecognizerClientTypeToStringHelper(RecognizerClientType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RecognizerClientType::kUnknown:
      return "kUnknown";
    case RecognizerClientType::kDictation:
      return "kDictation";
    case RecognizerClientType::kLiveCaption:
      return "kLiveCaption";
    case RecognizerClientType::kProjector:
      return "kProjector";
    case RecognizerClientType::kCastModerator:
      return "kCastModerator";
    case RecognizerClientType::kSchoolTools:
      return "kSchoolTools";
    default:
      return nullptr;
  }
}

std::string RecognizerClientTypeToString(RecognizerClientType value) {
  const char *str = RecognizerClientTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RecognizerClientType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RecognizerClientType value) {
  return os << RecognizerClientTypeToString(value);
}

namespace internal {


// static
bool HypothesisParts_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HypothesisParts_Data* object =
      static_cast<const HypothesisParts_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hypothesis_part_offset, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hypothesis_part_offset, validation_context))
    return false;

  return true;
}

HypothesisParts_Data::HypothesisParts_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaTimestampRange_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaTimestampRange_Data* object =
      static_cast<const MediaTimestampRange_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end, validation_context))
    return false;

  return true;
}

MediaTimestampRange_Data::MediaTimestampRange_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TimingInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 32 },
    { 11, 40 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TimingInformation_Data* object =
      static_cast<const TimingInformation_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_start_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->audio_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_end_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->audio_end_time, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& hypothesis_parts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hypothesis_parts, validation_context,
                                         &hypothesis_parts_validate_params)) {
    return false;
  }
  if (object->header_.version < 11)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& originating_media_timestamps_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->originating_media_timestamps, validation_context,
                                         &originating_media_timestamps_validate_params)) {
    return false;
  }

  return true;
}

TimingInformation_Data::TimingInformation_Data()
    : header_({sizeof(*this), 11}) {}


// static
bool SpeechRecognitionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionResult_Data* object =
      static_cast<const SpeechRecognitionResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transcription, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transcription_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->transcription, validation_context,
                                         &transcription_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->timing_information, validation_context))
    return false;

  return true;
}

SpeechRecognitionResult_Data::SpeechRecognitionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LanguageIdentificationEvent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 24 },
    { 1, 32 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LanguageIdentificationEvent_Data* object =
      static_cast<const LanguageIdentificationEvent_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::ConfidenceLevel_Data
        ::Validate(object->confidence_level, validation_context))
    return false;
  if (object->header_.version < 1)
    return true;


  if (!::media::mojom::internal::AsrSwitchResult_Data
        ::Validate(object->asr_switch_result_$value, validation_context))
    return false;

  return true;
}

LanguageIdentificationEvent_Data::LanguageIdentificationEvent_Data()
    : header_({sizeof(*this), 1}) {}


// static
bool SpeechRecognitionOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 24 },
    { 1, 32 },
    { 4, 32 },
    { 5, 40 },
    { 6, 48 },
    { 8, 56 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionOptions_Data* object =
      static_cast<const SpeechRecognitionOptions_Data*>(data);


  if (!::media::mojom::internal::SpeechRecognitionMode_Data
        ::Validate(object->recognition_mode, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }
  if (object->header_.version < 1)
    return true;


  if (!::media::mojom::internal::RecognizerClientType_Data
        ::Validate(object->recognizer_client_type, validation_context))
    return false;
  if (object->header_.version < 5)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& experiment_recognizer_routing_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->experiment_recognizer_routing_key, validation_context,
                                         &experiment_recognizer_routing_key_validate_params)) {
    return false;
  }
  if (object->header_.version < 8)
    return true;

  if (!mojo::internal::ValidateStruct(object->recognition_context, validation_context))
    return false;

  return true;
}

SpeechRecognitionOptions_Data::SpeechRecognitionOptions_Data()
    : header_({sizeof(*this), 8}) {}


// static
bool SpeechRecognitionContext_BindRecognizer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionContext_BindRecognizer_Params_Data* object =
      static_cast<const SpeechRecognitionContext_BindRecognizer_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

SpeechRecognitionContext_BindRecognizer_Params_Data::SpeechRecognitionContext_BindRecognizer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionContext_BindRecognizer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionContext_BindRecognizer_ResponseParams_Data* object =
      static_cast<const SpeechRecognitionContext_BindRecognizer_ResponseParams_Data*>(data);

  return true;
}

SpeechRecognitionContext_BindRecognizer_ResponseParams_Data::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionContext_BindWebSpeechRecognizer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionContext_BindWebSpeechRecognizer_Params_Data* object =
      static_cast<const SpeechRecognitionContext_BindWebSpeechRecognizer_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session_client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->audio_forwarder, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->audio_forwarder,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

SpeechRecognitionContext_BindWebSpeechRecognizer_Params_Data::SpeechRecognitionContext_BindWebSpeechRecognizer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 16 },
    { 10, 24 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data* object =
      static_cast<const SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;
  if (object->header_.version < 10)
    return true;

  if (!mojo::internal::ValidateStruct(object->media_start_pts, validation_context))
    return false;

  return true;
}

SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data()
    : header_({sizeof(*this), 10}) {}


// static
bool SpeechRecognitionRecognizer_MarkDone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionRecognizer_MarkDone_Params_Data* object =
      static_cast<const SpeechRecognitionRecognizer_MarkDone_Params_Data*>(data);

  return true;
}

SpeechRecognitionRecognizer_MarkDone_Params_Data::SpeechRecognitionRecognizer_MarkDone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data* object =
      static_cast<const SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data::SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params_Data* object =
      static_cast<const SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params_Data*>(data);

  return true;
}

SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params_Data::SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizer_UpdateRecognitionContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionRecognizer_UpdateRecognitionContext_Params_Data* object =
      static_cast<const SpeechRecognitionRecognizer_UpdateRecognitionContext_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recognition_context, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->recognition_context, validation_context))
    return false;

  return true;
}

SpeechRecognitionRecognizer_UpdateRecognitionContext_Params_Data::SpeechRecognitionRecognizer_UpdateRecognitionContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data* object =
      static_cast<const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data* object =
      static_cast<const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data*>(data);

  return true;
}

SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params_Data* object =
      static_cast<const SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params_Data*>(data);

  return true;
}

SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params_Data::SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data* object =
      static_cast<const SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data*>(data);

  return true;
}

SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data::SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data* object =
      static_cast<const SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data::SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data* object =
      static_cast<const SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data*>(data);

  return true;
}

SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data::SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data* object =
      static_cast<const SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data::SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params_Data* object =
      static_cast<const SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params_Data*>(data);

  return true;
}

SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params_Data::SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionSurface_Activate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionSurface_Activate_Params_Data* object =
      static_cast<const SpeechRecognitionSurface_Activate_Params_Data*>(data);

  return true;
}

SpeechRecognitionSurface_Activate_Params_Data::SpeechRecognitionSurface_Activate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionSurface_GetBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionSurface_GetBounds_Params_Data* object =
      static_cast<const SpeechRecognitionSurface_GetBounds_Params_Data*>(data);

  return true;
}

SpeechRecognitionSurface_GetBounds_Params_Data::SpeechRecognitionSurface_GetBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionSurface_GetBounds_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionSurface_GetBounds_ResponseParams_Data* object =
      static_cast<const SpeechRecognitionSurface_GetBounds_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

SpeechRecognitionSurface_GetBounds_ResponseParams_Data::SpeechRecognitionSurface_GetBounds_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionSurfaceClient_OnSessionEnded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionSurfaceClient_OnSessionEnded_Params_Data* object =
      static_cast<const SpeechRecognitionSurfaceClient_OnSessionEnded_Params_Data*>(data);

  return true;
}

SpeechRecognitionSurfaceClient_OnSessionEnded_Params_Data::SpeechRecognitionSurfaceClient_OnSessionEnded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params_Data* object =
      static_cast<const SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params_Data*>(data);

  return true;
}

SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params_Data::SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data* object =
      static_cast<const SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionClientBrowserInterface_REMOVED_1_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionClientBrowserInterface_REMOVED_1_Params_Data* object =
      static_cast<const SpeechRecognitionClientBrowserInterface_REMOVED_1_Params_Data*>(data);

  return true;
}

SpeechRecognitionClientBrowserInterface_REMOVED_1_Params_Data::SpeechRecognitionClientBrowserInterface_REMOVED_1_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::ConfidenceLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::ConfidenceLevel value) {
  return std::move(context).WriteString(::media::mojom::ConfidenceLevelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::AsrSwitchResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::AsrSwitchResult value) {
  return std::move(context).WriteString(::media::mojom::AsrSwitchResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::SpeechRecognitionMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::SpeechRecognitionMode value) {
  return std::move(context).WriteString(::media::mojom::SpeechRecognitionModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::RecognizerClientType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::RecognizerClientType value) {
  return std::move(context).WriteString(::media::mojom::RecognizerClientTypeToString(value));
}

} // namespace perfetto