// media/mojo/mojom/remoting.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_REMOTING_MOJOM_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_REMOTING_MOJOM_TEST_UTILS_H_

#include "media/mojo/mojom/remoting.mojom.h"


namespace media::mojom {


class  RemoterFactoryInterceptorForTesting : public RemoterFactory {
  virtual RemoterFactory* GetForwardingInterface() = 0;
  void Create(::mojo::PendingRemote<RemotingSource> source, ::mojo::PendingReceiver<Remoter> remoter) override;
};
class  RemoterFactoryAsyncWaiter {
 public:
  explicit RemoterFactoryAsyncWaiter(RemoterFactory* proxy);

  RemoterFactoryAsyncWaiter(const RemoterFactoryAsyncWaiter&) = delete;
  RemoterFactoryAsyncWaiter& operator=(const RemoterFactoryAsyncWaiter&) = delete;

  ~RemoterFactoryAsyncWaiter();

 private:
  RemoterFactory* const proxy_;
};


class  RemotingDataStreamSenderInterceptorForTesting : public RemotingDataStreamSender {
  virtual RemotingDataStreamSender* GetForwardingInterface() = 0;
  void SendFrame(::media::mojom::DecoderBufferPtr frame, SendFrameCallback callback) override;
  void CancelInFlightData() override;
};
class  RemotingDataStreamSenderAsyncWaiter {
 public:
  explicit RemotingDataStreamSenderAsyncWaiter(RemotingDataStreamSender* proxy);

  RemotingDataStreamSenderAsyncWaiter(const RemotingDataStreamSenderAsyncWaiter&) = delete;
  RemotingDataStreamSenderAsyncWaiter& operator=(const RemotingDataStreamSenderAsyncWaiter&) = delete;

  ~RemotingDataStreamSenderAsyncWaiter();
  void SendFrame(
      ::media::mojom::DecoderBufferPtr frame);
  

 private:
  RemotingDataStreamSender* const proxy_;
};


class  RemoterInterceptorForTesting : public Remoter {
  virtual Remoter* GetForwardingInterface() = 0;
  void Start() override;
  void StartWithPermissionAlreadyGranted() override;
  void StartDataStreams(::mojo::ScopedDataPipeConsumerHandle audio_pipe, ::mojo::ScopedDataPipeConsumerHandle video_pipe, ::mojo::PendingReceiver<RemotingDataStreamSender> audio_sender, ::mojo::PendingReceiver<RemotingDataStreamSender> video_sender) override;
  void Stop(::media::mojom::RemotingStopReason reason) override;
  void SendMessageToSink(const std::vector<uint8_t>& message) override;
  void EstimateTransmissionCapacity(EstimateTransmissionCapacityCallback callback) override;
};
class  RemoterAsyncWaiter {
 public:
  explicit RemoterAsyncWaiter(Remoter* proxy);

  RemoterAsyncWaiter(const RemoterAsyncWaiter&) = delete;
  RemoterAsyncWaiter& operator=(const RemoterAsyncWaiter&) = delete;

  ~RemoterAsyncWaiter();
  void EstimateTransmissionCapacity(
      double* out_rate);
  double EstimateTransmissionCapacity();

 private:
  Remoter* const proxy_;
};


class  RemotingSourceInterceptorForTesting : public RemotingSource {
  virtual RemotingSource* GetForwardingInterface() = 0;
  void OnSinkAvailable(::media::mojom::RemotingSinkMetadataPtr metadata) override;
  void OnSinkGone() override;
  void OnStarted() override;
  void OnStartFailed(::media::mojom::RemotingStartFailReason reason) override;
  void OnMessageFromSink(const std::vector<uint8_t>& message) override;
  void OnStopped(::media::mojom::RemotingStopReason reason) override;
};
class  RemotingSourceAsyncWaiter {
 public:
  explicit RemotingSourceAsyncWaiter(RemotingSource* proxy);

  RemotingSourceAsyncWaiter(const RemotingSourceAsyncWaiter&) = delete;
  RemotingSourceAsyncWaiter& operator=(const RemotingSourceAsyncWaiter&) = delete;

  ~RemotingSourceAsyncWaiter();

 private:
  RemotingSource* const proxy_;
};


class  RemoteeInterceptorForTesting : public Remotee {
  virtual Remotee* GetForwardingInterface() = 0;
  void OnRemotingSinkReady(::mojo::PendingRemote<RemotingSink> sink) override;
  void SendMessageToSource(const std::vector<uint8_t>& message) override;
  void StartDataStreams(::mojo::PendingRemote<RemotingDataStreamReceiver> audio_stream, ::mojo::PendingRemote<RemotingDataStreamReceiver> video_stream) override;
  void OnFlushUntil(uint32_t audio_frame_count, uint32_t video_frame_count) override;
  void OnVideoNaturalSizeChange(const ::gfx::Size& size) override;
};
class  RemoteeAsyncWaiter {
 public:
  explicit RemoteeAsyncWaiter(Remotee* proxy);

  RemoteeAsyncWaiter(const RemoteeAsyncWaiter&) = delete;
  RemoteeAsyncWaiter& operator=(const RemoteeAsyncWaiter&) = delete;

  ~RemoteeAsyncWaiter();

 private:
  Remotee* const proxy_;
};


class  RemotingSinkInterceptorForTesting : public RemotingSink {
  virtual RemotingSink* GetForwardingInterface() = 0;
  void OnMessageFromSource(const std::vector<uint8_t>& message) override;
};
class  RemotingSinkAsyncWaiter {
 public:
  explicit RemotingSinkAsyncWaiter(RemotingSink* proxy);

  RemotingSinkAsyncWaiter(const RemotingSinkAsyncWaiter&) = delete;
  RemotingSinkAsyncWaiter& operator=(const RemotingSinkAsyncWaiter&) = delete;

  ~RemotingSinkAsyncWaiter();

 private:
  RemotingSink* const proxy_;
};


class  RemotingDataStreamReceiverInterceptorForTesting : public RemotingDataStreamReceiver {
  virtual RemotingDataStreamReceiver* GetForwardingInterface() = 0;
  void InitializeDataPipe(::mojo::ScopedDataPipeConsumerHandle data_pipe) override;
  void ReceiveFrame(uint32_t frame_count, ::media::mojom::DecoderBufferPtr buffer) override;
  void FlushUntil(uint32_t frame_count) override;
};
class  RemotingDataStreamReceiverAsyncWaiter {
 public:
  explicit RemotingDataStreamReceiverAsyncWaiter(RemotingDataStreamReceiver* proxy);

  RemotingDataStreamReceiverAsyncWaiter(const RemotingDataStreamReceiverAsyncWaiter&) = delete;
  RemotingDataStreamReceiverAsyncWaiter& operator=(const RemotingDataStreamReceiverAsyncWaiter&) = delete;

  ~RemotingDataStreamReceiverAsyncWaiter();

 private:
  RemotingDataStreamReceiver* const proxy_;
};




}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_REMOTING_MOJOM_TEST_UTILS_H_