// media/mojo/mojom/playback_events_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/playback_events_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/playback_events_recorder.mojom-params-data.h"
#include "media/mojo/mojom/playback_events_recorder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/playback_events_recorder.mojom-import-headers.h"
#include "media/mojo/mojom/playback_events_recorder.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

PlaybackEventsRecorder::IPCStableHashFunction PlaybackEventsRecorder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PlaybackEventsRecorder>(message.name())) {
    case messages::PlaybackEventsRecorder::kOnPlaying: {
      return &PlaybackEventsRecorder::OnPlaying_Sym::IPCStableHash;
    }
    case messages::PlaybackEventsRecorder::kOnPaused: {
      return &PlaybackEventsRecorder::OnPaused_Sym::IPCStableHash;
    }
    case messages::PlaybackEventsRecorder::kOnSeeking: {
      return &PlaybackEventsRecorder::OnSeeking_Sym::IPCStableHash;
    }
    case messages::PlaybackEventsRecorder::kOnEnded: {
      return &PlaybackEventsRecorder::OnEnded_Sym::IPCStableHash;
    }
    case messages::PlaybackEventsRecorder::kOnError: {
      return &PlaybackEventsRecorder::OnError_Sym::IPCStableHash;
    }
    case messages::PlaybackEventsRecorder::kOnBuffering: {
      return &PlaybackEventsRecorder::OnBuffering_Sym::IPCStableHash;
    }
    case messages::PlaybackEventsRecorder::kOnBufferingComplete: {
      return &PlaybackEventsRecorder::OnBufferingComplete_Sym::IPCStableHash;
    }
    case messages::PlaybackEventsRecorder::kOnNaturalSizeChanged: {
      return &PlaybackEventsRecorder::OnNaturalSizeChanged_Sym::IPCStableHash;
    }
    case messages::PlaybackEventsRecorder::kOnPipelineStatistics: {
      return &PlaybackEventsRecorder::OnPipelineStatistics_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PlaybackEventsRecorder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PlaybackEventsRecorder>(message.name())) {
      case messages::PlaybackEventsRecorder::kOnPlaying:
            return "Receive media::mojom::PlaybackEventsRecorder::OnPlaying";
      case messages::PlaybackEventsRecorder::kOnPaused:
            return "Receive media::mojom::PlaybackEventsRecorder::OnPaused";
      case messages::PlaybackEventsRecorder::kOnSeeking:
            return "Receive media::mojom::PlaybackEventsRecorder::OnSeeking";
      case messages::PlaybackEventsRecorder::kOnEnded:
            return "Receive media::mojom::PlaybackEventsRecorder::OnEnded";
      case messages::PlaybackEventsRecorder::kOnError:
            return "Receive media::mojom::PlaybackEventsRecorder::OnError";
      case messages::PlaybackEventsRecorder::kOnBuffering:
            return "Receive media::mojom::PlaybackEventsRecorder::OnBuffering";
      case messages::PlaybackEventsRecorder::kOnBufferingComplete:
            return "Receive media::mojom::PlaybackEventsRecorder::OnBufferingComplete";
      case messages::PlaybackEventsRecorder::kOnNaturalSizeChanged:
            return "Receive media::mojom::PlaybackEventsRecorder::OnNaturalSizeChanged";
      case messages::PlaybackEventsRecorder::kOnPipelineStatistics:
            return "Receive media::mojom::PlaybackEventsRecorder::OnPipelineStatistics";
    }
  } else {
    switch (static_cast<messages::PlaybackEventsRecorder>(message.name())) {
      case messages::PlaybackEventsRecorder::kOnPlaying:
            return "Receive reply media::mojom::PlaybackEventsRecorder::OnPlaying";
      case messages::PlaybackEventsRecorder::kOnPaused:
            return "Receive reply media::mojom::PlaybackEventsRecorder::OnPaused";
      case messages::PlaybackEventsRecorder::kOnSeeking:
            return "Receive reply media::mojom::PlaybackEventsRecorder::OnSeeking";
      case messages::PlaybackEventsRecorder::kOnEnded:
            return "Receive reply media::mojom::PlaybackEventsRecorder::OnEnded";
      case messages::PlaybackEventsRecorder::kOnError:
            return "Receive reply media::mojom::PlaybackEventsRecorder::OnError";
      case messages::PlaybackEventsRecorder::kOnBuffering:
            return "Receive reply media::mojom::PlaybackEventsRecorder::OnBuffering";
      case messages::PlaybackEventsRecorder::kOnBufferingComplete:
            return "Receive reply media::mojom::PlaybackEventsRecorder::OnBufferingComplete";
      case messages::PlaybackEventsRecorder::kOnNaturalSizeChanged:
            return "Receive reply media::mojom::PlaybackEventsRecorder::OnNaturalSizeChanged";
      case messages::PlaybackEventsRecorder::kOnPipelineStatistics:
            return "Receive reply media::mojom::PlaybackEventsRecorder::OnPipelineStatistics";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PlaybackEventsRecorder::OnPlaying_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff647b76;  // IPCStableHash for media::mojom::PlaybackEventsRecorder::OnPlaying
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PlaybackEventsRecorder::OnPaused_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x86e2919a;  // IPCStableHash for media::mojom::PlaybackEventsRecorder::OnPaused
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PlaybackEventsRecorder::OnSeeking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc5f74d4b;  // IPCStableHash for media::mojom::PlaybackEventsRecorder::OnSeeking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PlaybackEventsRecorder::OnEnded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4122cbc;  // IPCStableHash for media::mojom::PlaybackEventsRecorder::OnEnded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PlaybackEventsRecorder::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x34066b53;  // IPCStableHash for media::mojom::PlaybackEventsRecorder::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PlaybackEventsRecorder::OnBuffering_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0167bf3f;  // IPCStableHash for media::mojom::PlaybackEventsRecorder::OnBuffering
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PlaybackEventsRecorder::OnBufferingComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaa60cb35;  // IPCStableHash for media::mojom::PlaybackEventsRecorder::OnBufferingComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PlaybackEventsRecorder::OnNaturalSizeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4cc2d5f;  // IPCStableHash for media::mojom::PlaybackEventsRecorder::OnNaturalSizeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PlaybackEventsRecorder::OnPipelineStatistics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7353dff;  // IPCStableHash for media::mojom::PlaybackEventsRecorder::OnPipelineStatistics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PlaybackEventsRecorderProxy::PlaybackEventsRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PlaybackEventsRecorderProxy::OnPlaying(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::PlaybackEventsRecorder::OnPlaying");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PlaybackEventsRecorder::kOnPlaying), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnPlaying_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnPlaying");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PlaybackEventsRecorderProxy::OnPaused(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::PlaybackEventsRecorder::OnPaused");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PlaybackEventsRecorder::kOnPaused), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnPaused_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnPaused");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PlaybackEventsRecorderProxy::OnSeeking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::PlaybackEventsRecorder::OnSeeking");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PlaybackEventsRecorder::kOnSeeking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnSeeking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnSeeking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PlaybackEventsRecorderProxy::OnEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::PlaybackEventsRecorder::OnEnded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PlaybackEventsRecorder::kOnEnded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PlaybackEventsRecorderProxy::OnError(
    const ::media::PipelineStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::PlaybackEventsRecorder::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::PipelineStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PlaybackEventsRecorder::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PipelineStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in PlaybackEventsRecorder.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PlaybackEventsRecorderProxy::OnBuffering(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::PlaybackEventsRecorder::OnBuffering");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PlaybackEventsRecorder::kOnBuffering), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnBuffering_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnBuffering");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PlaybackEventsRecorderProxy::OnBufferingComplete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::PlaybackEventsRecorder::OnBufferingComplete");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PlaybackEventsRecorder::kOnBufferingComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnBufferingComplete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnBufferingComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PlaybackEventsRecorderProxy::OnNaturalSizeChanged(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::PlaybackEventsRecorder::OnNaturalSizeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PlaybackEventsRecorder::kOnNaturalSizeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnNaturalSizeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in PlaybackEventsRecorder.OnNaturalSizeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnNaturalSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PlaybackEventsRecorderProxy::OnPipelineStatistics(
    const ::media::PipelineStatistics& in_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::PlaybackEventsRecorder::OnPipelineStatistics", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stats"), in_stats,
                        "<value of type const ::media::PipelineStatistics&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PlaybackEventsRecorder::kOnPipelineStatistics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnPipelineStatistics_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->stats)::BaseType> stats_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PipelineStatisticsDataView>(
    in_stats,
    stats_fragment);

  params->stats.Set(
      stats_fragment.is_null() ? nullptr : stats_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->stats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null stats in PlaybackEventsRecorder.OnPipelineStatistics request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnPipelineStatistics");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PlaybackEventsRecorderStubDispatch::Accept(
    PlaybackEventsRecorder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PlaybackEventsRecorder>(message->header()->name)) {
    case messages::PlaybackEventsRecorder::kOnPlaying: {
      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnPlaying_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnPlaying_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PlaybackEventsRecorder.0
      bool success = true;
      PlaybackEventsRecorder_OnPlaying_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPlaying(        );
      return true;
    }
    case messages::PlaybackEventsRecorder::kOnPaused: {
      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnPaused_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnPaused_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PlaybackEventsRecorder.1
      bool success = true;
      PlaybackEventsRecorder_OnPaused_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaused(        );
      return true;
    }
    case messages::PlaybackEventsRecorder::kOnSeeking: {
      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnSeeking_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnSeeking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PlaybackEventsRecorder.2
      bool success = true;
      PlaybackEventsRecorder_OnSeeking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSeeking(        );
      return true;
    }
    case messages::PlaybackEventsRecorder::kOnEnded: {
      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnEnded_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnEnded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PlaybackEventsRecorder.3
      bool success = true;
      PlaybackEventsRecorder_OnEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEnded(        );
      return true;
    }
    case messages::PlaybackEventsRecorder::kOnError: {
      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnError_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PlaybackEventsRecorder.4
      bool success = true;
      ::media::PipelineStatus p_status{};
      PlaybackEventsRecorder_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_status));
      return true;
    }
    case messages::PlaybackEventsRecorder::kOnBuffering: {
      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnBuffering_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnBuffering_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PlaybackEventsRecorder.5
      bool success = true;
      PlaybackEventsRecorder_OnBuffering_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBuffering(        );
      return true;
    }
    case messages::PlaybackEventsRecorder::kOnBufferingComplete: {
      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnBufferingComplete_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnBufferingComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PlaybackEventsRecorder.6
      bool success = true;
      PlaybackEventsRecorder_OnBufferingComplete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferingComplete(        );
      return true;
    }
    case messages::PlaybackEventsRecorder::kOnNaturalSizeChanged: {
      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnNaturalSizeChanged_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnNaturalSizeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PlaybackEventsRecorder.7
      bool success = true;
      ::gfx::Size p_size{};
      PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNaturalSizeChanged(        
        std::move(p_size));
      return true;
    }
    case messages::PlaybackEventsRecorder::kOnPipelineStatistics: {
      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnPipelineStatistics_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnPipelineStatistics_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PlaybackEventsRecorder.8
      bool success = true;
      ::media::PipelineStatistics p_stats{};
      PlaybackEventsRecorder_OnPipelineStatistics_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStats(&p_stats))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPipelineStatistics(        
        std::move(p_stats));
      return true;
    }
  }
  return false;
}

// static
bool PlaybackEventsRecorderStubDispatch::AcceptWithResponder(
    PlaybackEventsRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PlaybackEventsRecorder>(message->header()->name)) {
    case messages::PlaybackEventsRecorder::kOnPlaying: {
      break;
    }
    case messages::PlaybackEventsRecorder::kOnPaused: {
      break;
    }
    case messages::PlaybackEventsRecorder::kOnSeeking: {
      break;
    }
    case messages::PlaybackEventsRecorder::kOnEnded: {
      break;
    }
    case messages::PlaybackEventsRecorder::kOnError: {
      break;
    }
    case messages::PlaybackEventsRecorder::kOnBuffering: {
      break;
    }
    case messages::PlaybackEventsRecorder::kOnBufferingComplete: {
      break;
    }
    case messages::PlaybackEventsRecorder::kOnNaturalSizeChanged: {
      break;
    }
    case messages::PlaybackEventsRecorder::kOnPipelineStatistics: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPlaybackEventsRecorderValidationInfo[] = {
    { &internal::PlaybackEventsRecorder_OnPlaying_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PlaybackEventsRecorder_OnPaused_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PlaybackEventsRecorder_OnSeeking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PlaybackEventsRecorder_OnEnded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PlaybackEventsRecorder_OnError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PlaybackEventsRecorder_OnBuffering_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PlaybackEventsRecorder_OnBufferingComplete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PlaybackEventsRecorder_OnNaturalSizeChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PlaybackEventsRecorder_OnPipelineStatistics_Params_Data::Validate,
     nullptr /* no response */},
};

bool PlaybackEventsRecorderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::PlaybackEventsRecorder::Name_,
    kPlaybackEventsRecorderValidationInfo);
}



}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void PlaybackEventsRecorderInterceptorForTesting::OnPlaying() {
  GetForwardingInterface()->OnPlaying();
}
void PlaybackEventsRecorderInterceptorForTesting::OnPaused() {
  GetForwardingInterface()->OnPaused();
}
void PlaybackEventsRecorderInterceptorForTesting::OnSeeking() {
  GetForwardingInterface()->OnSeeking();
}
void PlaybackEventsRecorderInterceptorForTesting::OnEnded() {
  GetForwardingInterface()->OnEnded();
}
void PlaybackEventsRecorderInterceptorForTesting::OnError(const ::media::PipelineStatus& status) {
  GetForwardingInterface()->OnError(
    std::move(status)
    );
}
void PlaybackEventsRecorderInterceptorForTesting::OnBuffering() {
  GetForwardingInterface()->OnBuffering();
}
void PlaybackEventsRecorderInterceptorForTesting::OnBufferingComplete() {
  GetForwardingInterface()->OnBufferingComplete();
}
void PlaybackEventsRecorderInterceptorForTesting::OnNaturalSizeChanged(const ::gfx::Size& size) {
  GetForwardingInterface()->OnNaturalSizeChanged(
    std::move(size)
    );
}
void PlaybackEventsRecorderInterceptorForTesting::OnPipelineStatistics(const ::media::PipelineStatistics& stats) {
  GetForwardingInterface()->OnPipelineStatistics(
    std::move(stats)
    );
}
PlaybackEventsRecorderAsyncWaiter::PlaybackEventsRecorderAsyncWaiter(
    PlaybackEventsRecorder* proxy) : proxy_(proxy) {}

PlaybackEventsRecorderAsyncWaiter::~PlaybackEventsRecorderAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif