// media/mojo/mojom/playback_events_recorder.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('media.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.PlaybackEventsRecorderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.PlaybackEventsRecorder.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.PlaybackEventsRecorderInterface }
 */
media.mojom.PlaybackEventsRecorderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.PlaybackEventsRecorderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.PlaybackEventsRecorderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.PlaybackEventsRecorderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onPlaying() {
    this.proxy.sendMessage(
        0,
        media.mojom.PlaybackEventsRecorder_OnPlaying_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onPaused() {
    this.proxy.sendMessage(
        1,
        media.mojom.PlaybackEventsRecorder_OnPaused_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onSeeking() {
    this.proxy.sendMessage(
        2,
        media.mojom.PlaybackEventsRecorder_OnSeeking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onEnded() {
    this.proxy.sendMessage(
        3,
        media.mojom.PlaybackEventsRecorder_OnEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PipelineStatus } status
   */

  onError(
      status) {
    this.proxy.sendMessage(
        4,
        media.mojom.PlaybackEventsRecorder_OnError_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   */

  onBuffering() {
    this.proxy.sendMessage(
        5,
        media.mojom.PlaybackEventsRecorder_OnBuffering_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onBufferingComplete() {
    this.proxy.sendMessage(
        6,
        media.mojom.PlaybackEventsRecorder_OnBufferingComplete_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Size } size
   */

  onNaturalSizeChanged(
      size) {
    this.proxy.sendMessage(
        7,
        media.mojom.PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsSpec.$,
        null,
        [
          size
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PipelineStatistics } stats
   */

  onPipelineStatistics(
      stats) {
    this.proxy.sendMessage(
        8,
        media.mojom.PlaybackEventsRecorder_OnPipelineStatistics_ParamsSpec.$,
        null,
        [
          stats
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PlaybackEventsRecorder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.PlaybackEventsRecorderReceiver = class {
  /**
   * @param {!media.mojom.PlaybackEventsRecorderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.PlaybackEventsRecorderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.PlaybackEventsRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.PlaybackEventsRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.PlaybackEventsRecorder_OnPlaying_ParamsSpec.$,
        null,
        impl.onPlaying.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.PlaybackEventsRecorder_OnPaused_ParamsSpec.$,
        null,
        impl.onPaused.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.PlaybackEventsRecorder_OnSeeking_ParamsSpec.$,
        null,
        impl.onSeeking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.PlaybackEventsRecorder_OnEnded_ParamsSpec.$,
        null,
        impl.onEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.PlaybackEventsRecorder_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.PlaybackEventsRecorder_OnBuffering_ParamsSpec.$,
        null,
        impl.onBuffering.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.PlaybackEventsRecorder_OnBufferingComplete_ParamsSpec.$,
        null,
        impl.onBufferingComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        media.mojom.PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsSpec.$,
        null,
        impl.onNaturalSizeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        media.mojom.PlaybackEventsRecorder_OnPipelineStatistics_ParamsSpec.$,
        null,
        impl.onPipelineStatistics.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.PlaybackEventsRecorder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.PlaybackEventsRecorder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.PlaybackEventsRecorderRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.PlaybackEventsRecorderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PlaybackEventsRecorder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.PlaybackEventsRecorderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.PlaybackEventsRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.PlaybackEventsRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPlaying =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.PlaybackEventsRecorder_OnPlaying_ParamsSpec.$,
        null,
        this.onPlaying.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPaused =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.PlaybackEventsRecorder_OnPaused_ParamsSpec.$,
        null,
        this.onPaused.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSeeking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.PlaybackEventsRecorder_OnSeeking_ParamsSpec.$,
        null,
        this.onSeeking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.PlaybackEventsRecorder_OnEnded_ParamsSpec.$,
        null,
        this.onEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.PlaybackEventsRecorder_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBuffering =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.PlaybackEventsRecorder_OnBuffering_ParamsSpec.$,
        null,
        this.onBuffering.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBufferingComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.PlaybackEventsRecorder_OnBufferingComplete_ParamsSpec.$,
        null,
        this.onBufferingComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNaturalSizeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        media.mojom.PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsSpec.$,
        null,
        this.onNaturalSizeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPipelineStatistics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        media.mojom.PlaybackEventsRecorder_OnPipelineStatistics_ParamsSpec.$,
        null,
        this.onPipelineStatistics.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaybackEventsRecorder_OnPlaying_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaybackEventsRecorder_OnPaused_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaybackEventsRecorder_OnSeeking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaybackEventsRecorder_OnEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaybackEventsRecorder_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaybackEventsRecorder_OnBuffering_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaybackEventsRecorder_OnBufferingComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaybackEventsRecorder_OnPipelineStatistics_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.PlaybackEventsRecorder_OnPlaying_ParamsSpec.$,
    'PlaybackEventsRecorder_OnPlaying_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.PlaybackEventsRecorder_OnPlaying_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.PlaybackEventsRecorder_OnPaused_ParamsSpec.$,
    'PlaybackEventsRecorder_OnPaused_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.PlaybackEventsRecorder_OnPaused_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.PlaybackEventsRecorder_OnSeeking_ParamsSpec.$,
    'PlaybackEventsRecorder_OnSeeking_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.PlaybackEventsRecorder_OnSeeking_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.PlaybackEventsRecorder_OnEnded_ParamsSpec.$,
    'PlaybackEventsRecorder_OnEnded_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.PlaybackEventsRecorder_OnEnded_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.PlaybackEventsRecorder_OnError_ParamsSpec.$,
    'PlaybackEventsRecorder_OnError_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.PipelineStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.PlaybackEventsRecorder_OnError_Params = class {
  constructor() {
    /** @export { !media.mojom.PipelineStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.PlaybackEventsRecorder_OnBuffering_ParamsSpec.$,
    'PlaybackEventsRecorder_OnBuffering_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.PlaybackEventsRecorder_OnBuffering_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.PlaybackEventsRecorder_OnBufferingComplete_ParamsSpec.$,
    'PlaybackEventsRecorder_OnBufferingComplete_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.PlaybackEventsRecorder_OnBufferingComplete_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsSpec.$,
    'PlaybackEventsRecorder_OnNaturalSizeChanged_Params',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.PlaybackEventsRecorder_OnNaturalSizeChanged_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.size;
  }
};



mojo.internal.Struct(
    media.mojom.PlaybackEventsRecorder_OnPipelineStatistics_ParamsSpec.$,
    'PlaybackEventsRecorder_OnPipelineStatistics_Params',
    [
      mojo.internal.StructField(
        'stats', 0,
        0,
        media.mojom.PipelineStatisticsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.PlaybackEventsRecorder_OnPipelineStatistics_Params = class {
  constructor() {
    /** @export { !media.mojom.PipelineStatistics } */
    this.stats;
  }
};

