// media/mojo/mojom/media_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Sandbox as sandbox_mojom_Sandbox,
  SandboxSpec as sandbox_mojom_SandboxSpec
} from '../../../sandbox/policy/mojom/sandbox.mojom.m.js';

import {
  FrameInterfaceFactoryRemote as media_mojom_FrameInterfaceFactoryRemote,
  FrameInterfaceFactoryPendingReceiver as media_mojom_FrameInterfaceFactoryPendingReceiver
} from './frame_interface_factory.mojom.m.js';

import {
  InterfaceFactoryRemote as media_mojom_InterfaceFactoryRemote,
  InterfaceFactoryPendingReceiver as media_mojom_InterfaceFactoryPendingReceiver
} from './interface_factory.mojom.m.js';


/**
 * @const { !sandbox_mojom_Sandbox }
 */
export const MEDIA_SANDBOX = sandbox_mojom_Sandbox.kGpu;




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.MediaService', scope);
  }
}

/** @interface */
export class MediaServiceInterface {
  
  /**
   * @param { !media_mojom_InterfaceFactoryPendingReceiver } factory
   * @param { !media_mojom_FrameInterfaceFactoryRemote } frameInterfaces
   */

  createInterfaceFactory(factory, frameInterfaces) {}
}

/**
 * @implements { MediaServiceInterface }
 */
export class MediaServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_InterfaceFactoryPendingReceiver } factory
   * @param { !media_mojom_FrameInterfaceFactoryRemote } frameInterfaces
   */

  createInterfaceFactory(
      factory,
      frameInterfaces) {
    this.proxy.sendMessage(
        0,
        MediaService_CreateInterfaceFactory_ParamsSpec.$,
        null,
        [
          factory,
          frameInterfaces
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaServiceReceiver {
  /**
   * @param {!MediaServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaService_CreateInterfaceFactory_ParamsSpec.$,
        null,
        impl.createInterfaceFactory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaServiceRemote}
   */
  static getRemote() {
    let remote = new MediaServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createInterfaceFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaService_CreateInterfaceFactory_ParamsSpec.$,
        null,
        this.createInterfaceFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaService_CreateInterfaceFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MediaService_CreateInterfaceFactory_ParamsSpec.$,
    'MediaService_CreateInterfaceFactory_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_InterfaceFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameInterfaces', 4,
        0,
        mojo.internal.InterfaceProxy(media_mojom_FrameInterfaceFactoryRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaService_CreateInterfaceFactory_Params {
  constructor() {
    /** @type { !media_mojom_InterfaceFactoryPendingReceiver } */
    this.factory;
    /** @type { !media_mojom_FrameInterfaceFactoryRemote } */
    this.frameInterfaces;
  }
}

