// media/mojo/mojom/media_player.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_PLAYER_MOJOM_BLINK_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_MEDIA_PLAYER_MOJOM_BLINK_TEST_UTILS_H_

#include "media/mojo/mojom/media_player.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace media::mojom::blink {


class BLINK_PLATFORM_EXPORT MediaPlayerInterceptorForTesting : public MediaPlayer {
  virtual MediaPlayer* GetForwardingInterface() = 0;
  void RequestPlay() override;
  void RequestPause(bool triggered_by_user) override;
  void RequestSeekForward(::base::TimeDelta seek_time) override;
  void RequestSeekBackward(::base::TimeDelta seek_time) override;
  void RequestSeekTo(::base::TimeDelta seek_time) override;
  void RequestEnterPictureInPicture() override;
  void RequestMute(bool mute) override;
  void SetVolumeMultiplier(double multiplier) override;
  void SetPersistentState(bool persistent) override;
  void SetPowerExperimentState(bool enabled) override;
  void SetAudioSinkId(const ::blink::String& sink_id) override;
  void SuspendForFrameClosed() override;
  void RequestMediaRemoting() override;
  void RequestVisibility(RequestVisibilityCallback callback) override;
  void RecordAutoPictureInPictureInfo(const ::media::PictureInPictureEventsInfo::AutoPipInfo& auto_picture_in_picture_info) override;
};
class BLINK_PLATFORM_EXPORT MediaPlayerAsyncWaiter {
 public:
  explicit MediaPlayerAsyncWaiter(MediaPlayer* proxy);

  MediaPlayerAsyncWaiter(const MediaPlayerAsyncWaiter&) = delete;
  MediaPlayerAsyncWaiter& operator=(const MediaPlayerAsyncWaiter&) = delete;

  ~MediaPlayerAsyncWaiter();
  void RequestVisibility(
      bool* out_has_sufficiently_visible_video);
  bool RequestVisibility();

 private:
  MediaPlayer* const proxy_;
};


class BLINK_PLATFORM_EXPORT MediaPlayerObserverClientInterceptorForTesting : public MediaPlayerObserverClient {
  virtual MediaPlayerObserverClient* GetForwardingInterface() = 0;
  void GetHasPlayedBefore(GetHasPlayedBeforeCallback callback) override;
};
class BLINK_PLATFORM_EXPORT MediaPlayerObserverClientAsyncWaiter {
 public:
  explicit MediaPlayerObserverClientAsyncWaiter(MediaPlayerObserverClient* proxy);

  MediaPlayerObserverClientAsyncWaiter(const MediaPlayerObserverClientAsyncWaiter&) = delete;
  MediaPlayerObserverClientAsyncWaiter& operator=(const MediaPlayerObserverClientAsyncWaiter&) = delete;

  ~MediaPlayerObserverClientAsyncWaiter();
  void GetHasPlayedBefore(
      bool* out_has_played_before);
  bool GetHasPlayedBefore();

 private:
  MediaPlayerObserverClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT MediaPlayerObserverInterceptorForTesting : public MediaPlayerObserver {
  virtual MediaPlayerObserver* GetForwardingInterface() = 0;
  void OnMediaPlaying() override;
  void OnMediaPaused(bool stream_ended) override;
  void OnMutedStatusChanged(bool muted) override;
  void OnMediaMetadataChanged(bool has_audio, bool has_video, ::media::MediaContentType content_type) override;
  void OnMediaPositionStateChanged(::media_session::mojom::blink::MediaPositionPtr media_position) override;
  void OnMediaEffectivelyFullscreenChanged(::blink::WebFullscreenVideoStatus status) override;
  void OnMediaSizeChanged(const ::gfx::Size& size) override;
  void OnPictureInPictureAvailabilityChanged(bool available) override;
  void OnAudioOutputSinkChanged(const ::blink::String& hashed_device_id) override;
  void OnUseAudioServiceChanged(bool uses_audio_service) override;
  void OnAudioOutputSinkChangingDisabled() override;
  void OnRemotePlaybackMetadataChange(::media_session::mojom::blink::RemotePlaybackMetadataPtr remote_playback_metadata) override;
  void OnVideoVisibilityChanged(bool meets_visibility_threshold) override;
};
class BLINK_PLATFORM_EXPORT MediaPlayerObserverAsyncWaiter {
 public:
  explicit MediaPlayerObserverAsyncWaiter(MediaPlayerObserver* proxy);

  MediaPlayerObserverAsyncWaiter(const MediaPlayerObserverAsyncWaiter&) = delete;
  MediaPlayerObserverAsyncWaiter& operator=(const MediaPlayerObserverAsyncWaiter&) = delete;

  ~MediaPlayerObserverAsyncWaiter();

 private:
  MediaPlayerObserver* const proxy_;
};


class BLINK_PLATFORM_EXPORT MediaPlayerHostInterceptorForTesting : public MediaPlayerHost {
  virtual MediaPlayerHost* GetForwardingInterface() = 0;
  void OnMediaPlayerAdded(::mojo::PendingAssociatedRemote<MediaPlayer> player_remote, ::mojo::PendingAssociatedReceiver<MediaPlayerObserver> observer, int32_t player_id) override;
};
class BLINK_PLATFORM_EXPORT MediaPlayerHostAsyncWaiter {
 public:
  explicit MediaPlayerHostAsyncWaiter(MediaPlayerHost* proxy);

  MediaPlayerHostAsyncWaiter(const MediaPlayerHostAsyncWaiter&) = delete;
  MediaPlayerHostAsyncWaiter& operator=(const MediaPlayerHostAsyncWaiter&) = delete;

  ~MediaPlayerHostAsyncWaiter();

 private:
  MediaPlayerHost* const proxy_;
};




}  // media::mojom::blink

#endif  // MEDIA_MOJO_MOJOM_MEDIA_PLAYER_MOJOM_BLINK_TEST_UTILS_H_