// media/mojo/mojom/demuxer_stream.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  AudioDecoderConfig as media_mojom_AudioDecoderConfig,
  AudioDecoderConfigSpec as media_mojom_AudioDecoderConfigSpec,
  VideoDecoderConfig as media_mojom_VideoDecoderConfig,
  VideoDecoderConfigSpec as media_mojom_VideoDecoderConfigSpec,
  DecoderBuffer as media_mojom_DecoderBuffer,
  DecoderBufferSpec as media_mojom_DecoderBufferSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DemuxerStreamPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.DemuxerStream', scope);
  }
}

/** @interface */
export class DemuxerStreamInterface {
  
  /**
   * @return {!Promise<{
        type: !DemuxerStream_Type,
        pipe: !MojoHandle,
        audioConfig: ?media_mojom_AudioDecoderConfig,
        videoConfig: ?media_mojom_VideoDecoderConfig,
   *  }>}
   */

  initialize() {}
  
  /**
   * @param { !number } count
   * @return {!Promise<{
        status: !DemuxerStream_Status,
        batchBuffers: !Array<!media_mojom_DecoderBuffer>,
        audioConfig: ?media_mojom_AudioDecoderConfig,
        videoConfig: ?media_mojom_VideoDecoderConfig,
   *  }>}
   */

  read(count) {}
  
  /**
   */

  enableBitstreamConverter() {}
}

/**
 * @implements { DemuxerStreamInterface }
 */
export class DemuxerStreamRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DemuxerStreamPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DemuxerStreamPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DemuxerStreamPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        type: !DemuxerStream_Type,
        pipe: !MojoHandle,
        audioConfig: ?media_mojom_AudioDecoderConfig,
        videoConfig: ?media_mojom_VideoDecoderConfig,
   *  }>}
   */

  initialize() {
    return this.proxy.sendMessage(
        0,
        DemuxerStream_Initialize_ParamsSpec.$,
        DemuxerStream_Initialize_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } count
   * @return {!Promise<{
        status: !DemuxerStream_Status,
        batchBuffers: !Array<!media_mojom_DecoderBuffer>,
        audioConfig: ?media_mojom_AudioDecoderConfig,
        videoConfig: ?media_mojom_VideoDecoderConfig,
   *  }>}
   */

  read(
      count) {
    return this.proxy.sendMessage(
        1,
        DemuxerStream_Read_ParamsSpec.$,
        DemuxerStream_Read_ResponseParamsSpec.$,
        [
          count
        ],
        false);
  }

  
  /**
   */

  enableBitstreamConverter() {
    this.proxy.sendMessage(
        2,
        DemuxerStream_EnableBitstreamConverter_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DemuxerStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DemuxerStreamReceiver {
  /**
   * @param {!DemuxerStreamInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DemuxerStreamRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DemuxerStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DemuxerStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DemuxerStream_Initialize_ParamsSpec.$,
        DemuxerStream_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DemuxerStream_Read_ParamsSpec.$,
        DemuxerStream_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DemuxerStream_EnableBitstreamConverter_ParamsSpec.$,
        null,
        impl.enableBitstreamConverter.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DemuxerStream {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.DemuxerStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DemuxerStreamRemote}
   */
  static getRemote() {
    let remote = new DemuxerStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DemuxerStream_TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DemuxerStream_Type = {
  
};
/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DemuxerStream_StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DemuxerStream_Status = {
  
};

/**
 * An object which receives request messages for the DemuxerStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DemuxerStreamCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DemuxerStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DemuxerStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DemuxerStream_Initialize_ParamsSpec.$,
        DemuxerStream_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DemuxerStream_Read_ParamsSpec.$,
        DemuxerStream_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableBitstreamConverter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DemuxerStream_EnableBitstreamConverter_ParamsSpec.$,
        null,
        this.enableBitstreamConverter.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DemuxerStream_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DemuxerStream_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DemuxerStream_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DemuxerStream_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DemuxerStream_EnableBitstreamConverter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DemuxerStream_Initialize_ParamsSpec.$,
    'DemuxerStream_Initialize_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DemuxerStream_Initialize_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DemuxerStream_Initialize_ResponseParamsSpec.$,
    'DemuxerStream_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        DemuxerStream_TypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pipe', 4,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioConfig', 8,
        0,
        media_mojom_AudioDecoderConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoConfig', 16,
        0,
        media_mojom_VideoDecoderConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DemuxerStream_Initialize_ResponseParams {
  constructor() {
    /** @type { !DemuxerStream_Type } */
    this.type;
    /** @type { !MojoHandle } */
    this.pipe;
    /** @type { (media_mojom_AudioDecoderConfig|undefined) } */
    this.audioConfig;
    /** @type { (media_mojom_VideoDecoderConfig|undefined) } */
    this.videoConfig;
  }
}



mojo.internal.Struct(
    DemuxerStream_Read_ParamsSpec.$,
    'DemuxerStream_Read_Params',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DemuxerStream_Read_Params {
  constructor() {
    /** @type { !number } */
    this.count;
  }
}



mojo.internal.Struct(
    DemuxerStream_Read_ResponseParamsSpec.$,
    'DemuxerStream_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        DemuxerStream_StatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'batchBuffers', 8,
        0,
        mojo.internal.Array(media_mojom_DecoderBufferSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioConfig', 16,
        0,
        media_mojom_AudioDecoderConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoConfig', 24,
        0,
        media_mojom_VideoDecoderConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DemuxerStream_Read_ResponseParams {
  constructor() {
    /** @type { !DemuxerStream_Status } */
    this.status;
    /** @type { !Array<!media_mojom_DecoderBuffer> } */
    this.batchBuffers;
    /** @type { (media_mojom_AudioDecoderConfig|undefined) } */
    this.audioConfig;
    /** @type { (media_mojom_VideoDecoderConfig|undefined) } */
    this.videoConfig;
  }
}



mojo.internal.Struct(
    DemuxerStream_EnableBitstreamConverter_ParamsSpec.$,
    'DemuxerStream_EnableBitstreamConverter_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DemuxerStream_EnableBitstreamConverter_Params {
  constructor() {
  }
}

