// media/mojo/mojom/audio_output_stream.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  ReadWriteAudioDataPipe as media_mojom_ReadWriteAudioDataPipe,
  ReadWriteAudioDataPipeSpec as media_mojom_ReadWriteAudioDataPipeSpec
} from './audio_data_pipe.mojom.m.js';

import {
  AudioParameters as media_mojom_AudioParameters,
  AudioParametersSpec as media_mojom_AudioParametersSpec
} from './audio_parameters.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioOutputStreamPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioOutputStream', scope);
  }
}

/** @interface */
export class AudioOutputStreamInterface {
  
  /**
   */

  play() {}
  
  /**
   */

  pause() {}
  
  /**
   */

  flush() {}
  
  /**
   * @param { !number } volume
   */

  setVolume(volume) {}
}

/**
 * @implements { AudioOutputStreamInterface }
 */
export class AudioOutputStreamRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioOutputStreamPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioOutputStreamPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioOutputStreamPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  play() {
    this.proxy.sendMessage(
        0,
        AudioOutputStream_Play_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  pause() {
    this.proxy.sendMessage(
        1,
        AudioOutputStream_Pause_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  flush() {
    this.proxy.sendMessage(
        2,
        AudioOutputStream_Flush_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  setVolume(
      volume) {
    this.proxy.sendMessage(
        3,
        AudioOutputStream_SetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioOutputStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioOutputStreamReceiver {
  /**
   * @param {!AudioOutputStreamInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioOutputStreamRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioOutputStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioOutputStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioOutputStream_Play_ParamsSpec.$,
        null,
        impl.play.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioOutputStream_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioOutputStream_Flush_ParamsSpec.$,
        null,
        impl.flush.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AudioOutputStream_SetVolume_ParamsSpec.$,
        null,
        impl.setVolume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioOutputStream {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioOutputStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioOutputStreamRemote}
   */
  static getRemote() {
    let remote = new AudioOutputStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioOutputStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioOutputStreamCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioOutputStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioOutputStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.play =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioOutputStream_Play_ParamsSpec.$,
        null,
        this.play.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioOutputStream_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioOutputStream_Flush_ParamsSpec.$,
        null,
        this.flush.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AudioOutputStream_SetVolume_ParamsSpec.$,
        null,
        this.setVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioOutputStreamObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioOutputStreamObserver', scope);
  }
}

/** @interface */
export class AudioOutputStreamObserverInterface {
  
  /**
   */

  didStartPlaying() {}
  
  /**
   */

  didStopPlaying() {}
  
  /**
   * @param { !boolean } isAudible
   */

  didChangeAudibleState(isAudible) {}
}

/**
 * @implements { AudioOutputStreamObserverInterface }
 */
export class AudioOutputStreamObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioOutputStreamObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioOutputStreamObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioOutputStreamObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  didStartPlaying() {
    this.proxy.sendMessage(
        0,
        AudioOutputStreamObserver_DidStartPlaying_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  didStopPlaying() {
    this.proxy.sendMessage(
        1,
        AudioOutputStreamObserver_DidStopPlaying_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } isAudible
   */

  didChangeAudibleState(
      isAudible) {
    this.proxy.sendMessage(
        2,
        AudioOutputStreamObserver_DidChangeAudibleState_ParamsSpec.$,
        null,
        [
          isAudible
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioOutputStreamObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioOutputStreamObserverReceiver {
  /**
   * @param {!AudioOutputStreamObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioOutputStreamObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioOutputStreamObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioOutputStreamObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioOutputStreamObserver_DidStartPlaying_ParamsSpec.$,
        null,
        impl.didStartPlaying.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioOutputStreamObserver_DidStopPlaying_ParamsSpec.$,
        null,
        impl.didStopPlaying.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioOutputStreamObserver_DidChangeAudibleState_ParamsSpec.$,
        null,
        impl.didChangeAudibleState.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioOutputStreamObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioOutputStreamObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioOutputStreamObserverRemote}
   */
  static getRemote() {
    let remote = new AudioOutputStreamObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AudioOutputStreamObserver_DisconnectReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AudioOutputStreamObserver_DisconnectReason = {
  
  kDefault: 0,
  kPlatformError: 1,
  kTerminatedByClient: 2,
  kStreamCreationFailed: 3,
  kDocumentDestroyed: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * An object which receives request messages for the AudioOutputStreamObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioOutputStreamObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioOutputStreamObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioOutputStreamObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStartPlaying =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioOutputStreamObserver_DidStartPlaying_ParamsSpec.$,
        null,
        this.didStartPlaying.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStopPlaying =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioOutputStreamObserver_DidStopPlaying_ParamsSpec.$,
        null,
        this.didStopPlaying.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeAudibleState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioOutputStreamObserver_DidChangeAudibleState_ParamsSpec.$,
        null,
        this.didChangeAudibleState.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioOutputStreamProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioOutputStreamProvider', scope);
  }
}

/** @interface */
export class AudioOutputStreamProviderInterface {
  
  /**
   * @param { !media_mojom_AudioParameters } params
   * @param { !AudioOutputStreamProviderClientRemote } client
   */

  acquire(params, client) {}
}

/**
 * @implements { AudioOutputStreamProviderInterface }
 */
export class AudioOutputStreamProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioOutputStreamProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioOutputStreamProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioOutputStreamProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_AudioParameters } params
   * @param { !AudioOutputStreamProviderClientRemote } client
   */

  acquire(
      params,
      client) {
    this.proxy.sendMessage(
        0,
        AudioOutputStreamProvider_Acquire_ParamsSpec.$,
        null,
        [
          params,
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioOutputStreamProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioOutputStreamProviderReceiver {
  /**
   * @param {!AudioOutputStreamProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioOutputStreamProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioOutputStreamProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioOutputStreamProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioOutputStreamProvider_Acquire_ParamsSpec.$,
        null,
        impl.acquire.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioOutputStreamProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioOutputStreamProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioOutputStreamProviderRemote}
   */
  static getRemote() {
    let remote = new AudioOutputStreamProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioOutputStreamProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioOutputStreamProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioOutputStreamProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioOutputStreamProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acquire =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioOutputStreamProvider_Acquire_ParamsSpec.$,
        null,
        this.acquire.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioOutputStreamProviderClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioOutputStreamProviderClient', scope);
  }
}

/** @interface */
export class AudioOutputStreamProviderClientInterface {
  
  /**
   * @param { !AudioOutputStreamRemote } stream
   * @param { !media_mojom_ReadWriteAudioDataPipe } dataPipe
   */

  created(stream, dataPipe) {}
}

/**
 * @implements { AudioOutputStreamProviderClientInterface }
 */
export class AudioOutputStreamProviderClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioOutputStreamProviderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioOutputStreamProviderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioOutputStreamProviderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AudioOutputStreamRemote } stream
   * @param { !media_mojom_ReadWriteAudioDataPipe } dataPipe
   */

  created(
      stream,
      dataPipe) {
    this.proxy.sendMessage(
        0,
        AudioOutputStreamProviderClient_Created_ParamsSpec.$,
        null,
        [
          stream,
          dataPipe
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioOutputStreamProviderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioOutputStreamProviderClientReceiver {
  /**
   * @param {!AudioOutputStreamProviderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioOutputStreamProviderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioOutputStreamProviderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioOutputStreamProviderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioOutputStreamProviderClient_Created_ParamsSpec.$,
        null,
        impl.created.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioOutputStreamProviderClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioOutputStreamProviderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioOutputStreamProviderClientRemote}
   */
  static getRemote() {
    let remote = new AudioOutputStreamProviderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioOutputStreamProviderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioOutputStreamProviderClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioOutputStreamProviderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioOutputStreamProviderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.created =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioOutputStreamProviderClient_Created_ParamsSpec.$,
        null,
        this.created.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DeviceSwitchInterfacePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.DeviceSwitchInterface', scope);
  }
}

/** @interface */
export class DeviceSwitchInterfaceInterface {
  
  /**
   * @param { !string } outputDeviceId
   */

  switchAudioOutputDeviceId(outputDeviceId) {}
}

/**
 * @implements { DeviceSwitchInterfaceInterface }
 */
export class DeviceSwitchInterfaceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DeviceSwitchInterfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DeviceSwitchInterfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DeviceSwitchInterfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } outputDeviceId
   */

  switchAudioOutputDeviceId(
      outputDeviceId) {
    this.proxy.sendMessage(
        0,
        DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsSpec.$,
        null,
        [
          outputDeviceId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DeviceSwitchInterface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DeviceSwitchInterfaceReceiver {
  /**
   * @param {!DeviceSwitchInterfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DeviceSwitchInterfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DeviceSwitchInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DeviceSwitchInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsSpec.$,
        null,
        impl.switchAudioOutputDeviceId.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DeviceSwitchInterface {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.DeviceSwitchInterface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DeviceSwitchInterfaceRemote}
   */
  static getRemote() {
    let remote = new DeviceSwitchInterfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DeviceSwitchInterface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DeviceSwitchInterfaceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DeviceSwitchInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DeviceSwitchInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.switchAudioOutputDeviceId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsSpec.$,
        null,
        this.switchAudioOutputDeviceId.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioOutputStream_Play_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioOutputStream_Pause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioOutputStream_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioOutputStream_SetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioOutputStreamObserver_DidStartPlaying_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioOutputStreamObserver_DidStopPlaying_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioOutputStreamObserver_DidChangeAudibleState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioOutputStreamProvider_Acquire_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioOutputStreamProviderClient_Created_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AudioOutputStream_Play_ParamsSpec.$,
    'AudioOutputStream_Play_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioOutputStream_Play_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioOutputStream_Pause_ParamsSpec.$,
    'AudioOutputStream_Pause_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioOutputStream_Pause_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioOutputStream_Flush_ParamsSpec.$,
    'AudioOutputStream_Flush_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioOutputStream_Flush_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioOutputStream_SetVolume_ParamsSpec.$,
    'AudioOutputStream_SetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioOutputStream_SetVolume_Params {
  constructor() {
    /** @type { !number } */
    this.volume;
  }
}



mojo.internal.Struct(
    AudioOutputStreamObserver_DidStartPlaying_ParamsSpec.$,
    'AudioOutputStreamObserver_DidStartPlaying_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioOutputStreamObserver_DidStartPlaying_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioOutputStreamObserver_DidStopPlaying_ParamsSpec.$,
    'AudioOutputStreamObserver_DidStopPlaying_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioOutputStreamObserver_DidStopPlaying_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioOutputStreamObserver_DidChangeAudibleState_ParamsSpec.$,
    'AudioOutputStreamObserver_DidChangeAudibleState_Params',
    [
      mojo.internal.StructField(
        'isAudible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioOutputStreamObserver_DidChangeAudibleState_Params {
  constructor() {
    /** @type { !boolean } */
    this.isAudible;
  }
}



mojo.internal.Struct(
    AudioOutputStreamProvider_Acquire_ParamsSpec.$,
    'AudioOutputStreamProvider_Acquire_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(AudioOutputStreamProviderClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioOutputStreamProvider_Acquire_Params {
  constructor() {
    /** @type { !media_mojom_AudioParameters } */
    this.params;
    /** @type { !AudioOutputStreamProviderClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    AudioOutputStreamProviderClient_Created_ParamsSpec.$,
    'AudioOutputStreamProviderClient_Created_Params',
    [
      mojo.internal.StructField(
        'stream', 0,
        0,
        mojo.internal.InterfaceProxy(AudioOutputStreamRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataPipe', 8,
        0,
        media_mojom_ReadWriteAudioDataPipeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioOutputStreamProviderClient_Created_Params {
  constructor() {
    /** @type { !AudioOutputStreamRemote } */
    this.stream;
    /** @type { !media_mojom_ReadWriteAudioDataPipe } */
    this.dataPipe;
  }
}



mojo.internal.Struct(
    DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsSpec.$,
    'DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params',
    [
      mojo.internal.StructField(
        'outputDeviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params {
  constructor() {
    /** @type { !string } */
    this.outputDeviceId;
  }
}

