// media/mojo/mojom/audio_encoder.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('media.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.AacOutputFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.AacOutputFormat = {
  
  kAAC: 0,
  kADTS: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioEncoderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioEncoder.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.AudioEncoderInterface }
 */
media.mojom.AudioEncoderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioEncoderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioEncoderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioEncoderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @param { !media.mojom.AudioEncoderConfig } config
   * @return {!Promise<{
        status: !media.mojom.EncoderStatus,
   *  }>}
   */

  initialize(
      client,
      config) {
    return this.proxy.sendMessage(
        0,
        media.mojom.AudioEncoder_Initialize_ParamsSpec.$,
        media.mojom.AudioEncoder_Initialize_ResponseParamsSpec.$,
        [
          client,
          config
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.AudioBuffer } buffer
   * @return {!Promise<{
        status: !media.mojom.EncoderStatus,
   *  }>}
   */

  encode(
      buffer) {
    return this.proxy.sendMessage(
        1,
        media.mojom.AudioEncoder_Encode_ParamsSpec.$,
        media.mojom.AudioEncoder_Encode_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        status: !media.mojom.EncoderStatus,
   *  }>}
   */

  flush() {
    return this.proxy.sendMessage(
        2,
        media.mojom.AudioEncoder_Flush_ParamsSpec.$,
        media.mojom.AudioEncoder_Flush_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioEncoder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioEncoderReceiver = class {
  /**
   * @param {!media.mojom.AudioEncoderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioEncoderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioEncoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioEncoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioEncoder_Initialize_ParamsSpec.$,
        media.mojom.AudioEncoder_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioEncoder_Encode_ParamsSpec.$,
        media.mojom.AudioEncoder_Encode_ResponseParamsSpec.$,
        impl.encode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.AudioEncoder_Flush_ParamsSpec.$,
        media.mojom.AudioEncoder_Flush_ResponseParamsSpec.$,
        impl.flush.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioEncoder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioEncoder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioEncoderRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioEncoderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioEncoder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioEncoderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioEncoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioEncoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioEncoder_Initialize_ParamsSpec.$,
        media.mojom.AudioEncoder_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.encode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioEncoder_Encode_ParamsSpec.$,
        media.mojom.AudioEncoder_Encode_ResponseParamsSpec.$,
        this.encode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.AudioEncoder_Flush_ParamsSpec.$,
        media.mojom.AudioEncoder_Flush_ResponseParamsSpec.$,
        this.flush.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioEncoderClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioEncoderClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.AudioEncoderClientInterface }
 */
media.mojom.AudioEncoderClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioEncoderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioEncoderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioEncoderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.EncodedAudioBuffer } buffer
   * @param { !Array<!number> } description
   */

  onEncodedBufferReady(
      buffer,
      description) {
    this.proxy.sendMessage(
        0,
        media.mojom.AudioEncoderClient_OnEncodedBufferReady_ParamsSpec.$,
        null,
        [
          buffer,
          description
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioEncoderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioEncoderClientReceiver = class {
  /**
   * @param {!media.mojom.AudioEncoderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioEncoderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioEncoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioEncoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioEncoderClient_OnEncodedBufferReady_ParamsSpec.$,
        null,
        impl.onEncodedBufferReady.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioEncoderClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioEncoderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioEncoderClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioEncoderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioEncoderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioEncoderClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioEncoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioEncoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEncodedBufferReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioEncoderClient_OnEncodedBufferReady_ParamsSpec.$,
        null,
        this.onEncodedBufferReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AacAudioEncoderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioEncoderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.EncodedAudioBufferSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioEncoder_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioEncoder_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioEncoder_Encode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioEncoder_Encode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioEncoder_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioEncoder_Flush_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioEncoderClient_OnEncodedBufferReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.AacAudioEncoderConfigSpec.$,
    'AacAudioEncoderConfig',
    [
      mojo.internal.StructField(
        'format', 0,
        0,
        media.mojom.AacOutputFormatSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.AacAudioEncoderConfig = class {
  constructor() {
    /** @export { !media.mojom.AacOutputFormat } */
    this.format;
  }
};



mojo.internal.Struct(
    media.mojom.AudioEncoderConfigSpec.$,
    'AudioEncoderConfig',
    [
      mojo.internal.StructField(
        'codec', 0,
        0,
        media.mojom.AudioCodecSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelCount', 4,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sampleRate', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bitrate', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'aac', 16,
        0,
        media.mojom.AacAudioEncoderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
media.mojom.AudioEncoderConfig = class {
  constructor() {
    /** @export { !media.mojom.AudioCodec } */
    this.codec;
    /** @export { !number } */
    this.channelCount;
    /** @export { !number } */
    this.sampleRate;
    /** @export { !number } */
    this.bitrate;
    /** @export { !media.mojom.AacAudioEncoderConfig } */
    this.aac;
  }
};



mojo.internal.Struct(
    media.mojom.EncodedAudioBufferSpec.$,
    'EncodedAudioBuffer',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        media.mojom.AudioParametersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timestamp', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'duration', 16,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
media.mojom.EncodedAudioBuffer = class {
  constructor() {
    /** @export { !media.mojom.AudioParameters } */
    this.params;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.timestamp;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.duration;
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    media.mojom.AudioEncoder_Initialize_ParamsSpec.$,
    'AudioEncoder_Initialize_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(media.mojom.AudioEncoderClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'config', 8,
        0,
        media.mojom.AudioEncoderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
media.mojom.AudioEncoder_Initialize_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
    /** @export { !media.mojom.AudioEncoderConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    media.mojom.AudioEncoder_Initialize_ResponseParamsSpec.$,
    'AudioEncoder_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.EncoderStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.AudioEncoder_Initialize_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.EncoderStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.AudioEncoder_Encode_ParamsSpec.$,
    'AudioEncoder_Encode_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media.mojom.AudioBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.AudioEncoder_Encode_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    media.mojom.AudioEncoder_Encode_ResponseParamsSpec.$,
    'AudioEncoder_Encode_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.EncoderStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.AudioEncoder_Encode_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.EncoderStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.AudioEncoder_Flush_ParamsSpec.$,
    'AudioEncoder_Flush_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.AudioEncoder_Flush_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioEncoder_Flush_ResponseParamsSpec.$,
    'AudioEncoder_Flush_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.EncoderStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.AudioEncoder_Flush_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.EncoderStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.AudioEncoderClient_OnEncodedBufferReady_ParamsSpec.$,
    'AudioEncoderClient_OnEncodedBufferReady_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media.mojom.EncodedAudioBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
media.mojom.AudioEncoderClient_OnEncodedBufferReady_Params = class {
  constructor() {
    /** @export { !media.mojom.EncodedAudioBuffer } */
    this.buffer;
    /** @export { !Array<!number> } */
    this.description;
  }
};

