// media/capture/mojom/video_effects_manager.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_SEND_VALIDATION_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_SEND_VALIDATION_H_

#include "media/capture/mojom/video_effects_manager.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "media/capture/mojom/video_effects_manager.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::SetConfigurationResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::ImageEnhancementDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ImageEnhancementDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::ImageEnhancement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->lighting = Traits::lighting(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::BlurDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::BlurDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Blur_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::FramingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::FramingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Framing_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::padding_ratios(input)) in_padding_ratios = Traits::padding_ratios(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->padding_ratios)::BaseType> padding_ratios_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::InsetsFDataView, send_validation>(
        in_padding_ratios,
        padding_ratios_fragment);

      fragment->padding_ratios.Set(
          padding_ratios_fragment.is_null() ? nullptr : padding_ratios_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->padding_ratios.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null padding_ratios in Framing struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoEffectsConfigurationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoEffectsConfigurationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoEffectsConfiguration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::image_enhancement(input)) in_image_enhancement = Traits::image_enhancement(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_enhancement)::BaseType> image_enhancement_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::ImageEnhancementDataView, send_validation>(
        in_image_enhancement,
        image_enhancement_fragment);

      fragment->image_enhancement.Set(
          image_enhancement_fragment.is_null() ? nullptr : image_enhancement_fragment.data());

      decltype(Traits::blur(input)) in_blur = Traits::blur(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->blur)::BaseType> blur_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::BlurDataView, send_validation>(
        in_blur,
        blur_fragment);

      fragment->blur.Set(
          blur_fragment.is_null() ? nullptr : blur_fragment.data());

      decltype(Traits::framing(input)) in_framing = Traits::framing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->framing)::BaseType> framing_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::FramingDataView, send_validation>(
        in_framing,
        framing_fragment);

      fragment->framing.Set(
          framing_fragment.is_null() ? nullptr : framing_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_SEND_VALIDATION_H_