// media/capture/mojom/video_capture.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_BLINK_TEST_UTILS_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_BLINK_TEST_UTILS_H_

#include "media/capture/mojom/video_capture.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace media::mojom::blink {


class BLINK_PLATFORM_EXPORT VideoCaptureObserverInterceptorForTesting : public VideoCaptureObserver {
  virtual VideoCaptureObserver* GetForwardingInterface() = 0;
  void OnStateChanged(VideoCaptureResultPtr result) override;
  void OnNewBuffer(int32_t buffer_id, ::media::mojom::blink::VideoBufferHandlePtr buffer_handle) override;
  void OnBufferReady(::media::mojom::blink::ReadyBufferPtr buffer) override;
  void OnBufferDestroyed(int32_t buffer_id) override;
  void OnFrameDropped(::media::VideoCaptureFrameDropReason reason) override;
  void OnNewCaptureVersion(const ::media::CaptureVersion& capture_version) override;
};
class BLINK_PLATFORM_EXPORT VideoCaptureObserverAsyncWaiter {
 public:
  explicit VideoCaptureObserverAsyncWaiter(VideoCaptureObserver* proxy);

  VideoCaptureObserverAsyncWaiter(const VideoCaptureObserverAsyncWaiter&) = delete;
  VideoCaptureObserverAsyncWaiter& operator=(const VideoCaptureObserverAsyncWaiter&) = delete;

  ~VideoCaptureObserverAsyncWaiter();

 private:
  VideoCaptureObserver* const proxy_;
};


class BLINK_PLATFORM_EXPORT VideoCaptureHostInterceptorForTesting : public VideoCaptureHost {
  virtual VideoCaptureHost* GetForwardingInterface() = 0;
  void Start(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, const ::media::VideoCaptureParams& params, ::mojo::PendingRemote<VideoCaptureObserver> observer) override;
  void Stop(const ::base::UnguessableToken& device_id) override;
  void Pause(const ::base::UnguessableToken& device_id) override;
  void Resume(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, const ::media::VideoCaptureParams& params) override;
  void RequestRefreshFrame(const ::base::UnguessableToken& device_id) override;
  void ReleaseBuffer(const ::base::UnguessableToken& device_id, int32_t buffer_id, const ::media::VideoCaptureFeedback& feedback) override;
  void GetDeviceSupportedFormats(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, GetDeviceSupportedFormatsCallback callback) override;
  void GetDeviceFormatsInUse(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, GetDeviceFormatsInUseCallback callback) override;
  void OnLog(const ::base::UnguessableToken& device_id, const ::blink::String& message) override;
};
class BLINK_PLATFORM_EXPORT VideoCaptureHostAsyncWaiter {
 public:
  explicit VideoCaptureHostAsyncWaiter(VideoCaptureHost* proxy);

  VideoCaptureHostAsyncWaiter(const VideoCaptureHostAsyncWaiter&) = delete;
  VideoCaptureHostAsyncWaiter& operator=(const VideoCaptureHostAsyncWaiter&) = delete;

  ~VideoCaptureHostAsyncWaiter();
  void GetDeviceSupportedFormats(
      const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, ::blink::Vector<::media::VideoCaptureFormat>* out_formats_supported);
  ::blink::Vector<::media::VideoCaptureFormat> GetDeviceSupportedFormats(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id);
  void GetDeviceFormatsInUse(
      const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, ::blink::Vector<::media::VideoCaptureFormat>* out_formats_in_use);
  ::blink::Vector<::media::VideoCaptureFormat> GetDeviceFormatsInUse(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id);

 private:
  VideoCaptureHost* const proxy_;
};




}  // media::mojom::blink

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_BLINK_TEST_UTILS_H_