// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "headless/lib/browser/protocol/page.h"

#include "headless/lib/browser/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace headless {
namespace protocol {
namespace Page {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Page";
const char Metainfo::commandPrefix[] = "Page.";
const char Metainfo::version[] = "1.3";

// ------------- Enum values from params.


namespace CaptureScreenshot {
namespace FormatEnum {
const char* Jpeg = "jpeg";
const char* Png = "png";
const char* Webp = "webp";
} // namespace FormatEnum
} // namespace CaptureScreenshot

namespace CaptureSnapshot {
namespace FormatEnum {
const char* Mhtml = "mhtml";
} // namespace FormatEnum
} // namespace CaptureSnapshot

namespace PrintToPDF {
namespace TransferModeEnum {
const char* ReturnAsBase64 = "ReturnAsBase64";
const char* ReturnAsStream = "ReturnAsStream";
} // namespace TransferModeEnum
} // namespace PrintToPDF

namespace SetDownloadBehavior {
namespace BehaviorEnum {
const char* Deny = "deny";
const char* Allow = "allow";
const char* Default = "default";
} // namespace BehaviorEnum
} // namespace SetDownloadBehavior

namespace SetTouchEmulationEnabled {
namespace ConfigurationEnum {
const char* Mobile = "mobile";
const char* Desktop = "desktop";
} // namespace ConfigurationEnum
} // namespace SetTouchEmulationEnabled

namespace StartScreencast {
namespace FormatEnum {
const char* Jpeg = "jpeg";
const char* Png = "png";
} // namespace FormatEnum
} // namespace StartScreencast

namespace SetWebLifecycleState {
namespace StateEnum {
const char* Frozen = "frozen";
const char* Active = "active";
} // namespace StateEnum
} // namespace SetWebLifecycleState

namespace SetSPCTransactionMode {
namespace ModeEnum {
const char* None = "none";
const char* AutoAccept = "autoAccept";
const char* AutoChooseToAuthAnotherWay = "autoChooseToAuthAnotherWay";
const char* AutoReject = "autoReject";
const char* AutoOptOut = "autoOptOut";
} // namespace ModeEnum
} // namespace SetSPCTransactionMode

namespace SetRPHRegistrationMode {
namespace ModeEnum {
const char* None = "none";
const char* AutoAccept = "autoAccept";
const char* AutoReject = "autoReject";
} // namespace ModeEnum
} // namespace SetRPHRegistrationMode

namespace FileChooserOpened {
namespace ModeEnum {
const char* SelectSingle = "selectSingle";
const char* SelectMultiple = "selectMultiple";
} // namespace ModeEnum
} // namespace FileChooserOpened

namespace FrameDetached {
namespace ReasonEnum {
const char* Remove = "remove";
const char* Swap = "swap";
} // namespace ReasonEnum
} // namespace FrameDetached

namespace FrameStartedNavigating {
namespace NavigationTypeEnum {
const char* Reload = "reload";
const char* ReloadBypassingCache = "reloadBypassingCache";
const char* Restore = "restore";
const char* RestoreWithPost = "restoreWithPost";
const char* HistorySameDocument = "historySameDocument";
const char* HistoryDifferentDocument = "historyDifferentDocument";
const char* SameDocument = "sameDocument";
const char* DifferentDocument = "differentDocument";
} // namespace NavigationTypeEnum
} // namespace FrameStartedNavigating

namespace DownloadProgress {
namespace StateEnum {
const char* InProgress = "inProgress";
const char* Completed = "completed";
const char* Canceled = "canceled";
} // namespace StateEnum
} // namespace DownloadProgress

namespace NavigatedWithinDocument {
namespace NavigationTypeEnum {
const char* Fragment = "fragment";
const char* HistoryApi = "historyApi";
const char* Other = "other";
} // namespace NavigationTypeEnum
} // namespace NavigatedWithinDocument

// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void printToPDF(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("printToPDF"),
          &DomainDispatcherImpl::printToPDF
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class PrintToPDFCallbackImpl : public Backend::PrintToPDFCallback, public DomainDispatcher::Callback {
public:
    PrintToPDFCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.printToPDF"), message) { }

    void sendSuccess(const Binary& data, std::optional<String> stream) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("data"), data);
        serializer.AddField(crdtp::MakeSpan("stream"), stream);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct printToPDFParams : public crdtp::DeserializableProtocolObject<printToPDFParams> {
    std::optional<bool> landscape;
    std::optional<bool> displayHeaderFooter;
    std::optional<bool> printBackground;
    std::optional<double> scale;
    std::optional<double> paperWidth;
    std::optional<double> paperHeight;
    std::optional<double> marginTop;
    std::optional<double> marginBottom;
    std::optional<double> marginLeft;
    std::optional<double> marginRight;
    std::optional<String> pageRanges;
    std::optional<String> headerTemplate;
    std::optional<String> footerTemplate;
    std::optional<bool> preferCSSPageSize;
    std::optional<String> transferMode;
    std::optional<bool> generateTaggedPDF;
    std::optional<bool> generateDocumentOutline;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(printToPDFParams)
    CRDTP_DESERIALIZE_FIELD_OPT("displayHeaderFooter", displayHeaderFooter),
    CRDTP_DESERIALIZE_FIELD_OPT("footerTemplate", footerTemplate),
    CRDTP_DESERIALIZE_FIELD_OPT("generateDocumentOutline", generateDocumentOutline),
    CRDTP_DESERIALIZE_FIELD_OPT("generateTaggedPDF", generateTaggedPDF),
    CRDTP_DESERIALIZE_FIELD_OPT("headerTemplate", headerTemplate),
    CRDTP_DESERIALIZE_FIELD_OPT("landscape", landscape),
    CRDTP_DESERIALIZE_FIELD_OPT("marginBottom", marginBottom),
    CRDTP_DESERIALIZE_FIELD_OPT("marginLeft", marginLeft),
    CRDTP_DESERIALIZE_FIELD_OPT("marginRight", marginRight),
    CRDTP_DESERIALIZE_FIELD_OPT("marginTop", marginTop),
    CRDTP_DESERIALIZE_FIELD_OPT("pageRanges", pageRanges),
    CRDTP_DESERIALIZE_FIELD_OPT("paperHeight", paperHeight),
    CRDTP_DESERIALIZE_FIELD_OPT("paperWidth", paperWidth),
    CRDTP_DESERIALIZE_FIELD_OPT("preferCSSPageSize", preferCSSPageSize),
    CRDTP_DESERIALIZE_FIELD_OPT("printBackground", printBackground),
    CRDTP_DESERIALIZE_FIELD_OPT("scale", scale),
    CRDTP_DESERIALIZE_FIELD_OPT("transferMode", transferMode),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::printToPDF(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    printToPDFParams params;
    if (!printToPDFParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->PrintToPDF(std::move(params.landscape), std::move(params.displayHeaderFooter), std::move(params.printBackground), std::move(params.scale), std::move(params.paperWidth), std::move(params.paperHeight), std::move(params.marginTop), std::move(params.marginBottom), std::move(params.marginLeft), std::move(params.marginRight), std::move(params.pageRanges), std::move(params.headerTemplate), std::move(params.footerTemplate), std::move(params.preferCSSPageSize), std::move(params.transferMode), std::move(params.generateTaggedPDF), std::move(params.generateDocumentOutline), std::make_unique<PrintToPDFCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
          { crdtp::SpanFrom("Page.clearDeviceMetricsOverride"), crdtp::SpanFrom("Emulation.clearDeviceMetricsOverride") },
          { crdtp::SpanFrom("Page.clearDeviceOrientationOverride"), crdtp::SpanFrom("DeviceOrientation.clearDeviceOrientationOverride") },
          { crdtp::SpanFrom("Page.clearGeolocationOverride"), crdtp::SpanFrom("Emulation.clearGeolocationOverride") },
          { crdtp::SpanFrom("Page.deleteCookie"), crdtp::SpanFrom("Network.deleteCookie") },
          { crdtp::SpanFrom("Page.setDeviceMetricsOverride"), crdtp::SpanFrom("Emulation.setDeviceMetricsOverride") },
          { crdtp::SpanFrom("Page.setDeviceOrientationOverride"), crdtp::SpanFrom("DeviceOrientation.setDeviceOrientationOverride") },
          { crdtp::SpanFrom("Page.setGeolocationOverride"), crdtp::SpanFrom("Emulation.setGeolocationOverride") },
          { crdtp::SpanFrom("Page.setTouchEmulationEnabled"), crdtp::SpanFrom("Emulation.setTouchEmulationEnabled") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Page"), SortedRedirects(), std::move(dispatcher));
}

} // Page
} // namespace headless
} // namespace protocol
