// gpu/ipc/common/shared_image_pool_client_interface.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_SHARED_IMAGE_POOL_CLIENT_INTERFACE_MOJOM_H_
#define GPU_IPC_COMMON_SHARED_IMAGE_POOL_CLIENT_INTERFACE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/shared_image_pool_client_interface.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/shared_image_pool_client_interface.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/shared_image_pool_client_interface.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "gpu/gpu_export.h"




namespace gpu::mojom {

class SharedImagePoolClientInterfaceProxy;

template <typename ImplRefTraits>
class SharedImagePoolClientInterfaceStub;

class SharedImagePoolClientInterfaceRequestValidator;


class GPU_EXPORT SharedImagePoolClientInterface
    : public SharedImagePoolClientInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "gpu.mojom.SharedImagePoolClientInterface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedImagePoolClientInterfaceInterfaceBase;
  using Proxy_ = SharedImagePoolClientInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedImagePoolClientInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = SharedImagePoolClientInterfaceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnClearPoolMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnClearPool_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedImagePoolClientInterface() = default;

  virtual void OnClearPool() = 0;
};



class GPU_EXPORT SharedImagePoolClientInterfaceProxy
    : public SharedImagePoolClientInterface {
 public:
  using InterfaceType = SharedImagePoolClientInterface;

  explicit SharedImagePoolClientInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnClearPool() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class GPU_EXPORT SharedImagePoolClientInterfaceStubDispatch {
 public:
  static bool Accept(SharedImagePoolClientInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedImagePoolClientInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedImagePoolClientInterface>>
class SharedImagePoolClientInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedImagePoolClientInterfaceStub() = default;
  ~SharedImagePoolClientInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedImagePoolClientInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedImagePoolClientInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class GPU_EXPORT SharedImagePoolClientInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // gpu::mojom

namespace mojo {

}  // namespace mojo

#endif  // GPU_IPC_COMMON_SHARED_IMAGE_POOL_CLIENT_INTERFACE_MOJOM_H_