// gpu/ipc/common/shared_image_metadata.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_SEND_VALIDATION_H_
#define GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_SEND_VALIDATION_H_

#include "gpu/ipc/common/shared_image_metadata.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "skia/public/mojom/surface_origin.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"

#include "gpu/ipc/common/shared_image_metadata.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::SharedImageMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::SharedImageMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::SharedImageMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::format(input)) in_format = Traits::format(input);
      mojo::internal::MessageFragment<decltype(fragment->format)>
          format_fragment(fragment.message());
      format_fragment.Claim(&fragment->format);
      
      mojo::internal::Serialize<::viz::mojom::SharedImageFormatDataView, send_validation>(
        in_format,
        format_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->format.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null format in SharedImageMetadata struct");

      decltype(Traits::size(input)) in_size = Traits::size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->size)::BaseType> size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_size,
        size_fragment);

      fragment->size.Set(
          size_fragment.is_null() ? nullptr : size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size in SharedImageMetadata struct");

      decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color_space)::BaseType> color_space_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView, send_validation>(
        in_color_space,
        color_space_fragment);

      fragment->color_space.Set(
          color_space_fragment.is_null() ? nullptr : color_space_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color_space.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_space in SharedImageMetadata struct");

      
      mojo::internal::Serialize<::skia::mojom::SurfaceOrigin>(
        Traits::surface_origin(input),
        &fragment->surface_origin);

      
      mojo::internal::Serialize<::skia::mojom::AlphaType>(
        Traits::alpha_type(input),
        &fragment->alpha_type);

      fragment->usage = Traits::usage(input);
  }
};

}  // namespace mojo::internal

#endif  // GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_SEND_VALIDATION_H_