// gpu/ipc/common/memory_stats.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_MEMORY_STATS_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_MEMORY_STATS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "gpu/ipc/common/memory_stats.mojom-shared-internal.h"


namespace gpu::mojom {
class VideoMemoryProcessStatsDataView;

class VideoMemoryUsageStatsDataView;



}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::VideoMemoryProcessStatsDataView> {
  using Data = ::gpu::mojom::internal::VideoMemoryProcessStats_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VideoMemoryUsageStatsDataView> {
  using Data = ::gpu::mojom::internal::VideoMemoryUsageStats_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


class VideoMemoryProcessStatsDataView {
 public:
  VideoMemoryProcessStatsDataView() = default;

  VideoMemoryProcessStatsDataView(
      internal::VideoMemoryProcessStats_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t video_memory_bytes() const {
    return data_->video_memory_bytes;
  }
  bool has_duplicates() const {
    return data_->has_duplicates;
  }
 private:
  internal::VideoMemoryProcessStats_Data* data_ = nullptr;
};


class VideoMemoryUsageStatsDataView {
 public:
  VideoMemoryUsageStatsDataView() = default;

  VideoMemoryUsageStatsDataView(
      internal::VideoMemoryUsageStats_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProcessMapDataView(
      mojo::MapDataView<int32_t, VideoMemoryProcessStatsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProcessMap(UserType* output) {
    
    auto* pointer = data_->process_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<int32_t, ::gpu::mojom::VideoMemoryProcessStatsDataView>>(
        pointer, output, message_);
  }
  uint64_t bytes_allocated() const {
    return data_->bytes_allocated;
  }
 private:
  internal::VideoMemoryUsageStats_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

#endif  // GPU_IPC_COMMON_MEMORY_STATS_MOJOM_DATA_VIEW_H_