// gpu/ipc/common/gpu_info.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_INFO_MOJOM_SEND_VALIDATION_H_
#define GPU_IPC_COMMON_GPU_INFO_MOJOM_SEND_VALIDATION_H_

#include "gpu/ipc/common/gpu_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gl/mojom/gl_implementation.mojom-shared.h"
#include "ui/gl/mojom/gpu_preference.mojom-shared.h"

#include "gpu/ipc/common/gpu_info.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gpu::mojom::SkiaBackendType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gpu::mojom::VideoCodecProfile, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gpu::mojom::ImageDecodeAcceleratorType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gpu::mojom::ImageDecodeAcceleratorSubsampling, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::GpuDeviceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GpuDeviceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::GpuDevice_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->vendor_id = Traits::vendor_id(input);

      fragment->device_id = Traits::device_id(input);

      fragment->active = Traits::active(input);

      decltype(Traits::vendor_string(input)) in_vendor_string = Traits::vendor_string(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->vendor_string)::BaseType> vendor_string_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_vendor_string,
        vendor_string_fragment);

      fragment->vendor_string.Set(
          vendor_string_fragment.is_null() ? nullptr : vendor_string_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->vendor_string.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null vendor_string in GpuDevice struct");

      decltype(Traits::device_string(input)) in_device_string = Traits::device_string(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device_string)::BaseType> device_string_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_device_string,
        device_string_fragment);

      fragment->device_string.Set(
          device_string_fragment.is_null() ? nullptr : device_string_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device_string.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_string in GpuDevice struct");

      decltype(Traits::driver_vendor(input)) in_driver_vendor = Traits::driver_vendor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->driver_vendor)::BaseType> driver_vendor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_driver_vendor,
        driver_vendor_fragment);

      fragment->driver_vendor.Set(
          driver_vendor_fragment.is_null() ? nullptr : driver_vendor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->driver_vendor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null driver_vendor in GpuDevice struct");

      decltype(Traits::driver_version(input)) in_driver_version = Traits::driver_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->driver_version)::BaseType> driver_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_driver_version,
        driver_version_fragment);

      fragment->driver_version.Set(
          driver_version_fragment.is_null() ? nullptr : driver_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->driver_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null driver_version in GpuDevice struct");

      
      mojo::internal::Serialize<::gl::mojom::GpuPreference>(
        Traits::gpu_preference(input),
        &fragment->gpu_preference);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VideoDecodeAcceleratorSupportedProfile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::gpu::mojom::VideoCodecProfile>(
        Traits::profile(input),
        &fragment->profile);

      decltype(Traits::max_resolution(input)) in_max_resolution = Traits::max_resolution(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->max_resolution)::BaseType> max_resolution_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_max_resolution,
        max_resolution_fragment);

      fragment->max_resolution.Set(
          max_resolution_fragment.is_null() ? nullptr : max_resolution_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->max_resolution.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_resolution in VideoDecodeAcceleratorSupportedProfile struct");

      decltype(Traits::min_resolution(input)) in_min_resolution = Traits::min_resolution(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->min_resolution)::BaseType> min_resolution_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_min_resolution,
        min_resolution_fragment);

      fragment->min_resolution.Set(
          min_resolution_fragment.is_null() ? nullptr : min_resolution_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->min_resolution.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null min_resolution in VideoDecodeAcceleratorSupportedProfile struct");

      fragment->encrypted_only = Traits::encrypted_only(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::VideoDecodeAcceleratorCapabilitiesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VideoDecodeAcceleratorCapabilitiesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VideoDecodeAcceleratorCapabilities_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::supported_profiles(input)) in_supported_profiles = Traits::supported_profiles(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_profiles)::BaseType>
          supported_profiles_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_profiles_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView>, send_validation>(
        in_supported_profiles,
        supported_profiles_fragment,
        &supported_profiles_validate_params);

      fragment->supported_profiles.Set(
          supported_profiles_fragment.is_null() ? nullptr : supported_profiles_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->supported_profiles.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_profiles in VideoDecodeAcceleratorCapabilities struct");

      fragment->flags = Traits::flags(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::VideoEncodeAcceleratorSupportedProfileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VideoEncodeAcceleratorSupportedProfileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VideoEncodeAcceleratorSupportedProfile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::gpu::mojom::VideoCodecProfile>(
        Traits::profile(input),
        &fragment->profile);

      decltype(Traits::min_resolution(input)) in_min_resolution = Traits::min_resolution(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->min_resolution)::BaseType> min_resolution_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_min_resolution,
        min_resolution_fragment);

      fragment->min_resolution.Set(
          min_resolution_fragment.is_null() ? nullptr : min_resolution_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->min_resolution.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null min_resolution in VideoEncodeAcceleratorSupportedProfile struct");

      decltype(Traits::max_resolution(input)) in_max_resolution = Traits::max_resolution(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->max_resolution)::BaseType> max_resolution_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_max_resolution,
        max_resolution_fragment);

      fragment->max_resolution.Set(
          max_resolution_fragment.is_null() ? nullptr : max_resolution_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->max_resolution.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_resolution in VideoEncodeAcceleratorSupportedProfile struct");

      fragment->max_framerate_numerator = Traits::max_framerate_numerator(input);

      fragment->max_framerate_denominator = Traits::max_framerate_denominator(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::ImageDecodeAcceleratorSupportedProfileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::ImageDecodeAcceleratorSupportedProfileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::ImageDecodeAcceleratorSupportedProfile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::gpu::mojom::ImageDecodeAcceleratorType>(
        Traits::image_type(input),
        &fragment->image_type);

      decltype(Traits::min_encoded_dimensions(input)) in_min_encoded_dimensions = Traits::min_encoded_dimensions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->min_encoded_dimensions)::BaseType> min_encoded_dimensions_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_min_encoded_dimensions,
        min_encoded_dimensions_fragment);

      fragment->min_encoded_dimensions.Set(
          min_encoded_dimensions_fragment.is_null() ? nullptr : min_encoded_dimensions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->min_encoded_dimensions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null min_encoded_dimensions in ImageDecodeAcceleratorSupportedProfile struct");

      decltype(Traits::max_encoded_dimensions(input)) in_max_encoded_dimensions = Traits::max_encoded_dimensions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->max_encoded_dimensions)::BaseType> max_encoded_dimensions_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_max_encoded_dimensions,
        max_encoded_dimensions_fragment);

      fragment->max_encoded_dimensions.Set(
          max_encoded_dimensions_fragment.is_null() ? nullptr : max_encoded_dimensions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->max_encoded_dimensions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_encoded_dimensions in ImageDecodeAcceleratorSupportedProfile struct");

      decltype(Traits::subsamplings(input)) in_subsamplings = Traits::subsamplings(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subsamplings)::BaseType>
          subsamplings_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& subsamplings_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::gpu::mojom::internal::ImageDecodeAcceleratorSubsampling_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::ImageDecodeAcceleratorSubsampling>, send_validation>(
        in_subsamplings,
        subsamplings_fragment,
        &subsamplings_validate_params);

      fragment->subsamplings.Set(
          subsamplings_fragment.is_null() ? nullptr : subsamplings_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subsamplings.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subsamplings in ImageDecodeAcceleratorSupportedProfile struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::GpuInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GpuInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::GpuInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::initialization_time(input)) in_initialization_time = Traits::initialization_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initialization_time)::BaseType> initialization_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_initialization_time,
        initialization_time_fragment);

      fragment->initialization_time.Set(
          initialization_time_fragment.is_null() ? nullptr : initialization_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->initialization_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null initialization_time in GpuInfo struct");

      fragment->optimus = Traits::optimus(input);

      fragment->amd_switchable = Traits::amd_switchable(input);

      decltype(Traits::gpu(input)) in_gpu = Traits::gpu(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gpu)::BaseType> gpu_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::GpuDeviceDataView, send_validation>(
        in_gpu,
        gpu_fragment);

      fragment->gpu.Set(
          gpu_fragment.is_null() ? nullptr : gpu_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gpu.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gpu in GpuInfo struct");

      decltype(Traits::secondary_gpus(input)) in_secondary_gpus = Traits::secondary_gpus(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->secondary_gpus)::BaseType>
          secondary_gpus_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& secondary_gpus_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::GpuDeviceDataView>, send_validation>(
        in_secondary_gpus,
        secondary_gpus_fragment,
        &secondary_gpus_validate_params);

      fragment->secondary_gpus.Set(
          secondary_gpus_fragment.is_null() ? nullptr : secondary_gpus_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->secondary_gpus.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null secondary_gpus in GpuInfo struct");

      decltype(Traits::npus(input)) in_npus = Traits::npus(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->npus)::BaseType>
          npus_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& npus_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::GpuDeviceDataView>, send_validation>(
        in_npus,
        npus_fragment,
        &npus_validate_params);

      fragment->npus.Set(
          npus_fragment.is_null() ? nullptr : npus_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->npus.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null npus in GpuInfo struct");

      decltype(Traits::pixel_shader_version(input)) in_pixel_shader_version = Traits::pixel_shader_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pixel_shader_version)::BaseType> pixel_shader_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_pixel_shader_version,
        pixel_shader_version_fragment);

      fragment->pixel_shader_version.Set(
          pixel_shader_version_fragment.is_null() ? nullptr : pixel_shader_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pixel_shader_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pixel_shader_version in GpuInfo struct");

      decltype(Traits::vertex_shader_version(input)) in_vertex_shader_version = Traits::vertex_shader_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->vertex_shader_version)::BaseType> vertex_shader_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_vertex_shader_version,
        vertex_shader_version_fragment);

      fragment->vertex_shader_version.Set(
          vertex_shader_version_fragment.is_null() ? nullptr : vertex_shader_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->vertex_shader_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null vertex_shader_version in GpuInfo struct");

      decltype(Traits::max_msaa_samples(input)) in_max_msaa_samples = Traits::max_msaa_samples(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->max_msaa_samples)::BaseType> max_msaa_samples_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_max_msaa_samples,
        max_msaa_samples_fragment);

      fragment->max_msaa_samples.Set(
          max_msaa_samples_fragment.is_null() ? nullptr : max_msaa_samples_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->max_msaa_samples.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_msaa_samples in GpuInfo struct");

      decltype(Traits::machine_model_name(input)) in_machine_model_name = Traits::machine_model_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->machine_model_name)::BaseType> machine_model_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_machine_model_name,
        machine_model_name_fragment);

      fragment->machine_model_name.Set(
          machine_model_name_fragment.is_null() ? nullptr : machine_model_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->machine_model_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null machine_model_name in GpuInfo struct");

      decltype(Traits::machine_model_version(input)) in_machine_model_version = Traits::machine_model_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->machine_model_version)::BaseType> machine_model_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_machine_model_version,
        machine_model_version_fragment);

      fragment->machine_model_version.Set(
          machine_model_version_fragment.is_null() ? nullptr : machine_model_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->machine_model_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null machine_model_version in GpuInfo struct");

      decltype(Traits::display_type(input)) in_display_type = Traits::display_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_type)::BaseType> display_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_type,
        display_type_fragment);

      fragment->display_type.Set(
          display_type_fragment.is_null() ? nullptr : display_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_type in GpuInfo struct");

      
      mojo::internal::Serialize<::gpu::mojom::SkiaBackendType>(
        Traits::skia_backend_type(input),
        &fragment->skia_backend_type);

      decltype(Traits::gl_version(input)) in_gl_version = Traits::gl_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gl_version)::BaseType> gl_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_gl_version,
        gl_version_fragment);

      fragment->gl_version.Set(
          gl_version_fragment.is_null() ? nullptr : gl_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gl_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gl_version in GpuInfo struct");

      decltype(Traits::gl_vendor(input)) in_gl_vendor = Traits::gl_vendor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gl_vendor)::BaseType> gl_vendor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_gl_vendor,
        gl_vendor_fragment);

      fragment->gl_vendor.Set(
          gl_vendor_fragment.is_null() ? nullptr : gl_vendor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gl_vendor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gl_vendor in GpuInfo struct");

      decltype(Traits::gl_renderer(input)) in_gl_renderer = Traits::gl_renderer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gl_renderer)::BaseType> gl_renderer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_gl_renderer,
        gl_renderer_fragment);

      fragment->gl_renderer.Set(
          gl_renderer_fragment.is_null() ? nullptr : gl_renderer_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gl_renderer.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gl_renderer in GpuInfo struct");

      decltype(Traits::gl_extensions(input)) in_gl_extensions = Traits::gl_extensions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gl_extensions)::BaseType> gl_extensions_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_gl_extensions,
        gl_extensions_fragment);

      fragment->gl_extensions.Set(
          gl_extensions_fragment.is_null() ? nullptr : gl_extensions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gl_extensions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gl_extensions in GpuInfo struct");

      decltype(Traits::gl_ws_vendor(input)) in_gl_ws_vendor = Traits::gl_ws_vendor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gl_ws_vendor)::BaseType> gl_ws_vendor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_gl_ws_vendor,
        gl_ws_vendor_fragment);

      fragment->gl_ws_vendor.Set(
          gl_ws_vendor_fragment.is_null() ? nullptr : gl_ws_vendor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gl_ws_vendor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gl_ws_vendor in GpuInfo struct");

      decltype(Traits::gl_ws_version(input)) in_gl_ws_version = Traits::gl_ws_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gl_ws_version)::BaseType> gl_ws_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_gl_ws_version,
        gl_ws_version_fragment);

      fragment->gl_ws_version.Set(
          gl_ws_version_fragment.is_null() ? nullptr : gl_ws_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gl_ws_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gl_ws_version in GpuInfo struct");

      decltype(Traits::gl_ws_extensions(input)) in_gl_ws_extensions = Traits::gl_ws_extensions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gl_ws_extensions)::BaseType> gl_ws_extensions_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_gl_ws_extensions,
        gl_ws_extensions_fragment);

      fragment->gl_ws_extensions.Set(
          gl_ws_extensions_fragment.is_null() ? nullptr : gl_ws_extensions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gl_ws_extensions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gl_ws_extensions in GpuInfo struct");

      fragment->gl_reset_notification_strategy = Traits::gl_reset_notification_strategy(input);

      decltype(Traits::gl_implementation_parts(input)) in_gl_implementation_parts = Traits::gl_implementation_parts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gl_implementation_parts)::BaseType> gl_implementation_parts_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gl::mojom::GLImplementationPartsDataView, send_validation>(
        in_gl_implementation_parts,
        gl_implementation_parts_fragment);

      fragment->gl_implementation_parts.Set(
          gl_implementation_parts_fragment.is_null() ? nullptr : gl_implementation_parts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gl_implementation_parts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gl_implementation_parts in GpuInfo struct");

      decltype(Traits::direct_rendering_version(input)) in_direct_rendering_version = Traits::direct_rendering_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->direct_rendering_version)::BaseType> direct_rendering_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_direct_rendering_version,
        direct_rendering_version_fragment);

      fragment->direct_rendering_version.Set(
          direct_rendering_version_fragment.is_null() ? nullptr : direct_rendering_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->direct_rendering_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null direct_rendering_version in GpuInfo struct");

      fragment->sandboxed = Traits::sandboxed(input);

      fragment->in_process_gpu = Traits::in_process_gpu(input);

      fragment->passthrough_cmd_decoder = Traits::passthrough_cmd_decoder(input);

      fragment->can_support_threaded_texture_mailbox = Traits::can_support_threaded_texture_mailbox(input);

      decltype(Traits::video_decode_accelerator_supported_profiles(input)) in_video_decode_accelerator_supported_profiles = Traits::video_decode_accelerator_supported_profiles(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->video_decode_accelerator_supported_profiles)::BaseType>
          video_decode_accelerator_supported_profiles_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& video_decode_accelerator_supported_profiles_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView>, send_validation>(
        in_video_decode_accelerator_supported_profiles,
        video_decode_accelerator_supported_profiles_fragment,
        &video_decode_accelerator_supported_profiles_validate_params);

      fragment->video_decode_accelerator_supported_profiles.Set(
          video_decode_accelerator_supported_profiles_fragment.is_null() ? nullptr : video_decode_accelerator_supported_profiles_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->video_decode_accelerator_supported_profiles.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null video_decode_accelerator_supported_profiles in GpuInfo struct");

      decltype(Traits::video_encode_accelerator_supported_profiles(input)) in_video_encode_accelerator_supported_profiles = Traits::video_encode_accelerator_supported_profiles(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->video_encode_accelerator_supported_profiles)::BaseType>
          video_encode_accelerator_supported_profiles_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& video_encode_accelerator_supported_profiles_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VideoEncodeAcceleratorSupportedProfileDataView>, send_validation>(
        in_video_encode_accelerator_supported_profiles,
        video_encode_accelerator_supported_profiles_fragment,
        &video_encode_accelerator_supported_profiles_validate_params);

      fragment->video_encode_accelerator_supported_profiles.Set(
          video_encode_accelerator_supported_profiles_fragment.is_null() ? nullptr : video_encode_accelerator_supported_profiles_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->video_encode_accelerator_supported_profiles.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null video_encode_accelerator_supported_profiles in GpuInfo struct");

      fragment->jpeg_decode_accelerator_supported = Traits::jpeg_decode_accelerator_supported(input);

      fragment->subpixel_font_rendering = Traits::subpixel_font_rendering(input);

      fragment->visibility_callback_call_count = Traits::visibility_callback_call_count(input);
  }
};

}  // namespace mojo::internal

#endif  // GPU_IPC_COMMON_GPU_INFO_MOJOM_SEND_VALIDATION_H_