// extensions/common/mojom/service_worker_host.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('extensions.mojom.ChannelType');
goog.require('extensions.mojom.EventDispatcher');
goog.require('extensions.mojom.MessagePort');
goog.require('extensions.mojom.MessagePortHost');
goog.require('extensions.mojom.ExtensionId');
goog.require('extensions.mojom.ExternalConnectionInfo');
goog.require('extensions.mojom.ExtraResponseData');
goog.require('mojoBase.mojom.ListValue');
goog.require('extensions.mojom.PortId');
goog.require('extensions.mojom.RequestParams');
goog.require('blink.mojom.ServiceWorkerToken');
goog.require('mojoBase.mojom.UnguessableToken');
goog.require('url.mojom.Url');
goog.require('mojoBase.mojom.Uuid');






goog.provide('extensions.mojom.ServiceWorkerHost');
goog.provide('extensions.mojom.ServiceWorkerHostReceiver');
goog.provide('extensions.mojom.ServiceWorkerHostCallbackRouter');
goog.provide('extensions.mojom.ServiceWorkerHostInterface');
goog.provide('extensions.mojom.ServiceWorkerHostRemote');
goog.provide('extensions.mojom.ServiceWorkerHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.ServiceWorkerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.ServiceWorkerHost.$interfaceName,
        scope);
  }
};

/** @interface */
extensions.mojom.ServiceWorkerHostInterface = class {
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   * @param { !blink.mojom.ServiceWorkerToken } serviceWorkerToken
   * @param { !Object } eventDispatcher
   */

  didInitializeServiceWorkerContext(extensionId, serviceWorkerVersionId, workerThreadId, serviceWorkerToken, eventDispatcher) {}
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !mojoBase.mojom.UnguessableToken } activationToken
   * @param { !url.mojom.Url } serviceWorkerScope
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   */

  didStartServiceWorkerContext(extensionId, activationToken, serviceWorkerScope, serviceWorkerVersionId, workerThreadId) {}
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !mojoBase.mojom.UnguessableToken } activationToken
   * @param { !url.mojom.Url } serviceWorkerScope
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   */

  didStopServiceWorkerContext(extensionId, activationToken, serviceWorkerScope, serviceWorkerVersionId, workerThreadId) {}
  
  /**
   * @param { !extensions.mojom.RequestParams } params
   * @return {!Promise<{
        success: !boolean,
        responseWrapper: !mojoBase.mojom.ListValue,
        error: !string,
        extraData: ?extensions.mojom.ExtraResponseData,
   *  }>}
   */

  requestWorker(params) {}
  
  /**
   * @param { !mojoBase.mojom.Uuid } requestUuid
   */

  workerResponseAck(requestUuid) {}
  
  /**
   * @param { !extensions.mojom.ExternalConnectionInfo } info
   * @param { !extensions.mojom.ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions.mojom.PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToExtension(info, channelType, channelName, portId, port, portHost) {}
  
  /**
   * @param { !string } nativeAppName
   * @param { !extensions.mojom.PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToNativeApp(nativeAppName, portId, port, portHost) {}
  
  /**
   * @param { !number } tabId
   * @param { !number } frameId
   * @param { ?string } documentId
   * @param { !extensions.mojom.ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions.mojom.PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToTab(tabId, frameId, documentId, channelType, channelName, portId, port, portHost) {}
};

/**
 * @export
 * @implements { extensions.mojom.ServiceWorkerHostInterface }
 */
extensions.mojom.ServiceWorkerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.ServiceWorkerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.ServiceWorkerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.ServiceWorkerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   * @param { !blink.mojom.ServiceWorkerToken } serviceWorkerToken
   * @param { !Object } eventDispatcher
   */

  didInitializeServiceWorkerContext(
      extensionId,
      serviceWorkerVersionId,
      workerThreadId,
      serviceWorkerToken,
      eventDispatcher) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec.$,
        null,
        [
          extensionId,
          serviceWorkerVersionId,
          workerThreadId,
          serviceWorkerToken,
          eventDispatcher
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !mojoBase.mojom.UnguessableToken } activationToken
   * @param { !url.mojom.Url } serviceWorkerScope
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   */

  didStartServiceWorkerContext(
      extensionId,
      activationToken,
      serviceWorkerScope,
      serviceWorkerVersionId,
      workerThreadId) {
    this.proxy.sendMessage(
        1,
        extensions.mojom.ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec.$,
        null,
        [
          extensionId,
          activationToken,
          serviceWorkerScope,
          serviceWorkerVersionId,
          workerThreadId
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !mojoBase.mojom.UnguessableToken } activationToken
   * @param { !url.mojom.Url } serviceWorkerScope
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   */

  didStopServiceWorkerContext(
      extensionId,
      activationToken,
      serviceWorkerScope,
      serviceWorkerVersionId,
      workerThreadId) {
    this.proxy.sendMessage(
        2,
        extensions.mojom.ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec.$,
        null,
        [
          extensionId,
          activationToken,
          serviceWorkerScope,
          serviceWorkerVersionId,
          workerThreadId
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.RequestParams } params
   * @return {!Promise<{
        success: !boolean,
        responseWrapper: !mojoBase.mojom.ListValue,
        error: !string,
        extraData: ?extensions.mojom.ExtraResponseData,
   *  }>}
   */

  requestWorker(
      params) {
    return this.proxy.sendMessage(
        3,
        extensions.mojom.ServiceWorkerHost_RequestWorker_ParamsSpec.$,
        extensions.mojom.ServiceWorkerHost_RequestWorker_ResponseParamsSpec.$,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Uuid } requestUuid
   */

  workerResponseAck(
      requestUuid) {
    this.proxy.sendMessage(
        4,
        extensions.mojom.ServiceWorkerHost_WorkerResponseAck_ParamsSpec.$,
        null,
        [
          requestUuid
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExternalConnectionInfo } info
   * @param { !extensions.mojom.ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions.mojom.PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToExtension(
      info,
      channelType,
      channelName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        5,
        extensions.mojom.ServiceWorkerHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        [
          info,
          channelType,
          channelName,
          portId,
          port,
          portHost
        ],
        false);
  }

  
  /**
   * @param { !string } nativeAppName
   * @param { !extensions.mojom.PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToNativeApp(
      nativeAppName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        6,
        extensions.mojom.ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        [
          nativeAppName,
          portId,
          port,
          portHost
        ],
        false);
  }

  
  /**
   * @param { !number } tabId
   * @param { !number } frameId
   * @param { ?string } documentId
   * @param { !extensions.mojom.ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions.mojom.PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToTab(
      tabId,
      frameId,
      documentId,
      channelType,
      channelName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        7,
        extensions.mojom.ServiceWorkerHost_OpenChannelToTab_ParamsSpec.$,
        null,
        [
          tabId,
          frameId,
          documentId,
          channelType,
          channelName,
          portId,
          port,
          portHost
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.ServiceWorkerHostReceiver = class {
  /**
   * @param {!extensions.mojom.ServiceWorkerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.ServiceWorkerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.ServiceWorkerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.ServiceWorkerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec.$,
        null,
        impl.didInitializeServiceWorkerContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec.$,
        null,
        impl.didStartServiceWorkerContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec.$,
        null,
        impl.didStopServiceWorkerContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.ServiceWorkerHost_RequestWorker_ParamsSpec.$,
        extensions.mojom.ServiceWorkerHost_RequestWorker_ResponseParamsSpec.$,
        impl.requestWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        extensions.mojom.ServiceWorkerHost_WorkerResponseAck_ParamsSpec.$,
        null,
        impl.workerResponseAck.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        extensions.mojom.ServiceWorkerHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        impl.openChannelToExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        extensions.mojom.ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        impl.openChannelToNativeApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        extensions.mojom.ServiceWorkerHost_OpenChannelToTab_ParamsSpec.$,
        null,
        impl.openChannelToTab.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.ServiceWorkerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.ServiceWorkerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.ServiceWorkerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.ServiceWorkerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.ServiceWorkerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.ServiceWorkerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.ServiceWorkerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didInitializeServiceWorkerContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec.$,
        null,
        this.didInitializeServiceWorkerContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStartServiceWorkerContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec.$,
        null,
        this.didStartServiceWorkerContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStopServiceWorkerContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec.$,
        null,
        this.didStopServiceWorkerContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.ServiceWorkerHost_RequestWorker_ParamsSpec.$,
        extensions.mojom.ServiceWorkerHost_RequestWorker_ResponseParamsSpec.$,
        this.requestWorker.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.workerResponseAck =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        extensions.mojom.ServiceWorkerHost_WorkerResponseAck_ParamsSpec.$,
        null,
        this.workerResponseAck.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        extensions.mojom.ServiceWorkerHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        this.openChannelToExtension.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToNativeApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        extensions.mojom.ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        this.openChannelToNativeApp.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        extensions.mojom.ServiceWorkerHost_OpenChannelToTab_ParamsSpec.$,
        null,
        this.openChannelToTab.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('extensions.mojom.ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.ServiceWorkerHost_RequestWorker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorkerHost_RequestWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.ServiceWorkerHost_RequestWorker_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorkerHost_RequestWorker_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.ServiceWorkerHost_WorkerResponseAck_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorkerHost_WorkerResponseAck_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.ServiceWorkerHost_OpenChannelToExtension_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorkerHost_OpenChannelToExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.ServiceWorkerHost_OpenChannelToTab_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorkerHost_OpenChannelToTab_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mojom.ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec.$,
    'ServiceWorkerHost_DidInitializeServiceWorkerContext_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerVersionId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'workerThreadId', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerToken', 24,
        0,
        blink.mojom.ServiceWorkerTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventDispatcher', 32,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions.mojom.EventDispatcherRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('extensions.mojom.ServiceWorkerHost_DidInitializeServiceWorkerContext_Params');

/** @record */
extensions.mojom.ServiceWorkerHost_DidInitializeServiceWorkerContext_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !bigint } */
    this.serviceWorkerVersionId;
    /** @export { !number } */
    this.workerThreadId;
    /** @export { !blink.mojom.ServiceWorkerToken } */
    this.serviceWorkerToken;
    /** @export { !Object } */
    this.eventDispatcher;
  }
};



mojo.internal.Struct(
    extensions.mojom.ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec.$,
    'ServiceWorkerHost_DidStartServiceWorkerContext_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'activationToken', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerScope', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerVersionId', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'workerThreadId', 32,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('extensions.mojom.ServiceWorkerHost_DidStartServiceWorkerContext_Params');

/** @record */
extensions.mojom.ServiceWorkerHost_DidStartServiceWorkerContext_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.activationToken;
    /** @export { !url.mojom.Url } */
    this.serviceWorkerScope;
    /** @export { !bigint } */
    this.serviceWorkerVersionId;
    /** @export { !number } */
    this.workerThreadId;
  }
};



mojo.internal.Struct(
    extensions.mojom.ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec.$,
    'ServiceWorkerHost_DidStopServiceWorkerContext_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'activationToken', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerScope', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerVersionId', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'workerThreadId', 32,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('extensions.mojom.ServiceWorkerHost_DidStopServiceWorkerContext_Params');

/** @record */
extensions.mojom.ServiceWorkerHost_DidStopServiceWorkerContext_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.activationToken;
    /** @export { !url.mojom.Url } */
    this.serviceWorkerScope;
    /** @export { !bigint } */
    this.serviceWorkerVersionId;
    /** @export { !number } */
    this.workerThreadId;
  }
};



mojo.internal.Struct(
    extensions.mojom.ServiceWorkerHost_RequestWorker_ParamsSpec.$,
    'ServiceWorkerHost_RequestWorker_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        extensions.mojom.RequestParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('extensions.mojom.ServiceWorkerHost_RequestWorker_Params');

/** @record */
extensions.mojom.ServiceWorkerHost_RequestWorker_Params = class {
  constructor() {
    /** @export { !extensions.mojom.RequestParams } */
    this.params;
  }
};



mojo.internal.Struct(
    extensions.mojom.ServiceWorkerHost_RequestWorker_ResponseParamsSpec.$,
    'ServiceWorkerHost_RequestWorker_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseWrapper', 8,
        0,
        mojoBase.mojom.ListValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extraData', 24,
        0,
        extensions.mojom.ExtraResponseDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('extensions.mojom.ServiceWorkerHost_RequestWorker_ResponseParams');

/** @record */
extensions.mojom.ServiceWorkerHost_RequestWorker_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !mojoBase.mojom.ListValue } */
    this.responseWrapper;
    /** @export { !string } */
    this.error;
    /** @export { (extensions.mojom.ExtraResponseData|undefined) } */
    this.extraData;
  }
};



mojo.internal.Struct(
    extensions.mojom.ServiceWorkerHost_WorkerResponseAck_ParamsSpec.$,
    'ServiceWorkerHost_WorkerResponseAck_Params',
    [
      mojo.internal.StructField(
        'requestUuid', 0,
        0,
        mojoBase.mojom.UuidSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('extensions.mojom.ServiceWorkerHost_WorkerResponseAck_Params');

/** @record */
extensions.mojom.ServiceWorkerHost_WorkerResponseAck_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Uuid } */
    this.requestUuid;
  }
};



mojo.internal.Struct(
    extensions.mojom.ServiceWorkerHost_OpenChannelToExtension_ParamsSpec.$,
    'ServiceWorkerHost_OpenChannelToExtension_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        extensions.mojom.ExternalConnectionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelType', 8,
        0,
        extensions.mojom.ChannelTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portId', 24,
        0,
        extensions.mojom.PortIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'port', 32,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions.mojom.MessagePortRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portHost', 12,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions.mojom.MessagePortHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('extensions.mojom.ServiceWorkerHost_OpenChannelToExtension_Params');

/** @record */
extensions.mojom.ServiceWorkerHost_OpenChannelToExtension_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExternalConnectionInfo } */
    this.info;
    /** @export { !extensions.mojom.ChannelType } */
    this.channelType;
    /** @export { !string } */
    this.channelName;
    /** @export { !extensions.mojom.PortId } */
    this.portId;
    /** @export { !Object } */
    this.port;
    /** @export { !Object } */
    this.portHost;
  }
};



mojo.internal.Struct(
    extensions.mojom.ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec.$,
    'ServiceWorkerHost_OpenChannelToNativeApp_Params',
    [
      mojo.internal.StructField(
        'nativeAppName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portId', 8,
        0,
        extensions.mojom.PortIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'port', 16,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions.mojom.MessagePortRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portHost', 24,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions.mojom.MessagePortHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('extensions.mojom.ServiceWorkerHost_OpenChannelToNativeApp_Params');

/** @record */
extensions.mojom.ServiceWorkerHost_OpenChannelToNativeApp_Params = class {
  constructor() {
    /** @export { !string } */
    this.nativeAppName;
    /** @export { !extensions.mojom.PortId } */
    this.portId;
    /** @export { !Object } */
    this.port;
    /** @export { !Object } */
    this.portHost;
  }
};



mojo.internal.Struct(
    extensions.mojom.ServiceWorkerHost_OpenChannelToTab_ParamsSpec.$,
    'ServiceWorkerHost_OpenChannelToTab_Params',
    [
      mojo.internal.StructField(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameId', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentId', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelType', 16,
        0,
        extensions.mojom.ChannelTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelName', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portId', 32,
        0,
        extensions.mojom.PortIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'port', 40,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions.mojom.MessagePortRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portHost', 20,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions.mojom.MessagePortHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('extensions.mojom.ServiceWorkerHost_OpenChannelToTab_Params');

/** @record */
extensions.mojom.ServiceWorkerHost_OpenChannelToTab_Params = class {
  constructor() {
    /** @export { !number } */
    this.tabId;
    /** @export { !number } */
    this.frameId;
    /** @export { (string|undefined) } */
    this.documentId;
    /** @export { !extensions.mojom.ChannelType } */
    this.channelType;
    /** @export { !string } */
    this.channelName;
    /** @export { !extensions.mojom.PortId } */
    this.portId;
    /** @export { !Object } */
    this.port;
    /** @export { !Object } */
    this.portHost;
  }
};

