// extensions/common/mojom/service_worker.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_SERVICE_WORKER_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_SERVICE_WORKER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/service_worker.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/service_worker.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/service_worker.mojom-forward.h"  // IWYU pragma: export
#include "extensions/common/mojom/message_port.mojom.h"
#include "extensions/common/mojom/permission_set.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {

class ServiceWorkerProxy;

template <typename ImplRefTraits>
class ServiceWorkerStub;

class ServiceWorkerRequestValidator;
class ServiceWorkerResponseValidator;


class ServiceWorker
    : public ServiceWorkerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions.mojom.ServiceWorker";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerInterfaceBase;
  using Proxy_ = ServiceWorkerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerRequestValidator;
  using ResponseValidator_ = ServiceWorkerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kUpdatePermissionsMinVersion = 0,
    kDispatchOnConnectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdatePermissions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchOnConnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorker() = default;

  virtual void UpdatePermissions(::extensions::PermissionSet active_permissions, ::extensions::PermissionSet withheld_permissions) = 0;

  using DispatchOnConnectCallback = base::OnceCallback<void(bool)>;
  using DispatchOnConnectMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DispatchOnConnect(const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host, DispatchOnConnectCallback callback) = 0;
};



class  ServiceWorkerProxy
    : public ServiceWorker {
 public:
  using InterfaceType = ServiceWorker;

  explicit ServiceWorkerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdatePermissions(::extensions::PermissionSet active_permissions, ::extensions::PermissionSet withheld_permissions) final;
  
  void DispatchOnConnect(const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host, DispatchOnConnectCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ServiceWorkerStubDispatch {
 public:
  static bool Accept(ServiceWorker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorker>>
class ServiceWorkerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerStub() = default;
  ~ServiceWorkerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // extensions::mojom

namespace mojo {

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_SERVICE_WORKER_MOJOM_H_