// extensions/common/mojom/renderer_host.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('extensions.mojom.ExtensionId');
goog.require('mojoBase.mojom.ListValue');
goog.require('mojoBase.mojom.String16');
goog.require('url.mojom.Url');






goog.provide('extensions.mojom.RendererHost');
goog.provide('extensions.mojom.RendererHostReceiver');
goog.provide('extensions.mojom.RendererHostCallbackRouter');
goog.provide('extensions.mojom.RendererHostInterface');
goog.provide('extensions.mojom.RendererHostRemote');
goog.provide('extensions.mojom.RendererHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.RendererHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.RendererHost.$interfaceName,
        scope);
  }
};

/** @interface */
extensions.mojom.RendererHostInterface = class {
  
  /**
   * @param { ?extensions.mojom.ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase.mojom.ListValue } args
   * @param { !string } extra
   */

  addAPIActionToActivityLog(extensionId, callName, args, extra) {}
  
  /**
   * @param { ?extensions.mojom.ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase.mojom.ListValue } args
   * @param { !string } extra
   */

  addEventToActivityLog(extensionId, callName, args, extra) {}
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase.mojom.ListValue } args
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.String16 } urlTitle
   * @param { !number } callType
   */

  addDOMActionToActivityLog(extensionId, callName, args, url, urlTitle, callType) {}
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @return {!Promise<{
        messageMap: !Object<!string, !string>,
   *  }>}
   */

  getMessageBundle(extensionId) {}
};

/**
 * @export
 * @implements { extensions.mojom.RendererHostInterface }
 */
extensions.mojom.RendererHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.RendererHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.RendererHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.RendererHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?extensions.mojom.ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase.mojom.ListValue } args
   * @param { !string } extra
   */

  addAPIActionToActivityLog(
      extensionId,
      callName,
      args,
      extra) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.RendererHost_AddAPIActionToActivityLog_ParamsSpec.$,
        null,
        [
          extensionId,
          callName,
          args,
          extra
        ],
        false);
  }

  
  /**
   * @param { ?extensions.mojom.ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase.mojom.ListValue } args
   * @param { !string } extra
   */

  addEventToActivityLog(
      extensionId,
      callName,
      args,
      extra) {
    this.proxy.sendMessage(
        1,
        extensions.mojom.RendererHost_AddEventToActivityLog_ParamsSpec.$,
        null,
        [
          extensionId,
          callName,
          args,
          extra
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase.mojom.ListValue } args
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.String16 } urlTitle
   * @param { !number } callType
   */

  addDOMActionToActivityLog(
      extensionId,
      callName,
      args,
      url,
      urlTitle,
      callType) {
    this.proxy.sendMessage(
        2,
        extensions.mojom.RendererHost_AddDOMActionToActivityLog_ParamsSpec.$,
        null,
        [
          extensionId,
          callName,
          args,
          url,
          urlTitle,
          callType
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @return {!Promise<{
        messageMap: !Object<!string, !string>,
   *  }>}
   */

  getMessageBundle(
      extensionId) {
    return this.proxy.sendMessage(
        3,
        extensions.mojom.RendererHost_GetMessageBundle_ParamsSpec.$,
        extensions.mojom.RendererHost_GetMessageBundle_ResponseParamsSpec.$,
        [
          extensionId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RendererHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.RendererHostReceiver = class {
  /**
   * @param {!extensions.mojom.RendererHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.RendererHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.RendererHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.RendererHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.RendererHost_AddAPIActionToActivityLog_ParamsSpec.$,
        null,
        impl.addAPIActionToActivityLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.RendererHost_AddEventToActivityLog_ParamsSpec.$,
        null,
        impl.addEventToActivityLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.RendererHost_AddDOMActionToActivityLog_ParamsSpec.$,
        null,
        impl.addDOMActionToActivityLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.RendererHost_GetMessageBundle_ParamsSpec.$,
        extensions.mojom.RendererHost_GetMessageBundle_ResponseParamsSpec.$,
        impl.getMessageBundle.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.RendererHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.RendererHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.RendererHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.RendererHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RendererHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.RendererHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.RendererHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.RendererHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAPIActionToActivityLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.RendererHost_AddAPIActionToActivityLog_ParamsSpec.$,
        null,
        this.addAPIActionToActivityLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addEventToActivityLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.RendererHost_AddEventToActivityLog_ParamsSpec.$,
        null,
        this.addEventToActivityLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addDOMActionToActivityLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.RendererHost_AddDOMActionToActivityLog_ParamsSpec.$,
        null,
        this.addDOMActionToActivityLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getMessageBundle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.RendererHost_GetMessageBundle_ParamsSpec.$,
        extensions.mojom.RendererHost_GetMessageBundle_ResponseParamsSpec.$,
        this.getMessageBundle.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('extensions.mojom.RendererHost_AddAPIActionToActivityLog_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.RendererHost_AddAPIActionToActivityLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.RendererHost_AddEventToActivityLog_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.RendererHost_AddEventToActivityLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.RendererHost_AddDOMActionToActivityLog_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.RendererHost_AddDOMActionToActivityLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.RendererHost_GetMessageBundle_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.RendererHost_GetMessageBundle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.RendererHost_GetMessageBundle_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.RendererHost_GetMessageBundle_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mojom.RendererHost_AddAPIActionToActivityLog_ParamsSpec.$,
    'RendererHost_AddAPIActionToActivityLog_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'callName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'args', 16,
        0,
        mojoBase.mojom.ListValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extra', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('extensions.mojom.RendererHost_AddAPIActionToActivityLog_Params');

/** @record */
extensions.mojom.RendererHost_AddAPIActionToActivityLog_Params = class {
  constructor() {
    /** @export { (extensions.mojom.ExtensionId|undefined) } */
    this.extensionId;
    /** @export { !string } */
    this.callName;
    /** @export { !mojoBase.mojom.ListValue } */
    this.args;
    /** @export { !string } */
    this.extra;
  }
};



mojo.internal.Struct(
    extensions.mojom.RendererHost_AddEventToActivityLog_ParamsSpec.$,
    'RendererHost_AddEventToActivityLog_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'callName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'args', 16,
        0,
        mojoBase.mojom.ListValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extra', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('extensions.mojom.RendererHost_AddEventToActivityLog_Params');

/** @record */
extensions.mojom.RendererHost_AddEventToActivityLog_Params = class {
  constructor() {
    /** @export { (extensions.mojom.ExtensionId|undefined) } */
    this.extensionId;
    /** @export { !string } */
    this.callName;
    /** @export { !mojoBase.mojom.ListValue } */
    this.args;
    /** @export { !string } */
    this.extra;
  }
};



mojo.internal.Struct(
    extensions.mojom.RendererHost_AddDOMActionToActivityLog_ParamsSpec.$,
    'RendererHost_AddDOMActionToActivityLog_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'callName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'args', 16,
        0,
        mojoBase.mojom.ListValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlTitle', 32,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'callType', 40,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('extensions.mojom.RendererHost_AddDOMActionToActivityLog_Params');

/** @record */
extensions.mojom.RendererHost_AddDOMActionToActivityLog_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !string } */
    this.callName;
    /** @export { !mojoBase.mojom.ListValue } */
    this.args;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.String16 } */
    this.urlTitle;
    /** @export { !number } */
    this.callType;
  }
};



mojo.internal.Struct(
    extensions.mojom.RendererHost_GetMessageBundle_ParamsSpec.$,
    'RendererHost_GetMessageBundle_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('extensions.mojom.RendererHost_GetMessageBundle_Params');

/** @record */
extensions.mojom.RendererHost_GetMessageBundle_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
  }
};



mojo.internal.Struct(
    extensions.mojom.RendererHost_GetMessageBundle_ResponseParamsSpec.$,
    'RendererHost_GetMessageBundle_ResponseParams',
    [
      mojo.internal.StructField(
        'messageMap', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('extensions.mojom.RendererHost_GetMessageBundle_ResponseParams');

/** @record */
extensions.mojom.RendererHost_GetMessageBundle_ResponseParams = class {
  constructor() {
    /** @export { !Object<!string, !string> } */
    this.messageMap;
  }
};

