// extensions/common/mojom/message_port.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_MESSAGE_PORT_MOJOM_SEND_VALIDATION_H_
#define EXTENSIONS_COMMON_MOJOM_MESSAGE_PORT_MOJOM_SEND_VALIDATION_H_

#include "extensions/common/mojom/message_port.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "extensions/common/mojom/message_port.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::extensions::mojom::SerializationFormat, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::extensions::mojom::ChannelType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::extensions::mojom::MessagingEndpointType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::PortIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::PortIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::PortId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::context_id(input)) in_context_id = Traits::context_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->context_id)::BaseType> context_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_context_id,
        context_id_fragment);

      fragment->context_id.Set(
          context_id_fragment.is_null() ? nullptr : context_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->context_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null context_id in PortId struct");

      fragment->port_number = Traits::port_number(input);

      fragment->is_opener = Traits::is_opener(input);

      
      mojo::internal::Serialize<::extensions::mojom::SerializationFormat>(
        Traits::serialization_format(input),
        &fragment->serialization_format);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::MessagingEndpointDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::MessagingEndpointDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::MessagingEndpoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::extensions::mojom::MessagingEndpointType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::extension_id(input)) in_extension_id = Traits::extension_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extension_id)::BaseType> extension_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_extension_id,
        extension_id_fragment);

      fragment->extension_id.Set(
          extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

      decltype(Traits::native_app_name(input)) in_native_app_name = Traits::native_app_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->native_app_name)::BaseType> native_app_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_native_app_name,
        native_app_name_fragment);

      fragment->native_app_name.Set(
          native_app_name_fragment.is_null() ? nullptr : native_app_name_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::TabConnectionInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::TabConnectionInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::TabConnectionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::tab(input)) in_tab = Traits::tab(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tab)::BaseType> tab_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView, send_validation>(
        in_tab,
        tab_fragment);

      fragment->tab.Set(
          tab_fragment.is_null() ? nullptr : tab_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tab.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tab in TabConnectionInfo struct");

      fragment->frame_id = Traits::frame_id(input);

      decltype(Traits::document_id(input)) in_document_id = Traits::document_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->document_id)::BaseType> document_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_document_id,
        document_id_fragment);

      fragment->document_id.Set(
          document_id_fragment.is_null() ? nullptr : document_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->document_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_id in TabConnectionInfo struct");

      decltype(Traits::document_lifecycle(input)) in_document_lifecycle = Traits::document_lifecycle(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->document_lifecycle)::BaseType> document_lifecycle_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_document_lifecycle,
        document_lifecycle_fragment);

      fragment->document_lifecycle.Set(
          document_lifecycle_fragment.is_null() ? nullptr : document_lifecycle_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->document_lifecycle.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_lifecycle in TabConnectionInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::ExternalConnectionInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::ExternalConnectionInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::ExternalConnectionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::source_endpoint(input)) in_source_endpoint = Traits::source_endpoint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_endpoint)::BaseType> source_endpoint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::extensions::mojom::MessagingEndpointDataView, send_validation>(
        in_source_endpoint,
        source_endpoint_fragment);

      fragment->source_endpoint.Set(
          source_endpoint_fragment.is_null() ? nullptr : source_endpoint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_endpoint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_endpoint in ExternalConnectionInfo struct");

      decltype(Traits::target_id(input)) in_target_id = Traits::target_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->target_id)::BaseType> target_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_target_id,
        target_id_fragment);

      fragment->target_id.Set(
          target_id_fragment.is_null() ? nullptr : target_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->target_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_id in ExternalConnectionInfo struct");

      decltype(Traits::source_url(input)) in_source_url = Traits::source_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_url)::BaseType> source_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_source_url,
        source_url_fragment);

      fragment->source_url.Set(
          source_url_fragment.is_null() ? nullptr : source_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_url in ExternalConnectionInfo struct");

      decltype(Traits::source_origin(input)) in_source_origin = Traits::source_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_origin)::BaseType> source_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_source_origin,
        source_origin_fragment);

      fragment->source_origin.Set(
          source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());

      fragment->guest_process_id = Traits::guest_process_id(input);

      fragment->guest_render_frame_routing_id = Traits::guest_render_frame_routing_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::MessageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::MessageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::Message_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType> data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_data,
        data_fragment);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in Message struct");

      
      mojo::internal::Serialize<::extensions::mojom::SerializationFormat>(
        Traits::format(input),
        &fragment->format);

      fragment->user_gesture = Traits::user_gesture(input);

      fragment->from_privileged_context = Traits::from_privileged_context(input);
  }
};

}  // namespace mojo::internal

#endif  // EXTENSIONS_COMMON_MOJOM_MESSAGE_PORT_MOJOM_SEND_VALIDATION_H_