// extensions/common/mojom/frame.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_SEND_VALIDATION_H_
#define EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_SEND_VALIDATION_H_

#include "extensions/common/mojom/frame.mojom-shared-internal.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "extensions/common/mojom/code_injection.mojom-shared.h"
#include "extensions/common/mojom/context_type.mojom-shared.h"
#include "extensions/common/mojom/extra_response_data.mojom-shared.h"
#include "extensions/common/mojom/host_id.mojom-shared.h"
#include "extensions/common/mojom/injection_type.mojom-shared.h"
#include "extensions/common/mojom/extension_id.mojom-shared.h"
#include "extensions/common/mojom/match_origin_as_fallback.mojom-shared.h"
#include "extensions/common/mojom/message_port.mojom-shared.h"
#include "extensions/common/mojom/run_location.mojom-shared.h"
#include "extensions/common/mojom/stack_frame.mojom-shared.h"
#include "extensions/common/mojom/view_type.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"

#include "extensions/common/mojom/frame.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::ExecuteCodeParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::ExecuteCodeParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::ExecuteCodeParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::host_id(input)) in_host_id = Traits::host_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host_id)::BaseType> host_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::extensions::mojom::HostIDDataView, send_validation>(
        in_host_id,
        host_id_fragment);

      fragment->host_id.Set(
          host_id_fragment.is_null() ? nullptr : host_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_id in ExecuteCodeParams struct");

      decltype(Traits::injection(input)) in_injection = Traits::injection(input);
      mojo::internal::MessageFragment<decltype(fragment->injection)>
          injection_fragment(fragment.message());
      injection_fragment.Claim(&fragment->injection);
      
      mojo::internal::Serialize<::extensions::mojom::CodeInjectionDataView, send_validation>(
        in_injection,
        injection_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->injection.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null injection in ExecuteCodeParams struct");

      decltype(Traits::webview_src(input)) in_webview_src = Traits::webview_src(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->webview_src)::BaseType> webview_src_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_webview_src,
        webview_src_fragment);

      fragment->webview_src.Set(
          webview_src_fragment.is_null() ? nullptr : webview_src_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->webview_src.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null webview_src in ExecuteCodeParams struct");

      
      mojo::internal::Serialize<::extensions::mojom::MatchOriginAsFallbackBehavior>(
        Traits::match_origin_as_fallback_behavior(input),
        &fragment->match_origin_as_fallback_behavior);

      
      mojo::internal::Serialize<::extensions::mojom::RunLocation>(
        Traits::run_at(input),
        &fragment->run_at);

      fragment->is_web_view = Traits::is_web_view(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::RequestParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::RequestParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::RequestParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in RequestParams struct");

      decltype(Traits::arguments(input)) in_arguments = Traits::arguments(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->arguments)::BaseType> arguments_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView, send_validation>(
        in_arguments,
        arguments_fragment);

      fragment->arguments.Set(
          arguments_fragment.is_null() ? nullptr : arguments_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->arguments.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null arguments in RequestParams struct");

      decltype(Traits::extension_id(input)) in_extension_id = Traits::extension_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extension_id)::BaseType> extension_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_extension_id,
        extension_id_fragment);

      fragment->extension_id.Set(
          extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->extension_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extension_id in RequestParams struct");

      decltype(Traits::source_url(input)) in_source_url = Traits::source_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_url)::BaseType> source_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_source_url,
        source_url_fragment);

      fragment->source_url.Set(
          source_url_fragment.is_null() ? nullptr : source_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_url in RequestParams struct");

      
      mojo::internal::Serialize<::extensions::mojom::ContextType>(
        Traits::context_type(input),
        &fragment->context_type);

      fragment->request_id = Traits::request_id(input);

      fragment->has_callback = Traits::has_callback(input);

      fragment->user_gesture = Traits::user_gesture(input);

      fragment->worker_thread_id = Traits::worker_thread_id(input);

      fragment->service_worker_version_id = Traits::service_worker_version_id(input);

      decltype(Traits::js_callstack(input)) in_js_callstack = Traits::js_callstack(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->js_callstack)::BaseType>
          js_callstack_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& js_callstack_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>, send_validation>(
        in_js_callstack,
        js_callstack_fragment,
        &js_callstack_validate_params);

      fragment->js_callstack.Set(
          js_callstack_fragment.is_null() ? nullptr : js_callstack_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_SEND_VALIDATION_H_