// extensions/common/mojom/frame.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('extensions.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.LocalFramePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.LocalFrame.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { extensions.mojom.LocalFrameInterface }
 */
extensions.mojom.LocalFrameRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.LocalFramePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.LocalFramePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.LocalFramePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } frameName
   */

  setFrameName(
      frameName) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.LocalFrame_SetFrameName_ParamsSpec.$,
        null,
        [
          frameName
        ],
        false);
  }

  
  /**
   * @param { !boolean } spatialNavEnabled
   */

  setSpatialNavigationEnabled(
      spatialNavEnabled) {
    this.proxy.sendMessage(
        1,
        extensions.mojom.LocalFrame_SetSpatialNavigationEnabled_ParamsSpec.$,
        null,
        [
          spatialNavEnabled
        ],
        false);
  }

  
  /**
   * @param { !number } tabId
   */

  setTabId(
      tabId) {
    this.proxy.sendMessage(
        2,
        extensions.mojom.LocalFrame_SetTabId_ParamsSpec.$,
        null,
        [
          tabId
        ],
        false);
  }

  
  /**
   * @param { !boolean } sendOnclosed
   */

  appWindowClosed(
      sendOnclosed) {
    this.proxy.sendMessage(
        3,
        extensions.mojom.LocalFrame_AppWindowClosed_ParamsSpec.$,
        null,
        [
          sendOnclosed
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ViewType } viewType
   */

  notifyRenderViewType(
      viewType) {
    this.proxy.sendMessage(
        4,
        extensions.mojom.LocalFrame_NotifyRenderViewType_ParamsSpec.$,
        null,
        [
          viewType
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } moduleName
   * @param { !string } functionName
   * @param { !mojoBase.mojom.ListValue } args
   */

  messageInvoke(
      extensionId,
      moduleName,
      functionName,
      args) {
    this.proxy.sendMessage(
        5,
        extensions.mojom.LocalFrame_MessageInvoke_ParamsSpec.$,
        null,
        [
          extensionId,
          moduleName,
          functionName,
          args
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExecuteCodeParams } param
   * @return {!Promise<{
        error: !string,
        url: !url.mojom.Url,
        result: ?mojoBase.mojom.Value,
   *  }>}
   */

  executeCode(
      param) {
    return this.proxy.sendMessage(
        6,
        extensions.mojom.LocalFrame_ExecuteCode_ParamsSpec.$,
        extensions.mojom.LocalFrame_ExecuteCode_ResponseParamsSpec.$,
        [
          param
        ],
        false);
  }

  
  /**
   * @param { !number } tabId
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } scriptId
   * @param { !url.mojom.Url } url
   */

  executeDeclarativeScript(
      tabId,
      extensionId,
      scriptId,
      url) {
    this.proxy.sendMessage(
        7,
        extensions.mojom.LocalFrame_ExecuteDeclarativeScript_ParamsSpec.$,
        null,
        [
          tabId,
          extensionId,
          scriptId,
          url
        ],
        false);
  }

  
  /**
   * @param { !number } windowId
   */

  updateBrowserWindowId(
      windowId) {
    this.proxy.sendMessage(
        8,
        extensions.mojom.LocalFrame_UpdateBrowserWindowId_ParamsSpec.$,
        null,
        [
          windowId
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.PortId } portId
   * @param { !extensions.mojom.ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions.mojom.TabConnectionInfo } tabInfo
   * @param { !extensions.mojom.ExternalConnectionInfo } externalConnectionInfo
   * @param { !Object } port
   * @param { !Object } portHost
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  dispatchOnConnect(
      portId,
      channelType,
      channelName,
      tabInfo,
      externalConnectionInfo,
      port,
      portHost) {
    return this.proxy.sendMessage(
        9,
        extensions.mojom.LocalFrame_DispatchOnConnect_ParamsSpec.$,
        extensions.mojom.LocalFrame_DispatchOnConnect_ResponseParamsSpec.$,
        [
          portId,
          channelType,
          channelName,
          tabInfo,
          externalConnectionInfo,
          port,
          portHost
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LocalFrame
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.LocalFrameReceiver = class {
  /**
   * @param {!extensions.mojom.LocalFrameInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.LocalFrameRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.LocalFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.LocalFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.LocalFrame_SetFrameName_ParamsSpec.$,
        null,
        impl.setFrameName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.LocalFrame_SetSpatialNavigationEnabled_ParamsSpec.$,
        null,
        impl.setSpatialNavigationEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.LocalFrame_SetTabId_ParamsSpec.$,
        null,
        impl.setTabId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.LocalFrame_AppWindowClosed_ParamsSpec.$,
        null,
        impl.appWindowClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        extensions.mojom.LocalFrame_NotifyRenderViewType_ParamsSpec.$,
        null,
        impl.notifyRenderViewType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        extensions.mojom.LocalFrame_MessageInvoke_ParamsSpec.$,
        null,
        impl.messageInvoke.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        extensions.mojom.LocalFrame_ExecuteCode_ParamsSpec.$,
        extensions.mojom.LocalFrame_ExecuteCode_ResponseParamsSpec.$,
        impl.executeCode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        extensions.mojom.LocalFrame_ExecuteDeclarativeScript_ParamsSpec.$,
        null,
        impl.executeDeclarativeScript.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        extensions.mojom.LocalFrame_UpdateBrowserWindowId_ParamsSpec.$,
        null,
        impl.updateBrowserWindowId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        extensions.mojom.LocalFrame_DispatchOnConnect_ParamsSpec.$,
        extensions.mojom.LocalFrame_DispatchOnConnect_ResponseParamsSpec.$,
        impl.dispatchOnConnect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.LocalFrame = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.LocalFrame";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.LocalFrameRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.LocalFrameRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LocalFrame
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.LocalFrameCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.LocalFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.LocalFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFrameName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.LocalFrame_SetFrameName_ParamsSpec.$,
        null,
        this.setFrameName.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSpatialNavigationEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.LocalFrame_SetSpatialNavigationEnabled_ParamsSpec.$,
        null,
        this.setSpatialNavigationEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTabId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.LocalFrame_SetTabId_ParamsSpec.$,
        null,
        this.setTabId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.appWindowClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.LocalFrame_AppWindowClosed_ParamsSpec.$,
        null,
        this.appWindowClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyRenderViewType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        extensions.mojom.LocalFrame_NotifyRenderViewType_ParamsSpec.$,
        null,
        this.notifyRenderViewType.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.messageInvoke =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        extensions.mojom.LocalFrame_MessageInvoke_ParamsSpec.$,
        null,
        this.messageInvoke.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.executeCode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        extensions.mojom.LocalFrame_ExecuteCode_ParamsSpec.$,
        extensions.mojom.LocalFrame_ExecuteCode_ResponseParamsSpec.$,
        this.executeCode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.executeDeclarativeScript =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        extensions.mojom.LocalFrame_ExecuteDeclarativeScript_ParamsSpec.$,
        null,
        this.executeDeclarativeScript.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateBrowserWindowId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        extensions.mojom.LocalFrame_UpdateBrowserWindowId_ParamsSpec.$,
        null,
        this.updateBrowserWindowId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchOnConnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        extensions.mojom.LocalFrame_DispatchOnConnect_ParamsSpec.$,
        extensions.mojom.LocalFrame_DispatchOnConnect_ResponseParamsSpec.$,
        this.dispatchOnConnect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.LocalFrameHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.LocalFrameHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { extensions.mojom.LocalFrameHostInterface }
 */
extensions.mojom.LocalFrameHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.LocalFrameHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.LocalFrameHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.LocalFrameHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !extensions.mojom.InjectionType } scriptType
   * @param { !extensions.mojom.RunLocation } runLocation
   * @return {!Promise<{
        granted: !boolean,
   *  }>}
   */

  requestScriptInjectionPermission(
      extensionId,
      scriptType,
      runLocation) {
    return this.proxy.sendMessage(
        0,
        extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ParamsSpec.$,
        extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsSpec.$,
        [
          extensionId,
          scriptType,
          runLocation
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        state: !string,
   *  }>}
   */

  getAppInstallState(
      url) {
    return this.proxy.sendMessage(
        1,
        extensions.mojom.LocalFrameHost_GetAppInstallState_ParamsSpec.$,
        extensions.mojom.LocalFrameHost_GetAppInstallState_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.RequestParams } params
   * @return {!Promise<{
        success: !boolean,
        responseWrapper: !mojoBase.mojom.ListValue,
        error: !string,
        extraData: ?extensions.mojom.ExtraResponseData,
   *  }>}
   */

  request(
      params) {
    return this.proxy.sendMessage(
        2,
        extensions.mojom.LocalFrameHost_Request_ParamsSpec.$,
        extensions.mojom.LocalFrameHost_Request_ResponseParamsSpec.$,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Uuid } requestUuid
   */

  responseAck(
      requestUuid) {
    this.proxy.sendMessage(
        3,
        extensions.mojom.LocalFrameHost_ResponseAck_ParamsSpec.$,
        null,
        [
          requestUuid
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } cssSelectors
   */

  watchedPageChange(
      cssSelectors) {
    this.proxy.sendMessage(
        4,
        extensions.mojom.LocalFrameHost_WatchedPageChange_ParamsSpec.$,
        null,
        [
          cssSelectors
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } message
   * @param { !mojoBase.mojom.String16 } source
   * @param { !Array<!extensions.mojom.StackFrame> } stackTrace
   * @param { !blink.mojom.ConsoleMessageLevel } level
   */

  detailedConsoleMessageAdded(
      message,
      source,
      stackTrace,
      level) {
    this.proxy.sendMessage(
        5,
        extensions.mojom.LocalFrameHost_DetailedConsoleMessageAdded_ParamsSpec.$,
        null,
        [
          message,
          source,
          stackTrace,
          level
        ],
        false);
  }

  
  /**
   * @param { !Object<!string, !Array<!string>> } extensionIdToScripts
   * @param { !url.mojom.Url } frameUrl
   */

  contentScriptsExecuting(
      extensionIdToScripts,
      frameUrl) {
    this.proxy.sendMessage(
        6,
        extensions.mojom.LocalFrameHost_ContentScriptsExecuting_ParamsSpec.$,
        null,
        [
          extensionIdToScripts,
          frameUrl
        ],
        false);
  }

  
  /**
   */

  incrementLazyKeepaliveCount() {
    this.proxy.sendMessage(
        7,
        extensions.mojom.LocalFrameHost_IncrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  decrementLazyKeepaliveCount() {
    this.proxy.sendMessage(
        8,
        extensions.mojom.LocalFrameHost_DecrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  appWindowReady() {
    this.proxy.sendMessage(
        9,
        extensions.mojom.LocalFrameHost_AppWindowReady_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExternalConnectionInfo } info
   * @param { !extensions.mojom.ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions.mojom.PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToExtension(
      info,
      channelType,
      channelName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        10,
        extensions.mojom.LocalFrameHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        [
          info,
          channelType,
          channelName,
          portId,
          port,
          portHost
        ],
        false);
  }

  
  /**
   * @param { !string } nativeAppName
   * @param { !extensions.mojom.PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToNativeApp(
      nativeAppName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        11,
        extensions.mojom.LocalFrameHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        [
          nativeAppName,
          portId,
          port,
          portHost
        ],
        false);
  }

  
  /**
   * @param { !number } tabId
   * @param { !number } frameId
   * @param { ?string } documentId
   * @param { !extensions.mojom.ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions.mojom.PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToTab(
      tabId,
      frameId,
      documentId,
      channelType,
      channelName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        12,
        extensions.mojom.LocalFrameHost_OpenChannelToTab_ParamsSpec.$,
        null,
        [
          tabId,
          frameId,
          documentId,
          channelType,
          channelName,
          portId,
          port,
          portHost
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LocalFrameHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.LocalFrameHostReceiver = class {
  /**
   * @param {!extensions.mojom.LocalFrameHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.LocalFrameHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.LocalFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.LocalFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ParamsSpec.$,
        extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsSpec.$,
        impl.requestScriptInjectionPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.LocalFrameHost_GetAppInstallState_ParamsSpec.$,
        extensions.mojom.LocalFrameHost_GetAppInstallState_ResponseParamsSpec.$,
        impl.getAppInstallState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.LocalFrameHost_Request_ParamsSpec.$,
        extensions.mojom.LocalFrameHost_Request_ResponseParamsSpec.$,
        impl.request.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.LocalFrameHost_ResponseAck_ParamsSpec.$,
        null,
        impl.responseAck.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        extensions.mojom.LocalFrameHost_WatchedPageChange_ParamsSpec.$,
        null,
        impl.watchedPageChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        extensions.mojom.LocalFrameHost_DetailedConsoleMessageAdded_ParamsSpec.$,
        null,
        impl.detailedConsoleMessageAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        extensions.mojom.LocalFrameHost_ContentScriptsExecuting_ParamsSpec.$,
        null,
        impl.contentScriptsExecuting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        extensions.mojom.LocalFrameHost_IncrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        impl.incrementLazyKeepaliveCount.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        extensions.mojom.LocalFrameHost_DecrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        impl.decrementLazyKeepaliveCount.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        extensions.mojom.LocalFrameHost_AppWindowReady_ParamsSpec.$,
        null,
        impl.appWindowReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        extensions.mojom.LocalFrameHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        impl.openChannelToExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        extensions.mojom.LocalFrameHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        impl.openChannelToNativeApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        extensions.mojom.LocalFrameHost_OpenChannelToTab_ParamsSpec.$,
        null,
        impl.openChannelToTab.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.LocalFrameHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.LocalFrameHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.LocalFrameHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.LocalFrameHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LocalFrameHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.LocalFrameHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.LocalFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.LocalFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestScriptInjectionPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ParamsSpec.$,
        extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsSpec.$,
        this.requestScriptInjectionPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAppInstallState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.LocalFrameHost_GetAppInstallState_ParamsSpec.$,
        extensions.mojom.LocalFrameHost_GetAppInstallState_ResponseParamsSpec.$,
        this.getAppInstallState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.request =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.LocalFrameHost_Request_ParamsSpec.$,
        extensions.mojom.LocalFrameHost_Request_ResponseParamsSpec.$,
        this.request.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.responseAck =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.LocalFrameHost_ResponseAck_ParamsSpec.$,
        null,
        this.responseAck.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.watchedPageChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        extensions.mojom.LocalFrameHost_WatchedPageChange_ParamsSpec.$,
        null,
        this.watchedPageChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detailedConsoleMessageAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        extensions.mojom.LocalFrameHost_DetailedConsoleMessageAdded_ParamsSpec.$,
        null,
        this.detailedConsoleMessageAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.contentScriptsExecuting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        extensions.mojom.LocalFrameHost_ContentScriptsExecuting_ParamsSpec.$,
        null,
        this.contentScriptsExecuting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.incrementLazyKeepaliveCount =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        extensions.mojom.LocalFrameHost_IncrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        this.incrementLazyKeepaliveCount.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decrementLazyKeepaliveCount =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        extensions.mojom.LocalFrameHost_DecrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        this.decrementLazyKeepaliveCount.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.appWindowReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        extensions.mojom.LocalFrameHost_AppWindowReady_ParamsSpec.$,
        null,
        this.appWindowReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        extensions.mojom.LocalFrameHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        this.openChannelToExtension.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToNativeApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        extensions.mojom.LocalFrameHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        this.openChannelToNativeApp.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        extensions.mojom.LocalFrameHost_OpenChannelToTab_ParamsSpec.$,
        null,
        this.openChannelToTab.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ExecuteCodeParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.RequestParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_SetFrameName_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_SetSpatialNavigationEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_SetTabId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_AppWindowClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_NotifyRenderViewType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_MessageInvoke_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_ExecuteCode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_ExecuteCode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_ExecuteDeclarativeScript_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_UpdateBrowserWindowId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_DispatchOnConnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrame_DispatchOnConnect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_GetAppInstallState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_GetAppInstallState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_Request_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_Request_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_ResponseAck_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_WatchedPageChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_DetailedConsoleMessageAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_ContentScriptsExecuting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_IncrementLazyKeepaliveCount_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_DecrementLazyKeepaliveCount_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_AppWindowReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_OpenChannelToExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_OpenChannelToNativeApp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.LocalFrameHost_OpenChannelToTab_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mojom.ExecuteCodeParamsSpec.$,
    'ExecuteCodeParams',
    [
      mojo.internal.StructField(
        'hostId', 0,
        0,
        extensions.mojom.HostIDSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'injection', 8,
        0,
        extensions.mojom.CodeInjectionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'webviewSrc', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchOriginAsFallbackBehavior', 32,
        0,
        extensions.mojom.MatchOriginAsFallbackBehaviorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'runAt', 36,
        0,
        extensions.mojom.RunLocationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isWebView', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
extensions.mojom.ExecuteCodeParams = class {
  constructor() {
    /** @export { !extensions.mojom.HostID } */
    this.hostId;
    /** @export { !extensions.mojom.CodeInjection } */
    this.injection;
    /** @export { !url.mojom.Url } */
    this.webviewSrc;
    /** @export { !extensions.mojom.MatchOriginAsFallbackBehavior } */
    this.matchOriginAsFallbackBehavior;
    /** @export { !extensions.mojom.RunLocation } */
    this.runAt;
    /** @export { !boolean } */
    this.isWebView;
  }
};



mojo.internal.Struct(
    extensions.mojom.RequestParamsSpec.$,
    'RequestParams',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'arguments', 8,
        0,
        mojoBase.mojom.ListValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extensionId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceUrl', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contextType', 32,
        0,
        extensions.mojom.ContextTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestId', 36,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasCallback', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userGesture', 40,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'workerThreadId', 44,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerVersionId', 48,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'jsCallstack', 56,
        0,
        mojo.internal.Array(extensions.mojom.StackFrameSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);





/** @record */
extensions.mojom.RequestParams = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !mojoBase.mojom.ListValue } */
    this.arguments;
    /** @export { !string } */
    this.extensionId;
    /** @export { !url.mojom.Url } */
    this.sourceUrl;
    /** @export { !extensions.mojom.ContextType } */
    this.contextType;
    /** @export { !number } */
    this.requestId;
    /** @export { !boolean } */
    this.hasCallback;
    /** @export { !boolean } */
    this.userGesture;
    /** @export { !number } */
    this.workerThreadId;
    /** @export { !bigint } */
    this.serviceWorkerVersionId;
    /** @export { (Array<!extensions.mojom.StackFrame>|undefined) } */
    this.jsCallstack;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_SetFrameName_ParamsSpec.$,
    'LocalFrame_SetFrameName_Params',
    [
      mojo.internal.StructField(
        'frameName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrame_SetFrameName_Params = class {
  constructor() {
    /** @export { !string } */
    this.frameName;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_SetSpatialNavigationEnabled_ParamsSpec.$,
    'LocalFrame_SetSpatialNavigationEnabled_Params',
    [
      mojo.internal.StructField(
        'spatialNavEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrame_SetSpatialNavigationEnabled_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.spatialNavEnabled;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_SetTabId_ParamsSpec.$,
    'LocalFrame_SetTabId_Params',
    [
      mojo.internal.StructField(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrame_SetTabId_Params = class {
  constructor() {
    /** @export { !number } */
    this.tabId;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_AppWindowClosed_ParamsSpec.$,
    'LocalFrame_AppWindowClosed_Params',
    [
      mojo.internal.StructField(
        'sendOnclosed', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrame_AppWindowClosed_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.sendOnclosed;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_NotifyRenderViewType_ParamsSpec.$,
    'LocalFrame_NotifyRenderViewType_Params',
    [
      mojo.internal.StructField(
        'viewType', 0,
        0,
        extensions.mojom.ViewTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrame_NotifyRenderViewType_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ViewType } */
    this.viewType;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_MessageInvoke_ParamsSpec.$,
    'LocalFrame_MessageInvoke_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'moduleName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'functionName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'args', 24,
        0,
        mojoBase.mojom.ListValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
extensions.mojom.LocalFrame_MessageInvoke_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !string } */
    this.moduleName;
    /** @export { !string } */
    this.functionName;
    /** @export { !mojoBase.mojom.ListValue } */
    this.args;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_ExecuteCode_ParamsSpec.$,
    'LocalFrame_ExecuteCode_Params',
    [
      mojo.internal.StructField(
        'param', 0,
        0,
        extensions.mojom.ExecuteCodeParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrame_ExecuteCode_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExecuteCodeParams } */
    this.param;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_ExecuteCode_ResponseParamsSpec.$,
    'LocalFrame_ExecuteCode_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 16,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
extensions.mojom.LocalFrame_ExecuteCode_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.error;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { (mojoBase.mojom.Value|undefined) } */
    this.result;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_ExecuteDeclarativeScript_ParamsSpec.$,
    'LocalFrame_ExecuteDeclarativeScript_Params',
    [
      mojo.internal.StructField(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extensionId', 8,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
extensions.mojom.LocalFrame_ExecuteDeclarativeScript_Params = class {
  constructor() {
    /** @export { !number } */
    this.tabId;
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !string } */
    this.scriptId;
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_UpdateBrowserWindowId_ParamsSpec.$,
    'LocalFrame_UpdateBrowserWindowId_Params',
    [
      mojo.internal.StructField(
        'windowId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrame_UpdateBrowserWindowId_Params = class {
  constructor() {
    /** @export { !number } */
    this.windowId;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_DispatchOnConnect_ParamsSpec.$,
    'LocalFrame_DispatchOnConnect_Params',
    [
      mojo.internal.StructField(
        'portId', 0,
        0,
        extensions.mojom.PortIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelType', 8,
        0,
        extensions.mojom.ChannelTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tabInfo', 24,
        0,
        extensions.mojom.TabConnectionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'externalConnectionInfo', 32,
        0,
        extensions.mojom.ExternalConnectionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'port', 12,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions.mojom.MessagePortPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portHost', 40,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions.mojom.MessagePortHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
extensions.mojom.LocalFrame_DispatchOnConnect_Params = class {
  constructor() {
    /** @export { !extensions.mojom.PortId } */
    this.portId;
    /** @export { !extensions.mojom.ChannelType } */
    this.channelType;
    /** @export { !string } */
    this.channelName;
    /** @export { !extensions.mojom.TabConnectionInfo } */
    this.tabInfo;
    /** @export { !extensions.mojom.ExternalConnectionInfo } */
    this.externalConnectionInfo;
    /** @export { !Object } */
    this.port;
    /** @export { !Object } */
    this.portHost;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrame_DispatchOnConnect_ResponseParamsSpec.$,
    'LocalFrame_DispatchOnConnect_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrame_DispatchOnConnect_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ParamsSpec.$,
    'LocalFrameHost_RequestScriptInjectionPermission_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptType', 8,
        0,
        extensions.mojom.InjectionTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'runLocation', 12,
        0,
        extensions.mojom.RunLocationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !extensions.mojom.InjectionType } */
    this.scriptType;
    /** @export { !extensions.mojom.RunLocation } */
    this.runLocation;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsSpec.$,
    'LocalFrameHost_RequestScriptInjectionPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'granted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrameHost_RequestScriptInjectionPermission_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.granted;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_GetAppInstallState_ParamsSpec.$,
    'LocalFrameHost_GetAppInstallState_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrameHost_GetAppInstallState_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_GetAppInstallState_ResponseParamsSpec.$,
    'LocalFrameHost_GetAppInstallState_ResponseParams',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrameHost_GetAppInstallState_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.state;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_Request_ParamsSpec.$,
    'LocalFrameHost_Request_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        extensions.mojom.RequestParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrameHost_Request_Params = class {
  constructor() {
    /** @export { !extensions.mojom.RequestParams } */
    this.params;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_Request_ResponseParamsSpec.$,
    'LocalFrameHost_Request_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseWrapper', 8,
        0,
        mojoBase.mojom.ListValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extraData', 24,
        0,
        extensions.mojom.ExtraResponseDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
extensions.mojom.LocalFrameHost_Request_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !mojoBase.mojom.ListValue } */
    this.responseWrapper;
    /** @export { !string } */
    this.error;
    /** @export { (extensions.mojom.ExtraResponseData|undefined) } */
    this.extraData;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_ResponseAck_ParamsSpec.$,
    'LocalFrameHost_ResponseAck_Params',
    [
      mojo.internal.StructField(
        'requestUuid', 0,
        0,
        mojoBase.mojom.UuidSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrameHost_ResponseAck_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Uuid } */
    this.requestUuid;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_WatchedPageChange_ParamsSpec.$,
    'LocalFrameHost_WatchedPageChange_Params',
    [
      mojo.internal.StructField(
        'cssSelectors', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.LocalFrameHost_WatchedPageChange_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.cssSelectors;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_DetailedConsoleMessageAdded_ParamsSpec.$,
    'LocalFrameHost_DetailedConsoleMessageAdded_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stackTrace', 16,
        0,
        mojo.internal.Array(extensions.mojom.StackFrameSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'level', 24,
        0,
        blink.mojom.ConsoleMessageLevelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
extensions.mojom.LocalFrameHost_DetailedConsoleMessageAdded_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.message;
    /** @export { !mojoBase.mojom.String16 } */
    this.source;
    /** @export { !Array<!extensions.mojom.StackFrame> } */
    this.stackTrace;
    /** @export { !blink.mojom.ConsoleMessageLevel } */
    this.level;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_ContentScriptsExecuting_ParamsSpec.$,
    'LocalFrameHost_ContentScriptsExecuting_Params',
    [
      mojo.internal.StructField(
        'extensionIdToScripts', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Array(mojo.internal.String, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.LocalFrameHost_ContentScriptsExecuting_Params = class {
  constructor() {
    /** @export { !Object<!string, !Array<!string>> } */
    this.extensionIdToScripts;
    /** @export { !url.mojom.Url } */
    this.frameUrl;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_IncrementLazyKeepaliveCount_ParamsSpec.$,
    'LocalFrameHost_IncrementLazyKeepaliveCount_Params',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mojom.LocalFrameHost_IncrementLazyKeepaliveCount_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_DecrementLazyKeepaliveCount_ParamsSpec.$,
    'LocalFrameHost_DecrementLazyKeepaliveCount_Params',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mojom.LocalFrameHost_DecrementLazyKeepaliveCount_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_AppWindowReady_ParamsSpec.$,
    'LocalFrameHost_AppWindowReady_Params',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mojom.LocalFrameHost_AppWindowReady_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_OpenChannelToExtension_ParamsSpec.$,
    'LocalFrameHost_OpenChannelToExtension_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        extensions.mojom.ExternalConnectionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelType', 8,
        0,
        extensions.mojom.ChannelTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portId', 24,
        0,
        extensions.mojom.PortIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'port', 32,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions.mojom.MessagePortRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portHost', 12,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions.mojom.MessagePortHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
extensions.mojom.LocalFrameHost_OpenChannelToExtension_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExternalConnectionInfo } */
    this.info;
    /** @export { !extensions.mojom.ChannelType } */
    this.channelType;
    /** @export { !string } */
    this.channelName;
    /** @export { !extensions.mojom.PortId } */
    this.portId;
    /** @export { !Object } */
    this.port;
    /** @export { !Object } */
    this.portHost;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_OpenChannelToNativeApp_ParamsSpec.$,
    'LocalFrameHost_OpenChannelToNativeApp_Params',
    [
      mojo.internal.StructField(
        'nativeAppName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portId', 8,
        0,
        extensions.mojom.PortIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'port', 16,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions.mojom.MessagePortRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portHost', 24,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions.mojom.MessagePortHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
extensions.mojom.LocalFrameHost_OpenChannelToNativeApp_Params = class {
  constructor() {
    /** @export { !string } */
    this.nativeAppName;
    /** @export { !extensions.mojom.PortId } */
    this.portId;
    /** @export { !Object } */
    this.port;
    /** @export { !Object } */
    this.portHost;
  }
};



mojo.internal.Struct(
    extensions.mojom.LocalFrameHost_OpenChannelToTab_ParamsSpec.$,
    'LocalFrameHost_OpenChannelToTab_Params',
    [
      mojo.internal.StructField(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameId', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentId', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelType', 16,
        0,
        extensions.mojom.ChannelTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelName', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portId', 32,
        0,
        extensions.mojom.PortIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'port', 40,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions.mojom.MessagePortRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portHost', 20,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions.mojom.MessagePortHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
extensions.mojom.LocalFrameHost_OpenChannelToTab_Params = class {
  constructor() {
    /** @export { !number } */
    this.tabId;
    /** @export { !number } */
    this.frameId;
    /** @export { (string|undefined) } */
    this.documentId;
    /** @export { !extensions.mojom.ChannelType } */
    this.channelType;
    /** @export { !string } */
    this.channelName;
    /** @export { !extensions.mojom.PortId } */
    this.portId;
    /** @export { !Object } */
    this.port;
    /** @export { !Object } */
    this.portHost;
  }
};

