// device/vr/public/mojom/test/browser_test_interfaces.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_TEST_BROWSER_TEST_INTERFACES_MOJOM_SEND_VALIDATION_H_
#define DEVICE_VR_PUBLIC_MOJOM_TEST_BROWSER_TEST_INTERFACES_MOJOM_SEND_VALIDATION_H_

#include "device/vr/public/mojom/test/browser_test_interfaces.mojom-shared-internal.h"
#include "device/vr/public/mojom/openxr_interaction_profile_type.mojom-shared.h"
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"

#include "device/vr/public/mojom/test/browser_test_interfaces.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device_test::mojom::Eye, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device_test::mojom::ControllerRole, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device_test::mojom::EventType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device_test::mojom::ColorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ColorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::Color_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->r = Traits::r(input);

      fragment->g = Traits::g(input);

      fragment->b = Traits::b(input);

      fragment->a = Traits::a(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device_test::mojom::ViewDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ViewDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::ViewData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::color(input)) in_color = Traits::color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color)::BaseType> color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device_test::mojom::ColorDataView, send_validation>(
        in_color,
        color_fragment);

      fragment->color.Set(
          color_fragment.is_null() ? nullptr : color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color in ViewData struct");

      
      mojo::internal::Serialize<::device_test::mojom::Eye>(
        Traits::eye(input),
        &fragment->eye);

      decltype(Traits::viewport(input)) in_viewport = Traits::viewport(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->viewport)::BaseType> viewport_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_viewport,
        viewport_fragment);

      fragment->viewport.Set(
          viewport_fragment.is_null() ? nullptr : viewport_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->viewport.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport in ViewData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device_test::mojom::DeviceConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::DeviceConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::DeviceConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->interpupillary_distance = Traits::interpupillary_distance(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device_test::mojom::ControllerAxisDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ControllerAxisDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::ControllerAxisData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->x = Traits::x(input);

      fragment->y = Traits::y(input);

      fragment->axis_type = Traits::axis_type(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device_test::mojom::ControllerFrameDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ControllerFrameDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::ControllerFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->packet_number = Traits::packet_number(input);

      fragment->buttons_pressed = Traits::buttons_pressed(input);

      fragment->buttons_touched = Traits::buttons_touched(input);

      fragment->supported_buttons = Traits::supported_buttons(input);

      decltype(Traits::axis_data(input)) in_axis_data = Traits::axis_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->axis_data)::BaseType>
          axis_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& axis_data_validate_params =
          mojo::internal::GetArrayValidator<5, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device_test::mojom::ControllerAxisDataDataView>, send_validation>(
        in_axis_data,
        axis_data_fragment,
        &axis_data_validate_params);

      fragment->axis_data.Set(
          axis_data_fragment.is_null() ? nullptr : axis_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->axis_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null axis_data in ControllerFrameData struct");

      decltype(Traits::pose_data(input)) in_pose_data = Traits::pose_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pose_data)::BaseType> pose_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_pose_data,
        pose_data_fragment);

      fragment->pose_data.Set(
          pose_data_fragment.is_null() ? nullptr : pose_data_fragment.data());

      
      mojo::internal::Serialize<::device_test::mojom::ControllerRole>(
        Traits::role(input),
        &fragment->role);

      decltype(Traits::hand_data(input)) in_hand_data = Traits::hand_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hand_data)::BaseType> hand_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRHandTrackingDataDataView, send_validation>(
        in_hand_data,
        hand_data_fragment);

      fragment->hand_data.Set(
          hand_data_fragment.is_null() ? nullptr : hand_data_fragment.data());

      fragment->is_valid = Traits::is_valid(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device_test::mojom::EventDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::EventDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::EventData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device_test::mojom::EventType>(
        Traits::type(input),
        &fragment->type);

      
      mojo::internal::Serialize<::device::mojom::OpenXrInteractionProfileType>(
        Traits::interaction_profile(input),
        &fragment->interaction_profile);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device_test::mojom::XRVisibilityMaskDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::XRVisibilityMaskDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::XRVisibilityMask_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::vertices(input)) in_vertices = Traits::vertices(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->vertices)::BaseType>
          vertices_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& vertices_validate_params =
          mojo::internal::GetArrayValidator<6, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<float>, send_validation>(
        in_vertices,
        vertices_fragment,
        &vertices_validate_params);

      fragment->vertices.Set(
          vertices_fragment.is_null() ? nullptr : vertices_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->vertices.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null vertices in XRVisibilityMask struct");

      decltype(Traits::indices(input)) in_indices = Traits::indices(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->indices)::BaseType>
          indices_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& indices_validate_params =
          mojo::internal::GetArrayValidator<3, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>, send_validation>(
        in_indices,
        indices_fragment,
        &indices_validate_params);

      fragment->indices.Set(
          indices_fragment.is_null() ? nullptr : indices_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->indices.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null indices in XRVisibilityMask struct");
  }
};

}  // namespace mojo::internal

#endif  // DEVICE_VR_PUBLIC_MOJOM_TEST_BROWSER_TEST_INTERFACES_MOJOM_SEND_VALIDATION_H_