// device/gamepad/public/mojom/gamepad.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_SEND_VALIDATION_H_
#define DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_SEND_VALIDATION_H_

#include "device/gamepad/public/mojom/gamepad.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"

#include "device/gamepad/public/mojom/gamepad.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::GamepadMapping, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::GamepadHand, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::GamepadHapticActuatorType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::GamepadHapticEffectType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::GamepadHapticsResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GamepadQuaternionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadQuaternionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadQuaternion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->x = Traits::x(input);

      fragment->y = Traits::y(input);

      fragment->z = Traits::z(input);

      fragment->w = Traits::w(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GamepadVectorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadVectorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadVector_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->x = Traits::x(input);

      fragment->y = Traits::y(input);

      fragment->z = Traits::z(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GamepadButtonDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadButtonDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadButton_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->pressed = Traits::pressed(input);

      fragment->touched = Traits::touched(input);

      fragment->value = Traits::value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GamepadTouchDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadTouchDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadTouch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->touch_id = Traits::touch_id(input);

      fragment->surface_id = Traits::surface_id(input);

      fragment->x = Traits::x(input);

      fragment->y = Traits::y(input);

      fragment->surface_height = Traits::surface_height(input);

      fragment->surface_width = Traits::surface_width(input);

      fragment->has_surface_dimensions = Traits::has_surface_dimensions(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GamepadPoseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadPoseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadPose_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::orientation(input)) in_orientation = Traits::orientation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->orientation)::BaseType> orientation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::GamepadQuaternionDataView, send_validation>(
        in_orientation,
        orientation_fragment);

      fragment->orientation.Set(
          orientation_fragment.is_null() ? nullptr : orientation_fragment.data());

      decltype(Traits::position(input)) in_position = Traits::position(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->position)::BaseType> position_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::GamepadVectorDataView, send_validation>(
        in_position,
        position_fragment);

      fragment->position.Set(
          position_fragment.is_null() ? nullptr : position_fragment.data());

      decltype(Traits::angular_velocity(input)) in_angular_velocity = Traits::angular_velocity(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->angular_velocity)::BaseType> angular_velocity_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::GamepadVectorDataView, send_validation>(
        in_angular_velocity,
        angular_velocity_fragment);

      fragment->angular_velocity.Set(
          angular_velocity_fragment.is_null() ? nullptr : angular_velocity_fragment.data());

      decltype(Traits::linear_velocity(input)) in_linear_velocity = Traits::linear_velocity(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->linear_velocity)::BaseType> linear_velocity_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::GamepadVectorDataView, send_validation>(
        in_linear_velocity,
        linear_velocity_fragment);

      fragment->linear_velocity.Set(
          linear_velocity_fragment.is_null() ? nullptr : linear_velocity_fragment.data());

      decltype(Traits::angular_acceleration(input)) in_angular_acceleration = Traits::angular_acceleration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->angular_acceleration)::BaseType> angular_acceleration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::GamepadVectorDataView, send_validation>(
        in_angular_acceleration,
        angular_acceleration_fragment);

      fragment->angular_acceleration.Set(
          angular_acceleration_fragment.is_null() ? nullptr : angular_acceleration_fragment.data());

      decltype(Traits::linear_acceleration(input)) in_linear_acceleration = Traits::linear_acceleration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->linear_acceleration)::BaseType> linear_acceleration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::GamepadVectorDataView, send_validation>(
        in_linear_acceleration,
        linear_acceleration_fragment);

      fragment->linear_acceleration.Set(
          linear_acceleration_fragment.is_null() ? nullptr : linear_acceleration_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GamepadHapticActuatorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadHapticActuatorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadHapticActuator_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::GamepadHapticActuatorType>(
        Traits::type(input),
        &fragment->type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GamepadDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::Gamepad_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->connected = Traits::connected(input);

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType>
          id_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>, send_validation>(
        in_id,
        id_fragment,
        &id_validate_params);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in Gamepad struct");

      fragment->timestamp = Traits::timestamp(input);

      decltype(Traits::axes(input)) in_axes = Traits::axes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->axes)::BaseType>
          axes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& axes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<double>, send_validation>(
        in_axes,
        axes_fragment,
        &axes_validate_params);

      fragment->axes.Set(
          axes_fragment.is_null() ? nullptr : axes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->axes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null axes in Gamepad struct");

      decltype(Traits::buttons(input)) in_buttons = Traits::buttons(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->buttons)::BaseType>
          buttons_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& buttons_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::GamepadButtonDataView>, send_validation>(
        in_buttons,
        buttons_fragment,
        &buttons_validate_params);

      fragment->buttons.Set(
          buttons_fragment.is_null() ? nullptr : buttons_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->buttons.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buttons in Gamepad struct");

      decltype(Traits::vibration_actuator(input)) in_vibration_actuator = Traits::vibration_actuator(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->vibration_actuator)::BaseType> vibration_actuator_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::GamepadHapticActuatorDataView, send_validation>(
        in_vibration_actuator,
        vibration_actuator_fragment);

      fragment->vibration_actuator.Set(
          vibration_actuator_fragment.is_null() ? nullptr : vibration_actuator_fragment.data());

      
      mojo::internal::Serialize<::device::mojom::GamepadMapping>(
        Traits::mapping(input),
        &fragment->mapping);

      decltype(Traits::pose(input)) in_pose = Traits::pose(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pose)::BaseType> pose_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::GamepadPoseDataView, send_validation>(
        in_pose,
        pose_fragment);

      fragment->pose.Set(
          pose_fragment.is_null() ? nullptr : pose_fragment.data());

      
      mojo::internal::Serialize<::device::mojom::GamepadHand>(
        Traits::hand(input),
        &fragment->hand);

      decltype(Traits::touch_events(input)) in_touch_events = Traits::touch_events(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->touch_events)::BaseType>
          touch_events_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& touch_events_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::GamepadTouchDataView>, send_validation>(
        in_touch_events,
        touch_events_fragment,
        &touch_events_validate_params);

      fragment->touch_events.Set(
          touch_events_fragment.is_null() ? nullptr : touch_events_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->touch_events.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null touch_events in Gamepad struct");

      fragment->display_id = Traits::display_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GamepadEffectParametersDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadEffectParametersDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadEffectParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->duration = Traits::duration(input);

      fragment->start_delay = Traits::start_delay(input);

      fragment->strong_magnitude = Traits::strong_magnitude(input);

      fragment->weak_magnitude = Traits::weak_magnitude(input);

      fragment->left_trigger = Traits::left_trigger(input);

      fragment->right_trigger = Traits::right_trigger(input);
  }
};

}  // namespace mojo::internal

#endif  // DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_SEND_VALIDATION_H_