// device/gamepad/public/mojom/gamepad.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_DATA_VIEW_H_
#define DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "device/gamepad/public/mojom/gamepad.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"


namespace device::mojom {
class GamepadQuaternionDataView;

class GamepadVectorDataView;

class GamepadButtonDataView;

class GamepadTouchDataView;

class GamepadPoseDataView;

class GamepadHapticActuatorDataView;

class GamepadDataView;

class GamepadEffectParametersDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::GamepadQuaternionDataView> {
  using Data = ::device::mojom::internal::GamepadQuaternion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GamepadVectorDataView> {
  using Data = ::device::mojom::internal::GamepadVector_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GamepadButtonDataView> {
  using Data = ::device::mojom::internal::GamepadButton_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GamepadTouchDataView> {
  using Data = ::device::mojom::internal::GamepadTouch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GamepadPoseDataView> {
  using Data = ::device::mojom::internal::GamepadPose_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GamepadHapticActuatorDataView> {
  using Data = ::device::mojom::internal::GamepadHapticActuator_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GamepadDataView> {
  using Data = ::device::mojom::internal::Gamepad_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GamepadEffectParametersDataView> {
  using Data = ::device::mojom::internal::GamepadEffectParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class GamepadMapping : int32_t {
  
  GamepadMappingNone = 0,
  
  GamepadMappingStandard = 1,
  
  GamepadMappingXRStandard = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(GAMEPAD_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GamepadMapping value);
inline bool IsKnownEnumValue(GamepadMapping value) {
  return internal::GamepadMapping_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GamepadHand : int32_t {
  
  GamepadHandNone = 0,
  
  GamepadHandLeft = 1,
  
  GamepadHandRight = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(GAMEPAD_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GamepadHand value);
inline bool IsKnownEnumValue(GamepadHand value) {
  return internal::GamepadHand_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GamepadHapticActuatorType : int32_t {
  
  GamepadHapticActuatorTypeVibration = 0,
  
  GamepadHapticActuatorTypeDualRumble = 1,
  
  GamepadHapticActuatorTypeTriggerRumble = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(GAMEPAD_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GamepadHapticActuatorType value);
inline bool IsKnownEnumValue(GamepadHapticActuatorType value) {
  return internal::GamepadHapticActuatorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GamepadHapticEffectType : int32_t {
  
  GamepadHapticEffectTypeDualRumble = 0,
  
  GamepadHapticEffectTypeTriggerRumble = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(GAMEPAD_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GamepadHapticEffectType value);
inline bool IsKnownEnumValue(GamepadHapticEffectType value) {
  return internal::GamepadHapticEffectType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GamepadHapticsResult : int32_t {
  
  GamepadHapticsResultError = 0,
  
  GamepadHapticsResultComplete = 1,
  
  GamepadHapticsResultPreempted = 2,
  
  GamepadHapticsResultInvalidParameter = 3,
  
  GamepadHapticsResultNotSupported = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(GAMEPAD_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GamepadHapticsResult value);
inline bool IsKnownEnumValue(GamepadHapticsResult value) {
  return internal::GamepadHapticsResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class GamepadObserverInterfaceBase {};

using GamepadObserverPtrDataView =
    mojo::InterfacePtrDataView<GamepadObserverInterfaceBase>;
using GamepadObserverRequestDataView =
    mojo::InterfaceRequestDataView<GamepadObserverInterfaceBase>;
using GamepadObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GamepadObserverInterfaceBase>;
using GamepadObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GamepadObserverInterfaceBase>;
class GamepadMonitorInterfaceBase {};

using GamepadMonitorPtrDataView =
    mojo::InterfacePtrDataView<GamepadMonitorInterfaceBase>;
using GamepadMonitorRequestDataView =
    mojo::InterfaceRequestDataView<GamepadMonitorInterfaceBase>;
using GamepadMonitorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GamepadMonitorInterfaceBase>;
using GamepadMonitorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GamepadMonitorInterfaceBase>;
class GamepadHapticsManagerInterfaceBase {};

using GamepadHapticsManagerPtrDataView =
    mojo::InterfacePtrDataView<GamepadHapticsManagerInterfaceBase>;
using GamepadHapticsManagerRequestDataView =
    mojo::InterfaceRequestDataView<GamepadHapticsManagerInterfaceBase>;
using GamepadHapticsManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GamepadHapticsManagerInterfaceBase>;
using GamepadHapticsManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GamepadHapticsManagerInterfaceBase>;


class GamepadQuaternionDataView {
 public:
  GamepadQuaternionDataView() = default;

  GamepadQuaternionDataView(
      internal::GamepadQuaternion_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float x() const {
    return data_->x;
  }
  float y() const {
    return data_->y;
  }
  float z() const {
    return data_->z;
  }
  float w() const {
    return data_->w;
  }
 private:
  internal::GamepadQuaternion_Data* data_ = nullptr;
};


class GamepadVectorDataView {
 public:
  GamepadVectorDataView() = default;

  GamepadVectorDataView(
      internal::GamepadVector_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float x() const {
    return data_->x;
  }
  float y() const {
    return data_->y;
  }
  float z() const {
    return data_->z;
  }
 private:
  internal::GamepadVector_Data* data_ = nullptr;
};


class GamepadButtonDataView {
 public:
  GamepadButtonDataView() = default;

  GamepadButtonDataView(
      internal::GamepadButton_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool pressed() const {
    return data_->pressed;
  }
  bool touched() const {
    return data_->touched;
  }
  double value() const {
    return data_->value;
  }
 private:
  internal::GamepadButton_Data* data_ = nullptr;
};


class GamepadTouchDataView {
 public:
  GamepadTouchDataView() = default;

  GamepadTouchDataView(
      internal::GamepadTouch_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t touch_id() const {
    return data_->touch_id;
  }
  uint8_t surface_id() const {
    return data_->surface_id;
  }
  double x() const {
    return data_->x;
  }
  double y() const {
    return data_->y;
  }
  uint32_t surface_height() const {
    return data_->surface_height;
  }
  uint32_t surface_width() const {
    return data_->surface_width;
  }
  bool has_surface_dimensions() const {
    return data_->has_surface_dimensions;
  }
 private:
  internal::GamepadTouch_Data* data_ = nullptr;
};


class GamepadPoseDataView {
 public:
  GamepadPoseDataView() = default;

  GamepadPoseDataView(
      internal::GamepadPose_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOrientationDataView(
      GamepadQuaternionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrientation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadQuaternionDataView, UserType>(),
    "Attempting to read the optional `orientation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOrientation` instead "
    "of `ReadOrientation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->orientation.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadQuaternionDataView>(
        pointer, output, message_);
  }
  inline void GetPositionDataView(
      GamepadVectorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadVectorDataView, UserType>(),
    "Attempting to read the optional `position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPosition` instead "
    "of `ReadPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadVectorDataView>(
        pointer, output, message_);
  }
  inline void GetAngularVelocityDataView(
      GamepadVectorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAngularVelocity(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadVectorDataView, UserType>(),
    "Attempting to read the optional `angular_velocity` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAngularVelocity` instead "
    "of `ReadAngularVelocity if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->angular_velocity.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadVectorDataView>(
        pointer, output, message_);
  }
  inline void GetLinearVelocityDataView(
      GamepadVectorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinearVelocity(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadVectorDataView, UserType>(),
    "Attempting to read the optional `linear_velocity` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLinearVelocity` instead "
    "of `ReadLinearVelocity if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->linear_velocity.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadVectorDataView>(
        pointer, output, message_);
  }
  inline void GetAngularAccelerationDataView(
      GamepadVectorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAngularAcceleration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadVectorDataView, UserType>(),
    "Attempting to read the optional `angular_acceleration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAngularAcceleration` instead "
    "of `ReadAngularAcceleration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->angular_acceleration.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadVectorDataView>(
        pointer, output, message_);
  }
  inline void GetLinearAccelerationDataView(
      GamepadVectorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinearAcceleration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadVectorDataView, UserType>(),
    "Attempting to read the optional `linear_acceleration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLinearAcceleration` instead "
    "of `ReadLinearAcceleration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->linear_acceleration.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadVectorDataView>(
        pointer, output, message_);
  }
 private:
  internal::GamepadPose_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GamepadHapticActuatorDataView {
 public:
  GamepadHapticActuatorDataView() = default;

  GamepadHapticActuatorDataView(
      internal::GamepadHapticActuator_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::device::mojom::GamepadHapticActuatorType>(
        data_value, output);
  }
  GamepadHapticActuatorType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::GamepadHapticActuatorType>(data_->type));
  }
 private:
  internal::GamepadHapticActuator_Data* data_ = nullptr;
};


class GamepadDataView {
 public:
  GamepadDataView() = default;

  GamepadDataView(
      internal::Gamepad_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool connected() const {
    return data_->connected;
  }
  inline void GetIdDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  int64_t timestamp() const {
    return data_->timestamp;
  }
  inline void GetAxesDataView(
      mojo::ArrayDataView<double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAxes(UserType* output) {
    
    auto* pointer = data_->axes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<double>>(
        pointer, output, message_);
  }
  inline void GetButtonsDataView(
      mojo::ArrayDataView<GamepadButtonDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadButtons(UserType* output) {
    
    auto* pointer = data_->buttons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::GamepadButtonDataView>>(
        pointer, output, message_);
  }
  inline void GetVibrationActuatorDataView(
      GamepadHapticActuatorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVibrationActuator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadHapticActuatorDataView, UserType>(),
    "Attempting to read the optional `vibration_actuator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVibrationActuator` instead "
    "of `ReadVibrationActuator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->vibration_actuator.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadHapticActuatorDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMapping(UserType* output) const {
    auto data_value = data_->mapping;
    return mojo::internal::Deserialize<::device::mojom::GamepadMapping>(
        data_value, output);
  }
  GamepadMapping mapping() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::GamepadMapping>(data_->mapping));
  }
  inline void GetPoseDataView(
      GamepadPoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPose(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadPoseDataView, UserType>(),
    "Attempting to read the optional `pose` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPose` instead "
    "of `ReadPose if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pose.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadPoseDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHand(UserType* output) const {
    auto data_value = data_->hand;
    return mojo::internal::Deserialize<::device::mojom::GamepadHand>(
        data_value, output);
  }
  GamepadHand hand() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::GamepadHand>(data_->hand));
  }
  inline void GetTouchEventsDataView(
      mojo::ArrayDataView<GamepadTouchDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTouchEvents(UserType* output) {
    
    auto* pointer = data_->touch_events.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::GamepadTouchDataView>>(
        pointer, output, message_);
  }
  uint32_t display_id() const {
    return data_->display_id;
  }
 private:
  internal::Gamepad_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GamepadEffectParametersDataView {
 public:
  GamepadEffectParametersDataView() = default;

  GamepadEffectParametersDataView(
      internal::GamepadEffectParameters_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double duration() const {
    return data_->duration;
  }
  double start_delay() const {
    return data_->start_delay;
  }
  double strong_magnitude() const {
    return data_->strong_magnitude;
  }
  double weak_magnitude() const {
    return data_->weak_magnitude;
  }
  double left_trigger() const {
    return data_->left_trigger;
  }
  double right_trigger() const {
    return data_->right_trigger;
  }
 private:
  internal::GamepadEffectParameters_Data* data_ = nullptr;
};


}  // device::mojom

#endif  // DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_DATA_VIEW_H_