// device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_TEST_UTILS_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_TEST_UTILS_H_

#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom.h"


namespace bluetooth::mojom {


class  FakeBluetoothInterceptorForTesting : public FakeBluetooth {
  virtual FakeBluetooth* GetForwardingInterface() = 0;
  void SetLESupported(bool available, SetLESupportedCallback callback) override;
  void SimulateCentral(CentralState state, SimulateCentralCallback callback) override;
  void AllResponsesConsumed(AllResponsesConsumedCallback callback) override;
};
class  FakeBluetoothAsyncWaiter {
 public:
  explicit FakeBluetoothAsyncWaiter(FakeBluetooth* proxy);

  FakeBluetoothAsyncWaiter(const FakeBluetoothAsyncWaiter&) = delete;
  FakeBluetoothAsyncWaiter& operator=(const FakeBluetoothAsyncWaiter&) = delete;

  ~FakeBluetoothAsyncWaiter();
  void SetLESupported(
      bool available);
  
  void SimulateCentral(
      CentralState state, ::mojo::PendingRemote<FakeCentral>* out_fake_central);
  ::mojo::PendingRemote<FakeCentral> SimulateCentral(CentralState state);
  void AllResponsesConsumed(
      bool* out_consumed);
  bool AllResponsesConsumed();

 private:
  FakeBluetooth* const proxy_;
};


class  FakeCentralInterceptorForTesting : public FakeCentral {
  virtual FakeCentral* GetForwardingInterface() = 0;
  void SimulatePreconnectedPeripheral(const std::string& address, const std::string& name, const base::flat_map<uint16_t, std::vector<uint8_t>>& manufacturer_data, const std::vector<::device::BluetoothUUID>& known_service_uuids, SimulatePreconnectedPeripheralCallback callback) override;
  void SimulateAdvertisementReceived(ScanResultPtr result, SimulateAdvertisementReceivedCallback callback) override;
  void SetState(CentralState state, SetStateCallback callback) override;
  void SetNextGATTConnectionResponse(const std::string& address, uint16_t code, SetNextGATTConnectionResponseCallback callback) override;
  void SetNextGATTDiscoveryResponse(const std::string& address, uint16_t code, SetNextGATTDiscoveryResponseCallback callback) override;
  void SimulateGATTOperationResponse(GATTOperationType type, const std::string& address, uint16_t code, SimulateGATTOperationResponseCallback callback) override;
  void SimulateGATTDisconnection(const std::string& address, SimulateGATTDisconnectionCallback callback) override;
  void SimulateGATTServicesChanged(const std::string& address, SimulateGATTServicesChangedCallback callback) override;
  void SimulateCharacteristicOperationResponse(CharacteristicOperationType type, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, SimulateCharacteristicOperationResponseCallback callback) override;
  void SimulateDescriptorOperationResponse(DescriptorOperationType type, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, SimulateDescriptorOperationResponseCallback callback) override;
  void AddFakeService(const std::string& peripheral_address, const ::device::BluetoothUUID& service_uuid, AddFakeServiceCallback callback) override;
  void RemoveFakeService(const std::string& service_id, const std::string& peripheral_address, RemoveFakeServiceCallback callback) override;
  void AddFakeCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, CharacteristicPropertiesPtr properties, const std::string& service_id, const std::string& peripheral_address, AddFakeCharacteristicCallback callback) override;
  void RemoveFakeCharacteristic(const std::string& identifier, const std::string& service_id, const std::string& peripheral_address, RemoveFakeCharacteristicCallback callback) override;
  void AddFakeDescriptor(const ::device::BluetoothUUID& descriptor_uuid, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, AddFakeDescriptorCallback callback) override;
  void RemoveFakeDescriptor(const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, RemoveFakeDescriptorCallback callback) override;
  void SetNextReadCharacteristicResponse(uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextReadCharacteristicResponseCallback callback) override;
  void SetNextWriteCharacteristicResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextWriteCharacteristicResponseCallback callback) override;
  void SetNextSubscribeToNotificationsResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextSubscribeToNotificationsResponseCallback callback) override;
  void SetNextUnsubscribeFromNotificationsResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextUnsubscribeFromNotificationsResponseCallback callback) override;
  void IsNotifying(const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, IsNotifyingCallback callback) override;
  void GetLastWrittenCharacteristicValue(const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, GetLastWrittenCharacteristicValueCallback callback) override;
  void SetNextReadDescriptorResponse(uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextReadDescriptorResponseCallback callback) override;
  void SetNextWriteDescriptorResponse(uint16_t gatt_code, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextWriteDescriptorResponseCallback callback) override;
  void GetLastWrittenDescriptorValue(const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, GetLastWrittenDescriptorValueCallback callback) override;
  void SetClient(::mojo::PendingAssociatedRemote<FakeCentralClient> client) override;
};
class  FakeCentralAsyncWaiter {
 public:
  explicit FakeCentralAsyncWaiter(FakeCentral* proxy);

  FakeCentralAsyncWaiter(const FakeCentralAsyncWaiter&) = delete;
  FakeCentralAsyncWaiter& operator=(const FakeCentralAsyncWaiter&) = delete;

  ~FakeCentralAsyncWaiter();
  void SimulatePreconnectedPeripheral(
      const std::string& address, const std::string& name, const base::flat_map<uint16_t, std::vector<uint8_t>>& manufacturer_data, const std::vector<::device::BluetoothUUID>& known_service_uuids);
  
  void SimulateAdvertisementReceived(
      ScanResultPtr result);
  
  void SetState(
      CentralState state);
  
  void SetNextGATTConnectionResponse(
      const std::string& address, uint16_t code, bool* out_success);
  bool SetNextGATTConnectionResponse(const std::string& address, uint16_t code);
  void SetNextGATTDiscoveryResponse(
      const std::string& address, uint16_t code, bool* out_success);
  bool SetNextGATTDiscoveryResponse(const std::string& address, uint16_t code);
  void SimulateGATTOperationResponse(
      GATTOperationType type, const std::string& address, uint16_t code, bool* out_success);
  bool SimulateGATTOperationResponse(GATTOperationType type, const std::string& address, uint16_t code);
  void SimulateGATTDisconnection(
      const std::string& address, bool* out_success);
  bool SimulateGATTDisconnection(const std::string& address);
  void SimulateGATTServicesChanged(
      const std::string& address, bool* out_success);
  bool SimulateGATTServicesChanged(const std::string& address);
  void SimulateCharacteristicOperationResponse(
      CharacteristicOperationType type, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, bool* out_success);
  bool SimulateCharacteristicOperationResponse(CharacteristicOperationType type, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data);
  void SimulateDescriptorOperationResponse(
      DescriptorOperationType type, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, bool* out_success);
  bool SimulateDescriptorOperationResponse(DescriptorOperationType type, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data);
  void AddFakeService(
      const std::string& peripheral_address, const ::device::BluetoothUUID& service_uuid, std::optional<std::string>* out_service_id);
  std::optional<std::string> AddFakeService(const std::string& peripheral_address, const ::device::BluetoothUUID& service_uuid);
  void RemoveFakeService(
      const std::string& service_id, const std::string& peripheral_address, bool* out_success);
  bool RemoveFakeService(const std::string& service_id, const std::string& peripheral_address);
  void AddFakeCharacteristic(
      const ::device::BluetoothUUID& characteristic_uuid, CharacteristicPropertiesPtr properties, const std::string& service_id, const std::string& peripheral_address, std::optional<std::string>* out_characteristic_id);
  std::optional<std::string> AddFakeCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, CharacteristicPropertiesPtr properties, const std::string& service_id, const std::string& peripheral_address);
  void RemoveFakeCharacteristic(
      const std::string& identifier, const std::string& service_id, const std::string& peripheral_address, bool* out_success);
  bool RemoveFakeCharacteristic(const std::string& identifier, const std::string& service_id, const std::string& peripheral_address);
  void AddFakeDescriptor(
      const ::device::BluetoothUUID& descriptor_uuid, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, std::optional<std::string>* out_descriptor_id);
  std::optional<std::string> AddFakeDescriptor(const ::device::BluetoothUUID& descriptor_uuid, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address);
  void RemoveFakeDescriptor(
      const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success);
  bool RemoveFakeDescriptor(const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address);
  void SetNextReadCharacteristicResponse(
      uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success);
  bool SetNextReadCharacteristicResponse(uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address);
  void SetNextWriteCharacteristicResponse(
      uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success);
  bool SetNextWriteCharacteristicResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address);
  void SetNextSubscribeToNotificationsResponse(
      uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success);
  bool SetNextSubscribeToNotificationsResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address);
  void SetNextUnsubscribeFromNotificationsResponse(
      uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success);
  bool SetNextUnsubscribeFromNotificationsResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address);
  void IsNotifying(
      const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success, bool* out_is_notifying);
  
  void GetLastWrittenCharacteristicValue(
      const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success, std::optional<std::vector<uint8_t>>* out_value, WriteType* out_write_type);
  
  void SetNextReadDescriptorResponse(
      uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success);
  bool SetNextReadDescriptorResponse(uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address);
  void SetNextWriteDescriptorResponse(
      uint16_t gatt_code, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success);
  bool SetNextWriteDescriptorResponse(uint16_t gatt_code, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address);
  void GetLastWrittenDescriptorValue(
      const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success, std::optional<std::vector<uint8_t>>* out_value);
  

 private:
  FakeCentral* const proxy_;
};


class  FakeCentralClientInterceptorForTesting : public FakeCentralClient {
  virtual FakeCentralClient* GetForwardingInterface() = 0;
  void DispatchGATTOperationEvent(GATTOperationType type, const std::string& peripheral_address) override;
  void DispatchCharacteristicOperationEvent(CharacteristicOperationType type, const std::optional<std::vector<uint8_t>>& data, std::optional<WriteType> write_type, const std::string& characteristic_id) override;
  void DispatchDescriptorOperationEvent(DescriptorOperationType type, const std::optional<std::vector<uint8_t>>& data, const std::string& descriptor_id) override;
};
class  FakeCentralClientAsyncWaiter {
 public:
  explicit FakeCentralClientAsyncWaiter(FakeCentralClient* proxy);

  FakeCentralClientAsyncWaiter(const FakeCentralClientAsyncWaiter&) = delete;
  FakeCentralClientAsyncWaiter& operator=(const FakeCentralClientAsyncWaiter&) = delete;

  ~FakeCentralClientAsyncWaiter();

 private:
  FakeCentralClient* const proxy_;
};




}  // bluetooth::mojom

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_TEST_UTILS_H_